/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.gui;

import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JOptionPane;
import jsignnet.aplicacao.JSignNet;
import jsignnet.crypto.TipoKeyStore;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.ErroDeLogin;
import jsignnet.erro.JSignException;
import jsignnet.gui.DialogoSenha;
import jsignnet.infra.IContainer;
import jsignnet.infra.IFiltro;
import jsignnet.infra.Recursos;

public class ConfiguradorContainers {
    private IFiltro filtro;
    private IContainer iContainer;
    private Dialog dialogoPai;
    private ArrayList<Object[]> objetos;
    private Map<String, X509CertificadoWrapper> certificados;
    private String pathContainerPKCS11;
    private Map<String, JSignException> erros;
    public static final TipoKeyStore CAPI = TipoKeyStore.SUNMSCAPI;
    public static final TipoKeyStore JKS = TipoKeyStore.JKS;
    public static final TipoKeyStore PKCS11 = TipoKeyStore.PKCS11;
    public static final TipoKeyStore PKCS12 = TipoKeyStore.PKCS12;
    public static final TipoKeyStore KEYCHAINSTORE = TipoKeyStore.KEYCHAINSTORE;

    public ConfiguradorContainers(IContainer gerenciadorCertificados) {
        this.iContainer = gerenciadorCertificados;
        this.objetos = new ArrayList();
    }

    public void adicionaContainer(TipoKeyStore tipo) {
        this.adicionaContainer(tipo, null, null);
    }

    public void adicionaContainer(TipoKeyStore tipo, File arquivo) {
        this.adicionaContainer(tipo, null, arquivo);
    }

    public void adicionaContainer(TipoKeyStore tipo, char[] senha, File arquivo) {
        Object[] objeto = new Object[]{tipo, senha, arquivo};
        this.objetos.add(objeto);
    }

    public IFiltro getFiltro() {
        return this.filtro;
    }

    public void setFiltro(IFiltro filtro) {
        this.filtro = filtro;
    }

    public Dialog getDialogoPai() {
        return this.dialogoPai;
    }

    public void setDialogoPai(Dialog dialogoPai) {
        this.dialogoPai = dialogoPai;
    }

    public X509CertificadoWrapper[] getArrayCertificados() throws JSignException {
        if (this.certificados == null) {
            this.carregaCertificados();
        }
        ArrayList<X509CertificadoWrapper> resultado = new ArrayList<X509CertificadoWrapper>();
        for (X509CertificadoWrapper certificado : this.certificados.values()) {
            if (this.getFiltro() != null && !this.getFiltro().isCertificadoValido(certificado)) continue;
            resultado.add(certificado);
        }
        return resultado.toArray(new X509CertificadoWrapper[0]);
    }

    private void carregaCertificados() {
        this.certificados = new Hashtable<String, X509CertificadoWrapper>();
        if (this.objetos == null || this.getIContainer() == null) {
            return;
        }
        block7: for (Object[] elemento : this.objetos) {
            switch (((TipoKeyStore)elemento[0])._idTipo) {
                case 6: {
                    this.certificados.putAll(this.selecionaCertificadosCAPI());
                    continue block7;
                }
                case 1: {
                    this.certificados.putAll(this.selecionaCertificadosJKS((File)elemento[2], (char[])elemento[1]));
                    continue block7;
                }
                case 2: {
                    this.certificados.putAll(this.selecionaCertificadosPKCS11());
                    continue block7;
                }
                case 3: {
                    this.certificados.putAll(this.selecionaCertificadosPKCS12((File)elemento[2], (char[])elemento[1]));
                    continue block7;
                }
                case 7: {
                    this.certificados.putAll(this.selecionaCertificadosKeyChainStore());
                    continue block7;
                }
            }
            this.getErros().put("ERRO", new JSignException("Tipo incompativel"));
        }
    }

    private Map<String, X509CertificadoWrapper> selecionaCertificadosKeyChainStore() {
        try {
            return this.getIContainer().getMapaCertificadosKeyChainStore();
        }
        catch (JSignException e) {
            this.getErros().put("KeyChainStore", e);
            JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados KeyChainStore:" + e.getMessage());
            return Collections.emptyMap();
        }
    }

    private Map<String, X509CertificadoWrapper> selecionaCertificadosPKCS12(File arquivo, char[] pin) {
        Map<String, X509CertificadoWrapper> certificados = null;
        try {
            certificados = this.getIContainer().getMapaCertificadosPKCS12(arquivo, pin);
        }
        catch (JSignException e) {
            this.getErros().put("PKCS12", e);
            JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados PKCS12 diferente de ErroDeLogin:" + e.getMessage());
        }
        return certificados;
    }

    private Map<String, X509CertificadoWrapper> selecionaCertificadosJKS(File arquivo, char[] pin) {
        if (arquivo == null) {
            return Collections.emptyMap();
        }
        Hashtable<String, X509CertificadoWrapper> certificados = new Hashtable<String, X509CertificadoWrapper>();
        try {
            certificados.putAll(this.getIContainer().getMapaCertificadosJKS(arquivo, pin));
        }
        catch (JSignException e) {
            this.getErros().put("JKS", e);
            JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados JKS diferente de ErroDeLogin:" + e.getMessage());
        }
        return certificados;
    }

    private Map<String, X509CertificadoWrapper> selecionaCertificadosCAPI() {
        Map<String, X509CertificadoWrapper> certificados = Collections.emptyMap();
        try {
            certificados = this.getIContainer().getMapaCertificadosCAPI();
        }
        catch (JSignException e) {
            this.getErros().put("CAPI", e);
            JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados CAPI diferente de ErroDeLogin:" + e.getMessage());
        }
        return certificados;
    }

    private Map<String, X509CertificadoWrapper> selecionaCertificadosPKCS11() {
        Hashtable<String, X509CertificadoWrapper> certificados = new Hashtable<String, X509CertificadoWrapper>();
        try {
            Map<String, String> mapaHardwarePKCS11 = this.getIContainer().getHardwarePKCS11(new File(this.getPathContainerPKCS11()));
            if (mapaHardwarePKCS11.size() <= 0) {
                return certificados;
            }
            for (String container : mapaHardwarePKCS11.keySet()) {
                try {
                    certificados.putAll(this.getIContainer().getMapaCertificadosPKCS11(container, mapaHardwarePKCS11.get(container), null));
                }
                catch (ErroDeLogin err) {
                    try {
                        char[] senha;
                        if (this.getDialogoPai() == null || (senha = new DialogoSenha(this.getDialogoPai()).lerSenha(Recursos.getString("LoginContainer.titulo"), Recursos.getString("LoginContainer.mensagem") + " " + container)) == null) continue;
                        certificados.putAll(this.getIContainer().getMapaCertificadosPKCS11(container, mapaHardwarePKCS11.get(container), senha));
                    }
                    catch (ErroDeLogin e) {
                        JOptionPane.showMessageDialog(this.getDialogoPai(), Recursos.getString("Login.erro"), Recursos.getString("Login.titulo"), 0);
                    }
                    catch (JSignException e) {
                        this.getErros().put(container, e);
                        JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados PKCS11 diferente de ErroDeLogin:" + e.getMessage());
                    }
                }
                catch (JSignException e) {
                    this.getErros().put(container, e);
                    JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados PKCS11 diferente de ErroDeLogin:" + e.getMessage());
                }
            }
        }
        catch (JSignException e) {
            this.getErros().put("PKCS11", e);
            JSignNet.logger.warning("Exce\u00e7\u00e3o buscando certificados PKCS11 diferente de ErroDeLogin:" + e.getMessage());
        }
        return certificados;
    }

    protected IContainer getIContainer() {
        return this.iContainer;
    }

    protected void setIContainer(IContainer container) {
        this.iContainer = container;
    }

    public String getPathContainerPKCS11() {
        if (this.pathContainerPKCS11 == null) {
            this.pathContainerPKCS11 = "pkcs11";
        }
        return this.pathContainerPKCS11;
    }

    public void setPathContainerPKCS11(String pathContainerPKCS11) {
        this.pathContainerPKCS11 = pathContainerPKCS11;
    }

    public Map<String, JSignException> getErros() {
        if (this.erros == null) {
            this.erros = new Hashtable<String, JSignException>();
        }
        return this.erros;
    }

    public void limparCache() {
        this.certificados = null;
    }
}

