/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.interpretador;

import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class AnalisadorSintatico
implements PropertyChangeListener {
    protected Map operacoes = new Hashtable();
    protected ObjetoNegocio instanciaPrincipal = null;
    protected StringTokenizer tokensOperacao = null;
    protected LinkedList<String> tokens;
    protected int posAtual = 0;

    private AnalisadorSintatico() {
    }

    public AnalisadorSintatico(String strOp, ObjetoNegocio pInstanciaPrincipal) {
        this.tokensOperacao = new StringTokenizer(strOp, " ");
        while (this.tokensOperacao.hasMoreTokens()) {
            this.getTokens().add(this.tokensOperacao.nextToken().trim());
        }
        this.instanciaPrincipal = pInstanciaPrincipal;
    }

    protected String getTokenAtual() {
        if (this.posAtual < this.getTokens().size()) {
            String token = this.getTokens().get(this.posAtual).trim();
            return token;
        }
        return null;
    }

    protected String getProximoToken() {
        ++this.posAtual;
        return this.getTokens().get(this.posAtual).trim();
    }

    protected String getToken(int pos) {
        if (pos < this.tokens.size()) {
            return this.getTokens().get(pos);
        }
        return null;
    }

    protected void avancaToken() {
        ++this.posAtual;
    }

    protected boolean temMaisTokens() {
        return this.posAtual + 1 < this.getTokens().size();
    }

    protected boolean ehOperador(String proxToken) {
        return proxToken.equals("+") || proxToken.equals("-") || proxToken.equals("*") || proxToken.equals("/");
    }

    protected boolean ehCondicional(String token) {
        return token.toUpperCase().equals("SE");
    }

    public LinkedList<String> getTokens() {
        if (this.tokens == null) {
            this.tokens = new LinkedList();
        }
        return this.tokens;
    }
}

