/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.interpretador;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.interpretador.AnalisadorSintatico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class OperadorMatematico
extends AnalisadorSintatico {
    private Map<String, String> atributos;
    private Valor receptor;
    private boolean jahAdicionouObservadores = false;
    private Map<Colecao, Map<String, String>> colecoesEnvolvidas;
    private String identificador = null;
    private PropertyChangeListener observadorGeral = null;
    private boolean desabilitaAtribuicao = false;

    public OperadorMatematico(String strOp, ObjetoNegocio pInstanciaPrincipal, Map<String, String> pAtributos, String pReceptor, String pIdentificador, PropertyChangeListener pObs) {
        this(strOp, pInstanciaPrincipal, pAtributos);
        if (pReceptor != null && pReceptor.trim().length() > 0) {
            this.receptor = this.atributos.containsKey(pReceptor) ? (Valor)FabricaUtilitarios.obtemAtributo(this.instanciaPrincipal, this.atributos.get(pReceptor)) : (Valor)FabricaUtilitarios.obtemAtributo(this.instanciaPrincipal, pReceptor);
        }
        this.identificador = pIdentificador;
        this.observadorGeral = pObs;
    }

    private OperadorMatematico(String strOp, ObjetoNegocio pInstanciaPrincipal, Map<String, String> pAtributos) {
        super(strOp, pInstanciaPrincipal);
        this.atributos = pAtributos != null ? pAtributos : new Hashtable<String, String>();
    }

    public Valor operacao() {
        Valor operando1 = this.operando();
        this.avancaToken();
        if (this.getTokenAtual() == null || !this.ehOperador(this.getTokenAtual())) {
            return operando1;
        }
        char sinal = this.getTokenAtual().charAt(0);
        this.avancaToken();
        Valor retorno = this.operador(sinal, operando1);
        return retorno;
    }

    private Valor atribuicao() {
        boolean literalComObservador = this.getTokenAtual().equals("==>");
        this.avancaToken();
        Informacao informacaoAserAlterada = this.literal(this.getTokenAtual(), false);
        this.avancaToken();
        this.avancaToken();
        Informacao novoValor = null;
        if (this.getTokenAtual().equals("{")) {
            this.avancaToken();
            novoValor = this.literal(this.getTokenAtual(), literalComObservador);
            this.avancaToken();
            this.avancaToken();
        } else {
            novoValor = this.operacao();
        }
        if (!this.desabilitaAtribuicao) {
            informacaoAserAlterada.setConteudo(novoValor.getConteudoFormatado());
        }
        if (!this.getTokenAtual().equals(";")) {
            this.avancaToken();
        }
        if (this.getToken(this.posAtual + 1) != null && (this.getToken(this.posAtual + 1).equals("==>") || this.getToken(this.posAtual + 1).equals("!==>"))) {
            this.avancaToken();
            this.atribuicao();
        }
        return new Valor();
    }

    private Valor operando() {
        if (this.getTokenAtual().equals("==>") || this.getTokenAtual().equals("!==>")) {
            Valor ret = this.atribuicao();
            return ret;
        }
        if (this.getTokenAtual().equals("(")) {
            this.avancaToken();
            Valor retorno = this.operacao();
            this.avancaToken();
            return retorno;
        }
        if (this.ehFuncao(this.getTokenAtual())) {
            return this.funcao();
        }
        Informacao ret = this.literal(this.getTokenAtual());
        if (!(ret instanceof Valor)) {
            LogPPGD.erro("Erro no token->" + this.getTokenAtual());
        }
        return (Valor)ret;
    }

    private Valor funcao() {
        if (this.getTokenAtual().toUpperCase().equals("ARRED")) {
            return this.arredonda();
        }
        if (this.getTokenAtual().toUpperCase().equals("PARA_CADA_ITEM_EM")) {
            return this.percorreColecao();
        }
        return this.soma();
    }

    private Valor percorreColecao() {
        this.avancaToken();
        String strColecao = this.getTokenAtual();
        Colecao colecao = null;
        if (this.atributos.containsKey(strColecao)) {
            strColecao = this.atributos.get(strColecao);
        }
        if (strColecao.toUpperCase().equals("THIS")) {
            colecao = (Colecao)this.instanciaPrincipal;
        } else {
            int posicaoLasanha = strColecao.indexOf("#");
            if (posicaoLasanha != -1) {
                ObjetoNegocio obj = null;
                obj = posicaoLasanha == 0 ? this.instanciaPrincipal : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo(this.instanciaPrincipal, strColecao.substring(0, posicaoLasanha));
                String nomeMetodo = strColecao.substring(posicaoLasanha + 1, strColecao.length());
                colecao = (Colecao)FabricaUtilitarios.invocaMetodo(nomeMetodo, obj, new Class[0], new Object[0]);
            } else {
                colecao = (Colecao)FabricaUtilitarios.obtemAtributo(this.instanciaPrincipal, strColecao);
            }
        }
        if (!this.jahAdicionouObservadores) {
            colecao.getObservadoresLista().addPropertyChangeListener(this);
        }
        this.avancaToken();
        String tokenAtual = this.getTokenAtual();
        char sinalOperacao = '+';
        if (tokenAtual.toUpperCase().equals("RESULT")) {
            this.avancaToken();
            sinalOperacao = this.getTokenAtual().charAt(0);
            this.avancaToken();
        }
        int posicaoToken = this.posAtual;
        ObjetoNegocio ultimoObjetoNegocio = this.instanciaPrincipal;
        Valor retorno = new Valor();
        if (this.receptor != null) {
            retorno.converte(this.receptor);
        }
        Iterator itItens = colecao.recuperarLista().iterator();
        while (itItens.hasNext()) {
            ObjetoNegocio objAtual;
            this.instanciaPrincipal = objAtual = (ObjetoNegocio)itItens.next();
            this.posAtual = posicaoToken;
            retorno.append(sinalOperacao, this.operando());
        }
        this.instanciaPrincipal = ultimoObjetoNegocio;
        while (!this.getTokenAtual().equals("FIM_PARA_CADA_ITEM_EM")) {
            this.avancaToken();
        }
        tokenAtual = this.getTokenAtual();
        return retorno;
    }

    private Valor soma() {
        boolean itensAlternados;
        Valor retorno = new Valor();
        this.avancaToken();
        this.avancaToken();
        String strColecao = this.getTokenAtual();
        Colecao colecao = null;
        colecao = strColecao.toUpperCase().equals("THIS") ? (Colecao)this.instanciaPrincipal : (Colecao)FabricaUtilitarios.obtemAtributo(this.instanciaPrincipal, strColecao);
        this.avancaToken();
        this.avancaToken();
        String intervaloItens = this.getTokenAtual();
        int itemInicial = 0;
        int itemFinal = 0;
        boolean todosOsItens = intervaloItens.equals("*");
        boolean bl = itensAlternados = !todosOsItens && intervaloItens.indexOf(";") != -1;
        if (!todosOsItens) {
            int indice;
            if (itensAlternados) {
                indice = intervaloItens.indexOf(";");
                itemInicial = Integer.parseInt(intervaloItens.substring(0, indice));
                itemFinal = Integer.parseInt(intervaloItens.substring(indice + 1, intervaloItens.length()));
            } else {
                indice = intervaloItens.indexOf(":");
                itemInicial = Integer.parseInt(intervaloItens.substring(0, indice));
                itemFinal = Integer.parseInt(intervaloItens.substring(indice + 1, intervaloItens.length()));
            }
        }
        this.avancaToken();
        this.avancaToken();
        String nomeAtributoItemColecao = this.getTokenAtual();
        if (!this.jahAdicionouObservadores) {
            colecao.getObservadoresLista().addPropertyChangeListener(this);
            Map<String, String> listaAtributosColecaoEnvolvidosNoCalculo = null;
            listaAtributosColecaoEnvolvidosNoCalculo = this.getColecoesEnvolvidas().containsKey(colecao) ? this.getColecoesEnvolvidas().get(colecao) : new Hashtable<String, String>();
            listaAtributosColecaoEnvolvidosNoCalculo.put(nomeAtributoItemColecao, nomeAtributoItemColecao);
            this.getColecoesEnvolvidas().put(colecao, listaAtributosColecaoEnvolvidosNoCalculo);
        }
        if (todosOsItens) {
            for (ObjetoNegocio item : colecao.recuperarLista()) {
                Valor atributo = (Valor)FabricaUtilitarios.obtemAtributo(item, nomeAtributoItemColecao);
                retorno.converte(atributo);
                retorno.append('+', atributo);
            }
        } else if (itemFinal < colecao.recuperarLista().size()) {
            if (itensAlternados) {
                ObjetoNegocio objInicial = (ObjetoNegocio)colecao.recuperarLista().get(itemInicial - 1);
                ObjetoNegocio objFinal = (ObjetoNegocio)colecao.recuperarLista().get(itemFinal - 1);
                Valor atributo1 = (Valor)FabricaUtilitarios.obtemAtributo(objInicial, nomeAtributoItemColecao);
                Valor atributo2 = (Valor)FabricaUtilitarios.obtemAtributo(objFinal, nomeAtributoItemColecao);
                retorno.converte(atributo1);
                retorno.append('+', atributo1);
                retorno.append('+', atributo2);
            } else {
                for (int i = itemInicial - 1; i <= itemFinal - 1; ++i) {
                    ObjetoNegocio item = (ObjetoNegocio)colecao.recuperarLista().get(i);
                    Valor atributo = (Valor)FabricaUtilitarios.obtemAtributo(item, nomeAtributoItemColecao);
                    retorno.converte(atributo);
                    retorno.append('+', atributo);
                }
            }
        }
        this.avancaToken();
        return retorno;
    }

    private Valor arredonda() {
        Valor retorno = new Valor();
        this.avancaToken();
        this.avancaToken();
        Valor operando = this.operando();
        this.avancaToken();
        this.avancaToken();
        int qtdCasas = Integer.parseInt(this.getTokenAtual());
        this.avancaToken();
        this.avancaToken();
        int piso = Integer.parseInt(this.getTokenAtual());
        this.avancaToken();
        retorno.converte(operando);
        retorno.setConteudo(operando.getConteudoFormatado());
        retorno.arredonda(qtdCasas, piso);
        return retorno;
    }

    private boolean ehFuncao(String str) {
        return str.toUpperCase().equals("ARRED") || str.toUpperCase().equals("SOMA") || str.toUpperCase().equals("PARA_CADA_ITEM_EM");
    }

    private Valor operador(char pSinal, Valor operandoAnt) {
        Valor retorno = new Valor();
        retorno.converte(operandoAnt);
        retorno.setConteudo(operandoAnt);
        Valor operando2 = this.operando();
        retorno.append(pSinal, operando2);
        if (this.temMaisTokens() && this.ehOperador(this.getToken(this.posAtual + 1))) {
            this.avancaToken();
            char sinal = this.getTokenAtual().charAt(0);
            this.avancaToken();
            return this.operador(sinal, retorno);
        }
        return retorno;
    }

    private Informacao literal(String strLiteral) {
        return this.literal(strLiteral, true);
    }

    private Informacao literal(String strLiteral, boolean adicionaObservador) {
        Informacao retorno = null;
        String atributo = strLiteral;
        if (this.atributos.containsKey(strLiteral)) {
            atributo = this.atributos.get(strLiteral);
        }
        if (this.ehCondicional(atributo)) {
            retorno = this.condicional();
        } else if (this.ehNumero(atributo)) {
            retorno = new Valor(atributo);
        } else {
            try {
                int posicaoLasanha = atributo.indexOf("#");
                if (posicaoLasanha != -1) {
                    ObjetoNegocio obj = null;
                    obj = posicaoLasanha == 0 ? this.instanciaPrincipal : (ObjetoNegocio)FabricaUtilitarios.obtemAtributo(this.instanciaPrincipal, atributo.substring(0, posicaoLasanha));
                    String nomeMetodo = atributo.substring(posicaoLasanha + 1, atributo.length());
                    Informacao retornoMetodo = (Informacao)FabricaUtilitarios.invocaMetodo(nomeMetodo, obj, new Class[0], new Object[0]);
                    retorno = retornoMetodo != null ? retornoMetodo : new Valor();
                } else {
                    retorno = (Informacao)FabricaUtilitarios.obtemAtributoComExcecao(this.instanciaPrincipal, atributo);
                }
            }
            catch (Exception e) {
                retorno = new Alfa();
                if (atributo.indexOf("'") != -1) {
                    atributo = atributo.replaceAll("'", "");
                }
                ((Informacao)retorno).setConteudo(atributo);
            }
        }
        if (!this.possuiObservadorGeral(retorno) && adicionaObservador) {
            retorno.getObservadores().addPropertyChangeListener(this.observadorGeral);
        }
        return retorno;
    }

    private boolean possuiObservadorGeral(Informacao info) {
        PropertyChangeListener[] listeners = info.getObservadores().getPropertyChangeListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!listeners[i].equals(this.observadorGeral)) continue;
            return true;
        }
        return false;
    }

    private boolean ehNumero(String token) {
        for (int i = 0; i < token.length(); ++i) {
            boolean ehNum;
            boolean bl = ehNum = Character.isDigit(token.charAt(i)) || token.charAt(i) == '.' || token.charAt(i) == ',';
            if (ehNum) continue;
            return false;
        }
        return true;
    }

    private Valor condicional() {
        this.avancaToken();
        boolean condicao = this.condicao();
        this.avancaToken();
        this.avancaToken();
        this.desabilitaAtribuicao = !condicao;
        Valor operando1 = this.operando();
        this.avancaToken();
        this.avancaToken();
        this.desabilitaAtribuicao = condicao;
        Valor operando2 = this.operando();
        this.desabilitaAtribuicao = false;
        if (condicao) {
            return operando1;
        }
        return operando2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean condicao() {
        boolean retorno = false;
        if (this.getTokenAtual().equals("[")) {
            this.avancaToken();
            retorno = this.condicao();
            this.avancaToken();
            String logico = this.getTokenAtual();
            this.avancaToken();
            boolean segundaCondicao = this.condicao();
            this.avancaToken();
            if (logico.toUpperCase().equals("E")) {
                if (!retorno) return false;
                if (!segundaCondicao) return false;
                return true;
            }
            if (!logico.toUpperCase().equals("OU")) throw new IllegalArgumentException("Operador l\u00f3gico E ou OU esperado");
            if (retorno) return true;
            if (!segundaCondicao) return false;
            return true;
        }
        if (!this.getTokenAtual().startsWith("{")) return this.comparacao();
        return this.comparacaoLiteral();
    }

    private boolean comparacao() {
        Valor operando1 = this.operando();
        this.avancaToken();
        String comp = this.getTokenAtual();
        this.avancaToken();
        Valor operando2 = this.operando();
        return operando1.comparacao(comp, operando2);
    }

    private boolean comparacaoLiteral() {
        this.avancaToken();
        Informacao literal1 = this.literal(this.getTokenAtual());
        this.avancaToken();
        String sinalComp = this.getTokenAtual();
        this.avancaToken();
        Informacao literal2 = this.literal(this.getTokenAtual());
        boolean retorno = true;
        if (literal1 instanceof Valor && literal2 instanceof Valor) {
            retorno = ((Valor)literal1).comparacao(sinalComp, literal2.getConteudoFormatado());
        } else if (sinalComp.equals("!=") || sinalComp.equals("<>")) {
            retorno = !literal1.getConteudoFormatado().equals(literal2.getConteudoFormatado());
        } else if (sinalComp.equals("=")) {
            retorno = literal1.getConteudoFormatado().equals(literal2.getConteudoFormatado());
        }
        this.avancaToken();
        return retorno;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName;
        String string = propertyName = evt != null ? evt.getPropertyName() : null;
        if (propertyName != null && propertyName.equals("ObjetoInserido")) {
            Colecao source = (Colecao)evt.getSource();
            if (this.getColecoesEnvolvidas().containsKey(source)) {
                ObjetoNegocio obj = (ObjetoNegocio)evt.getNewValue();
                for (String prop : this.getColecoesEnvolvidas().get(source).values()) {
                    Informacao infoAtual = (Informacao)FabricaUtilitarios.getValorFieldGenerico(prop, obj);
                    infoAtual.getObservadores().addPropertyChangeListener(this.observadorGeral);
                }
            }
            this.atualiza();
        } else if (propertyName != null && propertyName.equals("ObjetoAremover")) {
            Colecao source = (Colecao)evt.getSource();
            ObjetoNegocio obj = (ObjetoNegocio)evt.getNewValue();
            if (this.getColecoesEnvolvidas().containsKey(source)) {
                for (String prop : this.getColecoesEnvolvidas().get(source).values()) {
                    Informacao infoAtual = (Informacao)FabricaUtilitarios.getValorFieldGenerico(prop, obj);
                    infoAtual.getObservadores().removePropertyChangeListener(this.observadorGeral);
                }
            } else {
                obj.removeObservadores(new Class[]{this.observadorGeral.getClass()});
            }
        } else if (propertyName != null && propertyName.equals("ObjetoRemovido")) {
            this.atualiza();
        }
    }

    public void atualiza() {
        try {
            this.posAtual = 0;
            if (this.receptor != null) {
                this.receptor.setConteudo(this.operacao().getConteudoFormatado());
            } else {
                this.operacao();
            }
            this.jahAdicionouObservadores = true;
        }
        catch (Exception e) {
            LogPPGD.erro("###############ERRO na operacao##############");
            LogPPGD.erro("identificador->" + this.getIdentificador());
            int posErro = this.posAtual;
            this.posAtual = 0;
            while (this.posAtual <= posErro) {
                LogPPGD.erro(" " + this.getTokenAtual());
                ++this.posAtual;
            }
            LogPPGD.erro(" ");
            LogPPGD.erro("####################################");
            e.printStackTrace();
        }
    }

    public Valor getReceptor() {
        return this.receptor;
    }

    public void setReceptor(Valor receptor) {
        this.receptor = receptor;
    }

    public Map<Colecao, Map<String, String>> getColecoesEnvolvidas() {
        if (this.colecoesEnvolvidas == null) {
            this.colecoesEnvolvidas = new Hashtable<Colecao, Map<String, String>>();
        }
        return this.colecoesEnvolvidas;
    }

    public boolean isJahAdicionouObservadores() {
        return this.jahAdicionouObservadores;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }
}

