/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import net.sf.jasperreports.components.iconlabel.ContainerFillEnum;
import net.sf.jasperreports.components.iconlabel.IconLabelComponentFactory;
import net.sf.jasperreports.components.iconlabel.IconPositionEnum;
import net.sf.jasperreports.components.iconlabel.IconTextFieldFactory;
import net.sf.jasperreports.components.iconlabel.LabelTextFieldFactory;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.xml.XmlConstantPropertyRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class IconLabelComponentDigester
implements XmlDigesterConfigurer {
    @Override
    public void configureDigester(Digester digester) {
        IconLabelComponentDigester.addIconLabelComponentRules(digester);
    }

    public static void addIconLabelComponentRules(Digester digester) {
        String componentNamespace = digester.getRuleNamespaceURI();
        String iconLabelComponentPattern = "*/componentElement/iconLabel";
        digester.addFactoryCreate(iconLabelComponentPattern, IconLabelComponentFactory.class.getName());
        digester.addSetProperties(iconLabelComponentPattern, new String[]{"iconPosition", "labelFill", "horizontalAlignment", "verticalAlignment"}, new String[0]);
        digester.addRule(iconLabelComponentPattern, (Rule)new XmlConstantPropertyRule("iconPosition", IconPositionEnum.values()));
        digester.addRule(iconLabelComponentPattern, (Rule)new XmlConstantPropertyRule("labelFill", ContainerFillEnum.values()));
        digester.addRule(iconLabelComponentPattern, (Rule)new XmlConstantPropertyRule("horizontalAlignment", HorizontalAlignEnum.values()));
        digester.addRule(iconLabelComponentPattern, (Rule)new XmlConstantPropertyRule("verticalAlignment", VerticalAlignEnum.values()));
        digester.setRuleNamespaceURI("http://jasperreports.sourceforge.net/jasperreports");
        digester.addFactoryCreate(String.valueOf(iconLabelComponentPattern) + "/label/textField", LabelTextFieldFactory.class.getName());
        digester.addFactoryCreate(String.valueOf(iconLabelComponentPattern) + "/icon/textField", IconTextFieldFactory.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
    }
}

