/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;

public class BooleanValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private int size;
    private ColumnValues longValues;

    public BooleanValues(int size, ColumnValues longValues) {
        this.size = size;
        this.longValues = longValues;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        out.writeUnshared(this.longValues);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.longValues = (ColumnValues)in.readUnshared();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new BooleanIterator();
    }

    protected class BooleanIterator
    implements ColumnValuesIterator {
        private final ColumnValuesIterator longIterator;
        private int index;
        private long currentLong;

        public BooleanIterator() {
            this.longIterator = BooleanValues.this.longValues.iterator();
            this.index = -1;
            this.currentLong = 0L;
        }

        @Override
        public void moveFirst() {
            this.longIterator.moveFirst();
            this.index = -1;
            this.currentLong = 0L;
        }

        @Override
        public boolean next() {
            if (this.index + 1 >= BooleanValues.this.size) {
                return false;
            }
            ++this.index;
            if ((this.index & 0x3F) == 0) {
                if (!this.longIterator.next()) {
                    throw new IllegalStateException();
                }
                this.currentLong = ((Number)this.longIterator.get()).longValue();
            }
            return true;
        }

        @Override
        public Object get() {
            if ((this.currentLong & 1L << this.index) != 0L) {
                return true;
            }
            return false;
        }
    }
}

