/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlDataSource
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    public abstract Node getCurrentNode();

    public abstract Object getSelectObject(Node var1, String var2) throws JRException;

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.getCurrentNode() == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        Class<?> valueClass = jrField.getValueClass();
        Object selectedObject = this.getSelectObject(this.getCurrentNode(), expression);
        if (Object.class != valueClass) {
            if (selectedObject != null) {
                if (selectedObject instanceof Node) {
                    String text = this.getText((Node)selectedObject);
                    if (text != null) {
                        value = this.convertStringValue(text, valueClass);
                    }
                } else if (selectedObject instanceof Boolean && valueClass.equals(Boolean.class)) {
                    value = selectedObject;
                } else if (selectedObject instanceof Number && Number.class.isAssignableFrom(valueClass)) {
                    value = this.convertNumber((Number)selectedObject, valueClass);
                } else {
                    String text = selectedObject.toString();
                    value = this.convertStringValue(text, valueClass);
                }
            }
        } else {
            value = selectedObject;
        }
        return value;
    }

    public abstract AbstractXmlDataSource subDataSource(String var1) throws JRException;

    public AbstractXmlDataSource subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public abstract Document subDocument() throws JRException;

    public abstract AbstractXmlDataSource dataSource(String var1) throws JRException;

    public AbstractXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer result = new StringBuffer();
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value != null) {
                    result.append(value);
                }
            } else if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value != null) {
                    result.append(value);
                }
            } else if (subnode.getNodeType() == 5 && (value = this.getText(subnode)) != null) {
                result.append(value);
            }
            ++i;
        }
        return result.toString();
    }
}

