/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.GridCellSize;
import net.sf.jasperreports.engine.export.GridCellStyle;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.PrintElementIndex;

public class ElementGridCell
extends JRExporterGridCell {
    private GridCellSize size;
    private JRGridLayout container;
    private PrintElementIndex parentIndex;
    private int elementIndex;

    public ElementGridCell(JRGridLayout container, PrintElementIndex parentIndex, int elementIndex, GridCellSize size) {
        this.size = size;
        this.container = container;
        this.parentIndex = parentIndex;
        this.elementIndex = elementIndex;
    }

    @Override
    public GridCellSize getSize() {
        return this.size;
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public JRPrintElement getElement() {
        return this.container.getElement(this.parentIndex, this.elementIndex);
    }

    @Override
    public String getProperty(String propName) {
        JRPrintElement element = this.getElement();
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(propName)) {
            return element.getPropertiesMap().getProperty(propName);
        }
        PrintElementIndex ancestorIndex = this.parentIndex;
        while (ancestorIndex != null) {
            JRPrintElement ancestor = this.container.getElement(ancestorIndex.getParentIndex(), ancestorIndex.getIndex());
            if (ancestor.hasProperties() && ancestor.getPropertiesMap().containsProperty(propName)) {
                return ancestor.getPropertiesMap().getProperty(propName);
            }
            ancestorIndex = ancestorIndex.getParentIndex();
        }
        return null;
    }

    public PrintElementIndex getParentIndex() {
        return this.parentIndex;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    @Override
    public String getElementAddress() {
        return PrintElementIndex.asAddress(this.parentIndex, this.elementIndex);
    }

    public JRGridLayout getLayout() {
        JRPrintElement element = this.getElement();
        if (!(element instanceof JRPrintFrame)) {
            throw new JRRuntimeException("Element at address " + this.getElementAddress() + " is not a frame");
        }
        JRPrintFrame frame = (JRPrintFrame)element;
        PrintElementIndex frameIndex = new PrintElementIndex(this.getParentIndex(), this.getElementIndex());
        return new JRGridLayout(this.container, frame.getElements(), frame.getWidth(), frame.getHeight(), 0, 0, frameIndex);
    }

    @Override
    public void setBox(JRLineBox box) {
        GridCellStyle newStyle = this.container.cellStyle(this.getBackcolor(), this.getForecolor(), box);
        this.setStyle(newStyle);
    }

    protected JRGridLayout getContainer() {
        return this.container;
    }
}

