/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRStyledText
implements Cloneable {
    public static final String PROPERTY_AWT_IGNORE_MISSING_FONT = "net.sf.jasperreports.awt.ignore.missing.font";
    private static final String PROPERTY_AWT_SUPERSCRIPT_FIX_ENABLED = "net.sf.jasperreports.awt.superscript.fix.enabled";
    private static final boolean AWT_SUPERSCRIPT_FIX_ENABLED = System.getProperty("java.version").startsWith("1.6") && JRProperties.getBooleanProperty("net.sf.jasperreports.awt.superscript.fix.enabled");
    private static final Set<AttributedCharacterIterator.Attribute> FONT_ATTRS = new HashSet<AttributedCharacterIterator.Attribute>();
    private StringBuilder sbuffer;
    private String text;
    private List<Run> runs = Collections.emptyList();
    private AttributedString attributedString;
    private AttributedString awtAttributedString;
    private Map<AttributedCharacterIterator.Attribute, Object> globalAttributes;
    private Locale locale;

    static {
        FONT_ATTRS.add(TextAttribute.FAMILY);
        FONT_ATTRS.add(TextAttribute.WEIGHT);
        FONT_ATTRS.add(TextAttribute.POSTURE);
        FONT_ATTRS.add(TextAttribute.SIZE);
        FONT_ATTRS.add(TextAttribute.SUPERSCRIPT);
    }

    public JRStyledText() {
        this(null);
    }

    public JRStyledText(Locale locale) {
        this.locale = locale;
    }

    public JRStyledText(Locale locale, String text, Map<AttributedCharacterIterator.Attribute, Object> globalAttributes) {
        this.locale = locale;
        this.text = text;
        this.globalAttributes = globalAttributes;
        this.runs = Collections.singletonList(new Run(globalAttributes, 0, text.length()));
    }

    private void ensureBuffer() {
        if (this.sbuffer == null) {
            this.sbuffer = this.text == null ? new StringBuilder() : new StringBuilder(this.text);
        }
        this.text = null;
    }

    private void ensureText() {
        if (this.text == null) {
            this.text = this.sbuffer == null ? "" : this.sbuffer.toString();
        }
        this.sbuffer = null;
    }

    public void append(String text) {
        this.ensureBuffer();
        this.sbuffer.append(text);
        this.attributedString = null;
        this.awtAttributedString = null;
    }

    public void addRun(Run run) {
        int currentSize = this.runs.size();
        if (currentSize == 0) {
            this.runs = Collections.singletonList(run);
        } else {
            if (currentSize == 1 && !(this.runs instanceof ArrayList)) {
                ArrayList<Run> newRuns = new ArrayList<Run>();
                newRuns.add(this.runs.get(0));
                this.runs = newRuns;
            }
            this.runs.add(run);
        }
        this.attributedString = null;
        this.awtAttributedString = null;
    }

    public int length() {
        return this.text == null ? (this.sbuffer == null ? 0 : this.sbuffer.length()) : this.text.length();
    }

    public String getText() {
        this.ensureText();
        return this.text;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public AttributedString getAttributedString() {
        if (this.attributedString == null) {
            this.ensureText();
            this.attributedString = new AttributedString(this.text);
            int i = this.runs.size() - 1;
            while (i >= 0) {
                Run run = this.runs.get(i);
                if (run.startIndex != run.endIndex && run.attributes != null) {
                    this.attributedString.addAttributes(run.attributes, run.startIndex, run.endIndex);
                }
                --i;
            }
        }
        return this.attributedString;
    }

    public AttributedString getAwtAttributedString(boolean ignoreMissingFont) {
        return this.getAwtAttributedString(DefaultJasperReportsContext.getInstance(), ignoreMissingFont);
    }

    public AttributedString getAwtAttributedString(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        if (this.awtAttributedString == null) {
            this.ensureText();
            this.awtAttributedString = new AttributedString(this.text);
            int i = this.runs.size() - 1;
            while (i >= 0) {
                Run run = this.runs.get(i);
                if (run.startIndex != run.endIndex && run.attributes != null) {
                    this.awtAttributedString.addAttributes(run.attributes, run.startIndex, run.endIndex);
                }
                --i;
            }
            AttributedCharacterIterator iterator = this.awtAttributedString.getIterator();
            int runLimit = 0;
            AffineTransform atrans = null;
            while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit(FONT_ATTRS)) <= iterator.getEndIndex()) {
                Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
                String familyName = (String)attrs.get(TextAttribute.FAMILY);
                Font awtFont = FontUtil.getInstance(jasperReportsContext).getAwtFontFromBundles(familyName, (TextAttribute.WEIGHT_BOLD.equals(attrs.get(TextAttribute.WEIGHT)) ? 1 : 0) | (TextAttribute.POSTURE_OBLIQUE.equals(attrs.get(TextAttribute.POSTURE)) ? 2 : 0), ((Float)attrs.get(TextAttribute.SIZE)).floatValue(), this.locale, ignoreMissingFont);
                if (awtFont == null) {
                    FontUtil.getInstance(jasperReportsContext).checkAwtFont(familyName, ignoreMissingFont);
                } else {
                    Integer superscript;
                    if (AWT_SUPERSCRIPT_FIX_ENABLED && atrans != null) {
                        double y = atrans.getTranslateY();
                        atrans = new AffineTransform();
                        atrans.translate(0.0, -y);
                        awtFont = awtFont.deriveFont(atrans);
                        atrans = null;
                    }
                    if (TextAttribute.SUPERSCRIPT_SUPER.equals(superscript = (Integer)attrs.get(TextAttribute.SUPERSCRIPT))) {
                        atrans = new AffineTransform();
                        atrans.scale(0.6666666666666666, 0.6666666666666666);
                        atrans.translate(0.0, (float)(-awtFont.getSize()) / 2.0f);
                        awtFont = awtFont.deriveFont(atrans);
                    } else if (TextAttribute.SUPERSCRIPT_SUB.equals(superscript)) {
                        atrans = new AffineTransform();
                        atrans.scale(0.6666666666666666, 0.6666666666666666);
                        atrans.translate(0.0, (float)awtFont.getSize() / 2.0f);
                        awtFont = awtFont.deriveFont(atrans);
                    }
                    this.awtAttributedString.addAttribute(TextAttribute.FONT, awtFont, iterator.getIndex(), runLimit);
                }
                iterator.setIndex(runLimit);
            }
        }
        return this.awtAttributedString;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public void setGlobalAttributes(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        this.globalAttributes = attributes;
        this.addRun(new Run(attributes, 0, this.length()));
    }

    public Map<AttributedCharacterIterator.Attribute, Object> getGlobalAttributes() {
        return this.globalAttributes;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected static Map<AttributedCharacterIterator.Attribute, Object> cloneAttributesMap(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        return attributes == null ? null : new HashMap<AttributedCharacterIterator.Attribute, Object>(attributes);
    }

    public JRStyledText cloneText() {
        try {
            JRStyledText clone = (JRStyledText)super.clone();
            clone.globalAttributes = JRStyledText.cloneAttributesMap(this.globalAttributes);
            int runsCount = this.runs.size();
            if (runsCount == 0) {
                clone.runs = Collections.emptyList();
            } else if (runsCount == 1) {
                clone.runs = Collections.singletonList(this.runs.get(0).cloneRun());
            } else {
                clone.runs = new ArrayList<Run>(runsCount);
                for (Run run : this.runs) {
                    Run runClone = run.cloneRun();
                    clone.runs.add(runClone);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void insert(String str, short[] offsets) {
        int insertLength = str.length();
        int currentLength = this.length();
        StringBuilder newText = new StringBuilder(currentLength + insertLength * offsets.length);
        char[] buffer = null;
        int offset = 0;
        int i = 0;
        while (i < offsets.length) {
            short charCount = offsets[i];
            int prevOffset = offset;
            offset += offsets[i];
            if (buffer == null || buffer.length < charCount) {
                buffer = new char[charCount];
            }
            this.getChars(prevOffset, offset, buffer, 0);
            newText.append(buffer, 0, (int)charCount);
            newText.append(str);
            for (Run run : this.runs) {
                if (run.startIndex >= offset) {
                    run.startIndex += insertLength;
                    run.endIndex += insertLength;
                    continue;
                }
                if (run.endIndex < offset) continue;
                run.endIndex += insertLength;
            }
            ++i;
        }
        int charCount = currentLength - offset;
        if (buffer == null || buffer.length < charCount) {
            buffer = new char[charCount];
        }
        this.getChars(offset, currentLength, buffer, 0);
        newText.append(buffer, 0, charCount);
        this.sbuffer = newText;
        this.text = null;
        this.attributedString = null;
        this.awtAttributedString = null;
    }

    private void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (this.text != null) {
            this.text.getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (this.sbuffer != null) {
            this.sbuffer.getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (srcBegin < srcEnd) {
            throw new JRRuntimeException("Cannot copy characters " + srcBegin + " to " + srcEnd);
        }
    }

    public static class Run
    implements Cloneable {
        public Map<AttributedCharacterIterator.Attribute, Object> attributes;
        public int startIndex;
        public int endIndex;

        public Run(Map<AttributedCharacterIterator.Attribute, Object> attributes, int startIndex, int endIndex) {
            this.attributes = attributes;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        protected Object clone() {
            return this.cloneRun();
        }

        public Run cloneRun() {
            try {
                Run clone = (Run)super.clone();
                clone.attributes = JRStyledText.cloneAttributesMap(this.attributes);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

