/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.search;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.util.Version;

public class LuceneSimpleAnalyzer
extends Analyzer {
    private Version matchVersion;
    private boolean isCaseSensitive;
    private boolean removeAccents;

    public LuceneSimpleAnalyzer(Version matchVersion, boolean isCaseSensitive, boolean removeAccents) {
        this.matchVersion = matchVersion;
        this.isCaseSensitive = isCaseSensitive;
        this.removeAccents = true;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        WhitespaceTokenizer source;
        WhitespaceTokenizer result = source = new WhitespaceTokenizer(this.matchVersion, reader);
        if (!this.isCaseSensitive) {
            result = new LowerCaseFilter(this.matchVersion, (TokenStream)source);
        }
        if (this.removeAccents) {
            result = new ASCIIFoldingFilter((TokenStream)result);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

