/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.cacheni;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCNPJ;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.Validador;

public class CacheNI {
    public static final String TIPO_ASSOCIACAO_CACHE = "CancheNI";
    private static final String ARQ_PERSISTENCIA_CACHE = UtilitariosArquivo.getPathDados() + File.separator + ".cache.properties";
    private static CacheNI instancia = new CacheNI();
    protected HashMap<String, String> cacheNINome = new HashMap();
    protected boolean ligado = true;

    private CacheNI() {
    }

    public static CacheNI getInstancia() {
        return instancia;
    }

    public void registrarNINome(NI aNi, Alfa aNome) {
        aNi.setInformacaoAssociada(TIPO_ASSOCIACAO_CACHE, (Informacao)aNome);
        aNome.setInformacaoAssociada(TIPO_ASSOCIACAO_CACHE, (Informacao)aNi);
    }

    private void processaAlteracaoNI(NI niObservado) {
        Alfa alfaAssociado;
        if (this.isLigado() && !niObservado.isVazio() && (alfaAssociado = (Alfa)niObservado.getInformacaoAssociada(TIPO_ASSOCIACAO_CACHE)) != null) {
            String chave = niObservado.naoFormatado();
            String strNome = this.cacheNINome.get(chave);
            if (strNome != null) {
                alfaAssociado.setConteudo(strNome);
            } else {
                boolean ehValido;
                boolean bl = ehValido = Validador.validarNI((String)chave) == null;
                if (ehValido && !alfaAssociado.isVazio()) {
                    this.cacheNINome.put(chave, alfaAssociado.naoFormatado());
                }
            }
        }
    }

    private void processaAlteracaoNome(Alfa nomeObservado) {
        NI niAssociado;
        if (this.isLigado() && !nomeObservado.isVazio() && (niAssociado = (NI)nomeObservado.getInformacaoAssociada(TIPO_ASSOCIACAO_CACHE)) != null && !niAssociado.isVazio()) {
            boolean ehValido;
            String chave = niAssociado.naoFormatado();
            boolean bl = ehValido = Validador.validarNI((String)chave) == null;
            if (ehValido) {
                this.cacheNINome.put(chave, nomeObservado.naoFormatado());
            }
        }
    }

    public void bindEditCampoNI(JEditCampo edit) {
        Informacao infoNI;
        if (edit != null && (infoNI = edit.getInformacao()) != null && infoNI instanceof NI && infoNI.getInformacaoAssociada(TIPO_ASSOCIACAO_CACHE) != null) {
            edit.getComponenteEditor().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CacheNI.this.processaAlteracaoNI((NI)infoNI);
                }
            });
        }
    }

    public void bindEditCampoAlfa(JEditCampo edit) {
        Informacao infoNome;
        if (edit != null && (infoNome = edit.getInformacao()) != null && infoNome instanceof Alfa && infoNome.getInformacaoAssociada(TIPO_ASSOCIACAO_CACHE) != null) {
            edit.getComponenteEditor().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CacheNI.this.processaAlteracaoNome((Alfa)infoNome);
                }
            });
        }
    }

    public void registrarCacheCampoNI(Container paninel) {
        for (Component component : paninel.getComponents()) {
            if (!(component instanceof Container)) continue;
            if (component instanceof JEditCampo) {
                if (component instanceof JEditCPF) {
                    this.bindEditCampoNI((JEditCampo)((JEditCPF)component));
                    continue;
                }
                if (component instanceof JEditCNPJ) {
                    this.bindEditCampoNI((JEditCampo)((JEditCNPJ)component));
                    continue;
                }
                if (component instanceof JEditNI) {
                    this.bindEditCampoNI((JEditCampo)((JEditNI)component));
                    continue;
                }
                if (!(component instanceof JEditAlfa)) continue;
                this.bindEditCampoAlfa((JEditCampo)((JEditAlfa)component));
                continue;
            }
            this.registrarCacheCampoNI((Container)component);
        }
    }

    private Object getObjetcField(Field field, Object obj) {
        Object ret = null;
        boolean acessible = field.isAccessible();
        field.setAccessible(true);
        try {
            ret = field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        field.setAccessible(acessible);
        return ret;
    }

    public void importarNIs(ObjetoNegocio obj, boolean atualizacaoCacheHabilitada) {
        try {
            this.importarNIs(null, obj, atualizacaoCacheHabilitada);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void importarNIs(Set<ObjetoNegocio> objetos, ObjetoNegocio obj, boolean atualizacaoCacheHabilitada) throws Exception {
        if (objetos == null) {
            objetos = new HashSet<ObjetoNegocio>();
        }
        if (obj != null && !objetos.contains(obj)) {
            objetos.add(obj);
            for (Class<?> objClass = obj.getClass(); objClass != null; objClass = objClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = objClass.getDeclaredFields()) {
                    Informacao nome;
                    NI ni;
                    if (ObjetoNegocio.class.isAssignableFrom(field.getType())) {
                        this.importarNIs(objetos, (ObjetoNegocio)this.getObjetcField(field, obj), atualizacaoCacheHabilitada);
                        continue;
                    }
                    if (!NI.class.isAssignableFrom(field.getType()) || (ni = (NI)this.getObjetcField(field, obj)) == null || Validador.validarNI((String)ni.naoFormatado()) != null || this.cacheNINome.containsKey(ni.naoFormatado()) && !atualizacaoCacheHabilitada || (nome = ni.getInformacaoAssociada(TIPO_ASSOCIACAO_CACHE)) == null || !(nome instanceof Alfa) || nome.isVazio()) continue;
                    this.cacheNINome.put(ni.naoFormatado(), nome.naoFormatado());
                }
            }
            if (obj instanceof Colecao) {
                List itens = ((Colecao)obj).itens();
                for (Object fObj : itens) {
                    this.importarNIs(objetos, (ObjetoNegocio)fObj, atualizacaoCacheHabilitada);
                }
            }
        }
    }

    public boolean isLigado() {
        return this.ligado;
    }

    public void setLigado(boolean ligado) {
        this.ligado = ligado;
    }

    public void salvar() throws IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.cacheNINome);
        properties.store(new FileOutputStream(ARQ_PERSISTENCIA_CACHE), null);
    }

    public void carregar() throws IOException {
        File f = new File(ARQ_PERSISTENCIA_CACHE);
        if (f.exists()) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(f));
            for (String key : properties.stringPropertyNames()) {
                this.cacheNINome.put(key, properties.get(key).toString());
            }
        }
    }

    public void limparCache() throws IOException {
        Properties properties = new Properties();
        this.cacheNINome.clear();
        properties.putAll((Map<?, ?>)this.cacheNINome);
        properties.store(new FileOutputStream(ARQ_PERSISTENCIA_CACHE), null);
    }
}

