/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.dialogs.PainelResultadoDuasListas;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.importacao.ResultadoImportacaoDTO;
import br.gov.serpro.gcap.util.GcapUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.Validador;

public class ImportarExercicioAnteriorAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getChaveMensagemConfirmaFecharDemonstrativo() {
        return "ConfirmarFecharDemonstrativoRestaurarCopia";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executarAcao(ActionEvent e) {
        try {
            boolean isDemonstrativoAberto = ControladorGui.isDemonstrativoAberto();
            if (!isDemonstrativoAberto) {
                GuiUtil.mostrarInfo("infoNecessarioDemonstrativoAberto");
                return;
            }
            GuiUtil.mostrarInfoAjuda("infoBensSeraoImportadosDemonstrativoAberto", "Como_importar_dados_ano_anterior");
            JFileChooser fc = UtilitariosGUI.setFileChooserProperties((String)"Importa\u00e7\u00e3o de demonstrativo de exerc\u00edcio anterior", (String)"Procurar em:", (String)"OK", (String)"Importar demonstrativo exerc\u00edcio anterior");
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(new GCAPFileFilter());
            fc.setMultiSelectionEnabled(true);
            this.definirDiretorioPadrao(fc);
            if (fc.showDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), null) == 0) {
                GcapUtil.setEstadoSistema(2);
                ResultadoImportacaoDTO retorno = ControladorGui.importaDemonstrativoExercicioAnterior(fc.getSelectedFiles());
                if (retorno != null) {
                    if (retorno.possuiItensNaoImportados()) {
                        List<String> importados = retorno.getImportados();
                        List<String> naoImportados = retorno.getNaoImportados();
                        PainelResultadoDuasListas painelResultado = new PainelResultadoDuasListas("Itens importados:", importados, "Itens n\u00e3o importados:", naoImportados);
                        GuiUtil.exibeDialog(painelResultado, true, "Importar dados", true);
                    } else {
                        GuiUtil.mostrarInfo("CopiaImportadaSucesso");
                    }
                }
            }
            IdDemonstrativoGCAP identificador = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo();
            ControladorGui.fecharDemonstrativo();
            ControladorGui.abrirDemonstrativo(identificador, true);
        }
        catch (Exception ex) {
            ControladorGui.tratarException(ex);
        }
        finally {
            GcapUtil.setEstadoSistema(0);
        }
    }

    private void definirDiretorioPadrao(JFileChooser pFileChooser) {
        try {
            File lDefaultDir = new File(File.separator);
            if (lDefaultDir.exists() && lDefaultDir.isDirectory()) {
                pFileChooser.setCurrentDirectory(lDefaultDir);
            } else {
                pFileChooser.setCurrentDirectory(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class GCAPFileFilter
    extends FileFilter {
        private final String padraoNomeCopiaSeguranca = "^(" + ControladorGui.getDemonstrativoAberto().getIdDemonstrativo().getCpf().naoFormatado() + "-\\d{4}-\\d{4}-" + ConstantesGlobais.NOME_PROGRAMA + "-" + ConstantesGlobais.EXERCICIO_ANTERIOR + "\\.DBK)$";

        private GCAPFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return Validador.validarString((String)f.getName(), (String)this.padraoNomeCopiaSeguranca);
        }

        @Override
        public String getDescription() {
            return "Arquivos GCAP " + ConstantesGlobais.EXERCICIO_ANTERIOR;
        }
    }
}

