/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.NavegacaoIf;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.dialogs.PainelImprimirDemonstrativo;
import br.gov.serpro.gcap.gui.dialogs.PainelSelecionarImpressaoDarf;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import serpro.ppgd.negocio.RetornoValidacao;

public class ImprimirDarfAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    private static final int DARF_BENS_DIREITOS = 1;
    private IdDemonstrativoGCAP idSelecionado = null;

    @Override
    public void executarAcao(ActionEvent e) {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DemonstrativoGCAP[] demonstrativo = new DemonstrativoGCAP[]{ControladorGui.getDemonstrativoAberto()};
                        PainelSelecionarImpressaoDarf painelSelecionarImpressao = new PainelSelecionarImpressaoDarf(demonstrativo);
                        String mensagem = MensagemUtil.getMensagem("ImpressaoDarf");
                        GuiUtil.exibeDialog(painelSelecionarImpressao, true, mensagem, false);
                    }
                });
            } else {
                RetornoValidacao validacao;
                if (this.idSelecionado == null) {
                    PainelImprimirDemonstrativo painelImprimirDemonstrativo = new PainelImprimirDemonstrativo(1);
                    GuiUtil.exibeDialog(painelImprimirDemonstrativo, true, MensagemUtil.getMensagem("ImpressaoDarf"), false);
                    this.idSelecionado = painelImprimirDemonstrativo.getIdSelecionado();
                }
                if ((validacao = this.idSelecionado.getTerritorioParaisoFiscal().validar().getPrimeiroRetornoValidacaoMaisSevero()).isValido()) {
                    GcapUtil.setEstadoSistema(-1);
                    GCAPFacade.abreDeclaracao(this.idSelecionado);
                    DemonstrativoGCAP[] demonstrativo = new DemonstrativoGCAP[]{GCAPFacade.getInstancia().getDeclaracao()};
                    PainelSelecionarImpressaoDarf painelSelecionarImpressao = new PainelSelecionarImpressaoDarf(demonstrativo);
                    String mensagem = MensagemUtil.getMensagem("ImpressaoDarf");
                    GuiUtil.exibeDialog(painelSelecionarImpressao, true, mensagem, false);
                    if (!ControladorGui.isDemonstrativoAberto()) {
                        GCAPFacade.fechaDeclaracao();
                        GcapUtil.setEstadoSistema(-1);
                    }
                } else {
                    GuiUtil.mostrarAviso("demonstrativoDesatualizado");
                }
                this.idSelecionado = null;
            }
        }
        catch (Exception pE) {
            this.idSelecionado = null;
            ControladorGui.tratarException(pE);
        }
    }

    private void voltaPainelPrincipal() {
        PainelDemonstrativoIf p = ControladorGui.getPainelAtualmenteExibido();
        String nomeClasse = p.getClass().getName();
        if (nomeClasse.indexOf("imoveis") != -1) {
            ControladorGui.acionarPainel(NavegacaoIf.PAINEL_BEM_IMOVEL);
        } else if (nomeClasse.indexOf("moveis") != -1) {
            ControladorGui.acionarPainel(NavegacaoIf.PAINEL_BEM_MOVEL);
        } else if (nomeClasse.indexOf("psocietar") != -1) {
            ControladorGui.acionarPainel(NavegacaoIf.PAINEL_PARTICIPACAO_SOCIETARIA);
        }
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        if (ControladorGui.isDemonstrativoAberto()) {
            this.idSelecionado = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo();
        }
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDemonstrativo() {
        return "ConfirmarFecharDemonstrativo";
    }
}

