/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.dialogs.PainelImprimirSelecionarDeclaracao;
import br.gov.serpro.gcap.gui.dialogs.PainelSelecionarImpressaoDemonstrativo;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class ImprimirDemonstrativoAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    private IdDemonstrativoGCAP idSelecionado = null;

    @Override
    public void executarAcao(ActionEvent e) {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DemonstrativoGCAP[] demonstrativo = new DemonstrativoGCAP[]{ControladorGui.getDemonstrativoAberto()};
                        PainelSelecionarImpressaoDemonstrativo painelSelecionarImpressao = new PainelSelecionarImpressaoDemonstrativo(demonstrativo);
                        ControladorGui.getDemonstrativoAberto().atualizarCalculoFaixasImposto();
                        try {
                            ControladorGui.salvarDemonstrativoAberto();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String mensagem = MensagemUtil.getMensagem("ImpressaoDemonstrativo");
                        GuiUtil.exibeDialog(painelSelecionarImpressao, true, mensagem, false);
                    }
                });
            } else {
                if (this.idSelecionado == null) {
                    PainelImprimirSelecionarDeclaracao painelDeclaracoes = new PainelImprimirSelecionarDeclaracao("Como fazer para.../Imprimir Demonstrativo");
                    GuiUtil.exibeDialog(painelDeclaracoes, true, "Imprimir Demonstrativo", false);
                    this.idSelecionado = painelDeclaracoes.getIdSelecionado();
                }
                if (this.idSelecionado != null) {
                    GCAPFacade.getInstancia();
                    GCAPFacade.abreDeclaracao(this.idSelecionado);
                    DemonstrativoGCAP[] demonstrativo = new DemonstrativoGCAP[]{GCAPFacade.getInstancia().getDeclaracao()};
                    PainelSelecionarImpressaoDemonstrativo painelSelecionarImpressao = new PainelSelecionarImpressaoDemonstrativo(demonstrativo);
                    GuiUtil.exibeDialog(painelSelecionarImpressao, true, "Imprimir Demonstrativo", false);
                    GCAPFacade.getInstancia();
                    GCAPFacade.fechaDeclaracao();
                }
                this.idSelecionado = null;
            }
        }
        catch (Exception pE) {
            this.idSelecionado = null;
            ControladorGui.tratarException(pE);
        }
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        if (ControladorGui.isDemonstrativoAberto()) {
            this.idSelecionado = ControladorGui.getDemonstrativoAberto().getIdDemonstrativo();
        }
        return true;
    }
}

