/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.dialogs.PainelResultadoDuasListas;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.importacao.ResultadoImportacaoDTO;
import br.gov.serpro.gcap.util.GcapUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.Validador;

public class RestaurarCopiaSegurancaAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isFecharDemonstrativoExigido() {
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDemonstrativo() {
        return "ConfirmarFecharDemonstrativoRestaurarCopia";
    }

    @Override
    public void executarAcao(ActionEvent e) {
        try {
            JFileChooser fc = UtilitariosGUI.setFileChooserProperties((String)"Restaurar c\u00f3pia de seguran\u00e7a de demonstrativo", (String)"Procurar em:", (String)"OK", (String)"Restaurar demonstrativo");
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(new GCAPFileFilter());
            fc.setMultiSelectionEnabled(true);
            if (fc.showDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), null) == 0) {
                GcapUtil.setEstadoSistema(2);
                ResultadoImportacaoDTO retorno = ControladorGui.restaurarCopiaSeguranca(fc.getSelectedFiles());
                if (retorno != null && (retorno.getImportados().size() > 0 || retorno.getNaoImportados().size() > 0)) {
                    List<String> restaurados = retorno.getImportados();
                    List<String> naorestaurados = retorno.getNaoImportados();
                    PainelResultadoDuasListas painelResultado = new PainelResultadoDuasListas("Itens restaurados:", restaurados, "Itens n\u00e3o restaurados:", naorestaurados);
                    GuiUtil.exibeDialog(painelResultado, true, "Restaura\u00e7\u00e3o de c\u00f3pia de seguran\u00e7a", true);
                }
                if (ControladorGui.getDemonstrativoAberto() == null) {
                    GcapUtil.setEstadoSistema(-1);
                } else {
                    GcapUtil.setEstadoSistema(0);
                }
            }
        }
        catch (Exception ex) {
            ControladorGui.tratarException(ex);
        }
    }

    private void definirDiretorioPadrao(JFileChooser pFileChooser) {
        try {
            File lDefaultDir = new File(File.separator);
            if (lDefaultDir.exists() && lDefaultDir.isDirectory()) {
                pFileChooser.setCurrentDirectory(lDefaultDir);
            } else {
                pFileChooser.setCurrentDirectory(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class GCAPFileFilter
    extends FileFilter {
        private final String padraoNomeCopiaSeguranca = "^(\\d{11}-\\d{4}-\\d{4}-" + ConstantesGlobais.NOME_PROGRAMA + "-" + ConstantesGlobais.EXERCICIO + "\\.DBK)$";
        private final String padraoNomeArquivoExportacaoIRPF = "^(\\d{11}-\\d{4}-\\d{4}-" + ConstantesGlobais.NOME_PROGRAMA + "-" + ConstantesGlobais.EXERCICIO + "\\.DEC)$";

        private GCAPFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return Validador.validarString((String)f.getName(), (String)this.padraoNomeCopiaSeguranca) || Validador.validarString((String)f.getName(), (String)this.padraoNomeArquivoExportacaoIRPF);
        }

        @Override
        public String getDescription() {
            return "Arquivos GCAP " + ConstantesGlobais.EXERCICIO;
        }
    }
}

