/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.acoes.SairAction;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.update.PainelAvisoVerificarAtualizacoes;
import br.gov.serpro.gcap.gui.update.PainelDownloadAtualizacoes;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.gui.util.ProcessoSwing;
import br.gov.serpro.gcap.gui.util.TarefaComExcecao;
import br.gov.serpro.gcap.gui.util.Toast;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.util.update.PGDAppUpdateProperties;
import br.gov.serpro.gcap.util.update.PGDAppUpdater;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jupar.Downloader;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.RoundedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;
import serpro.ppgd.gui.DialogoOcupado;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.LogPPGD;

public class VerificarNovaVersaoAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    public static final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    private PGDAppUpdateProperties updateProperties = null;
    private static SwingWorker<PGDAppUpdateProperties, Void> worker = null;
    private boolean exibirPopups = true;

    @Override
    public void executarAcao(ActionEvent e) {
        this.verificarUltimaVersao();
    }

    public void verificarUltimaVersao() {
        if (worker == null || SwingWorker.StateValue.DONE.equals((Object)worker.getState())) {
            worker = new SwingWorker<PGDAppUpdateProperties, Void>(){
                private DialogoOcupado dlg = null;

                @Override
                protected PGDAppUpdateProperties doInBackground() throws Exception {
                    this.dlg = DialogoOcupado.exibeDialogo((String)"Verificando atualiza\u00e7\u00e3o...");
                    return PGDAppUpdater.getInstance().verificarUltimaVersaoOnline();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    PGDAppUpdateProperties updateProperties = null;
                    AplicacaoException ex = null;
                    try {
                        updateProperties = worker.get();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        Throwable cause = e.getCause();
                        ex = cause != null && cause instanceof AplicacaoException ? (AplicacaoException)cause : new AplicacaoException("atualizar.erro.verificacao");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ex = new AplicacaoException("atualizar.erro.verificacao");
                    }
                    finally {
                        this.dlg.finaliza();
                    }
                    VerificarNovaVersaoAction.this.verificacaoFinalizada(PGDAppUpdater.getInstance(), updateProperties, ex);
                }
            };
        }
        if (SwingWorker.StateValue.PENDING.equals((Object)worker.getState())) {
            worker.execute();
        }
    }

    public void verificacaoFinalizada(PGDAppUpdater pgdUpdater, PGDAppUpdateProperties updateProperties, AplicacaoException exception) {
        if (exception != null) {
            GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), exception.getMessage());
        } else if (updateProperties != null) {
            this.confirmarNovaVersao(pgdUpdater, updateProperties);
        } else {
            Map<String, CadastroTabelasGCAP.TabelasBasicas> mapaArquivosParaAtualizar = this.obterMapaArquivosParaAtualizar(pgdUpdater);
            if (mapaArquivosParaAtualizar.size() > 0) {
                this.atualizarTabelas(pgdUpdater, mapaArquivosParaAtualizar);
            } else if (this.isExibirPopups()) {
                GuiUtil.mostrarInfo("atualizar.aviso.semNovaVersao", new String[]{ConstantesGlobais.EXERCICIO});
            }
        }
    }

    public Map<String, CadastroTabelasGCAP.TabelasBasicas> obterMapaArquivosParaAtualizar(PGDAppUpdater pgdUpdater) {
        CadastroTabelasGCAP.TabelasBasicas[] tabelas;
        HashMap<String, CadastroTabelasGCAP.TabelasBasicas> mapaArquivosParaAtualizar = new HashMap<String, CadastroTabelasGCAP.TabelasBasicas>();
        for (CadastroTabelasGCAP.TabelasBasicas tabela : tabelas = CadastroTabelasGCAP.TabelasBasicas.values()) {
            if (!pgdUpdater.temNovaVersaoArquivo(tabela.getIdentificador(), tabela.getHash())) continue;
            mapaArquivosParaAtualizar.put(tabela.getIdentificador(), tabela);
        }
        return mapaArquivosParaAtualizar;
    }

    public void confirmarNovaVersao(PGDAppUpdater pgdUpdater, PGDAppUpdateProperties updateProperties) {
        this.confirmarNovaVersao(pgdUpdater, updateProperties, null);
    }

    public void confirmarNovaVersao(final PGDAppUpdater pgdUpdater, final PGDAppUpdateProperties updateProperties, final BalloonTip balloonTip) {
        String titulo = MensagemUtil.getMensagem("atualizar.titulo");
        String mensagem = null;
        PainelAvisoVerificarAtualizacoes painel = null;
        if (!pgdUpdater.temPermissaoEscritaPastaBase() || updateProperties.isDownloadManual()) {
            mensagem = updateProperties.getTipoAtualizacao() == PGDAppUpdateProperties.TipoAtualizacao.Obrigatoria ? (pgdUpdater.temPermissaoEscritaPastaBase() ? "atualizar.aviso.atualizacaoManualObrigatoria" : "atualizar.aviso.semPermissaoAtualizacao.atualizacaoManualObrigatoria") : (pgdUpdater.temPermissaoEscritaPastaBase() ? "atualizar.aviso.atualizacaoManual" : "atualizar.aviso.semPermissaoAtualizacao.atualizacaoManual");
            mensagem = MensagemUtil.getMensagem(mensagem, new String[]{ConstantesGlobais.EXERCICIO, updateProperties.getUltimaVersao()});
            painel = new PainelAvisoVerificarAtualizacoes(titulo, mensagem, "Sim", "N\u00e3o");
            GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painel, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
            if (painel.isAtualizar()) {
                try {
                    pgdUpdater.execNavegador(updateProperties.getEnderecoServidorDownloadManual());
                }
                catch (AplicacaoException e) {
                    e.printStackTrace();
                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
                }
                SairAction fecharAction = new SairAction();
                fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                fecharAction.actionPerformed(null);
            }
        } else {
            mensagem = updateProperties.getTipoAtualizacao() == PGDAppUpdateProperties.TipoAtualizacao.Obrigatoria ? "atualizar.confirma.atualizacaoObrigatoria" : "atualizar.confirma.novaVersao";
            mensagem = MensagemUtil.getMensagem(mensagem, new String[]{ConstantesGlobais.EXERCICIO, updateProperties.getUltimaVersao()});
            painel = new PainelAvisoVerificarAtualizacoes(titulo, mensagem);
            GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painel, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
            if (painel.isAtualizar()) {
                if (balloonTip != null) {
                    balloonTip.closeBalloon();
                }
                if (this.verificarDemonstrativoFechado()) {
                    final PainelDownloadAtualizacoes painelDownload = new PainelDownloadAtualizacoes();
                    final Downloader.DownloadProgress progress = new Downloader.DownloadProgress(512){

                        public void onProgressChanged(boolean finished) {
                            final long downloaded = this.getTotalDownloadedFileSize() * 100L / this.getTotalDownloadingFileSize();
                            if (finished) {
                                if (this.isCanceled()) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            painelDownload.getLblDescricao().setText("Transfer\u00eancia de arquivos cancelada.");
                                            painelDownload.getLblPercentual().setText("");
                                            painelDownload.getProgressBar().setValue(painelDownload.getProgressBar().getMaximum());
                                        }
                                    });
                                } else {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            painelDownload.getLblDescricao().setText("Transfer\u00eancia de arquivos conclu\u00edda.");
                                            painelDownload.getLblPercentual().setText("");
                                            painelDownload.getProgressBar().setValue(painelDownload.getProgressBar().getMaximum());
                                        }
                                    });
                                }
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        painelDownload.getLblDescricao().setText("Transferindo arquivo " + (this.getTotalDownloadedFiles() + 1) + " de " + this.getTotalFiles());
                                        painelDownload.getLblPercentual().setText(downloaded + "% completo");
                                        painelDownload.getProgressBar().setValue((int)downloaded);
                                    }
                                });
                            }
                        }
                    };
                    painelDownload.getBtnCancelar().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            progress.setCanceled(true);
                        }
                    });
                    Runnable updatethread = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painelDownload, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
                                    }
                                });
                                pgdUpdater.download(updateProperties, progress);
                            }
                            catch (AplicacaoException ex) {
                                try {
                                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex.getMessage());
                                }
                                catch (Throwable throwable) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            GuiUtil.fecharDialog(painelDownload);
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            if (progress.isCanceled()) {
                                System.out.println("Atualiza\u00e7\u00e3o do " + ConstantesGlobais.NOME_PROGRAMA + ConstantesGlobais.EXERCICIO + ". Transfer\u00eancia de arquivos cancelada.");
                                GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagem("atualizar.aviso.downloadCancelado"));
                            } else {
                                System.out.println("Atualiza\u00e7\u00e3o do " + ConstantesGlobais.NOME_PROGRAMA + ConstantesGlobais.EXERCICIO + ". Transfer\u00eancia de arquivos conclu\u00edda.");
                                GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new PainelAvisoVerificarAtualizacoes("Concluir Atualiza\u00e7\u00e3o", MensagemUtil.getMensagem("atualizar.aviso.update"), PainelAvisoVerificarAtualizacoes.IconeAvisoAtualizacao.ICONE_OK, null, "OK"), true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
                                SairAction fecharAction = new SairAction(){
                                    private static final long serialVersionUID = 1L;

                                    @Override
                                    protected void onExitPgd() {
                                        try {
                                            pgdUpdater.execUpdate(updateProperties);
                                        }
                                        catch (AplicacaoException ex) {
                                            GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex.getMessage());
                                        }
                                    }
                                };
                                fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                                fecharAction.actionPerformed(null);
                            }
                        }
                    };
                    new Thread(updatethread).start();
                }
            } else if (balloonTip != null) {
                balloonTip.setVisible(true);
                TimingUtils.showTimedBalloon(balloonTip, 10000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        balloonTip.closeBalloon();
                    }
                });
            }
        }
    }

    public void atualizarTabelas(final PGDAppUpdater pgdUpdater, final Map<String, CadastroTabelasGCAP.TabelasBasicas> mapaArquivosParaAtualizar) {
        if (pgdUpdater.temPermissaoEscritaPastaBase() && this.verificarDemonstrativoFechado()) {
            final DialogoOcupado dlg = DialogoOcupado.exibeDialogo((String)"Atualizando tabelas internas...");
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    System.out.println("Executando download...");
                    pgdUpdater.download(mapaArquivosParaAtualizar.keySet(), null);
                    pgdUpdater.update(mapaArquivosParaAtualizar.keySet());
                    pgdUpdater.resetUpdateStatus();
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                protected void done() {
                    AplicacaoException ex = null;
                    try {
                        this.get();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        Throwable cause = e.getCause();
                        ex = cause != null && cause instanceof AplicacaoException ? (AplicacaoException)cause : new AplicacaoException("atualizar.erro.verificacao", e);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println("Fechando dlg...");
                                dlg.finaliza();
                            }
                        });
                        if (ex == null) {
                            for (CadastroTabelasGCAP.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                                tabela.carregarTabela();
                            }
                            ControladorGui.informarTabelasAtualizadas();
                            if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                                GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                            } else {
                                Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem("atualizar.info.atualizacaoTabelasSucesso")).display();
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        ex = new AplicacaoException("atualizar.erro.verificacao");
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        if (ex == null) {
                            for (CadastroTabelasGCAP.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                                tabela.carregarTabela();
                            }
                            ControladorGui.informarTabelasAtualizadas();
                            if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                                GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                            } else {
                                Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem("atualizar.info.atualizacaoTabelasSucesso")).display();
                            }
                        }
                        {
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                if (ex == null) {
                                    for (CadastroTabelasGCAP.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                                        tabela.carregarTabela();
                                    }
                                    ControladorGui.informarTabelasAtualizadas();
                                    if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                                        GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                                    } else {
                                        Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem("atualizar.info.atualizacaoTabelasSucesso")).display();
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    if (ex == null) {
                        for (CadastroTabelasGCAP.TabelasBasicas tabela : mapaArquivosParaAtualizar.values()) {
                            tabela.carregarTabela();
                        }
                        ControladorGui.informarTabelasAtualizadas();
                        if (VerificarNovaVersaoAction.this.isExibirPopups()) {
                            GuiUtil.mostrarInfo("atualizar.info.atualizacaoTabelasSucesso");
                        } else {
                            Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem("atualizar.info.atualizacaoTabelasSucesso")).display();
                        }
                    }
                }
            }.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificarNovaVersao() {
        final PGDAppUpdater pgdUpdater = PGDAppUpdater.getInstance();
        boolean mostrouPopUp = false;
        if (pgdUpdater.temPermissaoEscritaPastaBase()) {
            PGDAppUpdateProperties updateProperties = null;
            DialogoOcupado diaOcupado = null;
            try {
                updateProperties = pgdUpdater.temAtualizacaoCompletada();
                if (updateProperties != null) {
                    mostrouPopUp = true;
                    Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem(ConstantesGlobais.NOME_PROGRAMA + " Atualizado com sucesso. Vers\u00e3o " + updateProperties.getVersaoAtual() + ".")).display();
                    if (updateProperties.getMensagem() != null && !updateProperties.getMensagem().trim().isEmpty()) {
                        GuiUtil.exibeDialog(ControladorGui.getJanelaPrincipal(), new PainelAvisoVerificarAtualizacoes("Nova Vers\u00e3o Instalada", updateProperties.getMensagem(), null, "OK"), true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, true, false);
                    }
                }
            }
            catch (AplicacaoException aplicacaoException) {
                // empty catch block
            }
            try {
                updateProperties = null;
                if (pgdUpdater.verificarUltimaVersaoAposPeriodo()) {
                    diaOcupado = DialogoOcupado.exibeDialogo((String)"Verificando atualiza\u00e7\u00e3o...");
                    Object obj = ProcessoSwing.executarTarefaComExcecao(new TarefaComExcecao(){

                        @Override
                        public Object definirTarefa() throws Exception {
                            return pgdUpdater.verificarUltimaVersaoOnline();
                        }

                        @Override
                        public void definirComportamentoExcecao(Exception exception) {
                            LogPPGD.erro((String)exception.getMessage());
                        }
                    });
                    if (obj != null && obj instanceof PGDAppUpdateProperties) {
                        updateProperties = (PGDAppUpdateProperties)obj;
                    }
                }
            }
            catch (Exception obj) {
            }
            finally {
                if (diaOcupado != null) {
                    diaOcupado.finaliza();
                }
            }
            if (updateProperties != null) {
                mostrouPopUp = true;
                BalloonTip balloonTip = new BalloonTip(ControladorGui.getJanelaPrincipal().getJMenuFerramentas(), new JLabel(MensagemUtil.getMensagem("atualizar.aviso.dicaMenuFerramentas")), new RoundedBalloonStyle(5, 5, Color.white, Color.gray), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 30, 15, true);
                balloonTip.setVisible(false);
                balloonTip.setPadding(10);
                balloonTip.setTopLevelContainer(ControladorGui.getJanelaPrincipal().getLayeredPane());
                this.confirmarNovaVersao(pgdUpdater, updateProperties, balloonTip);
            }
        }
        return mostrouPopUp;
    }

    public boolean isExibirPopups() {
        return this.exibirPopups;
    }

    public void setExibirPopups(boolean exibirPopups) {
        this.exibirPopups = exibirPopups;
    }
}

