/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.acoes;

import br.gov.serpro.gcap.acoes.ActionAb;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.pendencias.PainelPendencias;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class VerificarPendenciasAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    @Override
    public void executarAcao(ActionEvent e) {
        try {
            ControladorGui.salvarDemonstrativoAberto();
        }
        catch (Exception ex) {
            Logger.getLogger(VerificarPendenciasAction.class.getName()).log(Level.SEVERE, null, ex);
        }
        PendenciasDemonstrativo pendencias = this.obterPendencias(ControladorGui.getDemonstrativoAberto());
        this.exibirPendencias(pendencias);
    }

    public PendenciasDemonstrativo obterPendencias(DemonstrativoGCAP dem) {
        int totalErros = 0;
        int totalAvisos = 0;
        List pendencias = FabricaUtilitarios.verificarPendencias((Object)((Object)dem));
        Iterator itPendencia = pendencias.iterator();
        block4: while (itPendencia.hasNext()) {
            Pendencia p = (Pendencia)itPendencia.next();
            switch (p.getSeveridade()) {
                case 2: {
                    ++totalAvisos;
                    continue block4;
                }
                case 3: 
                case 5: {
                    ++totalErros;
                    continue block4;
                }
            }
            itPendencia.remove();
        }
        return new PendenciasDemonstrativo(pendencias, totalErros, totalAvisos);
    }

    public PendenciasDemonstrativo obterPendencias(ColecaoMoedaAlienada colecaoMoedaAlienada) {
        int totalErros = 0;
        int totalAvisos = 0;
        List pendencias = FabricaUtilitarios.verificarPendencias((Object)((Object)colecaoMoedaAlienada));
        Iterator itPendencia = pendencias.iterator();
        block4: while (itPendencia.hasNext()) {
            Pendencia p = (Pendencia)itPendencia.next();
            switch (p.getSeveridade()) {
                case 2: {
                    ++totalAvisos;
                    continue block4;
                }
                case 3: 
                case 5: {
                    ++totalErros;
                    continue block4;
                }
            }
            itPendencia.remove();
        }
        return new PendenciasDemonstrativo(pendencias, totalErros, totalAvisos);
    }

    public void exibirPendencias(PendenciasDemonstrativo pendencias) {
        if (pendencias.getPendencias().isEmpty()) {
            GuiUtil.mostrarInfo("msg_nao_pendencias");
        } else {
            PainelPendencias painelVerificarPendencias = new PainelPendencias(pendencias.getPendencias());
            ControladorGui.acionarPainel(painelVerificarPendencias);
            ControladorGui.getJanelaPrincipal().setLastAccessedItem(this.getClass());
        }
    }

    public class PendenciasDemonstrativo {
        private List<Pendencia> pendencias;
        private int totalErros;
        private int totalAvisos;

        public PendenciasDemonstrativo(List<Pendencia> pendencias, int totalErros, int totalAvisos) {
            this.pendencias = pendencias;
            this.totalErros = totalErros;
            this.totalAvisos = totalAvisos;
        }

        public List<Pendencia> getPendencias() {
            return this.pendencias;
        }

        public int getTotalErros() {
            return this.totalErros;
        }

        public int getTotalAvisos() {
            return this.totalAvisos;
        }
    }
}

