/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.app;

import br.gov.serpro.gcap.acoes.NovidadesAction;
import br.gov.serpro.gcap.app.PGDAb;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.JanelaPrincipalGCAP;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.util.OpcoesApp;
import java.util.Locale;
import serpro.ppgd.infraestrutura.JanelaPrincipalPPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PGDGCAP
extends PGDAb {
    public static void main(String[] pArgs) throws Exception {
        Locale.setDefault(new Locale("pt", "BR"));
        System.setProperty("javax.xml.bind.JAXBContextFactory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
        try {
            if (pArgs.length > 0 && pArgs[0].equals("--verifica")) {
                if (PGDGCAP.verificaPGDEmExecucao()) {
                    System.out.print("1");
                } else {
                    System.out.print("0");
                }
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            OpcoesApp opcoes = new OpcoesApp(pArgs);
            opcoes.processaArgs();
            PGDGCAP.verificarSO();
            PGDGCAP.verificaVersaoMinimaJava("1.7.0");
            if (FabricaUtilitarios.isLinux() && pArgs.length > 0) {
                String complemento = null;
                if (pArgs[0].equals("--leia-me")) {
                    complemento = "Leia_me.htm";
                } else if (pArgs[0].equals("--ajuda")) {
                    complemento = "./help/AjudaGCAP.pdf";
                }
                if (complemento != null) {
                    Runtime.getRuntime().exec("xdg-open " + complemento, null);
                    System.exit(1);
                }
            }
            if (pArgs.length > 0 && (pArgs[0].equals("-h") || pArgs[0].equals("--help"))) {
                PGDGCAP.mostrarHelp();
            } else {
                new PGDGCAP();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtil.mostrarErro(null, e.getMessage());
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            GuiUtil.mostrarErro(null, "Ocorreu um erro inesperado!\nO aplicativo ser\u00e1 encerrado!");
            System.exit(1);
        }
    }

    public PGDGCAP() throws Exception {
        super(JanelaPrincipalGCAP.class);
    }

    @Override
    protected void posCriar(PlataformaPPGD pPlataforma) {
        ControladorGui.init();
        ((JanelaPrincipalPPGD)PlataformaPPGD.getPlataforma().getJanelaPrincipal()).configurarHelp();
    }

    @Override
    protected boolean getPermiteMaisDeUmaInstanciaAplicacao() {
        return false;
    }

    private void mostrarNovidades() {
        if (!ControladorGui.getGCAPPreferences().getBoolean(ControladorGui.NAO_EXIBIR_NOVIDADES_GCAP, false)) {
            new NovidadesAction().executarAcao(null);
        }
    }
}

