/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades;

import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.entidades.especie.TotalizacaoMoedasAlienadas;
import br.gov.serpro.gcap.observador.ObservadorCalculoTotaisParcelasBem;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;

public class DemonstrativoGCAP
extends ObjetoNegocio
implements DeclaracaoComIdentificador {
    private transient IdDemonstrativoGCAP idDemonstrativo;
    private IdDemonstrativoGCAP copiaIdentificador = new IdDemonstrativoGCAP();
    private ColecaoAlienacaoBemImovel bensImoveis;
    private ColecaoAlienacaoBemMovel bensMoveis;
    private ColecaoAlienacaoParticipacaoSocietaria participacoesSocietarias;
    private ColecaoMoedaAlienada moedasAlienadas;
    private TotalizacaoMoedasAlienadas totalizacaoMoedasAlienadas;
    private Consolidacao consolidacaoBrasil;
    private Consolidacao consolidacaoExterior;
    private DataHora dataHoraSalvamento = new DataHora((ObjetoNegocio)this, "dataHoraSalvamento");

    public DemonstrativoGCAP(IdDemonstrativoGCAP pIdentificadorDemonstrativo) {
        this.idDemonstrativo = pIdentificadorDemonstrativo;
        this.copiaIdentificador = pIdentificadorDemonstrativo;
        this.bensImoveis = new ColecaoAlienacaoBemImovel();
        this.bensMoveis = new ColecaoAlienacaoBemMovel();
        this.participacoesSocietarias = new ColecaoAlienacaoParticipacaoSocietaria();
        this.moedasAlienadas = new ColecaoMoedaAlienada();
        this.totalizacaoMoedasAlienadas = new TotalizacaoMoedasAlienadas();
        this.consolidacaoBrasil = new Consolidacao();
        this.consolidacaoExterior = new Consolidacao();
        Observador obsResidenteBrasil = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Alienacao alienacao = (Alienacao)((Object)valorNovo);
                if (DemonstrativoGCAP.this.getIdDemonstrativo().isDemonstrativoBrasil()) {
                    alienacao.getResidenteBrasil().setConteudo(Logico.SIM);
                } else {
                    alienacao.getResidenteBrasil().setConteudo(Logico.NAO);
                }
            }
        };
        this.getBensImoveis().addObservador("ObjetoInserido", obsResidenteBrasil);
        this.getBensMoveis().addObservador("ObjetoInserido", obsResidenteBrasil);
        this.getParticipacoesSocietarias().addObservador("ObjetoInserido", obsResidenteBrasil);
        final Observador obsAdquirenteTitular = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ((Adquirente)valorNovo).getCpfCnpj().addValidador((ValidadorIf)new ValidadorDefault(3){

                    public RetornoValidacao validarImplementado() {
                        if (!this.getInformacao().isVazio() && this.getInformacao().naoFormatado().equals(DemonstrativoGCAP.this.getIdDemonstrativo().getCpf().naoFormatado())) {
                            return new RetornoValidacao("O CPF/CNPJ do adquirente n\u00e3o pode ser o mesmo do contribuinte que est\u00e1 preenchendo o demonstrativo atual.", this.getSeveridade());
                        }
                        return null;
                    }
                });
            }
        };
        this.getBensImoveis().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel alienacao = (AlienacaoBemImovel)((Object)valorNovo);
                alienacao.getBemImovel().getAdquirentes().addObservador("ObjetoInserido", obsAdquirenteTitular);
                for (Adquirente adquirente : alienacao.getBemImovel().getAdquirentes().itens()) {
                    obsAdquirenteTitular.notifica(null, null, null, (Object)adquirente);
                }
            }
        });
        this.getBensMoveis().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemMovel alienacao = (AlienacaoBemMovel)((Object)valorNovo);
                alienacao.getBemMovel().getAdquirentes().addObservador("ObjetoInserido", obsAdquirenteTitular);
                for (Adquirente adquirente : alienacao.getBemMovel().getAdquirentes().itens()) {
                    obsAdquirenteTitular.notifica(null, null, null, (Object)adquirente);
                }
            }
        });
        this.getParticipacoesSocietarias().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria alienacao = (AlienacaoParticipacaoSocietaria)((Object)valorNovo);
                alienacao.getAdquirentes().addObservador("ObjetoInserido", obsAdquirenteTitular);
                for (Adquirente adquirente : alienacao.getAdquirentes().itens()) {
                    obsAdquirenteTitular.notifica(null, null, null, (Object)adquirente);
                }
            }
        });
        this.adicionarObservadoresConsolidacaoGeral();
        this.adicionaValidadoresEspeciais();
    }

    public IdentificadorDeclaracaoXML getIdentificador() {
        return this.idDemonstrativo;
    }

    public IdDemonstrativoGCAP getIdentificadorDeclaracao() {
        return this.idDemonstrativo;
    }

    public IdDemonstrativoGCAP getCopiaIdentificador() {
        return this.copiaIdentificador;
    }

    public IdDemonstrativoGCAP getIdDemonstrativo() {
        return this.idDemonstrativo;
    }

    public void setIdDemonstrativo(IdDemonstrativoGCAP idDemonstrativo) {
        this.idDemonstrativo = idDemonstrativo;
    }

    public ColecaoAlienacaoBemImovel getBensImoveis() {
        return this.bensImoveis;
    }

    public ColecaoAlienacaoBemMovel getBensMoveis() {
        return this.bensMoveis;
    }

    public ColecaoAlienacaoParticipacaoSocietaria getParticipacoesSocietarias() {
        return this.participacoesSocietarias;
    }

    public DataHora getDataHoraSalvamento() {
        return this.dataHoraSalvamento;
    }

    public void adicionarObservadoresPosAbertura() {
        this.adicionarObservadoresTotaisParcela();
    }

    private void adicionarObservadoresTotaisParcela() {
    }

    public ColecaoMoedaAlienada getMoedasAlienadas() {
        return this.moedasAlienadas;
    }

    public Consolidacao getConsolidacaoBrasil() {
        return this.consolidacaoBrasil;
    }

    public Consolidacao getConsolidacaoExterior() {
        return this.consolidacaoExterior;
    }

    private void adicionarObservadoresConsolidacaoGeral() {
        Observador obsTotalImpostoDevidoAnoAtual = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoDevidoAnoAtual());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoDevidoAnoAtual());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalImpostoDevidoAnoAtual());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getImpostoDevidoAnoAtual().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoDevidoAnoAtual().addObservador(obsTotalImpostoDevidoAnoAtual);
        this.getBensMoveis().getTotalImpostoDevidoAnoAtual().addObservador(obsTotalImpostoDevidoAnoAtual);
        this.getParticipacoesSocietarias().getTotalImpostoDevidoAnoAtual().addObservador(obsTotalImpostoDevidoAnoAtual);
        Observador obsTotalImpostoDiferidoAnosAnteriores = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoDiferidoAnosAnteriores());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoDiferidoAnosAnteriores());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalImpostoDiferidoAnosAnteriores());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getImpostoDiferidoAnosAnteriores().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoDiferidoAnosAnteriores().addObservador(obsTotalImpostoDiferidoAnosAnteriores);
        this.getBensMoveis().getTotalImpostoDiferidoAnosAnteriores().addObservador(obsTotalImpostoDiferidoAnosAnteriores);
        this.getParticipacoesSocietarias().getTotalImpostoDiferidoAnosAnteriores().addObservador(obsTotalImpostoDiferidoAnosAnteriores);
        Observador obsTotalImpostoDiferidoAnosPosteriores = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoDiferidoAnosPosteriores());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoDiferidoAnosPosteriores());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalImpostoDiferidoAnosPosteriores());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getImpostoDiferidoAnosPosteriores().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoDiferidoAnosPosteriores().addObservador(obsTotalImpostoDiferidoAnosPosteriores);
        this.getBensMoveis().getTotalImpostoDiferidoAnosPosteriores().addObservador(obsTotalImpostoDiferidoAnosPosteriores);
        this.getParticipacoesSocietarias().getTotalImpostoDiferidoAnosPosteriores().addObservador(obsTotalImpostoDiferidoAnosPosteriores);
        Observador obsTotalImpostoReferenteAlienacaoAnoAtual = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoReferenteAlienacaoAnoAtual());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoReferenteAlienacaoAnoAtual());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalImpostoReferenteAlienacaoAnoAtual());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getImpostoReferenteAlienacaoAnoAtual().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoReferenteAlienacaoAnoAtual().addObservador(obsTotalImpostoReferenteAlienacaoAnoAtual);
        this.getBensMoveis().getTotalImpostoReferenteAlienacaoAnoAtual().addObservador(obsTotalImpostoReferenteAlienacaoAnoAtual);
        this.getParticipacoesSocietarias().getTotalImpostoReferenteAlienacaoAnoAtual().addObservador(obsTotalImpostoReferenteAlienacaoAnoAtual);
        Observador obsTotalImpostoTotal = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoTotal());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoTotal());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalImpostoTotal());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getImpostoTotal().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoTotal().addObservador(obsTotalImpostoTotal);
        this.getBensMoveis().getTotalImpostoTotal().addObservador(obsTotalImpostoTotal);
        this.getParticipacoesSocietarias().getTotalImpostoTotal().addObservador(obsTotalImpostoTotal);
        Observador obsTotalValorIRF = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalValorIRF());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalValorIRF());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalValorIRF());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getValorIRF().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalValorIRF().addObservador(obsTotalValorIRF);
        this.getBensMoveis().getTotalValorIRF().addObservador(obsTotalValorIRF);
        this.getParticipacoesSocietarias().getTotalValorIRF().addObservador(obsTotalValorIRF);
        Observador obsTotalImpostoPagoBrasil = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoPagoBrasil());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoPagoBrasil());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalImpostoPago());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getTotalImpostoPago().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoPagoBrasil().addObservador(obsTotalImpostoPagoBrasil);
        this.getBensMoveis().getTotalImpostoPagoBrasil().addObservador(obsTotalImpostoPagoBrasil);
        this.getParticipacoesSocietarias().getTotalImpostoPago().addObservador(obsTotalImpostoPagoBrasil);
        Observador obsTotalImpostoPagoExterior = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalImpostoPagoExterior());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalImpostoPagoExterior());
                DemonstrativoGCAP.this.getConsolidacaoExterior().getTotalImpostoPago().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalImpostoPagoExterior().addObservador(obsTotalImpostoPagoExterior);
        this.getBensMoveis().getTotalImpostoPagoExterior().addObservador(obsTotalImpostoPagoExterior);
        Observador obsTotalRendIsentosNaoTributaveisBrasil = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalRendIsentosNaoTributaveisBrasil());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalRendIsentosNaoTributaveisBrasil());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalRendIsentosNaoTributaveis());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getTotalRendIsentosNaoTributaveis().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalRendIsentosNaoTributaveisBrasil().addObservador(obsTotalRendIsentosNaoTributaveisBrasil);
        this.getBensMoveis().getTotalRendIsentosNaoTributaveisBrasil().addObservador(obsTotalRendIsentosNaoTributaveisBrasil);
        this.getParticipacoesSocietarias().getTotalRendIsentosNaoTributaveis().addObservador(obsTotalRendIsentosNaoTributaveisBrasil);
        Observador obsTotalRendIsentosNaoTributaveisExterior = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalRendIsentosNaoTributaveisExterior());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalRendIsentosNaoTributaveisExterior());
                DemonstrativoGCAP.this.getConsolidacaoExterior().getTotalRendIsentosNaoTributaveis().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalRendIsentosNaoTributaveisExterior().addObservador(obsTotalRendIsentosNaoTributaveisExterior);
        this.getBensMoveis().getTotalRendIsentosNaoTributaveisExterior().addObservador(obsTotalRendIsentosNaoTributaveisExterior);
        Observador obsTotalRendSujeitosTributacaoBrasil = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalRendSujeitosTributacaoBrasil());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalRendSujeitosTributacaoBrasil());
                total.append('+', DemonstrativoGCAP.this.getParticipacoesSocietarias().getTotalRendSujeitosTributacao());
                DemonstrativoGCAP.this.getConsolidacaoBrasil().getTotalRendSujeitosTributacao().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalRendSujeitosTributacaoBrasil().addObservador(obsTotalRendSujeitosTributacaoBrasil);
        this.getBensMoveis().getTotalRendSujeitosTributacaoBrasil().addObservador(obsTotalRendSujeitosTributacaoBrasil);
        this.getParticipacoesSocietarias().getTotalRendSujeitosTributacao().addObservador(obsTotalRendSujeitosTributacaoBrasil);
        Observador obsTotalRendSujeitosTributacaoExterior = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo total = new ValorPositivo();
                total.append('+', DemonstrativoGCAP.this.getBensImoveis().getTotalRendSujeitosTributacaoExterior());
                total.append('+', DemonstrativoGCAP.this.getBensMoveis().getTotalRendSujeitosTributacaoExterior());
                DemonstrativoGCAP.this.getConsolidacaoExterior().getTotalRendSujeitosTributacao().setConteudo(total);
            }
        };
        this.getBensImoveis().getTotalRendSujeitosTributacaoExterior().addObservador(obsTotalRendSujeitosTributacaoExterior);
        this.getBensMoveis().getTotalRendSujeitosTributacaoExterior().addObservador(obsTotalRendSujeitosTributacaoExterior);
    }

    public void recalcularAlienacoes() {
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            if (imovel.isAlienacaoBrasil()) {
                imovel.recalcularImpostoBrasil();
                continue;
            }
            imovel.recalcularImpostoExterior();
        }
        for (AlienacaoBemMovel movel : this.getBensMoveis().itens()) {
            if (movel.isAlienacaoBrasil()) {
                movel.recalcularImpostoBrasil();
                continue;
            }
            movel.recalcularImpostoExterior();
        }
        for (AlienacaoParticipacaoSocietaria sociedade : this.getParticipacoesSocietarias().itens()) {
            sociedade.recalcularImpostoBrasil();
        }
    }

    public void ajustarFlagCobranca() {
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            imovel.ajustarFlagCobranca();
        }
        for (AlienacaoBemMovel movel : this.getBensMoveis().itens()) {
            movel.ajustarFlagCobranca();
        }
    }

    public void atualizarCalculoFaixasImposto() {
        for (AlienacaoBemImovel imovel : this.bensImoveis.itens()) {
            imovel.getCalculoImposto().atualizarCalculoFaixasImposto(imovel.getGanhoCapitalAlienacaoAnterior(), imovel.getCalculoImposto().getGanhoCapitalTotal());
        }
        for (AlienacaoBemMovel movel : this.bensMoveis.itens()) {
            movel.getCalculoImposto().atualizarCalculoFaixasImposto(movel.getGanhoCapitalAlienacaoAnterior(), movel.getCalculoImposto().getGanhoCapitalTotal());
        }
        for (AlienacaoParticipacaoSocietaria pSocietaria : this.participacoesSocietarias.itens()) {
            pSocietaria.getCalculoImposto().atualizarCalculoFaixasImposto(pSocietaria.getGanhoCapitalAlienacaoAnterior(), pSocietaria.getCalculoImposto().getGanhoCapitalTotal());
        }
    }

    public void atualizarDataDarfTCM() {
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            if (!alienacao.isTransmissaoCausaMortis()) continue;
            alienacao.getDataVencimentoTCM().setConteudo(alienacao.calculaDataVencimentoDarfCausaMortis());
        }
        for (Alienacao alienacao : this.getBensMoveis().itens()) {
            if (!alienacao.isTransmissaoCausaMortis()) continue;
            alienacao.getDataVencimentoTCM().setConteudo(alienacao.calculaDataVencimentoDarfCausaMortis());
        }
        for (Alienacao alienacao : this.getParticipacoesSocietarias().itens()) {
            if (!alienacao.isTransmissaoCausaMortis()) continue;
            alienacao.getDataVencimentoTCM().setConteudo(alienacao.calculaDataVencimentoDarfCausaMortis());
        }
    }

    public void corrigirErroGCAP2020_1_5() {
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            if (!imovel.getBemImovel().getAquisicao().getHouveReforma().naoFormatado().equals(Logico.SIM)) continue;
            if (imovel.isAlienacaoBrasil()) {
                imovel.recalcularImpostoBrasil();
                continue;
            }
            imovel.recalcularImpostoExterior();
        }
    }

    public void corrigirErroGCAP2024_1_2() {
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            if (imovel.isAlienacaoBrasil()) {
                imovel.getApuracao().getGanhoCapital5().forcaDisparoObservadores();
                continue;
            }
            if (imovel.getAquisicao().getOrigemRendimentos().naoFormatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL) || imovel.getAquisicao().getOrigemRendimentos().naoFormatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) {
                imovel.getApuracao().getGanhoCapital5OrigemMNReal().forcaDisparoObservadores();
                continue;
            }
            if (!imovel.getAquisicao().getOrigemRendimentos().naoFormatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA) && !imovel.getAquisicao().getOrigemRendimentos().naoFormatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) continue;
            imovel.getApuracao().getGanhoCapital5OrigemMEReal().forcaDisparoObservadores();
        }
    }

    public void corrigirErroGCAPSemFaixasAjuste() {
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            if (imovel.isAlienacaoBrasil()) continue;
            imovel.getAjuste().getGanhoCapitalTotal().forcaDisparoObservadores();
        }
        for (AlienacaoBemMovel movel : this.getBensMoveis().itens()) {
            if (movel.isAlienacaoBrasil()) continue;
            movel.getAjuste().getGanhoCapitalTotal().forcaDisparoObservadores();
        }
    }

    public void corrigirErroGCAP2025_1_0() {
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            if (!imovel.isAlienacaoBrasil() || !imovel.getBemImovel().getAquisicao().getHouveReforma().isVazio() && !Logico.NAO.equals(imovel.getBemImovel().getAquisicao().getHouveReforma().naoFormatado())) continue;
            imovel.getBemImovel().getAquisicao().getCustoAquisicao().forcaDisparoObservadores();
        }
    }

    public void adicionaObservadoresCalculosLate() {
        Object parcelaFake;
        this.getBensImoveis().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemImovel imovel = (AlienacaoBemImovel)((Object)valorNovo);
                imovel.getColecaoParcelaAlienacao().addObservador(new ObservadorCalculoTotaisParcelasBem(imovel));
            }
        });
        for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
            imovel.getColecaoParcelaAlienacao().addObservador(new ObservadorCalculoTotaisParcelasBem(imovel));
            for (ParcelaAlienacaoBem parcela : imovel.getColecaoParcelaAlienacao().itens()) {
                parcela.addObservador(new ObservadorCalculoTotaisParcelasBem(imovel));
            }
            parcelaFake = new ParcelaAlienacaoBem();
            imovel.getColecaoParcelaAlienacao().add((ObjetoNegocio)parcelaFake);
            imovel.getColecaoParcelaAlienacao().remove((ObjetoNegocio)parcelaFake);
        }
        this.getBensMoveis().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBemMovel movel = (AlienacaoBemMovel)((Object)valorNovo);
                movel.getColecaoParcelaAlienacao().addObservador(new ObservadorCalculoTotaisParcelasBem(movel));
            }
        });
        for (AlienacaoBemMovel movel : this.getBensMoveis().itens()) {
            movel.getColecaoParcelaAlienacao().addObservador(new ObservadorCalculoTotaisParcelasBem(movel));
            for (ParcelaAlienacaoBem parcela : movel.getColecaoParcelaAlienacao().itens()) {
                parcela.addObservador(new ObservadorCalculoTotaisParcelasBem(movel));
            }
            parcelaFake = new ParcelaAlienacaoBem();
            movel.getColecaoParcelaAlienacao().add((ObjetoNegocio)parcelaFake);
            movel.getColecaoParcelaAlienacao().remove((ObjetoNegocio)parcelaFake);
        }
        Observador obsRecalculoOperacoes = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                DemonstrativoGCAP.this.totalizacaoMoedasAlienadas.recalcular();
            }
        };
        for (MoedaAlienada moeda : this.moedasAlienadas.itens()) {
            for (OperacaoEspecie operacao : moeda.getOperacoesEspecie().itens()) {
                if (!"2".equals(operacao.getTipo().naoFormatado())) continue;
                operacao.getData().addObservador(obsRecalculoOperacoes);
                operacao.getQuantidade().addObservador(obsRecalculoOperacoes);
                operacao.getValor().addObservador(obsRecalculoOperacoes);
                operacao.getCotacaoDolar().addObservador(obsRecalculoOperacoes);
            }
        }
    }

    private void adicionaValidadoresEspeciais() {
    }

    public TotalizacaoMoedasAlienadas getTotalizacaoMoedasAlienadas() {
        return this.totalizacaoMoedasAlienadas;
    }
}

