/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.adquirente;

import br.gov.serpro.gcap.observador.ObservadorEspacosDuplicados;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorNomePessoaFisica;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Adquirente
extends ObjetoNegocio
implements Cloneable {
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do adquirente", 60);
    private NI cpfCnpj = new NI((ObjetoNegocio)this, "CPF/CNPJ do adquirente");

    public Adquirente() {
        this.adicionaObservadores();
        this.adicionaValidadores();
    }

    private void adicionaValidadores() {
        this.cpfCnpj.addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("erroCampoInvalido", new String[]{this.cpfCnpj.getNomeCampo()})));
        this.nome.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.nome.getNomeCampo()})));
        this.nome.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Adquirente.this.cpfCnpj.naoFormatado().length() <= 11) {
                    Alfa lNome = new Alfa();
                    lNome.addValidador((ValidadorIf)new ValidadorNomePessoaFisica(3));
                    lNome.setConteudo(Adquirente.this.nome);
                    RetornoValidacao retorno = lNome.validar().getPrimeiroRetornoValidacaoMaisSevero();
                    if (!retorno.isValido()) {
                        return retorno;
                    }
                }
                return new RetornoValidacao(0);
            }
        });
    }

    private void adicionaObservadores() {
        this.nome.addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    public Alfa getNome() {
        return this.nome;
    }

    public String getNomeImpressao() {
        return this.nome.formatado();
    }

    public void setNome(Alfa nome) {
        this.nome = nome;
    }

    public NI getCpfCnpj() {
        return this.cpfCnpj;
    }

    public String getCpfCnpjImpressao() {
        return this.cpfCnpj.formatado();
    }

    public void setCpfCnpj(NI cpf) {
        this.cpfCnpj = cpf;
    }

    public boolean isVazio() {
        return this.nome.isVazio() && this.cpfCnpj.isVazio();
    }

    public Adquirente obterCopia() {
        Adquirente clone = new Adquirente();
        clone.getNome().setConteudo(this.getNome());
        clone.getCpfCnpj().setConteudo(this.getCpfCnpj());
        return clone;
    }

    public void restaurar(Adquirente adquirente) {
        this.getNome().setConteudo(adquirente.getNome());
        this.getCpfCnpj().setConteudo(adquirente.getCpfCnpj());
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaAdquirentes() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getCpfCnpj());
        lista.add((Informacao)this.getNome());
        return lista;
    }
}

