/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.adquirente;

import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.validador.ValidadorCpfCnpjAdquirente;
import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ValidadorIf;

public class ColecaoAdquirente
extends Colecao<Adquirente> {
    private WeakReference<Alienacao> weakAlienacao;

    public ColecaoAdquirente(Alienacao alienacao) {
        super(Adquirente.class.getName());
        this.weakAlienacao = new WeakReference<Alienacao>(alienacao);
    }

    public boolean isExisteAdquirente(NI pCpfCnpj) {
        for (int i = this.itens().size() - 1; i >= 0; --i) {
            Adquirente adquirente = (Adquirente)this.itens().get(i);
            if (!adquirente.getCpfCnpj().formatado().trim().equals(pCpfCnpj.formatado().trim())) continue;
            return true;
        }
        return false;
    }

    public boolean isExisteAdquirente(NI pCpfCnpj, int pPosicao) {
        for (int i = this.itens().size() - 1; i >= 0; --i) {
            Adquirente adquirente = (Adquirente)this.itens().get(i);
            if (adquirente.getCpfCnpj().isVazio() || !adquirente.getCpfCnpj().formatado().trim().equals(pCpfCnpj.formatado().trim()) || i == pPosicao) continue;
            return true;
        }
        return false;
    }

    public ColecaoAdquirente obterCopia() {
        ColecaoAdquirente novaColecao = new ColecaoAdquirente((Alienacao)((Object)this.weakAlienacao.get()));
        List itens = this.itens();
        for (Adquirente adquirenteRecuperado : itens) {
            Adquirente novoAdquirente = new Adquirente();
            novoAdquirente.getCpfCnpj().setConteudo(adquirenteRecuperado.getCpfCnpj());
            novoAdquirente.getNome().setConteudo(adquirenteRecuperado.getNome());
            novaColecao.itens().add(novoAdquirente);
        }
        return novaColecao;
    }

    public void adicionaAdquirente(Adquirente pAdquirente) throws AplicacaoException {
        if (this.isExisteAdquirente(pAdquirente.getCpfCnpj()) && !pAdquirente.getCpfCnpj().isVazio()) {
            throw new AplicacaoException("ErroAdquirenteJaExiste");
        }
        this.itens().add(pAdquirente);
    }

    public void objetoInserido(Adquirente e) {
        e.getCpfCnpj().addValidador((ValidadorIf)new ValidadorCpfCnpjAdquirente((Alienacao)((Object)this.weakAlienacao.get())));
    }
}

