/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.apuracao.Apuracao;
import br.gov.serpro.gcap.entidades.calculo.Ajuste;
import br.gov.serpro.gcap.entidades.calculo.CalculoImposto;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorData;
import br.gov.serpro.gcap.validador.ValidadorDataAlienacao;
import br.gov.serpro.gcap.validador.ValidadorDataNaturezaCreditoJurosEResgateAplicacaoFinanceira;
import br.gov.serpro.gcap.validador.ValidadorDataNaturezaDoacaoLegitimaEDissolucaoConjugal;
import br.gov.serpro.gcap.validador.ValidadorDataNaturezaTransmissaoCausaMortis;
import br.gov.serpro.gcap.validador.ValidadorDataTransitoJulgado;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public abstract class Alienacao
extends ObjetoNegocio {
    public static int CONSTANTE_ANO_MINIMO_ALIENACAO_PARCIAL = 2017;
    public static int TIPO_ALIENACAO_BEM_IMOVEL = 1;
    public static int TIPO_ALIENACAO_BEM_MOVEL = 2;
    public static int TIPO_ALIENACAO_PARTICIPACAO_SOCIETARIA = 3;
    public static final String LABEL_CAMPO_DATA_ALIENACAO = "Data de Aliena\u00e7\u00e3o";
    public static final String LABEL_CAMPO_DATA_TRANSITO_JULGADO = "Data do tr\u00e2nsito em julgado";
    public static final String LABEL_CAMPO_DATA_DECISAO_JUDICIAL = "Data da decis\u00e3o judicial";
    public static final String LABEL_CAMPO_DATA_LAVRATURA = "Data da Lavratura";
    public static final String LABEL_CAMPO_NATUREZA = "Natureza";
    public static final String LABEL_CAMPO_VALOR_RECEBIDO_ANOS_ANTERIORES = "Valor Recebido em Anos Anteriores";
    public static final String LABEL_CAMPO_CORRETAGEM_ANOS_ANTERIORES = "Corretagem em Anos Anteriores";
    public static final String LABEL_CAMPO_VALOR_LIQUIDO_RECEBIDO_ANOS_ANTERIORES = "Valor L\u00edquido Recebido em Anos Anteriores";
    public static final String LABEL_CAMPO_VALOR_APLICADO_OUTRO_IMOVEL_ANOS_ANTERIORES = "Valor Aplicado em Outro Im\u00f3vel em Anos Anteriores";
    public static final String CONSTANTE_ALIQUOTA_FIXA_15_PORCENTO = "0,150000000";
    public static final String CONSTANTE_ALIQUOTA_FIXA_20_PORCENTO = "0,200000000";
    public static final String CONSTANTE_ALIQUOTA_FIXA_25_PORCENTO = "0,250000000";
    public static final int ANO_TRANSICAO_PARAISOS_FISCAIS = 2019;
    private Codigo natureza = new Codigo((ObjetoNegocio)this, "Natureza", new ArrayList());
    private Data dataAlienacao = new Data((ObjetoNegocio)this, "Data de Aliena\u00e7\u00e3o");
    private Data dataTransitoJulgado = new Data((ObjetoNegocio)this, "Data do tr\u00e2nsito em julgado");
    private Data dataRecebimentoUltimaParcela = new Data((ObjetoNegocio)this, "Data de Recebimento da \u00daltima Parcela");
    private Logico temUltimaParcela = new Logico((ObjetoNegocio)this, "A presta\u00e7\u00e3o/parcela final foi recebida em " + AplicacaoPropertiesUtil.getExercicio() + "?");
    private Logico motivoTransmissaoCausaMortisDecisaoJudicial = new Logico((ObjetoNegocio)this, "Decis\u00e3o Judicial?");
    private Logico alienacaoAPrazo = new Logico((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o");
    private ValorPositivo valorAlienacao = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o (R$)");
    private ValorPositivo custoCorretagem = new ValorPositivo(this, "Custo Corretagem (R$)");
    private Logico alienacaoParcial = new Logico((ObjetoNegocio)this, "J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem?");
    private Logico bemGrandeValor = new Logico((ObjetoNegocio)this, "O valor do conjundo dos bens ou direitos da mesma natureza, alienados em m\u00eas/ano, \u00e9 superior a 35.000,00?");
    private Logico bemGrandeValorOperacao = new Logico((ObjetoNegocio)this, " Resposta para bemGrandeValor se dados da opera\u00e7\u00e3o permitia");
    private ValorPositivo ganhoCapitalAlienacaoAnterior = new ValorPositivo(this, "Ganho de Capital de Aliena\u00e7\u00e3o anterior");
    private ValorPositivo valorLiquidoRecebidoAnosAnteriores = new ValorPositivo(this, "Valor L\u00edquido Recebido em Anos Anteriores");
    private ValorPositivo valorRecebidoAnosAnteriores = new ValorPositivo(this, "Valor Recebido em Anos Anteriores");
    private ValorPositivo corretagemAnosAnteriores = new ValorPositivo(this, "Corretagem em Anos Anteriores");
    private ValorPositivo valorAplicadoOutroImovelAnosAnteriores = new ValorPositivo(this, "Valor Aplicado em Outro Im\u00f3vel em Anos Anteriores");
    private CalculoImposto calculoImposto = new CalculoImposto();
    private Ajuste ajuste = new Ajuste();
    private Consolidacao consolidacao = new Consolidacao();
    private Logico alienacaoAnoAnterior = new Logico((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi realizada no ano anterior?");
    private Alfa numeroItem = new Alfa((ObjetoNegocio)this, "N\u00famero do Item");
    private Logico recebimentoUltimaParcelaAnoAnterior = new Logico((ObjetoNegocio)this, "A presta\u00e7\u00e3o/parcela final foi recebida em " + AplicacaoPropertiesUtil.getExercicioAnterior() + "?");
    private Logico residenteBrasil = new Logico((ObjetoNegocio)this, "\u00c9 residente no Brasil?");
    private Data dataVencimentoTCM = new Data((ObjetoNegocio)this, "Data de vencimento do DARF para TCM");
    private Codigo paisResidencia = new Codigo((ObjetoNegocio)this, "Pais de Resid\u00eancia", CadastroTabelasGCAP.recuperarPaises());
    private Logico territorioParaisoFiscal = new Logico((ObjetoNegocio)this, "Territ\u00f3rio Para\u00edso Fiscal");

    public Alienacao() {
        this.getTemUltimaParcela().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTemUltimaParcela().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getTemUltimaParcela().setConteudo(Logico.NAO);
        this.getAlienacaoAPrazo().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getAlienacaoAPrazo().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getAlienacaoParcial().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getAlienacaoParcial().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getBemGrandeValor().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemGrandeValor().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getBemGrandeValorOperacao().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemGrandeValorOperacao().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().setConteudo(Logico.SIM);
        this.getRecebimentoUltimaParcelaAnoAnterior().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getRecebimentoUltimaParcelaAnoAnterior().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getResidenteBrasil().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getResidenteBrasil().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.adicionarValidadoresAlienacao();
        this.adicionarObservadoresAlienacao();
        this.getDataRecebimentoUltimaParcela().setReadOnly(true);
        this.getTemUltimaParcela().setReadOnly(true);
        this.getValorLiquidoRecebidoAnosAnteriores().setReadOnly(true);
    }

    public abstract Apuracao getApuracao();

    public void adicionarValidadoresAlienacao() {
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorDataAlienacao(this, 3));
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getInformacao().getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorData(3));
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorDataAlienacao(this, 3));
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorDataNaturezaDoacaoLegitimaEDissolucaoConjugal(this, 3));
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorDataNaturezaCreditoJurosEResgateAplicacaoFinanceira(this, 3));
        this.getDataAlienacao().addValidador((ValidadorIf)new ValidadorDataNaturezaTransmissaoCausaMortis(this, 3));
        this.getDataTransitoJulgado().addValidador((ValidadorIf)new ValidadorDataTransitoJulgado(this, 3));
        this.getDataTransitoJulgado().addValidador((ValidadorIf)new ValidadorData(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno != null && Alienacao.this.isDataTransitoJulgadoObrigatoria()) {
                    return retorno;
                }
                return new RetornoValidacao(0);
            }
        });
        this.getAlienacaoAPrazo().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getAlienacaoAPrazo().getNomeCampo()})));
        this.getCorretagemAnosAnteriores().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Alienacao.this.isAlienacaoBrasil() && Alienacao.this.isAlienacaoEmAnoAnterior() && Alienacao.this.getCorretagemAnosAnteriores().comparacao(">", Alienacao.this.getValorRecebidoAnosAnteriores())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroComissaoMaiorAlienacaoAnoAnterior"));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorRecebidoAnosAnteriores().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo resultado = new ValorPositivo(null, "resultado");
                resultado.setConteudo(Alienacao.this.getValorRecebidoAnosAnteriores());
                resultado.append('-', Alienacao.this.getCorretagemAnosAnteriores());
                if (!resultado.equals((Object)Alienacao.this.getValorLiquidoRecebidoAnosAnteriores())) {
                    return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("valorLiquidoAnosAnterioresDiferente"));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    public void adicionarObservadoresAlienacao() {
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Alienacao.LABEL_CAMPO_NATUREZA.equals(nomePropriedade)) {
                    int codNaturezaNovo = -1;
                    try {
                        codNaturezaNovo = Integer.valueOf((String)valorNovo);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int codNaturezaAntigo = -1;
                    try {
                        codNaturezaAntigo = Integer.valueOf((String)valorAntigo);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_ALIENACAO);
                    if (codNaturezaNovo != codNaturezaAntigo && codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS) {
                        Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_DECISAO_JUDICIAL);
                    }
                    if (GcapUtil.getEstadoSistema() != 2) {
                        boolean apenasAVista = false;
                        boolean aliquotaFixa = false;
                        if (codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA) {
                            apenasAVista = true;
                        }
                        if (codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA) {
                            aliquotaFixa = true;
                        }
                        if (apenasAVista) {
                            Alienacao.this.alienacaoAPrazo.setReadOnly(true);
                            Alienacao.this.alienacaoAPrazo.setConteudo(Logico.NAO);
                            if (aliquotaFixa) {
                                Alienacao.this.alienacaoParcial.clear();
                            }
                        } else if (Alienacao.this.isAlienacaoEmAnoAnterior()) {
                            Alienacao.this.alienacaoAPrazo.setConteudo(Logico.SIM);
                            Alienacao.this.alienacaoAPrazo.setReadOnly(true);
                            Alienacao.this.alienacaoAnoAnterior.setConteudo(Logico.SIM);
                            if (!Alienacao.this.podeTerAlienacaoParcial()) {
                                Alienacao.this.alienacaoParcial.clear();
                            }
                        } else {
                            Alienacao.this.alienacaoAPrazo.setReadOnly(false);
                            Alienacao.this.alienacaoAnoAnterior.setConteudo(Logico.NAO);
                        }
                    }
                }
            }
        });
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Alienacao.this.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals(Logico.SIM)) {
                    Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_DECISAO_JUDICIAL);
                } else {
                    Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_LAVRATURA);
                }
            }
        });
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                int codNatureza = -1;
                try {
                    codNatureza = Integer.valueOf(Alienacao.this.getNatureza().naoFormatado());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (GcapUtil.getEstadoSistema() != 2) {
                    boolean apenasAVista = false;
                    boolean aliquotaFixa = false;
                    if (codNatureza == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codNatureza == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || codNatureza == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || codNatureza == AlienacaoBem.CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA || codNatureza == AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA) {
                        apenasAVista = true;
                    }
                    if (codNatureza == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codNatureza == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || codNatureza == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA) {
                        aliquotaFixa = true;
                    }
                    if (apenasAVista) {
                        Alienacao.this.alienacaoAPrazo.setReadOnly(true);
                        Alienacao.this.alienacaoAPrazo.setConteudo(Logico.NAO);
                        if (aliquotaFixa) {
                            Alienacao.this.alienacaoParcial.clear();
                        }
                    } else if (Alienacao.this.isAlienacaoEmAnoAnterior()) {
                        Alienacao.this.alienacaoAPrazo.setConteudo(Logico.SIM);
                        Alienacao.this.alienacaoAPrazo.setReadOnly(true);
                        Alienacao.this.alienacaoAnoAnterior.setConteudo(Logico.SIM);
                        if (!Alienacao.this.podeTerAlienacaoParcial()) {
                            Alienacao.this.alienacaoParcial.clear();
                        }
                    } else {
                        Alienacao.this.alienacaoAPrazo.setReadOnly(false);
                        Alienacao.this.alienacaoAnoAnterior.setConteudo(Logico.NAO);
                    }
                }
            }
        });
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Alienacao.this.getDataAlienacao().naoFormatado().trim().length() == 8 && Integer.parseInt(Alienacao.this.getDataAlienacao().getAno()) >= Integer.parseInt(ConstantesGlobais.EXERCICIO)) {
                    Alienacao.this.getValorRecebidoAnosAnteriores().clear();
                    Alienacao.this.getCorretagemAnosAnteriores().clear();
                    Alienacao.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                }
            }
        });
        this.getAlienacaoParcial().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!Alienacao.this.temAlienacaoParcial()) {
                    Alienacao.this.getGanhoCapitalAlienacaoAnterior().clear();
                }
            }
        });
        this.getDataRecebimentoUltimaParcela().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (GcapUtil.getEstadoSistema() != 2 && Alienacao.this.isAlienacaoAPrazo()) {
                    if (Alienacao.this.getDataRecebimentoUltimaParcela().isVazio()) {
                        Alienacao.this.getTemUltimaParcela().setConteudo(Logico.NAO);
                    } else {
                        Alienacao.this.getTemUltimaParcela().setConteudo(Logico.SIM);
                    }
                }
            }
        });
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!Alienacao.this.getNatureza().isVazio() && Integer.valueOf(Alienacao.this.getNatureza().naoFormatado()) == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS) {
                    Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_DECISAO_JUDICIAL);
                } else if (Alienacao.this.getMotivoTransmissaoCausaMortisDecisaoJudicial().equals(Logico.SIM)) {
                    Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_LAVRATURA);
                } else {
                    Alienacao.this.getDataAlienacao().setNomeCampo(Alienacao.LABEL_CAMPO_DATA_ALIENACAO);
                }
            }
        });
        Observador obsValorLiquidoRecebidoAnosAnteriores = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ValorPositivo resultado = new ValorPositivo(null, "resultado");
                resultado.setConteudo(Alienacao.this.getValorRecebidoAnosAnteriores());
                resultado.append('-', Alienacao.this.getCorretagemAnosAnteriores());
                Alienacao.this.getValorLiquidoRecebidoAnosAnteriores().setConteudo(resultado);
            }
        };
        this.getValorRecebidoAnosAnteriores().addObservador(obsValorLiquidoRecebidoAnosAnteriores);
        this.getCorretagemAnosAnteriores().addObservador(obsValorLiquidoRecebidoAnosAnteriores);
    }

    public Codigo getNatureza() {
        return this.natureza;
    }

    public Data getDataAlienacao() {
        return this.dataAlienacao;
    }

    public Data getDataTransitoJulgado() {
        return this.dataTransitoJulgado;
    }

    public Data getDataRecebimentoUltimaParcela() {
        return this.dataRecebimentoUltimaParcela;
    }

    public Logico getTemUltimaParcela() {
        return this.temUltimaParcela;
    }

    public Logico getMotivoTransmissaoCausaMortisDecisaoJudicial() {
        return this.motivoTransmissaoCausaMortisDecisaoJudicial;
    }

    public Logico getAlienacaoAPrazo() {
        return this.alienacaoAPrazo;
    }

    public ValorPositivo getValorAlienacao() {
        return this.valorAlienacao;
    }

    public ValorPositivo getCustoCorretagem() {
        return this.custoCorretagem;
    }

    public Logico getAlienacaoParcial() {
        return this.alienacaoParcial;
    }

    public ValorPositivo getGanhoCapitalAlienacaoAnterior() {
        return this.ganhoCapitalAlienacaoAnterior;
    }

    public ValorPositivo getValorLiquidoRecebidoAnosAnteriores() {
        return this.valorLiquidoRecebidoAnosAnteriores;
    }

    public ValorPositivo getValorRecebidoAnosAnteriores() {
        return this.valorRecebidoAnosAnteriores;
    }

    public ValorPositivo getCorretagemAnosAnteriores() {
        return this.corretagemAnosAnteriores;
    }

    public ValorPositivo getValorAplicadoOutroImovelAnosAnteriores() {
        return this.valorAplicadoOutroImovelAnosAnteriores;
    }

    public CalculoImposto getCalculoImposto() {
        return this.calculoImposto;
    }

    public Ajuste getAjuste() {
        return this.ajuste;
    }

    public Consolidacao getConsolidacao() {
        return this.consolidacao;
    }

    public boolean isAlienacaoAPrazo() {
        return Logico.SIM.equals(this.getAlienacaoAPrazo().naoFormatado());
    }

    public boolean isAlienacaoAVista() {
        return Logico.NAO.equals(this.getAlienacaoAPrazo().naoFormatado());
    }

    public boolean temAlienacaoParcial() {
        return Logico.SIM.equals(this.getAlienacaoParcial().naoFormatado());
    }

    public Logico getBemGrandeValor() {
        return this.bemGrandeValor;
    }

    public Logico getBemGrandeValorOperacao() {
        return this.bemGrandeValorOperacao;
    }

    public boolean isBemPequenoValor() {
        return Logico.NAO.equals(this.getBemGrandeValor().naoFormatado());
    }

    public boolean isBemPequenoValorOperacao() {
        return Logico.NAO.equals(this.getBemGrandeValorOperacao().naoFormatado());
    }

    public boolean isAlienacaoBrasil() {
        return true;
    }

    public Codigo obterCodigoOrigemRendimentos() {
        return null;
    }

    public void calcularApuracao() {
    }

    public abstract String obterAliquotaFixa();

    public Logico getAlienacaoAnoAnterior() {
        return this.alienacaoAnoAnterior;
    }

    public boolean podeTerAlienacaoParcial() {
        boolean retorno = false;
        int anoAlienacao = 0;
        try {
            anoAlienacao = Integer.valueOf(this.getDataAlienacao().getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (anoAlienacao >= CONSTANTE_ANO_MINIMO_ALIENACAO_PARCIAL) {
            retorno = true;
        }
        return retorno;
    }

    public abstract boolean podeResponderPerguntaBemIsentoPorPequenoValor();

    public void calcularParcelaBrasil(ParcelaAlienacao parcela) {
        ValorPositivo valorLiquidoAlienacao = new ValorPositivo(null, "valorLiquidoAlienacao", 11, 9);
        ValorPositivo custoAquisicaoProporcional = new ValorPositivo(null, "custoAquisicaoProporcional", 11, 9);
        ValorPositivo ganhoProporcional = new ValorPositivo(null, "Ganho Proporcional", 11, 9);
        ValorPositivo impostoDevido = new ValorPositivo(null, "ImpostoDevido Parcela", 11, 9);
        ValorPositivo impostoDevido2 = new ValorPositivo(null, "ImpostoDevido2 Parcela", 11, 9);
        ValorPositivo irrfLei110332004 = new ValorPositivo(null, "ImpostoRetidoFonte Parcela", 11, 9);
        valorLiquidoAlienacao.setConteudo(parcela.getValorRecebido());
        valorLiquidoAlienacao.append('-', parcela.getCustoCorretagem());
        parcela.getValorLiquidoAlienacao().setConteudo(valorLiquidoAlienacao);
        if (this.getApuracao().getValorLiquidoAlienacao().isVazio()) {
            parcela.getGanhoCapital1Proporcional().clear();
            parcela.getAliquotaMedia().clear();
            parcela.getImpostoDevido().clear();
            parcela.getImpostoDevido2().clear();
        } else {
            custoAquisicaoProporcional.setConteudo(parcela.getValorLiquidoAlienacao());
            custoAquisicaoProporcional.append('*', this.getApuracao().getCustoAquisicao());
            custoAquisicaoProporcional.append('/', this.getApuracao().getValorLiquidoAlienacao());
            custoAquisicaoProporcional.converteQtdCasasDecimaisRoundUp(2);
            parcela.getCustoAquisicaoProporcional().setConteudo(custoAquisicaoProporcional);
            ganhoProporcional.setConteudo(parcela.getValorLiquidoAlienacao());
            ganhoProporcional.append('-', parcela.getCustoAquisicaoProporcional());
            parcela.getGanhoCapital1Proporcional().setConteudo(ganhoProporcional);
            if (this.isIsento()) {
                impostoDevido.clear();
                parcela.getAliquotaMedia().clear();
            } else {
                parcela.getAliquotaMedia().setConteudo(this.getCalculoImposto().getAliquotaMedia());
                if (!this.getCalculoImposto().getGanhoCapitalTotal().isVazio()) {
                    impostoDevido.setConteudo(ganhoProporcional);
                    impostoDevido.append('*', this.getCalculoImposto().calcularImpostoDevidoTotal(this));
                    impostoDevido.append('/', this.getCalculoImposto().getGanhoCapitalTotal());
                }
            }
            parcela.getImpostoDevido().setConteudo(impostoDevido);
            irrfLei110332004.setConteudo(parcela.getIrrfLei110332004());
            impostoDevido2.setConteudo(impostoDevido);
            impostoDevido2.append('-', irrfLei110332004);
            parcela.getImpostoDevido2().setConteudo(impostoDevido2);
        }
    }

    public boolean isAlienacaoEmAnoAnterior() {
        int ano = AplicacaoPropertiesUtil.getExercicioAsInt();
        try {
            ano = Integer.valueOf(this.dataAlienacao.getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ano < AplicacaoPropertiesUtil.getExercicioAsInt();
    }

    public boolean isPaisAlienacaoIgualDemonstrativo(IdDemonstrativoGCAP id) {
        return this.getPaisResidencia().naoFormatado().equals(id.getPaisDeclarante().naoFormatado());
    }

    public boolean isTransmissaoCausaMortis() {
        int codNatureza = -1;
        try {
            codNatureza = Integer.valueOf(this.getNatureza().naoFormatado());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codNatureza == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS;
    }

    public boolean isDataTransitoJulgadoObrigatoria() {
        return this.isTransmissaoCausaMortis() && this.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals(Logico.SIM);
    }

    public boolean deveExibirMensagemValorecebidoAnoAnterior() {
        try {
            ValorBigDecimal valorZero = new ValorBigDecimal("0,00");
            if (this.dataAlienacao.naoFormatado().length() == 8 && Integer.parseInt(this.dataAlienacao.getAno()) < AplicacaoPropertiesUtil.getExercicioAsInt() && this.valorLiquidoRecebidoAnosAnteriores.comparacao(">", valorZero) && this.valorRecebidoAnosAnteriores.comparacao("=", valorZero)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isIsento() {
        return this.isBemPequenoValor();
    }

    public Alfa getNumeroItem() {
        return this.numeroItem;
    }

    public Logico getResidenteBrasil() {
        return this.residenteBrasil;
    }

    public Data getDataVencimentoTCM() {
        return this.dataVencimentoTCM;
    }

    public Codigo getPaisResidencia() {
        return this.paisResidencia;
    }

    public Logico getTerritorioParaisoFiscal() {
        return this.territorioParaisoFiscal;
    }

    public boolean isPaisResidenciaBrasil() {
        return "105".equals(this.getPaisResidencia().naoFormatado());
    }

    public boolean isPaisResidenciaExterior() {
        return !this.getPaisResidencia().isVazio() && !"105".equals(this.getPaisResidencia().naoFormatado());
    }

    public Logico getRecebimentoUltimaParcelaAnoAnterior() {
        return this.recebimentoUltimaParcelaAnoAnterior;
    }

    public boolean isParaisoFiscal() {
        return this.getPaisResidencia().getConteudoAtual(2).equals(Logico.SIM);
    }

    public boolean isTerritorioParaisoFiscal() {
        return this.getTerritorioParaisoFiscal().naoFormatado().equals(Logico.SIM);
    }

    public Data calculaDataVencimentoDarfCausaMortis() {
        Data dataReferencia;
        Data data = new Data();
        if (this.isTransmissaoCausaMortis() && (dataReferencia = this.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1") ? this.getDataTransitoJulgado() : this.getDataAlienacao()).validar().isTodosValidos()) {
            if (AplicacaoPropertiesUtil.getExercicio().equals(dataReferencia.getAno()) || Integer.valueOf(dataReferencia.getMes()) > 2) {
                data.setConteudo("31/05/" + (Integer.valueOf(dataReferencia.getAno()) + 1));
            } else {
                data.setConteudo("31/05/" + Integer.valueOf(dataReferencia.getAno()));
            }
            Calendar calendario = Calendar.getInstance();
            calendario.setTime(data.asDate());
            if (calendario.get(7) == 1) {
                calendario.add(5, -2);
            } else if (calendario.get(7) == 7) {
                calendario.add(5, -1);
            }
            String lVencimento = new SimpleDateFormat("dd/MM/yyyy").format(calendario.getTime());
            data.setConteudo(lVencimento);
        }
        return data;
    }

    public boolean isAdquirenteRequerido() {
        boolean requerido = true;
        if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL).equals(this.getNatureza().naoFormatado())) {
            requerido = false;
        }
        return requerido;
    }

    public boolean isDesapropriacao() {
        boolean retorno = false;
        int natureza = -1;
        try {
            natureza = Integer.parseInt(this.getNatureza().naoFormatado());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (AlienacaoBemImovel.CODIGO_NATUREZA_DESAPROPRIACAO == natureza) {
            retorno = true;
        }
        return retorno;
    }
}

