/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.apuracao.ApuracaoBem;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorNaoNuloGCAP;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public abstract class AlienacaoBem
extends Alienacao {
    public static int CODIGO_NATUREZA_VENDA = 1;
    public static int CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA = 2;
    public static int CODIGO_NATUREZA_DESAPROPRIACAO = 3;
    public static int CODIGO_NATUREZA_DACAO_EM_PAGAMENTO = 4;
    public static int CODIGO_NATUREZA_OUTRAS_DOACOES = 5;
    public static int CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA = 6;
    public static int CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA = 7;
    public static int CODIGO_NATUREZA_CESSAO_DE_DIREITOS = 8;
    public static int CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA = 9;
    public static int CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO = 18;
    public static int CODIGO_NATUREZA_OUTROS = 10;
    public static int CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL = 11;
    public static int CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS = 12;
    public static int CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA = 13;
    public static int CODIGO_NATUREZA_ALIENACAO_RESGATES_OUTRAS = 14;
    public static int CODIGO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES = 15;
    public static int CODIGO_NATUREZA_ALIENACAO_ACOES_BALCAO = 16;
    public static int CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA = 17;
    public static String DESCRICAO_NATUREZA_VENDA = "Venda";
    public static String DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA = "Permuta com Recebimento de Torna";
    public static String DESCRICAO_NATUREZA_DESAPROPRIACAO = "Desapropria\u00e7\u00e3o";
    public static String DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO = "Da\u00e7\u00e3o em Pagamento";
    public static String DESCRICAO_NATUREZA_OUTRAS_DOACOES = "Outras Doa\u00e7\u00f5es";
    public static String DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA = "Procura\u00e7\u00e3o em Causa Pr\u00f3pria";
    public static String DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA = "Promessa de Compra e Venda";
    public static String DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS = "Cess\u00e3o de Direitos/Cr\u00e9ditos";
    public static String DESCRICAO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA = "Liquida\u00e7\u00e3o ou Resgate de Aplica\u00e7\u00e3o Financeira";
    public static String DESCRICAO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO = "Dep\u00f3sitos em conta corrente, cart\u00e3o de cr\u00e9dito ou d\u00e9bito";
    public static String DESCRICAO_NATUREZA_OUTROS = "Outros";
    public static String DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL = "Dissolu\u00e7\u00e3o da Sociedade Conjugal ou Uni\u00e3o Est\u00e1vel";
    public static String DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS = "Transmiss\u00e3o Causa Mortis";
    public static String DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA = "Doa\u00e7\u00e3o em Adiantamento da Leg\u00edtima";
    public static String DESCRICAO_NATUREZA_ALIENACAO_RESGATES_OUTRAS = "Aliena\u00e7\u00f5es, resgates e outras transfer\u00eancias";
    public static String DESCRICAO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES = "Aliena\u00e7\u00e3o de A\u00e7\u00f5es em Bolsa de Valores";
    public static String DESCRICAO_NATUREZA_ALIENACAO_ACOES_BALCAO = "Aliena\u00e7\u00e3o de A\u00e7\u00f5es em Balc\u00e3o";
    public static String DESCRICAO_CREDITO_JUROS_APLICACAO_FINANCEIRA = "Cr\u00e9dito de Juros de Aplica\u00e7\u00e3o Financeira";
    public static final String VALOR_BEM_PEQUENO_VALOR = "35.000,00";
    public static final String VALOR_BEM_PEQUENO_VALOR_ACOES_BALCAO = "20.000,00";
    private ValorPositivo valorAlienacaoReal = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o - Moenda Nacional (R$)");
    private ValorPositivo valorAlienacaoDolar = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o - (XX$)");
    private ValorPositivo valorCorretagemReal = new ValorPositivo(this, "Custo de Corretagem - Moeda Nacional (R$)");
    private ValorPositivo valorCorretagemDolar = new ValorPositivo(this, "Custo de Corretagem - (XX$)");
    private ValorPositivo cotacaoDolarDataAlienacao = new ValorPositivo(this, "Cota\u00e7\u00e3o da moeda estrangeira na data de aliena\u00e7\u00e3o", 11, 4);
    private Codigo paisAcordo = new Codigo((ObjetoNegocio)this, "Pa\u00eds com acordo Internacional/Reciprocidade de Tratamento", CadastroTabelasGCAP.recuperarPaisesExterior());
    private ValorPositivo valorImpostoExteriorReal = new ValorPositivo(this, "Valor do imposto em Reais (R$)");
    private ColecaoParcelaAlienacaoBem colecaoParcelaAlienacao = new ColecaoParcelaAlienacaoBem(this);
    private Logico inCobranca = new Logico((ObjetoNegocio)this, "Indicador de que o imposto devido dever\u00e1 ser cobrado e enviado ao CCPF");

    public AlienacaoBem() {
        this.getInCobranca().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getInCobranca().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.adicionarValidadoresAlienacaoBem();
        this.adicionarObservadoresAlienacaoBem();
    }

    public void adicionarValidadoresAlienacaoBem() {
        this.getNatureza().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getNatureza().getNomeCampo()})));
        this.getPaisAcordo().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3){

            public RetornoValidacao validarImplementado() {
                if (!AlienacaoBem.this.getValorImpostoExteriorReal().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getValorImpostoExteriorReal().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3){

            public RetornoValidacao validarImplementado() {
                if (!AlienacaoBem.this.getPaisAcordo().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
    }

    public void adicionarObservadoresAlienacaoBem() {
        this.getValorAlienacaoDolar().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBem.this.valorAlienacaoReal.setConteudo(AlienacaoBem.this.valorAlienacaoDolar.operacao('*', AlienacaoBem.this.cotacaoDolarDataAlienacao));
            }
        });
        this.getValorCorretagemDolar().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBem.this.valorCorretagemReal.setConteudo(AlienacaoBem.this.getValorCorretagemDolar());
                AlienacaoBem.this.valorCorretagemReal.append('*', AlienacaoBem.this.cotacaoDolarDataAlienacao);
            }
        });
        this.getCotacaoDolarDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoBem.this.valorAlienacaoReal.setConteudo(AlienacaoBem.this.valorAlienacaoDolar.operacao('*', AlienacaoBem.this.cotacaoDolarDataAlienacao));
                AlienacaoBem.this.valorCorretagemReal.setConteudo(AlienacaoBem.this.valorCorretagemDolar.operacao('*', AlienacaoBem.this.cotacaoDolarDataAlienacao));
            }
        });
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoBem.this instanceof AlienacaoBemMovel && (String.valueOf(valorAntigo).equals(String.valueOf(CODIGO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES)) || String.valueOf(valorAntigo).equals(String.valueOf(CODIGO_NATUREZA_ALIENACAO_ACOES_BALCAO)) || String.valueOf(valorAntigo).equals(String.valueOf(CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA)))) {
                    ControladorGui.getGCAPPreferences().put("msgAbrirDemonstrativo", MensagemUtil.getMensagem("naturezaNaoExisteTributadaIRPF"));
                }
            }
        });
    }

    public ValorPositivo getCotacaoDolarDataAlienacao() {
        return this.cotacaoDolarDataAlienacao;
    }

    public ValorPositivo getValorAlienacaoDolar() {
        return this.valorAlienacaoDolar;
    }

    public ValorPositivo getValorCorretagemDolar() {
        return this.valorCorretagemDolar;
    }

    public ValorPositivo getValorAlienacaoReal() {
        return this.valorAlienacaoReal;
    }

    public ValorPositivo getValorCorretagemReal() {
        return this.valorCorretagemReal;
    }

    public Codigo getPaisAcordo() {
        return this.paisAcordo;
    }

    public ValorPositivo getValorImpostoExteriorReal() {
        return this.valorImpostoExteriorReal;
    }

    public ColecaoParcelaAlienacaoBem getColecaoParcelaAlienacao() {
        return this.colecaoParcelaAlienacao;
    }

    public Logico getInCobranca() {
        return this.inCobranca;
    }

    public void resetAlienacao(boolean isBrasil) {
        if (isBrasil) {
            this.getValorAlienacaoDolar().clear();
            this.getValorCorretagemDolar().clear();
            this.getCotacaoDolarDataAlienacao().clear();
            this.getPaisAcordo().clear();
            this.getValorImpostoExteriorReal().clear();
        } else {
            this.getValorAlienacao().clear();
            this.getCustoCorretagem().clear();
        }
    }

    @Override
    public String obterAliquotaFixa() {
        String aliquota = null;
        if (DataUtil.isDataPreenchida(this.getDataAlienacao()) && 2019 <= Integer.parseInt(this.getDataAlienacao().getAno()) && (Logico.SIM.equals(this.getPaisResidencia().getConteudoAtual(2)) || Logico.SIM.equals(this.getTerritorioParaisoFiscal().naoFormatado()))) {
            aliquota = "0,250000000";
        } else {
            int codigoNatureza = -1;
            if (!this.getNatureza().isVazio()) {
                codigoNatureza = Integer.valueOf(this.getNatureza().naoFormatado());
            }
            if (codigoNatureza == CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codigoNatureza == CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || codigoNatureza == CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS) {
                aliquota = "0,150000000";
            }
        }
        return aliquota;
    }

    public ValorBigDecimal getValorIsencao() {
        ValorBigDecimal valorIsencao = new ValorBigDecimal(null, null, 10, 2);
        if (String.valueOf(CODIGO_NATUREZA_ALIENACAO_ACOES_BALCAO).equals(this.getNatureza().naoFormatado())) {
            valorIsencao.setConteudo(VALOR_BEM_PEQUENO_VALOR_ACOES_BALCAO);
        } else {
            valorIsencao.setConteudo(VALOR_BEM_PEQUENO_VALOR);
        }
        return valorIsencao;
    }

    public String getValorIsencaoAsString() {
        String retorno = VALOR_BEM_PEQUENO_VALOR;
        if (String.valueOf(CODIGO_NATUREZA_ALIENACAO_ACOES_BALCAO).equals(this.getNatureza().naoFormatado())) {
            retorno = VALOR_BEM_PEQUENO_VALOR_ACOES_BALCAO;
        }
        return retorno;
    }

    public boolean isValorOperacaoMaior20K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        if (valorAlienacaoReal.comparacao(">", VALOR_BEM_PEQUENO_VALOR_ACOES_BALCAO)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isValorOperacaoMaior35K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        if (valorAlienacaoReal.comparacao(">", VALOR_BEM_PEQUENO_VALOR)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isValorParcelasMaior20K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                valorAlienacaoReal.append('+', p.getValorRecebido());
            }
        } else {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                ValorPositivo somaParcela = new ValorPositivo();
                somaParcela.setConteudo(p.getValorRecebidoDolar());
                somaParcela.append('*', p.getCotacaoDolar());
                valorAlienacaoReal.append('+', somaParcela);
            }
        }
        if (valorAlienacaoReal.comparacao(">", VALOR_BEM_PEQUENO_VALOR_ACOES_BALCAO)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isValorParcelasMaior35K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                valorAlienacaoReal.append('+', p.getValorRecebido());
            }
        } else {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                ValorPositivo somaParcela = new ValorPositivo();
                somaParcela.setConteudo(p.getValorRecebidoDolar());
                somaParcela.append('*', p.getCotacaoDolar());
                valorAlienacaoReal.append('+', somaParcela);
            }
        }
        if (valorAlienacaoReal.comparacao(">", VALOR_BEM_PEQUENO_VALOR)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isPrevisaoPrejuizo() {
        boolean retorno = false;
        if (!this.isAlienacaoBrasil()) {
            String origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado();
            ValorPositivo ganhoCapital = new ValorPositivo();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', this.getApuracao().getGanhoCapital1OrigemMEReal()));
            }
            if (ganhoCapital.isVazio()) {
                retorno = true;
            }
        }
        return retorno;
    }

    public boolean isPrejuizo() {
        boolean retorno = false;
        if (!this.isAlienacaoBrasil() && this.isAlienacaoAPrazo() && !this.getDataRecebimentoUltimaParcela().isVazio()) {
            ValorPositivo ganho1 = new ValorPositivo();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ganho1.setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ganho1.setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.obterCodigoOrigemRendimentos().naoFormatado())) {
                ganho1.setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
                ganho1.append('+', this.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            }
            if (ganho1.isVazio()) {
                retorno = true;
            }
        }
        return retorno;
    }

    public abstract Aquisicao getAquisicao();

    @Override
    public abstract ApuracaoBem getApuracao();

    public abstract ApuracaoBem getApuracaoFinal();

    public abstract void calcularParcelasExterior();

    public abstract void calcularParcelasOrigemNacional();

    public abstract void calcularParcelasOrigemEstrangeira();

    public abstract void calcularParcelasOrigemAmbas();

    public abstract void calcularApuracaoFinalOrigemNacional();

    public abstract void calcularApuracaoFinalOrigemME();

    public abstract void calcularApuracaoFinalOrigemAmbas();

    public abstract void calcularUltimaParcelaExterior(ParcelaAlienacaoBem var1);

    public abstract void calcularAjuste();

    public abstract void ajustarFlagCobranca();

    public void limparAjusteAlienacaoSemUltimaParcela() {
        if (this.getColecaoParcelaAlienacao().getDataRecebimentoUltimaParcela().isVazio()) {
            this.getAjuste().clear();
        }
    }

    public void limparAjusteAlienacaoApuracaoFinalSemGanho(ValorPositivo ganhoCapital) {
        if (ganhoCapital.isVazio()) {
            this.getAjuste().clear();
        }
    }

    protected ValorPositivo calcularGanhoCapitalMEReais(boolean permutaComTorna) {
        ValorPositivo dolarMedio = new ValorPositivo(null, "", 11, 9);
        ValorPositivo ganhoCapitalMEReais = new ValorPositivo();
        ValorPositivo custoAquisicao = new ValorPositivo();
        ParcelaAlienacaoBem ultima = (ParcelaAlienacaoBem)this.getColecaoParcelaAlienacao().obterUltimaParcela();
        if (ultima != null) {
            if (permutaComTorna) {
                custoAquisicao.setConteudo(ultima.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
            } else {
                custoAquisicao.setConteudo(ultima.getCustoAquisicaoProporcionalOrigemMEDolar());
            }
        }
        if (ultima == null || ultima != null && ultima.getValorLiquidoAlienacaoDolar().comparacao(">=", custoAquisicao)) {
            ganhoCapitalMEReais.setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal().naoFormatado());
        } else {
            if (this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar().isVazio()) {
                dolarMedio.clear();
            } else {
                dolarMedio.setConteudo(this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMERealTotal().naoFormatado());
                dolarMedio.append('/', this.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal().naoFormatado());
            }
            ganhoCapitalMEReais.setConteudo(this.getApuracaoFinal().getGanhoCapital1OrigemMEDolar());
            ganhoCapitalMEReais.append('*', dolarMedio);
        }
        return ganhoCapitalMEReais;
    }
}

