/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.adquirente.ColecaoAdquirente;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.apuracao.Apuracao;
import br.gov.serpro.gcap.entidades.calculo.ObservadorRemovedorParcelasAnteriorAlienacao;
import br.gov.serpro.gcap.entidades.calculo.ValidadorCorretagemTotalExcedida;
import br.gov.serpro.gcap.entidades.consolidacao.ObservadorCalculoConsolidacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ColecaoParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.OperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.psocietarias.PainelListaPSocietarias;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorCalculoImpostoDevido;
import br.gov.serpro.gcap.observador.ObservadorCalculoTotaisParcelasPSocietarias;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorComparacaoValor;
import br.gov.serpro.gcap.validador.ValidadorGanhoAlienacaoParcial;
import br.gov.serpro.gcap.validador.ValidadorPerguntaAlienacaoParcial;
import br.gov.serpro.gcap.validador.ValidadorPerguntaBemGrandeValor;
import br.gov.serpro.gcap.validador.ValidadorSomatorioParcelas;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCNPJ;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNegativo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class AlienacaoParticipacaoSocietaria
extends Alienacao
implements ObjetoFicha {
    public static final String VALOR_PS_ACOES_PEQUENO_VALOR = "20.000,00";
    public static final String VALOR_PS_OUTROS_PEQUENO_VALOR = "35.000,00";
    public static final String NOME_FICHA_PSOCIETARIA = "Participa\u00e7\u00f5es Societ\u00e1rias";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_APURACAO_CUSTO_AQUISICAO = "Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static String CODIGO_ESPECIE_ACOES = "A";
    public static String CODIGO_ESPECIE_FII = "F";
    public static String CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "P";
    public static String CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "C";
    public static String CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES = "E";
    public static String CODIGO_ESPECIE_QUOTAS = "Q";
    public static String CODIGO_ESPECIE_OUTRAS = "O";
    public static String DESCRICAO_ESPECIE_ACOES = "A\u00e7\u00f5es";
    public static String DESCRICAO_ESPECIE_FII = "F.I.I. (Fundos de Investimento Imobili\u00e1rio)";
    public static String DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "Fundos de Investimentos em Participa\u00e7\u00f5es";
    public static String DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "Fundos de Investimentos em Cotas de Investimentos em Fundos de Participa\u00e7\u00f5es";
    public static String DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES = "Fundos de Investimento em Empresas Emergentes";
    public static String DESCRICAO_ESPECIE_QUOTAS = "Quotas";
    public static String DESCRICAO_ESPECIE_OUTRAS = "Outras";
    private ParticipacaoSocietaria participacaoSocietaria = new ParticipacaoSocietaria();
    private Apuracao apuracao = new Apuracao();
    private ColecaoParcelaAlienacao colecaoParcelaAlienacao = new ColecaoParcelaAlienacao(this);
    private ColecaoParcelaAquisicaoParticipacaoSocietaria colecaoParcelaAquisicaoParticipacaoSocietaria = new ColecaoParcelaAquisicaoParticipacaoSocietaria(this);
    private ColecaoAdquirente adquirentes = new ColecaoAdquirente(this);

    public AlienacaoParticipacaoSocietaria() {
        this.adicionarValidadores();
        this.adicionarObservadores();
        this.inicializarVariaveisApuracao();
        this.inicializarVariaveisCalculoImposto();
        this.getNatureza().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarNaturezaParticipacaoSocietaria());
    }

    public ParticipacaoSocietaria getParticipacaoSocietaria() {
        return this.participacaoSocietaria;
    }

    @Override
    public Apuracao getApuracao() {
        return this.apuracao;
    }

    public ColecaoParcelaAlienacao getColecaoParcelaAlienacao() {
        return this.colecaoParcelaAlienacao;
    }

    public ColecaoParcelaAquisicaoParticipacaoSocietaria getColecaoParcelaAquisicaoParticipacaoSocietaria() {
        return this.colecaoParcelaAquisicaoParticipacaoSocietaria;
    }

    public ColecaoAdquirente getAdquirentes() {
        return this.adquirentes;
    }

    public void adicionarValidadores() {
        this.adicionarValidadoresIdentificacao();
        this.adicionarValidadoresOperacao();
        this.adicionarValidadoresCalculoImposto();
        this.adicionarValidadoresCalculoImpostoAPrazo();
    }

    public void adicionarObservadores() {
        this.adicionarObservadoresIdentificacao();
        this.adicionarObservadoresAquisicao();
        this.adicionarObservadoresOperacao();
        this.adicionarObservadoresCalculoApuracao();
        this.adicionarObservadoresCalculoImposto();
        this.adicionarObservadoresCalculoImpostoAPrazo();
        this.adicionaObservadoresConsolidacao();
    }

    private void inicializarVariaveisApuracao() {
        this.getApuracao().getValorAlienacao().setReadOnly(true);
        this.getApuracao().getCustoCorretagem().setReadOnly(true);
        this.getApuracao().getValorLiquidoAlienacao().setReadOnly(true);
        this.getApuracao().getCustoAquisicao().setReadOnly(true);
        this.getApuracao().getGanhoCapital1().setReadOnly(true);
    }

    private void inicializarVariaveisCalculoImposto() {
        this.definirIrrfLei110332004Editavel();
    }

    private void adicionarValidadoresIdentificacao() {
        this.participacaoSocietaria.getNome().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.participacaoSocietaria.getNome().getNomeCampo()})));
        this.participacaoSocietaria.getCnpj().addValidador((ValidadorIf)new ValidadorCNPJ(3));
        this.participacaoSocietaria.getEspecie().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.participacaoSocietaria.getEspecie().getNomeCampo()})));
    }

    private void adicionarValidadoresOperacao() {
        this.getAlienacaoParcial().addValidador((ValidadorIf)new ValidadorPerguntaAlienacaoParcial(this.getDataAlienacao(), this.getNatureza(), this.participacaoSocietaria.getEspecie()));
        this.getNatureza().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getNatureza().getNomeCampo()})));
        this.getValorAlienacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoParticipacaoSocietaria.this.getValorAlienacao().isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("erroCampoNulo", new String[]{AlienacaoParticipacaoSocietaria.this.getValorAlienacao().getNomeCampo()}));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getGanhoCapitalAlienacaoAnterior().addValidador((ValidadorIf)new ValidadorGanhoAlienacaoParcial(this.getAlienacaoParcial()));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -2, (Object)this.getValorAlienacao()));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorCorretagemTotalExcedida("R$", this.getColecaoParcelaAlienacao().getCustoCorretagemTotal(), this.getCorretagemAnosAnteriores(), this.getCustoCorretagem(), this.getAlienacaoAPrazo()));
        this.getBemGrandeValor().addValidador((ValidadorIf)new ValidadorPerguntaBemGrandeValor(this));
    }

    private void adicionarValidadoresCalculoImposto() {
    }

    private void adicionarValidadoresCalculoImpostoAPrazo() {
        this.getValorLiquidoRecebidoAnosAnteriores().addValidador((ValidadorIf)new ValidadorNaoNegativo(3){

            public RetornoValidacao validarImplementado() {
                if (AlienacaoParticipacaoSocietaria.this.isAlienacaoAPrazo() && AlienacaoParticipacaoSocietaria.this.getValorLiquidoRecebidoAnosAnteriores().comparacao(">", AlienacaoParticipacaoSocietaria.this.getValorAlienacao())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("valorAnosAnterioresMaiorQueAlienacao"));
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValorLiquidoRecebidoAnosAnteriores().addValidador((ValidadorIf)new ValidadorNaoNegativo(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo totalParcelasMaisAnosAnteriores = new ValorPositivo(null, "totalParcelasMaisAnosAnteriores", 11, 9);
                totalParcelasMaisAnosAnteriores.setConteudo(AlienacaoParticipacaoSocietaria.this.getValorLiquidoRecebidoAnosAnteriores());
                totalParcelasMaisAnosAnteriores.append('+', AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAlienacao().getValorRecebidoTotal());
                if (AlienacaoParticipacaoSocietaria.this.isAlienacaoAPrazo() && AlienacaoParticipacaoSocietaria.this.getValorLiquidoRecebidoAnosAnteriores().comparacao("<=", AlienacaoParticipacaoSocietaria.this.getValorAlienacao()) && totalParcelasMaisAnosAnteriores.comparacao(">", AlienacaoParticipacaoSocietaria.this.getValorAlienacao())) {
                    return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("valorParcelasMaisAnosAnterioresMaiorQueAlienacao"));
                }
                return new RetornoValidacao(0);
            }
        });
    }

    private void adicionarObservadoresIdentificacao() {
        this.participacaoSocietaria.getUf().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria.this.participacaoSocietaria.getMunicipio().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarMunicipios(AlienacaoParticipacaoSocietaria.this.participacaoSocietaria.getUf().formatado(), 1));
            }
        });
        this.participacaoSocietaria.getEspecie().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (!AlienacaoParticipacaoSocietaria.this.participacaoSocietaria.getEspecie().isVazio()) {
                    AlienacaoParticipacaoSocietaria.this.definirIrrfLei110332004Editavel();
                    String especieSelecionada = AlienacaoParticipacaoSocietaria.this.participacaoSocietaria.getEspecie().getConteudoAtual(0);
                    if (especieSelecionada.equals(CODIGO_ESPECIE_ACOES) || especieSelecionada.equals(CODIGO_ESPECIE_OUTRAS) || especieSelecionada.equals(CODIGO_ESPECIE_QUOTAS)) {
                        AlienacaoParticipacaoSocietaria.this.getAlienacaoParcial().setReadOnly(false);
                    } else {
                        AlienacaoParticipacaoSocietaria.this.getAlienacaoParcial().setReadOnly(true);
                        AlienacaoParticipacaoSocietaria.this.getGanhoCapitalAlienacaoAnterior().clear();
                    }
                    if (!AlienacaoParticipacaoSocietaria.this.participacaoSocietaria.getEspecie().getConteudoAtual(0).equals(AlienacaoParticipacaoSocietaria.this.participacaoSocietaria.getEspecie().getConteudoAntigo()) && !AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAquisicaoParticipacaoSocietaria().isVazio()) {
                        int novaEspecieParticipacaoSocietaria = -1;
                        List<ElementoTabela> tiposEspecie = CadastroTabelasGCAP.recuperarEspecieAquisicaoPSAcoes();
                        if (!especieSelecionada.equals(CODIGO_ESPECIE_ACOES) && !especieSelecionada.equals(CODIGO_ESPECIE_OUTRAS)) {
                            tiposEspecie = CadastroTabelasGCAP.recuperarEspecieAquisicaoPSQuota();
                            novaEspecieParticipacaoSocietaria = ParcelaAquisicaoParticipacaoSocietaria.CODIGO_QUOTA;
                        } else if (especieSelecionada.equals(CODIGO_ESPECIE_OUTRAS)) {
                            tiposEspecie = CadastroTabelasGCAP.recuperarEspecieAquisicaoPSOutras();
                            novaEspecieParticipacaoSocietaria = ParcelaAquisicaoParticipacaoSocietaria.CODIGO_OUTRAS;
                        }
                        for (ParcelaAquisicaoParticipacaoSocietaria parcelaAquisicao : AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAquisicaoParticipacaoSocietaria().itens()) {
                            parcelaAquisicao.getEspecieAquisicao().clear();
                            parcelaAquisicao.getEspecieAquisicao().setColecaoElementoTabela(tiposEspecie);
                            if (novaEspecieParticipacaoSocietaria == -1) continue;
                            parcelaAquisicao.getEspecieAquisicao().setConteudo(novaEspecieParticipacaoSocietaria);
                        }
                    }
                }
            }
        });
    }

    public void adicionarObservadoresAquisicao() {
        Observador obsCalculaCustoAquisicaoTotal = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getCustoAquisicao().setConteudo(AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal());
            }
        };
        this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal().addObservador(obsCalculaCustoAquisicaoTotal);
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoParticipacaoSocietaria.this.isAlienacaoEmAnoAnterior()) {
                    for (ParcelaAquisicaoParticipacaoSocietaria parcela : AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAquisicaoParticipacaoSocietaria().itens()) {
                        parcela.getParticipacaoSocietariaAlienada().getOperacoesParticipacaoSocietaria().clear();
                    }
                }
            }
        });
    }

    public void adicionarObservadoresCalculoApuracao() {
        Observador obsCalculoValorAlienacao = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getValorAlienacao().setConteudo(AlienacaoParticipacaoSocietaria.this.getValorAlienacao());
            }
        };
        this.getValorAlienacao().addObservador(obsCalculoValorAlienacao);
        this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal().addObservador(obsCalculoValorAlienacao);
        this.getApuracao().getValorAlienacao().addObservador(obsCalculoValorAlienacao);
        Observador obsCalculoCustoCorretagem = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getCustoCorretagem().setConteudo(AlienacaoParticipacaoSocietaria.this.getCustoCorretagem());
            }
        };
        this.getCustoCorretagem().addObservador(obsCalculoCustoCorretagem);
        this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal().addObservador(obsCalculoCustoCorretagem);
        this.getApuracao().getCustoCorretagem().addObservador(obsCalculoCustoCorretagem);
        Observador obsCalculoValorLiquidoAlienacao = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getValorLiquidoAlienacao().setConteudo(AlienacaoParticipacaoSocietaria.this.getValorAlienacao().operacao('-', AlienacaoParticipacaoSocietaria.this.getCustoCorretagem()));
            }
        };
        this.getApuracao().getValorLiquidoAlienacao().addObservador(obsCalculoValorLiquidoAlienacao);
        Observador obsCalculoCustoAquisicao = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getCustoAquisicao().setConteudo(AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal());
            }
        };
        this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal().addObservador(obsCalculoCustoAquisicao);
        Observador observadorGanhoCapital = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                if (AlienacaoParticipacaoSocietaria.this.getApuracao().getValorLiquidoAlienacao() != null && !AlienacaoParticipacaoSocietaria.this.getApuracao().getValorLiquidoAlienacao().isVazio()) {
                    AlienacaoParticipacaoSocietaria.this.getApuracao().getGanhoCapital1().setConteudo(AlienacaoParticipacaoSocietaria.this.getApuracao().getValorLiquidoAlienacao().operacao('-', AlienacaoParticipacaoSocietaria.this.getApuracao().getCustoAquisicao()));
                    for (ParcelaAlienacao parcela : AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAlienacao().itens()) {
                        parcela.getPercentualGanho().setConteudo(AlienacaoParticipacaoSocietaria.this.getApuracao().getGanhoCapital1());
                        parcela.getPercentualGanho().append('/', AlienacaoParticipacaoSocietaria.this.getApuracao().getValorLiquidoAlienacao());
                        parcela.getPercentualGanho().append('*', "100");
                    }
                }
            }
        };
        this.getApuracao().getGanhoCapital1().addObservador(observadorGanhoCapital);
    }

    public void adicionarObservadoresOperacao() {
        this.getValorAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (GcapUtil.getEstadoSistema() == 0 && !AlienacaoParticipacaoSocietaria.this.podeResponderPerguntaBemIsentoPorPequenoValor()) {
                    AlienacaoParticipacaoSocietaria.this.getBemGrandeValor().clear();
                }
            }
        });
        this.getValorAlienacao().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getValorAlienacao().setConteudo(AlienacaoParticipacaoSocietaria.this.getValorAlienacao());
            }
        });
        this.getCustoCorretagem().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria.this.getApuracao().getCustoCorretagem().setConteudo(AlienacaoParticipacaoSocietaria.this.getCustoCorretagem());
            }
        });
        this.getAlienacaoParcial().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!AlienacaoParticipacaoSocietaria.this.temAlienacaoParcial()) {
                    AlienacaoParticipacaoSocietaria.this.getGanhoCapitalAlienacaoAnterior().clear();
                }
            }
        });
        this.getAlienacaoAPrazo().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (propriedade.equals(((Informacao)observado).getNomeCampo()) && ((String)valorAntigo).length() > 0) {
                    AlienacaoParticipacaoSocietaria.this.limparCalculoImposto();
                }
                AlienacaoParticipacaoSocietaria.this.definirIrrfLei110332004Editavel();
            }
        });
        this.getNatureza().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (!AlienacaoParticipacaoSocietaria.this.isAdquirenteRequerido()) {
                    AlienacaoParticipacaoSocietaria.this.getAdquirentes().clear();
                }
            }
        });
    }

    private void definirIrrfLei110332004Editavel() {
        block5: {
            block4: {
                String especieSelecionada = "";
                if (!this.participacaoSocietaria.getEspecie().getConteudoAtual(0).equals("")) {
                    especieSelecionada = this.participacaoSocietaria.getEspecie().getConteudoAtual(0);
                }
                if (!especieSelecionada.equals(CODIGO_ESPECIE_ACOES)) break block4;
                this.getCalculoImposto().getIRRFLei110332004().setReadOnly(false);
                if (!this.isAlienacaoAPrazo()) break block5;
                for (ParcelaAlienacao parcela : this.getColecaoParcelaAlienacao().itens()) {
                    parcela.getIrrfLei110332004().setReadOnly(false);
                }
                break block5;
            }
            this.getCalculoImposto().getIRRFLei110332004().setReadOnly(true);
            this.getCalculoImposto().getIRRFLei110332004().clear();
            if (this.isAlienacaoAPrazo()) {
                for (ParcelaAlienacao parcela : this.getColecaoParcelaAlienacao().itens()) {
                    parcela.getIrrfLei110332004().setReadOnly(true);
                    parcela.getIrrfLei110332004().clear();
                }
            }
        }
    }

    public void adicionarObservadoresCalculoImposto() {
        this.getDataAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                boolean dataValida = AlienacaoParticipacaoSocietaria.this.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido();
                if (dataValida) {
                    if (Integer.valueOf(AlienacaoParticipacaoSocietaria.this.getDataAlienacao().getAno()) == AplicacaoPropertiesUtil.getExercicioAsInt()) {
                        AlienacaoParticipacaoSocietaria.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                    }
                } else {
                    AlienacaoParticipacaoSocietaria.this.getValorLiquidoRecebidoAnosAnteriores().clear();
                }
            }
        });
        this.getApuracao().getGanhoCapital1().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getGanhoCapitalTotal().setConteudo(AlienacaoParticipacaoSocietaria.this.getApuracao().getGanhoCapital1());
            }
        });
        ObservadorCalculoImpostoDevido obsCalculoImpostoDevido = new ObservadorCalculoImpostoDevido(this);
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(obsCalculoImpostoDevido);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsCalculoImpostoDevido);
        this.getDataAlienacao().addObservador((Observador)obsCalculoImpostoDevido);
        this.getBemGrandeValor().addObservador((Observador)obsCalculoImpostoDevido);
        this.getNatureza().addObservador((Observador)obsCalculoImpostoDevido);
        this.participacaoSocietaria.getEspecie().addObservador((Observador)obsCalculoImpostoDevido);
        this.getBemGrandeValor().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoParticipacaoSocietaria.this.isBemPequenoValor()) {
                    AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getImpostoPago().setReadOnly(true);
                } else {
                    AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getImpostoPago().setReadOnly(false);
                }
            }
        });
        Observador obsImpostoDevido2 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getImpostoDevido2().setConteudo(AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getImpostoDevido());
                AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getImpostoDevido2().append('-', AlienacaoParticipacaoSocietaria.this.getCalculoImposto().getIRRFLei110332004());
            }
        };
        this.getCalculoImposto().getImpostoDevido().addObservador(obsImpostoDevido2);
        this.getCalculoImposto().getIRRFLei110332004().addObservador(obsImpostoDevido2);
    }

    public void adicionarObservadoresCalculoImpostoAPrazo() {
        this.getDataAlienacao().addObservador((Observador)new ObservadorRemovedorParcelasAnteriorAlienacao(this.getDataAlienacao(), this.getColecaoParcelaAlienacao()));
        this.getApuracao().getCustoAquisicao().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria.this.recalcularImpostoBrasil();
                new ObservadorCalculoTotaisParcelasPSocietarias(AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAlienacao()).calculaTodosOsTotais();
            }
        });
        this.getParticipacaoSocietaria().getEspecie().addObservador(new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                AlienacaoParticipacaoSocietaria.this.recalcularImpostoBrasil();
                new ObservadorCalculoTotaisParcelasPSocietarias(AlienacaoParticipacaoSocietaria.this.getColecaoParcelaAlienacao()).calculaTodosOsTotais();
            }
        });
        Observador obsRecalculaParcelas = new Observador(){

            public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
                if (AlienacaoParticipacaoSocietaria.this.isAlienacaoAPrazo()) {
                    AlienacaoParticipacaoSocietaria.this.recalcularImpostoBrasil();
                }
            }
        };
        this.getApuracao().getValorLiquidoAlienacao().addObservador(obsRecalculaParcelas);
        this.getValorLiquidoRecebidoAnosAnteriores().addObservador(obsRecalculaParcelas);
        this.getAlienacaoParcial().addObservador(obsRecalculaParcelas);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsRecalculaParcelas);
        this.getBemGrandeValor().addObservador(obsRecalculaParcelas);
    }

    public void adicionaObservadoresConsolidacao() {
        ObservadorCalculoConsolidacaoParticipacaoSocietaria obsCalculoConsolidacao = new ObservadorCalculoConsolidacaoParticipacaoSocietaria(this);
        this.getBemGrandeValor().addObservador((Observador)obsCalculoConsolidacao);
        this.getDataAlienacao().addObservador((Observador)obsCalculoConsolidacao);
        this.getAlienacaoAPrazo().addObservador((Observador)obsCalculoConsolidacao);
        this.getTemUltimaParcela().addObservador((Observador)obsCalculoConsolidacao);
        this.getAlienacaoParcial().addObservador((Observador)obsCalculoConsolidacao);
        this.getGanhoCapitalAlienacaoAnterior().addObservador(obsCalculoConsolidacao);
        this.getNatureza().addObservador((Observador)obsCalculoConsolidacao);
        this.getCalculoImposto().getGanhoCapitalTotal().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getImpostoPago().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getImpostoDevido2().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().addObservador(obsCalculoConsolidacao);
        this.getCalculoImposto().getIRRFLei110332004().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getImpostoPagoTotal().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getImpostoDevido2Total().addObservador(obsCalculoConsolidacao);
        this.getColecaoParcelaAlienacao().getIrrfLei110332004Total().addObservador(obsCalculoConsolidacao);
        this.getConsolidacao().getImpostoDiferidoAnosAnteriores().addObservador(obsCalculoConsolidacao);
    }

    @Override
    public void calcularApuracao() {
        this.getApuracao().getValorLiquidoAlienacao().setConteudo(this.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal());
        this.getApuracao().getCustoAquisicao().setConteudo(this.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal());
        if (this.getApuracao().getCustoAquisicao().comparacao(">", this.getApuracao().getValorLiquidoAlienacao())) {
            this.getApuracao().getGanhoCapital1().clear();
        } else {
            ValorPositivo ganhoCapital = new ValorPositivo(null, "ganhoCapital", 11, 2);
            ganhoCapital.setConteudo(this.getApuracao().getValorLiquidoAlienacao());
            ganhoCapital.append('-', this.getApuracao().getCustoAquisicao());
            this.getApuracao().getGanhoCapital1().setConteudo(ganhoCapital);
        }
    }

    @Override
    public boolean podeResponderPerguntaBemIsentoPorPequenoValor() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        valorAlienacaoReal.setConteudo(this.getValorAlienacao());
        boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        String indiceEspecie = this.participacaoSocietaria.getEspecie().getConteudoAtual(0);
        if (residenteNoBrasil && !indiceEspecie.equals("") && this.getPaisResidencia().naoFormatado().equals("105") && (indiceEspecie.equals(CODIGO_ESPECIE_ACOES) && valorAlienacaoReal.comparacao("<=", VALOR_PS_ACOES_PEQUENO_VALOR) || !indiceEspecie.equals(CODIGO_ESPECIE_ACOES) && valorAlienacaoReal.comparacao("<=", VALOR_PS_OUTROS_PEQUENO_VALOR))) {
            retorno = true;
        }
        return retorno;
    }

    public void limparCalculoImposto() {
        this.getCalculoImposto().getImpostoPago().clear();
        this.getValorLiquidoRecebidoAnosAnteriores().clear();
        this.getColecaoParcelaAlienacao().itens().clear();
        this.getCalculoImposto().getIRRFLei110332004().clear();
    }

    public void recalcularImpostoBrasil() {
        this.getCalculoImposto().getGanhoCapitalTotal().forcaDisparoObservadores();
        if (this.isAlienacaoAPrazo()) {
            for (ParcelaAlienacao parcela : this.getColecaoParcelaAlienacao().itens()) {
                parcela.getValorRecebido().forcaDisparoObservadores();
            }
        }
    }

    @Override
    public String obterAliquotaFixa() {
        String aliquota = null;
        if (DataUtil.isDataPreenchida(this.getDataAlienacao()) && 2019 <= Integer.parseInt(this.getDataAlienacao().getAno()) && (Logico.SIM.equals(this.getPaisResidencia().getConteudoAtual(2)) || Logico.SIM.equals(this.getTerritorioParaisoFiscal().naoFormatado()))) {
            aliquota = "0,250000000";
        } else {
            int codigoNatureza = -1;
            if (!this.getNatureza().isVazio()) {
                codigoNatureza = Integer.valueOf(this.getNatureza().naoFormatado());
            }
            if (CODIGO_ESPECIE_FII.equals(this.participacaoSocietaria.getEspecie().naoFormatado())) {
                aliquota = "0,200000000";
            } else if (codigoNatureza == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codigoNatureza == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || codigoNatureza == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES.equals(this.participacaoSocietaria.getEspecie().naoFormatado()) || CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES.equals(this.participacaoSocietaria.getEspecie().naoFormatado()) || CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES.equals(this.participacaoSocietaria.getEspecie().naoFormatado())) {
                aliquota = "0,150000000";
            }
        }
        return aliquota;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        int i;
        ArrayList<Pendencia> listaPendencias = new ArrayList<Pendencia>();
        List<Informacao> informacoes = this.getParticipacaoSocietaria().recuperarListaCamposPendenciaAbaIdentificacao();
        String listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Identifica\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_IDENTIFICACAO, listaPassosSelecaoTela);
        boolean isAdquirenteRequerido = this.isAdquirenteRequerido();
        if (!isAdquirenteRequerido) {
            this.getAdquirentes().clear();
        }
        if (this.getAdquirentes().isVazio() && isAdquirenteRequerido) {
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Adquirentes";
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)3, MensagemUtil.getMensagem("alienacaoSemAdquirente"), this.getClasseFicha(), NOME_ABA_ADQUIRENTES, listaPassosSelecaoTela, NOME_FICHA_PSOCIETARIA));
        } else {
            List adquirentes = this.getAdquirentes().itens();
            for (i = 0; i < adquirentes.size(); ++i) {
                Adquirente adquirente = (Adquirente)adquirentes.get(i);
                String ni = adquirente.getCpfCnpj().isVazio() ? "(n\u00e3o informado)" : adquirente.getCpfCnpj().formatado();
                informacoes = adquirente.recuperarListaCamposPendenciaAbaAdquirentes();
                listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Adquirentes|Lista;" + (i + 1) + ";Adquirente CPF/CNPJ " + ni;
                GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_ADQUIRENTES, listaPassosSelecaoTela);
            }
        }
        if (this.getColecaoParcelaAquisicaoParticipacaoSocietaria().isVazio()) {
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o";
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)3, MensagemUtil.getMensagem("alienacaoParticipacaoSocietariaSemCustoAquisicao"), this.getClasseFicha(), NOME_ABA_APURACAO_CUSTO_AQUISICAO, listaPassosSelecaoTela, NOME_FICHA_PSOCIETARIA));
        }
        List parcelasAquisicao = this.getColecaoParcelaAquisicaoParticipacaoSocietaria().itens();
        for (i = 0; i < parcelasAquisicao.size(); ++i) {
            ParcelaAquisicaoParticipacaoSocietaria parcela = (ParcelaAquisicaoParticipacaoSocietaria)((Object)parcelasAquisicao.get(i));
            informacoes = parcela.recuperarListaCamposPendenciaAbaApucacaoCustoAquisicao();
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o|Lista;" + (i + 1) + ";Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o Item n\u00ba " + (i + 1);
            GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_APURACAO_CUSTO_AQUISICAO, listaPassosSelecaoTela);
            List operacoes = parcela.getParticipacaoSocietariaAlienada().getOperacoesParticipacaoSocietaria().itens();
            for (int j = 0; j < operacoes.size(); ++j) {
                OperacaoParticipacaoSocietaria operacao = (OperacaoParticipacaoSocietaria)((Object)operacoes.get(j));
                informacoes = operacao.recuperarListaCamposPendenciaAbaApucacaoCustoAquisicao();
                listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o|Lista;" + (i + 1) + ";Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o Item n\u00ba " + (i + 1) + "|Lista;" + (j + 1) + ";Planilha Item n\u00ba " + (j + 1);
                GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_APURACAO_CUSTO_AQUISICAO, listaPassosSelecaoTela);
            }
        }
        informacoes = this.recuperarListaCamposPendenciaAbaOperacao();
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;Opera\u00e7\u00e3o";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_OPERACAO, listaPassosSelecaoTela);
        informacoes = new ArrayList<Informacao>();
        informacoes.addAll(this.getCalculoImposto().recuperarListaCamposPendenciaAbaCalculo());
        informacoes.addAll(this.recuperarListaCamposPendenciaAbaCalculo());
        listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;C\u00e1lculo do Imposto";
        GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_CALCULO, listaPassosSelecaoTela);
        ValidadorSomatorioParcelas validadorSomatorio = new ValidadorSomatorioParcelas(this);
        RetornoValidacao retornoValidacao = validadorSomatorio.validarImplementado();
        listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo(retornoValidacao.getSeveridade(), retornoValidacao.getMensagemValidacao(), this.getClasseFicha(), NOME_ABA_CALCULO, listaPassosSelecaoTela, NOME_FICHA_PSOCIETARIA));
        if (this.isAlienacaoAPrazo() && this.getColecaoParcelaAlienacao().itens().isEmpty()) {
            listaPendencias.add(GCAPFacade.getInstancia().criarPendenciaSemCampo((byte)2, MensagemUtil.getMensagem("alienacaoPrazoSemParcelas"), this.getClasseFicha(), NOME_ABA_CALCULO, listaPassosSelecaoTela, NOME_FICHA_PSOCIETARIA));
        }
        List parcelas = this.getColecaoParcelaAlienacao().itens();
        for (int i2 = 0; i2 < parcelas.size(); ++i2) {
            ParcelaAlienacao parcela = (ParcelaAlienacao)((Object)parcelas.get(i2));
            String data = parcela.getDataRecebimento().isVazio() ? "(data n\u00e3o informada)" : parcela.getDataRecebimento().formatado();
            informacoes = parcela.recuperarListaCamposPendenciaAbaCalculo();
            listaPassosSelecaoTela = "Lista;" + numeroItem + ";Participa\u00e7\u00f5es Societ\u00e1rias Item n\u00ba " + numeroItem + "|Aba;C\u00e1lculo do Imposto|Lista;" + (i2 + 1) + ";Parcela recebida em " + data;
            GCAPFacade.getInstancia().verificarPendenciasObjetoNegocio(informacoes, listaPendencias, NOME_FICHA_PSOCIETARIA, this.getClasseFicha(), numeroItem, NOME_ABA_CALCULO, listaPassosSelecaoTela);
        }
        return listaPendencias;
    }

    public boolean deveExibirMensagemCustoAquisicaoAnoAntes2017() {
        try {
            if (Integer.parseInt(this.getDataAlienacao().getAno()) < 2017 && this.colecaoParcelaAquisicaoParticipacaoSocietaria.isVazio()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private List<Informacao> recuperarListaCamposPendenciaAbaOperacao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getNatureza());
        lista.add((Informacao)this.getAlienacaoAPrazo());
        lista.add((Informacao)this.getDataAlienacao());
        lista.add((Informacao)this.getDataTransitoJulgado());
        lista.add((Informacao)this.getValorAlienacao());
        lista.add((Informacao)this.getCustoCorretagem());
        lista.add((Informacao)this.getBemGrandeValor());
        lista.add((Informacao)this.getAlienacaoParcial());
        lista.add((Informacao)this.getGanhoCapitalAlienacaoAnterior());
        return lista;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaCalculo() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getValorRecebidoAnosAnteriores());
        lista.add(this.getCorretagemAnosAnteriores());
        return lista;
    }

    public String getClasseFicha() {
        return PainelListaPSocietarias.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

