/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.observador.ObservadorTotaisConsolidacaoImovel;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import java.util.Calendar;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;

public class ColecaoAlienacaoBemImovel
extends Colecao<AlienacaoBemImovel> {
    private ValorPositivo totalImpostoDiferidoAnosAnteriores = new ValorPositivo();
    private ValorPositivo totalImpostoReferenteAlienacaoAnoAtual = new ValorPositivo();
    private ValorPositivo totalImpostoTotal = new ValorPositivo();
    private ValorPositivo totalValorIRF = new ValorPositivo();
    private ValorPositivo totalImpostoDevidoAnoAtual = new ValorPositivo();
    private ValorPositivo totalImpostoDiferidoAnosPosteriores = new ValorPositivo();
    private ValorPositivo totalImpostoPagoBrasil = new ValorPositivo();
    private ValorPositivo totalRendIsentosNaoTributaveisBrasil = new ValorPositivo();
    private ValorPositivo totalRendSujeitosTributacaoBrasil = new ValorPositivo();
    private ValorPositivo totalImpostoPagoExterior = new ValorPositivo();
    private ValorPositivo totalRendIsentosNaoTributaveisExterior = new ValorPositivo();
    private ValorPositivo totalRendSujeitosTributacaoExterior = new ValorPositivo();
    private Data dataPrimeiraAlienacao180DiasPergunta1 = new Data();
    private Data dataPrimeiraAlienacao180DiasPergunta2 = new Data();
    private Data dataPrimeiraAlienacaoUnicoImovel = new Data();
    private Data dataPrimeiraAlienacao = new Data();
    private Alfa especificacaoDataPrimeiraAlienacao180DiasPergunta1 = new Alfa();
    private Alfa especificacaoDataPrimeiraAlienacao180DiasPergunta2 = new Alfa();
    private Alfa especificacaoDataPrimeiraAlienacaoUnicoImovel = new Alfa();
    private Alfa especificacaoDataPrimeiraAlienacao = new Alfa();

    public ColecaoAlienacaoBemImovel() {
        this.adicionarObservadores();
    }

    private void adicionarObservadores() {
        this.addObservador(new ObservadorTotaisConsolidacaoImovel(this));
    }

    public void objetoInserido(AlienacaoBemImovel e) {
        e.getConsolidacao().getImpostoDiferidoAnosAnteriores().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getImpostoTotal().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getValorIRF().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getImpostoDevidoAnoAtual().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getImpostoDiferidoAnosPosteriores().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getTotalImpostoPago().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getTotalRendIsentosNaoTributaveis().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
        e.getConsolidacao().getTotalRendSujeitosTributacao().addObservador(new ObservadorTotaisConsolidacaoImovel(this));
    }

    public ValorPositivo getTotalImpostoDiferidoAnosAnteriores() {
        return this.totalImpostoDiferidoAnosAnteriores;
    }

    public ValorPositivo getTotalImpostoReferenteAlienacaoAnoAtual() {
        return this.totalImpostoReferenteAlienacaoAnoAtual;
    }

    public ValorPositivo getTotalImpostoTotal() {
        return this.totalImpostoTotal;
    }

    public ValorPositivo getTotalValorIRF() {
        return this.totalValorIRF;
    }

    public ValorPositivo getTotalImpostoDevidoAnoAtual() {
        return this.totalImpostoDevidoAnoAtual;
    }

    public ValorPositivo getTotalImpostoDiferidoAnosPosteriores() {
        return this.totalImpostoDiferidoAnosPosteriores;
    }

    public ValorPositivo getTotalImpostoPagoBrasil() {
        return this.totalImpostoPagoBrasil;
    }

    public ValorPositivo getTotalRendIsentosNaoTributaveisBrasil() {
        return this.totalRendIsentosNaoTributaveisBrasil;
    }

    public ValorPositivo getTotalRendSujeitosTributacaoBrasil() {
        return this.totalRendSujeitosTributacaoBrasil;
    }

    public ValorPositivo getTotalImpostoPagoExterior() {
        return this.totalImpostoPagoExterior;
    }

    public ValorPositivo getTotalRendIsentosNaoTributaveisExterior() {
        return this.totalRendIsentosNaoTributaveisExterior;
    }

    public ValorPositivo getTotalRendSujeitosTributacaoExterior() {
        return this.totalRendSujeitosTributacaoExterior;
    }

    public Data getDataPrimeiraAlienacao180DiasPergunta1() {
        return this.dataPrimeiraAlienacao180DiasPergunta1;
    }

    public Data getDataPrimeiraAlienacao180DiasPergunta2() {
        return this.dataPrimeiraAlienacao180DiasPergunta2;
    }

    public Data getDataPrimeiraAlienacaoUnicoImovel() {
        return this.dataPrimeiraAlienacaoUnicoImovel;
    }

    public Data getDataPrimeiraAlienacao() {
        return this.dataPrimeiraAlienacao;
    }

    public Alfa getEspecificacaoDataPrimeiraAlienacao180DiasPergunta1() {
        return this.especificacaoDataPrimeiraAlienacao180DiasPergunta1;
    }

    public Alfa getEspecificacaoDataPrimeiraAlienacao180DiasPergunta2() {
        return this.especificacaoDataPrimeiraAlienacao180DiasPergunta2;
    }

    public Alfa getEspecificacaoDataPrimeiraAlienacaoUnicoImovel() {
        return this.especificacaoDataPrimeiraAlienacaoUnicoImovel;
    }

    public Alfa getEspecificacaoDataPrimeiraAlienacao() {
        return this.especificacaoDataPrimeiraAlienacao;
    }

    public void atualizarDatasAlienacoes() {
        this.getDataPrimeiraAlienacao().clear();
        this.getEspecificacaoDataPrimeiraAlienacao().clear();
        this.getDataPrimeiraAlienacao180DiasPergunta1().clear();
        this.getEspecificacaoDataPrimeiraAlienacao180DiasPergunta1().clear();
        this.getDataPrimeiraAlienacao180DiasPergunta2().clear();
        this.getEspecificacaoDataPrimeiraAlienacao180DiasPergunta2().clear();
        this.getDataPrimeiraAlienacaoUnicoImovel().clear();
        this.getEspecificacaoDataPrimeiraAlienacaoUnicoImovel().clear();
        for (AlienacaoBemImovel alienacao : this.itens()) {
            this.atualizarDatasAlienacoes(alienacao);
        }
    }

    public void atualizarDatasAlienacoes(AlienacaoBemImovel alienacao) {
        if (alienacao.getDataAlienacao().isValido() && alienacao.getDataAlienacao().maisAntiga(this.getDataPrimeiraAlienacao())) {
            this.getDataPrimeiraAlienacao().setConteudo(alienacao.getDataAlienacao());
            this.getEspecificacaoDataPrimeiraAlienacao().setConteudo(alienacao.getBemImovel().getEspecificacao());
        }
        if (alienacao.getDataAlienacao().isValido() && alienacao.getPerguntas().isValorReaplicado() && alienacao.getDataAlienacao().maisAntiga(this.getDataPrimeiraAlienacao180DiasPergunta1())) {
            this.getDataPrimeiraAlienacao180DiasPergunta1().setConteudo(alienacao.getDataAlienacao());
            this.getEspecificacaoDataPrimeiraAlienacao180DiasPergunta1().setConteudo(alienacao.getBemImovel().getEspecificacao());
        }
        if (alienacao.getPerguntas().isValorReaplicadoPrimeiraAlienacao() && alienacao.getPerguntas().getDataPrimeiraAlienacao().isValido() && !alienacao.getPerguntas().getDataPrimeiraAlienacao().isVazio()) {
            if (alienacao.getPerguntas().getDataPrimeiraAlienacao().getAno().equals(AplicacaoPropertiesUtil.getExercicio())) {
                this.getDataPrimeiraAlienacao180DiasPergunta2().setConteudo(this.getDataPrimeiraAlienacao180DiasPergunta1());
                this.getEspecificacaoDataPrimeiraAlienacao180DiasPergunta2().setConteudo(this.getEspecificacaoDataPrimeiraAlienacao180DiasPergunta1());
            } else {
                this.getDataPrimeiraAlienacao180DiasPergunta2().setConteudo(alienacao.getPerguntas().getDataPrimeiraAlienacao());
                this.getEspecificacaoDataPrimeiraAlienacao180DiasPergunta2().setConteudo(alienacao.getBemImovel().getEspecificacao());
            }
        }
        if (alienacao.getPerguntas().naoTemOutraAlienacao() && alienacao.getDataAlienacao().maisAntiga(this.getDataPrimeiraAlienacaoUnicoImovel())) {
            this.getDataPrimeiraAlienacaoUnicoImovel().setConteudo(alienacao.getDataAlienacao());
            this.getEspecificacaoDataPrimeiraAlienacaoUnicoImovel().setConteudo(alienacao.getBemImovel().getEspecificacao());
        }
    }

    public void objetoRemovido(Object o) {
        this.atualizarDatasAlienacoes();
    }

    public boolean existeAlienacaoEntreDatas(Data dataMaisAntiga, Data dataMaisRecente, String identificador) {
        boolean retorno = false;
        for (AlienacaoBemImovel alienacao : this.itens()) {
            if (alienacao.getBemImovel().getEspecificacao().naoFormatado().equals(identificador) || !(alienacao.getDataAlienacao().maisNova(dataMaisAntiga) && alienacao.getDataAlienacao().maisAntiga(dataMaisRecente) || alienacao.getPerguntas().getDataPrimeiraAlienacao().maisNova(dataMaisAntiga) && alienacao.getPerguntas().getDataPrimeiraAlienacao().maisAntiga(dataMaisRecente)) && !alienacao.getDataAlienacao().igual(dataMaisRecente)) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public boolean existeAlienacaoEntreDatasComIsencao180Dias(Data dataMaisAntiga, Data dataMaisRecente, String identificador) {
        boolean retorno = false;
        for (AlienacaoBemImovel alienacao : this.itens()) {
            if (alienacao.getBemImovel().getEspecificacao().naoFormatado().equals(identificador) || !alienacao.getPerguntas().isValorReaplicado() || !(alienacao.getDataAlienacao().maisNova(dataMaisAntiga) && alienacao.getDataAlienacao().maisAntiga(dataMaisRecente) || alienacao.getPerguntas().getDataPrimeiraAlienacao().maisNova(dataMaisAntiga) && alienacao.getPerguntas().getDataPrimeiraAlienacao().maisAntiga(dataMaisRecente)) && (!alienacao.getDataAlienacao().igual(dataMaisRecente) || alienacao.getPerguntas().isValorReaplicadoPrimeiraAlienacao())) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public Data obterData180DiasMaisAntigaPossivel(String identificador, Data dataAlienacao, Data dataPrimeiraAlienacao) {
        boolean achou = false;
        boolean testouAlgumaAlienacao = false;
        Data retorno = new Data();
        retorno.setConteudo(dataAlienacao);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dataAlienacao.asDate());
        calendar.add(5, -181);
        Data data181DiasAntesAlienacao = new Data();
        data181DiasAntesAlienacao.setConteudo(calendar.getTime());
        for (AlienacaoBemImovel alienacao : this.itens()) {
            if (alienacao.getBemImovel().getEspecificacao().naoFormatado().equals(identificador) || !alienacao.getPerguntas().isValorReaplicado()) continue;
            testouAlgumaAlienacao = true;
            if (alienacao.getDataAlienacao().igual(retorno) || alienacao.getDataAlienacao().maisAntiga(retorno) && data181DiasAntesAlienacao.maisAntiga(alienacao.getDataAlienacao())) {
                retorno.setConteudo(alienacao.getDataAlienacao());
                achou = true;
            }
            if (alienacao.getPerguntas().getDataPrimeiraAlienacao().isVazio() || !alienacao.getPerguntas().getDataPrimeiraAlienacao().maisAntiga(retorno) || !data181DiasAntesAlienacao.maisAntiga(alienacao.getPerguntas().getDataPrimeiraAlienacao())) continue;
            retorno.setConteudo(alienacao.getPerguntas().getDataPrimeiraAlienacao());
            achou = true;
        }
        if (!achou) {
            calendar.add(5, 1);
            Data data180DiasAntesAlienacao = new Data();
            data180DiasAntesAlienacao.setConteudo(calendar.getTime());
            if (testouAlgumaAlienacao) {
                if (!dataAlienacao.getAno().equals(data180DiasAntesAlienacao.getAno()) && data180DiasAntesAlienacao.getAno().equals(dataPrimeiraAlienacao.getAno())) {
                    retorno.setConteudo(dataPrimeiraAlienacao);
                } else {
                    retorno = null;
                }
            } else if (data181DiasAntesAlienacao.maisAntiga(dataAlienacao)) {
                retorno.setConteudo(dataPrimeiraAlienacao);
            } else {
                retorno = null;
            }
        }
        return retorno;
    }
}

