/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.alienacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.validador.ValidadorComparacaoValor;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ParcelaAlienacao
extends ObjetoNegocio {
    public static String CAMPO_VALOR_RECEBIDO = "Valor recebido";
    public static String CAMPO_CUSTO_CORRETAGEM = "Custo da Corretagem";
    public static String CAMPO_VALOR_LIQUIDO_ALIENACAO = "Valor L\u00edquido de Aliena\u00e7\u00e3o";
    public static String CAMPO_GANHO_1_PROPORCIONAL = "Ganho de Capital Proporcional - Resultado 1";
    public static String CAMPO_GANHO_2_PROPORCIONAL = "Ganho de Capital Proporcional - Resultado 2";
    public static String CAMPO_GANHO_3_PROPORCIONAL = "Ganho de Capital Proporcional - Resultado 3";
    public static String CAMPO_GANHO_4_PROPORCIONAL = "Ganho de Capital Proporcional - Resultado 4";
    public static String CAMPO_GANHO_5_PROPORCIONAL = "Ganho de Capital Proporcional - Resultado 5";
    public static String CAMPO_GANHO_1_PROPORCIONAL_MN = "Ganho de Capital Proporcional MN - Resultado 1";
    public static String CAMPO_GANHO_2_PROPORCIONAL_MN = "Ganho de Capital Proporcional MN - Resultado 2";
    public static String CAMPO_GANHO_3_PROPORCIONAL_MN = "Ganho de Capital Proporcional MN - Resultado 3";
    public static String CAMPO_GANHO_4_PROPORCIONAL_MN = "Ganho de Capital Proporcional MN - Resultado 4";
    public static String CAMPO_GANHO_5_PROPORCIONAL_MN = "Ganho de Capital Proporcional MN - Resultado 5";
    public static String CAMPO_GANHO_1_PROPORCIONAL_ME = "Ganho de Capital Proporcional ME - Resultado 1";
    public static String CAMPO_GANHO_2_PROPORCIONAL_ME = "Ganho de Capital Proporcional ME - Resultado 2";
    public static String CAMPO_GANHO_3_PROPORCIONAL_ME = "Ganho de Capital Proporcional ME - Resultado 3";
    public static String CAMPO_GANHO_4_PROPORCIONAL_ME = "Ganho de Capital Proporcional ME - Resultado 4";
    public static String CAMPO_GANHO_5_PROPORCIONAL_ME = "Ganho de Capital Proporcional ME - Resultado 5";
    public static String CAMPO_IMPOSTO_DEVIDO = "Imposto Devido (R$)";
    public static String CAMPO_IMPOSTO_PAGO_EXTERIOR_PASSIVEL_COMPENSACAO = "Imposto Pago no Exterior Pass\u00edvel de Compensa\u00e7\u00e3o";
    public static String CAMPO_IMPOSTO_DEVIDO_APOS_COMPENSACAO = "Imposto Devido Ap\u00f3s Compensa\u00e7\u00e3o(R$)";
    public static String CAMPO_IR_FONTE_LEI_11033_2004 = "IR na Fonte (Lei 11.033/2004)(R$)";
    public static String CAMPO_IMPOSTO_PAGO = "Imposto Pago";
    public static String CAMPO_VALOR_RECEBIDO_DOLAR = "Valor recebido (XX$)";
    public static String CAMPO_VALOR_RECEBIDO_REAL = "Valor recebido (R$)";
    public static String CAMPO_CUSTO_CORRETAGEM_DOLAR = "Custo da Corretagem (XX$)";
    public static String CAMPO_VALOR_LIQUIDO_ALIENACAO_DOLAR = "Valor L\u00edquido da Aliena\u00e7\u00e3o - (XX$)";
    public static String CAMPO_VALOR_LIQUIDO_ALIENACAO_REAL = "Valor L\u00edquido da Aliena\u00e7\u00e3o - (R$)";
    public static String CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_NACIONAL_REAL = "Ganho de Capital Proporcional - Rendimentos em Reais (R$)";
    public static String CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_ME_REAL = "Ganho de Capital Proporcional - Rendimentos ME (R$)";
    public static String CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_ME_DOLAR = "Ganho de Capital Proporcional - Rendimentos ME (US$)";
    public static String CAMPO_GANHO_CAPITAL_1_PROPORCIONAL_TOTAL_REAL = "Ganho de Capital 1 Proporcional Total - (R$)";
    public static String CAMPO_GANHO_CAPITAL_5_PROPORCIONAL_TOTAL_REAL = "Ganho de Capital 5 Proporcional Total - (R$)";
    public static String CAMPO_CUSTO_AQUISICAO_PROPORCIONAL = "Custo de Aquisi\u00e7\u00e3o Proporcional";
    public static String CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL = "Custo de aquisi\u00e7\u00e3o proporcional da torna (R$)";
    public static String CAMPO_CUSTO_AQUISICAO_PROPORCIONAL_NACIONAL_REAL = "Custo de Aquisi\u00e7\u00e3o Proporcional Rendimentos em Reais (R$)";
    public static String CAMPO_CUSTO_AQUISICAO_PROPORCIONAL_ME_DOLAR = "Custo de Aquisi\u00e7\u00e3o Proporcional - Rendimentos ME (US$)";
    public static String CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL_NACIONAL_REAL = "Custo de Aquisi\u00e7\u00e3o Torna Proporcional Rendimentos em Reais (R$)";
    public static String CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL_ME_DOLAR = "Custo de Aquisi\u00e7\u00e3o Torna Proporcional - Rendimentos ME (US$)";
    private Logico ultimaParcela = new Logico((ObjetoNegocio)this, "Esta \u00e9 a \u00daltima Parcela?");
    private Data dataRecebimento = new Data((ObjetoNegocio)this, "Data de Recebimento");
    private ValorPositivo valorRecebido = new ValorPositivo(this, CAMPO_VALOR_RECEBIDO);
    private ValorPositivo custoAquisicaoProporcional = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO_PROPORCIONAL);
    private ValorPositivo custoAquisicaoTornaProporcional = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO_TORNA_PROPORCIONAL);
    private ValorPositivo custoCorretagem = new ValorPositivo(this, CAMPO_CUSTO_CORRETAGEM);
    private ValorPositivo valorLiquidoAlienacao = new ValorPositivo(this, CAMPO_VALOR_LIQUIDO_ALIENACAO);
    private ValorPositivo ganhoCapitalTotal = new ValorPositivo(this, "Ganho de Capital Proporcional Total");
    private ValorPositivo percentualGanho = new ValorPositivo(this, "% Ganho sobre Valor Aliena\u00e7\u00e3o", 11, 6);
    private ValorPositivo ganhoCapital1Proporcional = new ValorPositivo(this, CAMPO_GANHO_1_PROPORCIONAL);
    private ValorPositivo percentualReducaoLei7713 = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 7.713, de 1988)", 3, 6);
    private ValorPositivo valorReducaoLei7713 = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - (R$)");
    private ValorPositivo ganhoCapital2Proporcional = new ValorPositivo(this, CAMPO_GANHO_2_PROPORCIONAL);
    private ValorPositivo percentualReducaoLei11196FR1 = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR1", 3, 6);
    private ValorPositivo valorReducaoLei11196FR1 = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR1 - (R$)");
    private ValorPositivo ganhoCapital3Proporcional = new ValorPositivo(this, CAMPO_GANHO_3_PROPORCIONAL);
    private ValorPositivo percentualReducaoLei11196FR2 = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o (lei 11.196, de 2005) - FR2", 3, 6);
    private ValorPositivo valorReducaoLei11196FR2 = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o (lei 7.713, de 1988) - FR2 - (R$)");
    private ValorPositivo ganhoCapital4Proporcional = new ValorPositivo(this, CAMPO_GANHO_4_PROPORCIONAL);
    private ValorPositivo valorInformadoReducaoAplicacaoOutroImovel = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo percentualReducaoAplicacaoOutroImovel = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel", 3, 6);
    private ValorPositivo valorReducaoAplicacaoOutroImovel = new ValorPositivo(this, "Valor calculado de redu\u00e7\u00e3o - Aplica\u00e7\u00e3o em outro im\u00f3vel - (R$)");
    private ValorPositivo percentualReducaoUnicoImovel = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo valorReducaoUnicoImovel = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo percentualReducaoBemPequenoValor = new ValorPositivo(this, "Percentual de redu\u00e7\u00e3o - Bem de pequeno valor", 3, 6);
    private ValorPositivo valorReducaoBemPequenoValor = new ValorPositivo(this, "Valor de redu\u00e7\u00e3o - Bem de pequeno valor - (R$)");
    private ValorPositivo ganhoCapital5Proporcional = new ValorPositivo(this, CAMPO_GANHO_5_PROPORCIONAL);
    private ValorPositivo aliquotaMedia = new ValorPositivo(this, "Al\u00edquota M\u00e9dia de Imposto Devido", 11, 6);
    private ValorPositivo impostoDevido = new ValorPositivo(this, CAMPO_IMPOSTO_DEVIDO);
    private ValorPositivo impostoPago = new ValorPositivo(this, CAMPO_IMPOSTO_PAGO);
    private ValorPositivo impostoDevido2 = new ValorPositivo(this, CAMPO_IMPOSTO_DEVIDO_APOS_COMPENSACAO);
    private ValorPositivo irrfLei110332004 = new ValorPositivo(this, CAMPO_IR_FONTE_LEI_11033_2004);
    private transient Alfa mesRecebimentoAux = new Alfa((ObjetoNegocio)this, "M\u00eas Recebimento da Parcela", 2);
    private boolean emReordenacao = false;

    public ParcelaAlienacao() {
        this.getUltimaParcela().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getUltimaParcela().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getValorLiquidoAlienacao().setReadOnly(true);
        this.getPercentualGanho().setReadOnly(true);
        this.getCustoAquisicaoTornaProporcional().setReadOnly(true);
        this.getGanhoCapital1Proporcional().setReadOnly(true);
        this.getPercentualReducaoLei7713().setReadOnly(true);
        this.getValorReducaoLei7713().setReadOnly(true);
        this.getGanhoCapital2Proporcional().setReadOnly(true);
        this.getPercentualReducaoLei11196FR1().setReadOnly(true);
        this.getValorReducaoLei11196FR1().setReadOnly(true);
        this.getGanhoCapital3Proporcional().setReadOnly(true);
        this.getPercentualReducaoLei11196FR2().setReadOnly(true);
        this.getValorReducaoLei11196FR2().setReadOnly(true);
        this.getGanhoCapital4Proporcional().setReadOnly(true);
        this.getPercentualReducaoAplicacaoOutroImovel().setReadOnly(true);
        this.getValorReducaoAplicacaoOutroImovel().setReadOnly(true);
        this.getPercentualReducaoUnicoImovel().setReadOnly(true);
        this.getValorReducaoUnicoImovel().setReadOnly(true);
        this.getPercentualReducaoBemPequenoValor().setReadOnly(true);
        this.getValorReducaoBemPequenoValor().setReadOnly(true);
        this.getGanhoCapital5Proporcional().setReadOnly(true);
        this.getAliquotaMedia().setReadOnly(true);
        this.getImpostoDevido().setReadOnly(true);
        this.getImpostoDevido2().setReadOnly(true);
        this.getCustoAquisicaoProporcional().setReadOnly(true);
        this.adicionarValidadoresParcelaAlienacao();
    }

    private void adicionarValidadoresParcelaAlienacao() {
        this.getUltimaParcela().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("perguntaEmBranco", new String[]{this.ultimaParcela.getNomeCampo()})));
        this.getCustoCorretagem().addValidador((ValidadorIf)new ValidadorComparacaoValor(3, -3, (Object)this.getValorRecebido()));
    }

    public ValorPositivo getImpostoDevido2() {
        return this.impostoDevido2;
    }

    public String getImpostoDevido2Impressao() {
        return this.impostoDevido2.formatado();
    }

    public ValorPositivo getIrrfLei110332004() {
        return this.irrfLei110332004;
    }

    public String getIrrfLei110332004Impressao() {
        return this.irrfLei110332004.formatado();
    }

    public Logico getUltimaParcela() {
        return this.ultimaParcela;
    }

    public Data getDataRecebimento() {
        return this.dataRecebimento;
    }

    public String getDataRecebimentoImpressao() {
        return this.dataRecebimento.isVazio() ? "" : this.dataRecebimento.formatado();
    }

    public ValorPositivo getGanhoCapitalTotal() {
        return this.ganhoCapitalTotal;
    }

    public String getGanhoCapitalTotalImpressao() {
        return this.ganhoCapitalTotal.formatado();
    }

    public ValorPositivo getAliquotaMedia() {
        return this.aliquotaMedia;
    }

    public String getAliquotaMediaImpressao() {
        return this.aliquotaMedia.formatado();
    }

    public ValorPositivo getImpostoDevido() {
        return this.impostoDevido;
    }

    public String getImpostoDevidoImpressao() {
        return this.impostoDevido.formatado();
    }

    public ValorPositivo getImpostoPago() {
        return this.impostoPago;
    }

    public String getImpostoPagoImpressao() {
        return this.impostoPago.formatado();
    }

    public ValorPositivo getValorRecebido() {
        return this.valorRecebido;
    }

    public String getValorRecebidoImpressao() {
        return this.valorRecebido.formatado();
    }

    public ValorPositivo getPercentualGanho() {
        return this.percentualGanho;
    }

    public String getPercentualGanhoImpressao() {
        return this.percentualGanho.formatado();
    }

    public ValorPositivo getGanhoCapital1Proporcional() {
        return this.ganhoCapital1Proporcional;
    }

    public ValorPositivo getGanhoCapital2Proporcional() {
        return this.ganhoCapital2Proporcional;
    }

    public ValorPositivo getGanhoCapital3Proporcional() {
        return this.ganhoCapital3Proporcional;
    }

    public ValorPositivo getGanhoCapital4Proporcional() {
        return this.ganhoCapital4Proporcional;
    }

    public ValorPositivo getGanhoCapital5Proporcional() {
        return this.ganhoCapital5Proporcional;
    }

    public String getGanhoProporcionalImpressao() {
        return this.ganhoCapital1Proporcional.formatado();
    }

    public boolean isUltimaParcela() {
        return Logico.SIM.equals(this.getUltimaParcela().naoFormatado());
    }

    public ParcelaAlienacao obterCopia() {
        ParcelaAlienacao clone = new ParcelaAlienacao();
        clone.getUltimaParcela().setConteudo(this.getUltimaParcela());
        clone.getDataRecebimento().setConteudo(this.getDataRecebimento());
        clone.getValorRecebido().setConteudo(this.getValorRecebido());
        clone.getPercentualGanho().setConteudo(this.getPercentualGanho());
        clone.getCustoAquisicaoTornaProporcional().setConteudo(this.getCustoAquisicaoTornaProporcional());
        clone.getGanhoCapital1Proporcional().setConteudo(this.getGanhoCapital1Proporcional());
        clone.getPercentualReducaoLei7713().setConteudo(this.getPercentualReducaoLei7713());
        clone.getValorReducaoLei7713().setConteudo(this.getValorReducaoLei7713());
        clone.getGanhoCapital2Proporcional().setConteudo(this.getGanhoCapital2Proporcional());
        clone.getPercentualReducaoLei11196FR1().setConteudo(this.getPercentualReducaoLei11196FR1());
        clone.getValorReducaoLei11196FR1().setConteudo(this.getValorReducaoLei11196FR1());
        clone.getGanhoCapital3Proporcional().setConteudo(this.getGanhoCapital3Proporcional());
        clone.getPercentualReducaoLei11196FR2().setConteudo(this.getPercentualReducaoLei11196FR2());
        clone.getValorReducaoLei11196FR2().setConteudo(this.getValorReducaoLei11196FR2());
        clone.getGanhoCapital4Proporcional().setConteudo(this.getGanhoCapital4Proporcional());
        clone.getPercentualReducaoAplicacaoOutroImovel().setConteudo(this.getPercentualReducaoAplicacaoOutroImovel());
        clone.getValorReducaoAplicacaoOutroImovel().setConteudo(this.getValorReducaoAplicacaoOutroImovel());
        clone.getPercentualReducaoUnicoImovel().setConteudo(this.getPercentualReducaoUnicoImovel());
        clone.getValorReducaoUnicoImovel().setConteudo(this.getValorReducaoUnicoImovel());
        clone.getPercentualReducaoBemPequenoValor().setConteudo(this.getPercentualReducaoBemPequenoValor());
        clone.getValorReducaoBemPequenoValor().setConteudo(this.getValorReducaoBemPequenoValor());
        clone.getGanhoCapital5Proporcional().setConteudo(this.getGanhoCapital5Proporcional());
        clone.getGanhoCapitalTotal().setConteudo(this.getGanhoCapitalTotal());
        clone.getAliquotaMedia().setConteudo(this.getAliquotaMedia());
        clone.getImpostoDevido().setConteudo(this.getImpostoDevido());
        clone.getImpostoPago().setConteudo(this.getImpostoPago());
        clone.getIrrfLei110332004().setConteudo(this.getIrrfLei110332004());
        clone.getImpostoDevido2().setConteudo(this.getImpostoDevido2());
        clone.getCustoAquisicaoProporcional().setConteudo(this.getCustoAquisicaoProporcional());
        return clone;
    }

    public void restaurar(ParcelaAlienacao parcela) {
        this.getUltimaParcela().setConteudo(parcela.getUltimaParcela());
        this.getDataRecebimento().setConteudo(parcela.getDataRecebimento());
        this.getValorRecebido().setConteudo(parcela.getValorRecebido());
        this.getPercentualGanho().setConteudo(parcela.getPercentualGanho());
        this.getCustoAquisicaoTornaProporcional().setConteudo(parcela.getCustoAquisicaoTornaProporcional());
        this.getGanhoCapital1Proporcional().setConteudo(parcela.getGanhoCapital1Proporcional());
        this.getPercentualReducaoLei7713().setConteudo(parcela.getPercentualReducaoLei7713());
        this.getValorReducaoLei7713().setConteudo(parcela.getValorReducaoLei7713());
        this.getGanhoCapital2Proporcional().setConteudo(parcela.getGanhoCapital2Proporcional());
        this.getPercentualReducaoLei11196FR1().setConteudo(parcela.getPercentualReducaoLei11196FR1());
        this.getValorReducaoLei11196FR1().setConteudo(parcela.getValorReducaoLei11196FR1());
        this.getGanhoCapital3Proporcional().setConteudo(parcela.getGanhoCapital3Proporcional());
        this.getPercentualReducaoLei11196FR2().setConteudo(parcela.getPercentualReducaoLei11196FR2());
        this.getValorReducaoLei11196FR2().setConteudo(parcela.getValorReducaoLei11196FR2());
        this.getGanhoCapital4Proporcional().setConteudo(parcela.getGanhoCapital4Proporcional());
        this.getPercentualReducaoAplicacaoOutroImovel().setConteudo(parcela.getPercentualReducaoAplicacaoOutroImovel());
        this.getValorReducaoAplicacaoOutroImovel().setConteudo(parcela.getValorReducaoAplicacaoOutroImovel());
        this.getPercentualReducaoUnicoImovel().setConteudo(parcela.getPercentualReducaoUnicoImovel());
        this.getValorReducaoUnicoImovel().setConteudo(parcela.getValorReducaoUnicoImovel());
        this.getPercentualReducaoBemPequenoValor().setConteudo(parcela.getPercentualReducaoBemPequenoValor());
        this.getValorReducaoBemPequenoValor().setConteudo(parcela.getValorReducaoBemPequenoValor());
        this.getGanhoCapital5Proporcional().setConteudo(parcela.getGanhoCapital5Proporcional());
        this.getGanhoCapitalTotal().setConteudo(parcela.getGanhoCapitalTotal());
        this.getAliquotaMedia().setConteudo(parcela.getAliquotaMedia());
        this.getImpostoDevido().setConteudo(parcela.getImpostoDevido());
        this.getImpostoPago().setConteudo(parcela.getImpostoPago());
        this.getIrrfLei110332004().setConteudo(parcela.getIrrfLei110332004());
        this.getImpostoDevido2().setConteudo(parcela.getImpostoDevido2());
        this.getCustoAquisicaoProporcional().setConteudo(parcela.getCustoAquisicaoProporcional());
    }

    public void addObservador(Observador obs) {
        this.valorRecebido.addObservador(obs);
        this.custoCorretagem.addObservador(obs);
        this.valorLiquidoAlienacao.addObservador(obs);
        this.impostoDevido.addObservador(obs);
        this.impostoPago.addObservador(obs);
        this.irrfLei110332004.addObservador(obs);
        this.impostoDevido2.addObservador(obs);
        this.custoAquisicaoProporcional.addObservador(obs);
        this.ganhoCapital1Proporcional.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.valorRecebido.removeObservador(obs);
        this.custoCorretagem.removeObservador(obs);
        this.valorLiquidoAlienacao.removeObservador(obs);
        this.impostoDevido.removeObservador(obs);
        this.impostoPago.removeObservador(obs);
        this.irrfLei110332004.removeObservador(obs);
        this.impostoDevido2.removeObservador(obs);
        this.custoAquisicaoProporcional.removeObservador(obs);
        this.ganhoCapital1Proporcional.removeObservador(obs);
    }

    public boolean isVazio() {
        return this.getDataRecebimento().isVazio() && this.getValorRecebido().isVazio();
    }

    public ValorPositivo getCustoCorretagem() {
        return this.custoCorretagem;
    }

    public ValorPositivo getValorLiquidoAlienacao() {
        return this.valorLiquidoAlienacao;
    }

    public ValorPositivo getCustoAquisicaoProporcional() {
        return this.custoAquisicaoProporcional;
    }

    public Alfa getMesRecebimentoAux() {
        return this.mesRecebimentoAux;
    }

    public boolean getEmReordenacao() {
        return this.emReordenacao;
    }

    public void setEmReordenacao(boolean emReordenacao) {
        this.emReordenacao = emReordenacao;
    }

    public ValorPositivo getCustoAquisicaoTornaProporcional() {
        return this.custoAquisicaoTornaProporcional;
    }

    public ValorPositivo getPercentualReducaoLei7713() {
        return this.percentualReducaoLei7713;
    }

    public ValorPositivo getValorReducaoLei7713() {
        return this.valorReducaoLei7713;
    }

    public ValorPositivo getPercentualReducaoLei11196FR1() {
        return this.percentualReducaoLei11196FR1;
    }

    public ValorPositivo getValorReducaoLei11196FR1() {
        return this.valorReducaoLei11196FR1;
    }

    public ValorPositivo getPercentualReducaoLei11196FR2() {
        return this.percentualReducaoLei11196FR2;
    }

    public ValorPositivo getValorReducaoLei11196FR2() {
        return this.valorReducaoLei11196FR2;
    }

    public ValorPositivo getValorInformadoReducaoAplicacaoOutroImovel() {
        return this.valorInformadoReducaoAplicacaoOutroImovel;
    }

    public ValorPositivo getPercentualReducaoAplicacaoOutroImovel() {
        return this.percentualReducaoAplicacaoOutroImovel;
    }

    public ValorPositivo getValorReducaoAplicacaoOutroImovel() {
        return this.valorReducaoAplicacaoOutroImovel;
    }

    public ValorPositivo getPercentualReducaoUnicoImovel() {
        return this.percentualReducaoUnicoImovel;
    }

    public ValorPositivo getValorReducaoUnicoImovel() {
        return this.valorReducaoUnicoImovel;
    }

    public ValorPositivo getPercentualReducaoBemPequenoValor() {
        return this.percentualReducaoBemPequenoValor;
    }

    public ValorPositivo getValorReducaoBemPequenoValor() {
        return this.valorReducaoBemPequenoValor;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaCalculo() {
        ArrayList<Informacao> campos = new ArrayList<Informacao>();
        campos.add((Informacao)this.getUltimaParcela());
        campos.add((Informacao)this.getDataRecebimento());
        campos.add((Informacao)this.getValorRecebido());
        campos.add((Informacao)this.getCustoCorretagem());
        return campos;
    }
}

