/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.apuracao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class Apuracao
extends ObjetoNegocio
implements ObjetoFicha {
    private ValorPositivo valorAlienacao = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o (R$)");
    private ValorPositivo custoCorretagem = new ValorPositivo(this, "Custo de Corretagem (R$)");
    private ValorPositivo valorLiquidoAlienacao = new ValorPositivo(this, "Valor L\u00edquido de Aliena\u00e7\u00e3o (R$)");
    private ValorPositivo custoAquisicao = new ValorPositivo(this, "Custo de Aquisi\u00e7\u00e3o (R$)");
    private ValorPositivo ganhoCapital1 = new ValorPositivo(this, "Ganho de Capital - Resultado 1 (R$)");

    public Apuracao() {
        this.valorAlienacao.setReadOnly(true);
        this.custoCorretagem.setReadOnly(true);
        this.valorLiquidoAlienacao.setReadOnly(true);
        this.custoAquisicao.setReadOnly(true);
        this.ganhoCapital1.setReadOnly(true);
        this.adicionaObservadoresApuracao();
    }

    protected void adicionaObservadoresApuracao() {
        Observador obsCalculoValorLiquidoAlienacao = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (Apuracao.this.getValorAlienacao().comparacao(">", Apuracao.this.getCustoCorretagem())) {
                    Apuracao.this.getValorLiquidoAlienacao().setConteudo(Apuracao.this.getValorAlienacao().operacao('-', Apuracao.this.getCustoCorretagem()));
                } else {
                    Apuracao.this.getValorLiquidoAlienacao().clear();
                }
            }
        };
        this.getValorAlienacao().addObservador(obsCalculoValorLiquidoAlienacao);
        this.getCustoCorretagem().addObservador(obsCalculoValorLiquidoAlienacao);
        Observador obsCalculoGanhoCapital1 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                Apuracao.this.calcularGanhoCapital1(Apuracao.this.getValorLiquidoAlienacao(), Apuracao.this.getCustoAquisicao());
            }
        };
        this.getValorLiquidoAlienacao().addObservador(obsCalculoGanhoCapital1);
        this.getCustoAquisicao().addObservador(obsCalculoGanhoCapital1);
    }

    public void calcularGanhoCapital1(ValorPositivo pValorLiquidoAlienacao, ValorPositivo pCustoAquisicao) {
        if (pValorLiquidoAlienacao.comparacao(">", pCustoAquisicao)) {
            this.getGanhoCapital1().setConteudo(pValorLiquidoAlienacao.operacao('-', pCustoAquisicao));
        } else {
            this.getGanhoCapital1().clear();
        }
    }

    public String getClasseFicha() {
        return null;
    }

    public String getNomeAba() {
        return null;
    }

    public ValorPositivo getValorAlienacao() {
        return this.valorAlienacao;
    }

    public ValorPositivo getCustoCorretagem() {
        return this.custoCorretagem;
    }

    public ValorPositivo getValorLiquidoAlienacao() {
        return this.valorLiquidoAlienacao;
    }

    public ValorPositivo getGanhoCapital1() {
        return this.ganhoCapital1;
    }

    public ValorPositivo getCustoAquisicao() {
        return this.custoAquisicao;
    }

    public ValorPositivo calcularPercentualGanhoBrasil() {
        ValorPositivo percentualGanho = new ValorPositivo(this, "Percentual de Ganho", 11, 9);
        if (this.valorLiquidoAlienacao.comparacao(">", "0,00")) {
            percentualGanho.setConteudo(this.ganhoCapital1);
            percentualGanho.append('*', "100,000000");
            percentualGanho.append('/', this.valorLiquidoAlienacao);
            percentualGanho.converteQtdCasasDecimais(6);
        }
        return percentualGanho;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

