/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.apuracao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.apuracao.Apuracao;
import serpro.ppgd.negocio.Observador;

public class ApuracaoBem
extends Apuracao {
    private ValorPositivo valorAlienacaoDolar = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o (XX$)");
    private ValorPositivo custoCorretagemDolar = new ValorPositivo(this, "Custo de Corretagem (XX$)");
    private ValorPositivo valorLiquidoAlienacaoDolar = new ValorPositivo(this, "Valor L\u00edquido de Aliena\u00e7\u00e3o (XX$)");
    private ValorPositivo percentualCustoAquisicaoOrigemMN = new ValorPositivo(this, "Percentual de Custo de Aquisi\u00e7\u00e3o com origem em Moeda Nacional", 3, 9);
    private ValorPositivo percentualCustoAquisicaoOrigemME = new ValorPositivo(this, "Percentual de Custo de Aquisi\u00e7\u00e3o com origem em Moeda Estrangeira", 3, 9);
    private ValorPositivo valorAlienacaoOrigemNacionalDolar = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o - Moeda Nacional (XX$)");
    private ValorPositivo valorAlienacaoOrigemMEDolar = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o - Moeda Estrangeira (US$)");
    private ValorPositivo custoCorretagemOrigemNacionalDolar = new ValorPositivo(this, "Custo de Corretagem - Moeda Nacional (XX$)");
    private ValorPositivo custoCorretagemOrigemMEDolar = new ValorPositivo(this, "Custo de Corretagem - Moeda Estrageira (US$)");
    private ValorPositivo valorLiquidoAlienacaoOrigemNacionalDolar = new ValorPositivo(this, "Valor L\u00edquido de Aliena\u00e7\u00e3o - Moeda Nacional (XX$)");
    private ValorPositivo valorLiquidoAlienacaoOrigemMEDolar = new ValorPositivo(this, "Valor L\u00edquido de Aliena\u00e7\u00e3o - Moeda Estrangeira (US$)");
    private ValorPositivo cotacaoDolarOrigemNacional = new ValorPositivo(this, "Cota\u00e7\u00e3o da moeda estrangeira na Data de Aliena\u00e7\u00e3o - Moeda Nacional", 11, 4);
    private ValorPositivo valorLiquidoAlienacaoOrigemNacionalReal = new ValorPositivo(this, "Valor L\u00edquido de Aliena\u00e7\u00e3o - Moeda Nacional (R$)");
    private ValorPositivo custoAquisicaoOrigemNacionalReal = new ValorPositivo(this, "Custo de Aquisi\u00e7\u00e3o - Moeda Nacional (R$)");
    private ValorPositivo custoAquisicaoOrigemMEDolar = new ValorPositivo(this, "Custo de Aquisi\u00e7\u00e3o - Moeda Estrangeira (US$)");
    private ValorPositivo ganhoCapital1OrigemNacionalReal = new ValorPositivo(this, "Ganho de Capital - Resultado 1 - Moeda Nacional (R$)");
    private ValorPositivo ganhoCapital1OrigemMEDolar = new ValorPositivo(this, "Ganho de Capital - Resultado 1 - Moeda Estrangeira (US$)");
    private ValorPositivo cotacaoDolarOrigemME = new ValorPositivo(this, "Cota\u00e7\u00e3o do D\u00f3lar - Moeda Estrangeira (R$)", 11, 4);
    private ValorPositivo ganhoCapital1OrigemMEReal = new ValorPositivo(this, "Ganho de Capital - Resultado 1 - Moeda Estrangeira (R$)");

    public ApuracaoBem() {
        this.valorAlienacaoDolar.setReadOnly(true);
        this.custoCorretagemDolar.setReadOnly(true);
        this.valorLiquidoAlienacaoDolar.setReadOnly(true);
        this.valorAlienacaoOrigemNacionalDolar.setReadOnly(true);
        this.valorAlienacaoOrigemMEDolar.setReadOnly(true);
        this.custoCorretagemOrigemNacionalDolar.setReadOnly(true);
        this.custoCorretagemOrigemMEDolar.setReadOnly(true);
        this.valorLiquidoAlienacaoOrigemNacionalDolar.setReadOnly(true);
        this.valorLiquidoAlienacaoOrigemMEDolar.setReadOnly(true);
        this.cotacaoDolarOrigemNacional.setReadOnly(true);
        this.valorLiquidoAlienacaoOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoOrigemMEDolar.setReadOnly(true);
        this.ganhoCapital1OrigemNacionalReal.setReadOnly(true);
        this.ganhoCapital1OrigemMEDolar.setReadOnly(true);
        this.cotacaoDolarOrigemME.setReadOnly(true);
        this.ganhoCapital1OrigemMEReal.setReadOnly(true);
        this.adicionaObservadoresApuracaoBem();
    }

    protected void adicionaObservadoresApuracaoBem() {
        Observador obsValorLiquidoDolar = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                ValorPositivo valorLiquido = new ValorPositivo();
                valorLiquido.setConteudo(ApuracaoBem.this.getValorAlienacaoDolar());
                valorLiquido.append('-', ApuracaoBem.this.getCustoCorretagemDolar());
                ApuracaoBem.this.getValorLiquidoAlienacaoDolar().setConteudo(valorLiquido);
            }
        };
        this.getValorAlienacaoDolar().addObservador(obsValorLiquidoDolar);
        this.getCustoCorretagemDolar().addObservador(obsValorLiquidoDolar);
        Observador obsCalculoValorAlienacaoProporcionalMN = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ValorPositivo ValorAlienacaoMNDolar = new ValorPositivo(null, "ValorAlienacaoMNDolar", 11, 9);
                ValorAlienacaoMNDolar.setConteudo(ApuracaoBem.this.getValorAlienacaoDolar().operacao('*', ApuracaoBem.this.getPercentualCustoAquisicaoOrigemMN()).operacao('/', "100,00"));
                ValorAlienacaoMNDolar.converteQtdCasasDecimais(2);
                ApuracaoBem.this.getValorAlienacaoOrigemNacionalDolar().setConteudo(ValorAlienacaoMNDolar);
                if (ApuracaoBem.this.getPercentualCustoAquisicaoOrigemME().comparacao(">", "0,00")) {
                    ApuracaoBem.this.getValorAlienacaoOrigemMEDolar().setConteudo(ApuracaoBem.this.getValorAlienacaoDolar().operacao('-', ApuracaoBem.this.getValorAlienacaoOrigemNacionalDolar()));
                } else {
                    ApuracaoBem.this.getValorAlienacaoOrigemMEDolar().clear();
                }
            }
        };
        this.getValorAlienacaoDolar().addObservador(obsCalculoValorAlienacaoProporcionalMN);
        this.getPercentualCustoAquisicaoOrigemMN().addObservador(obsCalculoValorAlienacaoProporcionalMN);
        this.getPercentualCustoAquisicaoOrigemME().addObservador(obsCalculoValorAlienacaoProporcionalMN);
        Observador obsCalculoCustoCorretagemProporcionalMN = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBem.this.getCustoCorretagemOrigemNacionalDolar().setConteudo(ApuracaoBem.this.getCustoCorretagemDolar().operacao('*', ApuracaoBem.this.getPercentualCustoAquisicaoOrigemMN()).operacao('/', "100,00"));
                if (ApuracaoBem.this.getPercentualCustoAquisicaoOrigemME().comparacao(">", "0,00")) {
                    ApuracaoBem.this.getCustoCorretagemOrigemMEDolar().setConteudo(ApuracaoBem.this.getCustoCorretagemDolar().operacao('-', ApuracaoBem.this.getCustoCorretagemOrigemNacionalDolar()));
                } else {
                    ApuracaoBem.this.getCustoCorretagemOrigemMEDolar().clear();
                }
            }
        };
        this.getCustoCorretagemDolar().addObservador(obsCalculoCustoCorretagemProporcionalMN);
        this.getPercentualCustoAquisicaoOrigemMN().addObservador(obsCalculoCustoCorretagemProporcionalMN);
        this.getPercentualCustoAquisicaoOrigemME().addObservador(obsCalculoCustoCorretagemProporcionalMN);
        Observador obsCalculoValorLiquidoAlienacaoMN = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (ApuracaoBem.this.getValorAlienacaoOrigemNacionalDolar().comparacao(">", ApuracaoBem.this.getCustoCorretagemOrigemNacionalDolar())) {
                    ApuracaoBem.this.getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(ApuracaoBem.this.getValorAlienacaoOrigemNacionalDolar().operacao('-', ApuracaoBem.this.getCustoCorretagemOrigemNacionalDolar()));
                } else {
                    ApuracaoBem.this.getValorLiquidoAlienacaoOrigemNacionalDolar().clear();
                }
            }
        };
        this.getValorAlienacaoOrigemNacionalDolar().addObservador(obsCalculoValorLiquidoAlienacaoMN);
        this.getCustoCorretagemOrigemNacionalDolar().addObservador(obsCalculoValorLiquidoAlienacaoMN);
        Observador obsCalculoValorLiquidoAlienacaoME = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (ApuracaoBem.this.getValorAlienacaoOrigemMEDolar().comparacao(">", ApuracaoBem.this.getCustoCorretagemOrigemMEDolar())) {
                    ApuracaoBem.this.getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(ApuracaoBem.this.getValorAlienacaoOrigemMEDolar().operacao('-', ApuracaoBem.this.getCustoCorretagemOrigemMEDolar()));
                } else {
                    ApuracaoBem.this.getValorLiquidoAlienacaoOrigemMEDolar().clear();
                }
            }
        };
        this.getValorAlienacaoOrigemMEDolar().addObservador(obsCalculoValorLiquidoAlienacaoME);
        this.getCustoCorretagemOrigemMEDolar().addObservador(obsCalculoValorLiquidoAlienacaoME);
        Observador obsCalculaValorLiquidoAlienacaoMNReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBem.this.getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(ApuracaoBem.this.getValorLiquidoAlienacaoOrigemNacionalDolar().operacao('*', ApuracaoBem.this.getCotacaoDolarOrigemNacional()));
            }
        };
        this.getValorLiquidoAlienacaoOrigemNacionalDolar().addObservador(obsCalculaValorLiquidoAlienacaoMNReal);
        this.getCotacaoDolarOrigemNacional().addObservador(obsCalculaValorLiquidoAlienacaoMNReal);
        Observador obsCalculaGanhoCapital1MNReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBem.this.calcularGanhoCapital1OrigemMNReal(ApuracaoBem.this.getValorLiquidoAlienacaoOrigemNacionalReal(), ApuracaoBem.this.getCustoAquisicaoOrigemNacionalReal());
            }
        };
        this.getValorLiquidoAlienacaoOrigemNacionalReal().addObservador(obsCalculaGanhoCapital1MNReal);
        this.getCustoAquisicaoOrigemNacionalReal().addObservador(obsCalculaGanhoCapital1MNReal);
        Observador obsCalculaGanhoCapital1MEDolar = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBem.this.calcularGanhoCapital1OrigemMEDolar(ApuracaoBem.this.getValorLiquidoAlienacaoOrigemMEDolar(), ApuracaoBem.this.getCustoAquisicaoOrigemMEDolar());
            }
        };
        this.getValorLiquidoAlienacaoOrigemMEDolar().addObservador(obsCalculaGanhoCapital1MEDolar);
        this.getCustoAquisicaoOrigemMEDolar().addObservador(obsCalculaGanhoCapital1MEDolar);
        Observador obsCalculaGanhoCapital1MEReal = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ApuracaoBem.this.getGanhoCapital1OrigemMEReal().setConteudo(ApuracaoBem.this.getGanhoCapital1OrigemMEDolar().operacao('*', ApuracaoBem.this.getCotacaoDolarOrigemME()));
            }
        };
        this.getGanhoCapital1OrigemMEDolar().addObservador(obsCalculaGanhoCapital1MEReal);
        this.getCotacaoDolarOrigemME().addObservador(obsCalculaGanhoCapital1MEReal);
    }

    public void calcularGanhoCapital1OrigemMNReal(ValorPositivo pValorLiquidoAlienacaoOrigemMNReal, ValorPositivo pCustoAquisicaoOrigemMNReal) {
        if (pValorLiquidoAlienacaoOrigemMNReal.comparacao(">", pCustoAquisicaoOrigemMNReal)) {
            this.getGanhoCapital1OrigemNacionalReal().setConteudo(pValorLiquidoAlienacaoOrigemMNReal.operacao('-', pCustoAquisicaoOrigemMNReal));
        } else {
            this.getGanhoCapital1OrigemNacionalReal().clear();
        }
    }

    public void calcularGanhoCapital1OrigemMEDolar(ValorPositivo pValorLiquidoAlienacaoOrigemMEDolar, ValorPositivo pCustoAquisicaoOrigemMEDolar) {
        if (pValorLiquidoAlienacaoOrigemMEDolar.comparacao(">", pCustoAquisicaoOrigemMEDolar)) {
            this.getGanhoCapital1OrigemMEDolar().setConteudo(pValorLiquidoAlienacaoOrigemMEDolar.operacao('-', pCustoAquisicaoOrigemMEDolar));
        } else {
            this.getGanhoCapital1OrigemMEDolar().clear();
        }
    }

    public ValorPositivo getValorAlienacaoOrigemNacionalDolar() {
        return this.valorAlienacaoOrigemNacionalDolar;
    }

    public ValorPositivo getValorAlienacaoOrigemMEDolar() {
        return this.valorAlienacaoOrigemMEDolar;
    }

    public ValorPositivo getCustoCorretagemOrigemNacionalDolar() {
        return this.custoCorretagemOrigemNacionalDolar;
    }

    public ValorPositivo getCustoCorretagemOrigemMEDolar() {
        return this.custoCorretagemOrigemMEDolar;
    }

    public ValorPositivo getValorLiquidoAlienacaoOrigemNacionalDolar() {
        return this.valorLiquidoAlienacaoOrigemNacionalDolar;
    }

    public ValorPositivo getValorLiquidoAlienacaoOrigemMEDolar() {
        return this.valorLiquidoAlienacaoOrigemMEDolar;
    }

    public ValorPositivo getCotacaoDolarOrigemNacional() {
        return this.cotacaoDolarOrigemNacional;
    }

    public ValorPositivo getValorLiquidoAlienacaoOrigemNacionalReal() {
        return this.valorLiquidoAlienacaoOrigemNacionalReal;
    }

    public ValorPositivo getCustoAquisicaoOrigemNacionalReal() {
        return this.custoAquisicaoOrigemNacionalReal;
    }

    public ValorPositivo getCustoAquisicaoOrigemMEDolar() {
        return this.custoAquisicaoOrigemMEDolar;
    }

    public ValorPositivo getGanhoCapital1OrigemNacionalReal() {
        return this.ganhoCapital1OrigemNacionalReal;
    }

    public ValorPositivo getGanhoCapital1OrigemMEDolar() {
        return this.ganhoCapital1OrigemMEDolar;
    }

    public ValorPositivo getCotacaoDolarOrigemME() {
        return this.cotacaoDolarOrigemME;
    }

    public ValorPositivo getGanhoCapital1OrigemMEReal() {
        return this.ganhoCapital1OrigemMEReal;
    }

    public ValorPositivo calcularPercentualGanhoExteriorOrigemNacional() {
        ValorPositivo percentualGanho = new ValorPositivo(this, "Percentual de Ganho", 11, 9);
        if (this.valorLiquidoAlienacaoOrigemNacionalReal.comparacao(">", "0,00")) {
            percentualGanho.setConteudo(this.ganhoCapital1OrigemNacionalReal);
            percentualGanho.append('*', "100,000000");
            percentualGanho.append('/', this.valorLiquidoAlienacaoOrigemNacionalReal);
            percentualGanho.converteQtdCasasDecimais(6);
        }
        return percentualGanho;
    }

    public ValorPositivo calcularPercentualGanhoExteriorOrigemME() {
        ValorPositivo percentualGanho = new ValorPositivo(this, "Percentual de Ganho", 11, 9);
        if (this.valorLiquidoAlienacaoOrigemMEDolar.comparacao(">", "0,00")) {
            percentualGanho.setConteudo(this.ganhoCapital1OrigemMEDolar);
            percentualGanho.append('*', "100,000000");
            percentualGanho.append('/', this.valorLiquidoAlienacaoOrigemMEDolar);
            percentualGanho.converteQtdCasasDecimais(6);
        }
        return percentualGanho;
    }

    public ValorPositivo getValorAlienacaoDolar() {
        return this.valorAlienacaoDolar;
    }

    public ValorPositivo getCustoCorretagemDolar() {
        return this.custoCorretagemDolar;
    }

    public ValorPositivo getValorLiquidoAlienacaoDolar() {
        return this.valorLiquidoAlienacaoDolar;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemMN() {
        return this.percentualCustoAquisicaoOrigemMN;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemME() {
        return this.percentualCustoAquisicaoOrigemME;
    }
}

