/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.aquisicao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.entidades.aquisicao.ColecaoParcelaAquisicao;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class AquisicaoBemImovel
extends Aquisicao {
    private ValorPositivo custoAquisicaoTorna = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna (R$)");
    private ValorPositivo custoAquisicaoTornaOrigemMNDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna - Origem em Moeda Nacional (XX$)");
    private ValorPositivo custoAquisicaoTornaOrigemMNReal = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna - Origem em Moeda Nacional (R$)");
    private ValorPositivo custoAquisicaoTornaOrigemMEDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o da torna - Origem em Moeda Estrangeira (US$)");
    private Logico houveReforma = new Logico((ObjetoNegocio)this, "Houve no im\u00f3vel alienado edifica\u00e7\u00e3o, amplia\u00e7\u00e3o, reforma ou trata-se de im\u00f3vel adquirido em partes e em datas diferentes?");
    private ColecaoParcelaAquisicao parcelasAquisicao = new ColecaoParcelaAquisicao();
    private transient Alfa houveReformaAux = new Alfa((ObjetoNegocio)this, "Houve no im\u00f3vel alienado edifica\u00e7\u00e3o, amplia\u00e7\u00e3o, reforma ou trata-se de im\u00f3vel adquirido em partes e em datas diferentes?", 1);
    private Logico bemAtualizado = new Logico((ObjetoNegocio)this, "Bem atualizado de acordo com a Lei 14.973/2024?");
    private ValorPositivo valorDTA = new ValorPositivo(this, "Valor acrescido referente a atualiza\u00e7\u00e3o");
    private Data dataDTA = new Data((ObjetoNegocio)this, "Data do pagamento do DARF");

    public AquisicaoBemImovel() {
        this.getHouveReforma().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getHouveReforma().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.adicionarObservadorHouveReforma();
        this.getCustoAquisicaoTorna().setReadOnly(true);
        this.getCustoAquisicaoTornaOrigemMEDolar().setReadOnly(true);
        this.getCustoAquisicaoTornaOrigemMNDolar().setReadOnly(true);
        this.getCustoAquisicaoTornaOrigemMNReal().setReadOnly(true);
        this.getBemAtualizado().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemAtualizado().addOpcao(Logico.NAO, Logico.LABEL_NAO);
    }

    private void adicionarObservadorHouveReforma() {
        this.getHouveReformaAux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (AquisicaoBemImovel.this.houveReformaAux.formatado().equals("S")) {
                    AquisicaoBemImovel.this.houveReforma.setConteudo(Logico.SIM);
                } else if (AquisicaoBemImovel.this.houveReformaAux.formatado().equals("N")) {
                    AquisicaoBemImovel.this.houveReforma.setConteudo(Logico.NAO);
                }
            }
        });
    }

    public void calcularCustoAquisicaoReal(ValorPositivo custoAquisicaoOrigemNacionalDolar, ValorPositivo cotacaoDolarDataAquisicao) {
        this.getCustoAquisicaoOrigemNacionalReal().setConteudo(custoAquisicaoOrigemNacionalDolar.operacao('*', cotacaoDolarDataAquisicao));
    }

    public void calcularCustoAquisicaoTotalDolar(ValorPositivo custoAquisicaoOrigemNacionalDolar, ValorPositivo custoAquisicaoOrigemMEDolar) {
        this.getCustoAquisicaoTotalDolar().setConteudo(custoAquisicaoOrigemNacionalDolar.operacao('+', custoAquisicaoOrigemMEDolar));
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.getOrigemRendimentos().naoFormatado())) {
            this.getPercentualCustoAquisicaoOrigemNacional().setConteudo("100,00");
            this.getPercentualCustoAquisicaoOrigemME().clear();
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.getOrigemRendimentos().naoFormatado())) {
            this.getPercentualCustoAquisicaoOrigemNacional().clear();
            this.getPercentualCustoAquisicaoOrigemME().setConteudo("100,00");
        } else if (this.getCustoAquisicaoTotalDolar().comparacao(">", "0,00")) {
            ValorPositivo percentualAquisicaoMN = new ValorPositivo(null, "percentualAquisicaoMN", 3, 9);
            percentualAquisicaoMN.setConteudo(custoAquisicaoOrigemNacionalDolar.formatado());
            percentualAquisicaoMN.append('*', "100,000");
            percentualAquisicaoMN.append('/', this.getCustoAquisicaoTotalDolar().formatado());
            Valor percentualAquisicaoMNArredondado = new Valor(null, "percentualAquisicaoMNArredondado", 3, 9);
            percentualAquisicaoMNArredondado.setConteudo(percentualAquisicaoMN.formatado());
            this.getPercentualCustoAquisicaoOrigemNacional().setConteudo(percentualAquisicaoMNArredondado.formatado());
            this.getPercentualCustoAquisicaoOrigemME().setConteudo(new ValorPositivo("100,00").operacao('-', this.getPercentualCustoAquisicaoOrigemNacional()));
        } else {
            this.getPercentualCustoAquisicaoOrigemNacional().clear();
            this.getPercentualCustoAquisicaoOrigemME().clear();
        }
    }

    @Override
    public List<Informacao> recuperarListaCamposPendenciaAbaIdentificacao() {
        List<Informacao> lista = super.recuperarListaCamposPendenciaAbaIdentificacao();
        lista.add((Informacao)this.getHouveReforma());
        lista.add((Informacao)this.getBemAtualizado());
        lista.add((Informacao)this.getValorDTA());
        lista.add((Informacao)this.getDataDTA());
        return lista;
    }

    public Logico getHouveReforma() {
        return this.houveReforma;
    }

    public ColecaoParcelaAquisicao getParcelasAquisicao() {
        return this.parcelasAquisicao;
    }

    public Alfa getHouveReformaAux() {
        return this.houveReformaAux;
    }

    public boolean houveReforma() {
        return Logico.SIM.equals(this.getHouveReforma().naoFormatado());
    }

    public boolean bemAtualizado() {
        return Logico.SIM.equals(this.getBemAtualizado().naoFormatado());
    }

    public boolean naoHouveReforma() {
        return Logico.NAO.equals(this.getHouveReforma().naoFormatado());
    }

    public ValorPositivo getCustoAquisicaoTorna() {
        return this.custoAquisicaoTorna;
    }

    public ValorPositivo getCustoAquisicaoTornaOrigemMNDolar() {
        return this.custoAquisicaoTornaOrigemMNDolar;
    }

    public ValorPositivo getCustoAquisicaoTornaOrigemMNReal() {
        return this.custoAquisicaoTornaOrigemMNReal;
    }

    public ValorPositivo getCustoAquisicaoTornaOrigemMEDolar() {
        return this.custoAquisicaoTornaOrigemMEDolar;
    }

    public Logico getBemAtualizado() {
        return this.bemAtualizado;
    }

    public ValorPositivo getValorDTA() {
        return this.valorDTA;
    }

    public Data getDataDTA() {
        return this.dataDTA;
    }
}

