/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.aquisicao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.aquisicao.ParcelaAquisicao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoParcelaAquisicao
extends Colecao<ParcelaAquisicao> {
    private ValorPositivo totalCustoAquisicao = new ValorPositivo((ObjetoNegocio)this, "Custo de Aquisi\u00e7\u00e3o (R$)");
    private ValorPositivo totalCustoAquisicaoOrigemMNDolar = new ValorPositivo((ObjetoNegocio)this, "Custo de aquisi\u00e7\u00e3o (XX$)");
    private ValorPositivo totalCustoAquisicaoOrigemMNReal = new ValorPositivo((ObjetoNegocio)this, "Custo de aquisi\u00e7\u00e3o (R$)");
    private ValorPositivo totalCustoAquisicaoOrigemMEDolar = new ValorPositivo((ObjetoNegocio)this, "Custo de aquisi\u00e7\u00e3o (US$)");
    private ValorPositivo totalCustoAquisicaoDolar = new ValorPositivo((ObjetoNegocio)this, "Custo de aquisi\u00e7\u00e3o total (XX$)");
    private ValorPositivo percentualCustoAquisicaoOrigemNacional = new ValorPositivo((ObjetoNegocio)this, "Percentual do custo de Aquisi\u00e7\u00e3o - Origem moeda nacional", 3, 9);
    private ValorPositivo percentualCustoAquisicaoOrigemME = new ValorPositivo((ObjetoNegocio)this, "Percentual do custo de Aquisi\u00e7\u00e3o - Origem moeda estrangeira", 3, 9);
    private static boolean modoEdicao = false;
    private Observador obsCalculoTotais = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            ColecaoParcelaAquisicao.this.calcularTotais();
        }
    };

    public ColecaoParcelaAquisicao() {
        super(ParcelaAlienacao.class.getName());
        this.totalCustoAquisicao.setReadOnly(true);
        this.totalCustoAquisicaoOrigemMNDolar.setReadOnly(true);
        this.totalCustoAquisicaoOrigemMNReal.setReadOnly(true);
        this.totalCustoAquisicaoOrigemMEDolar.setReadOnly(true);
        this.totalCustoAquisicaoDolar.setReadOnly(true);
    }

    public ParcelaAquisicao instanciaNovoObjeto() {
        ParcelaAquisicao parcela = null;
        parcela = this.isModoEdicao() ? new ParcelaAquisicao(this.itens().size()) : new ParcelaAquisicao();
        return parcela;
    }

    public ParcelaAquisicao novaParcelaEdicao() {
        ParcelaAquisicao parcela = null;
        ColecaoParcelaAquisicao.setModoEdicao(true);
        parcela = this.instanciaNovoObjeto();
        this.itens().add(parcela);
        ColecaoParcelaAquisicao.setModoEdicao(false);
        return parcela;
    }

    public void calcularTotais() {
        ValorPositivo lTotalCustoAquisicao = new ValorPositivo();
        ValorPositivo lTotalCustoAquisicaoOrigemMNDolar = new ValorPositivo();
        ValorPositivo lTotalCustoAquisicaoOrigemMNReal = new ValorPositivo();
        ValorPositivo lTotalCustoAquisicaoOrigemMEDolar = new ValorPositivo();
        ValorPositivo lTotalCustoAquisicaoDolar = new ValorPositivo();
        for (ParcelaAquisicao parcela : this.itens()) {
            parcela.getCustoAquisicaoOrigemNacionalReal().setConteudo(parcela.getCustoAquisicaoOrigemNacionalDolar().operacao('*', parcela.getCotacaoDolar()));
            parcela.getCustoAquisicaoTotalDolar().setConteudo(parcela.getCustoAquisicaoOrigemNacionalDolar().operacao('+', parcela.getCustoAquisicaoOrigemMEDolar()));
            lTotalCustoAquisicao.append('+', parcela.getCustoAquisicao());
            lTotalCustoAquisicaoOrigemMNDolar.append('+', parcela.getCustoAquisicaoOrigemNacionalDolar());
            lTotalCustoAquisicaoOrigemMNReal.append('+', parcela.getCustoAquisicaoOrigemNacionalReal());
            lTotalCustoAquisicaoOrigemMEDolar.append('+', parcela.getCustoAquisicaoOrigemMEDolar());
            lTotalCustoAquisicaoDolar.append('+', parcela.getCustoAquisicaoTotalDolar());
        }
        for (ParcelaAquisicao parcela : this.itens()) {
            ValorPositivo lPercentualCustoTotal = new ValorPositivo(null, "", 11, 9);
            if (lTotalCustoAquisicao.comparacao(">", "0,00")) {
                lPercentualCustoTotal.append('+', parcela.getCustoAquisicao());
                lPercentualCustoTotal.append('*', "100,00");
                lPercentualCustoTotal.append('/', lTotalCustoAquisicao);
                lPercentualCustoTotal.converteQtdCasasDecimais(6);
            }
            parcela.getPercentualCustoTotal().setConteudo(lPercentualCustoTotal);
            lPercentualCustoTotal = new ValorPositivo(null, "", 11, 9);
            if (lTotalCustoAquisicaoOrigemMNReal.comparacao(">", "0,00")) {
                lPercentualCustoTotal.append('+', parcela.getCustoAquisicaoOrigemNacionalReal());
                lPercentualCustoTotal.append('*', "100,00");
                lPercentualCustoTotal.append('/', lTotalCustoAquisicaoOrigemMNReal);
                lPercentualCustoTotal.converteQtdCasasDecimais(6);
            }
            parcela.getPercentualCustoTotalReal().setConteudo(lPercentualCustoTotal);
            lPercentualCustoTotal = new ValorPositivo(null, "", 11, 9);
            if (lTotalCustoAquisicaoOrigemMEDolar.comparacao(">", "0,00")) {
                lPercentualCustoTotal.append('+', parcela.getCustoAquisicaoOrigemMEDolar());
                lPercentualCustoTotal.append('*', "100,00");
                lPercentualCustoTotal.append('/', lTotalCustoAquisicaoOrigemMEDolar);
                lPercentualCustoTotal.converteQtdCasasDecimais(6);
            }
            parcela.getPercentualCustoTotalDolar().setConteudo(lPercentualCustoTotal);
        }
        this.getTotalCustoAquisicao().setConteudo(lTotalCustoAquisicao);
        this.getTotalCustoAquisicaoOrigemMNDolar().setConteudo(lTotalCustoAquisicaoOrigemMNDolar);
        this.getTotalCustoAquisicaoOrigemMNReal().setConteudo(lTotalCustoAquisicaoOrigemMNReal);
        this.getTotalCustoAquisicaoOrigemMEDolar().setConteudo(lTotalCustoAquisicaoOrigemMEDolar);
        this.getTotalCustoAquisicaoDolar().setConteudo(lTotalCustoAquisicaoDolar);
        if (lTotalCustoAquisicaoDolar.comparacao(">", "0,00")) {
            ValorPositivo percentualAquisicaoMN = new ValorPositivo(null, "percentualAquisicaoMN", 3, 9);
            percentualAquisicaoMN.setConteudo(lTotalCustoAquisicaoOrigemMNDolar.formatado());
            percentualAquisicaoMN.append('*', "100,000");
            percentualAquisicaoMN.append('/', lTotalCustoAquisicaoDolar.formatado());
            Valor percentualAquisicaoMNArredondado = new Valor(null, "percentualAquisicaoMNArredondado", 3, 9);
            percentualAquisicaoMNArredondado.setConteudo(percentualAquisicaoMN.formatado());
            this.getPercentualCustoAquisicaoOrigemNacional().setConteudo(percentualAquisicaoMNArredondado.formatado());
            this.getPercentualCustoAquisicaoOrigemME().setConteudo(new ValorPositivo("100,00").operacao('-', this.getPercentualCustoAquisicaoOrigemNacional()));
        } else {
            this.getPercentualCustoAquisicaoOrigemNacional().clear();
            this.getPercentualCustoAquisicaoOrigemME().clear();
        }
    }

    public void atualizarIndices() {
        for (int i = 0; i < this.itens().size(); ++i) {
            ((ParcelaAquisicao)((Object)this.itens().get(i))).getIndice().setConteudo(i);
        }
    }

    public void objetoInserido(ParcelaAquisicao parcela) {
        parcela.getCustoAquisicao().addObservador(this.obsCalculoTotais);
        parcela.getCustoAquisicaoOrigemNacionalDolar().addObservador(this.obsCalculoTotais);
        parcela.getCustoAquisicaoOrigemMEDolar().addObservador(this.obsCalculoTotais);
        parcela.getCotacaoDolar().addObservador(this.obsCalculoTotais);
        this.calcularTotais();
    }

    public void objetoRemovido(Object o) {
        ParcelaAquisicao parcela = (ParcelaAquisicao)((Object)o);
        parcela.getCustoAquisicao().removeObservador(this.obsCalculoTotais);
        parcela.getCustoAquisicaoOrigemNacionalDolar().removeObservador(this.obsCalculoTotais);
        parcela.getCustoAquisicaoOrigemMEDolar().removeObservador(this.obsCalculoTotais);
        parcela.getCotacaoDolar().removeObservador(this.obsCalculoTotais);
        this.atualizarIndices();
        this.calcularTotais();
    }

    public ValorPositivo getTotalCustoAquisicao() {
        return this.totalCustoAquisicao;
    }

    public ValorPositivo getTotalCustoAquisicaoOrigemMNDolar() {
        return this.totalCustoAquisicaoOrigemMNDolar;
    }

    public ValorPositivo getTotalCustoAquisicaoOrigemMNReal() {
        return this.totalCustoAquisicaoOrigemMNReal;
    }

    public ValorPositivo getTotalCustoAquisicaoOrigemMEDolar() {
        return this.totalCustoAquisicaoOrigemMEDolar;
    }

    public ValorPositivo getTotalCustoAquisicaoDolar() {
        return this.totalCustoAquisicaoDolar;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemNacional() {
        return this.percentualCustoAquisicaoOrigemNacional;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemME() {
        return this.percentualCustoAquisicaoOrigemME;
    }

    public boolean isModoEdicao() {
        return modoEdicao;
    }

    public static void setModoEdicao(boolean emModoEdicao) {
        modoEdicao = emModoEdicao;
    }

    public ValorPositivo calcularDolarMedio() {
        ValorPositivo cotacao = new ValorPositivo(null, "cotacao", 11, 4);
        if (!this.getTotalCustoAquisicaoOrigemMNDolar().isVazio()) {
            cotacao.setConteudo(this.getTotalCustoAquisicaoOrigemMNReal());
            cotacao.append('/', this.getTotalCustoAquisicaoOrigemMNDolar());
        }
        return cotacao;
    }
}

