/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.calculo;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.util.MensagemUtil;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ValidadorCorretagemTotalExcedida
extends ValidadorNaoNulo {
    private String prefixoMoeda;
    private ValorPositivo corretagemParcelas;
    private ValorPositivo corretagemAnosAnteriores;
    private ValorPositivo corretagemTotal;
    private Logico aPrazo;

    public ValidadorCorretagemTotalExcedida(String prefixoMoeda, ValorPositivo corretagemParcelas, ValorPositivo corretagemAnosAnteriores, ValorPositivo corretagemTotal, Logico aPrazo) {
        super((byte)3);
        this.prefixoMoeda = prefixoMoeda;
        this.corretagemParcelas = corretagemParcelas;
        this.corretagemAnosAnteriores = corretagemAnosAnteriores;
        this.corretagemTotal = corretagemTotal;
        this.aPrazo = aPrazo;
    }

    public RetornoValidacao validarImplementado() {
        ValorPositivo corretagemUtilizada = new ValorPositivo();
        corretagemUtilizada.setConteudo(this.corretagemParcelas.naoFormatado());
        if (this.corretagemAnosAnteriores != null) {
            corretagemUtilizada.append('+', this.corretagemAnosAnteriores.naoFormatado());
        }
        if (corretagemUtilizada.comparacao(">", this.corretagemTotal) && Logico.SIM.equals(this.aPrazo.naoFormatado())) {
            return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("limiteCorretagemExcedido", new String[]{this.prefixoMoeda + " " + corretagemUtilizada.formatado(), this.prefixoMoeda + " " + this.corretagemTotal.formatado()}));
        }
        return new RetornoValidacao(0);
    }
}

