/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.consolidacao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class Consolidacao
extends ObjetoNegocio
implements ObjetoFicha {
    public static String CAMPO_IMPOSTO_DIFERIDO_ANOS_ANTERIORES = "Diferido de anos anteriores - (R$)";
    public static String CAMPO_REFERENTE_ALIENACAO_ANO_ATUAL = "Referente \u00e0\u00a0 aliena\u00e7\u00e3o em " + AplicacaoPropertiesUtil.getExercicio() + " - (R$)";
    public static String CAMPO_IMPOSTO_TOTAL = "Total - (R$)";
    public static String CAMPO_VALOR_IRF = "IR na fonte (Lei 11.033/2004) - (R$)";
    public static String CAMPO_IMPOSTO_DEVIDO_ANO_ATUAL = "Devido em " + AplicacaoPropertiesUtil.getExercicio() + " -  (R$)";
    public static String CAMPO_IMPOSTO_DIFERIDO_ANOS_POSTERIORES = "Diferido para anos posteriores - (R$)";
    public static String CAMPO_TOTAL_IMPOSTO_PAGO = "Imposto Pago - Total-(R$)";
    public static String CAMPO_REND_ISENTOS_NAO_TRIBUTAVEIS = "Rendimentos Isentos e N\u00e3o Tributaveis - Total - (R$)";
    public static String CAMPO_REND_SUJEITO_TRIBUTACAO_EXCLUSIVA = "Rendimentos Sujeitos a\u00a0 Tributa\u00e7\u00e3o Definitiva - Total -(R$)";
    private ValorPositivo impostoDiferidoAnosAnteriores = new ValorPositivo(this, CAMPO_IMPOSTO_DIFERIDO_ANOS_ANTERIORES);
    private ValorPositivo impostoReferenteAlienacaoAnoAtual = new ValorPositivo(this, CAMPO_REFERENTE_ALIENACAO_ANO_ATUAL);
    private ValorPositivo impostoTotal = new ValorPositivo(this, CAMPO_IMPOSTO_TOTAL);
    private ValorPositivo valorIRF = new ValorPositivo(this, CAMPO_VALOR_IRF);
    private ValorPositivo impostoDevidoAnoAtual = new ValorPositivo(this, CAMPO_IMPOSTO_DEVIDO_ANO_ATUAL);
    private ValorPositivo impostoDiferidoAnosPosteriores = new ValorPositivo(this, CAMPO_IMPOSTO_DIFERIDO_ANOS_POSTERIORES);
    private ValorPositivo totalImpostoPago = new ValorPositivo(this, CAMPO_TOTAL_IMPOSTO_PAGO);
    private ValorPositivo totalRendIsentosNaoTributaveis = new ValorPositivo(this, CAMPO_REND_ISENTOS_NAO_TRIBUTAVEIS);
    private ValorPositivo totalRendSujeitosTributacao = new ValorPositivo(this, CAMPO_REND_SUJEITO_TRIBUTACAO_EXCLUSIVA);

    public Consolidacao() {
        this.impostoDiferidoAnosAnteriores.setReadOnly(true);
        this.impostoReferenteAlienacaoAnoAtual.setReadOnly(true);
        this.impostoTotal.setReadOnly(true);
        this.valorIRF.setReadOnly(true);
        this.impostoDevidoAnoAtual.setReadOnly(true);
        this.impostoDiferidoAnosPosteriores.setReadOnly(true);
        this.totalImpostoPago.setReadOnly(true);
        this.totalRendIsentosNaoTributaveis.setReadOnly(true);
        this.totalRendSujeitosTributacao.setReadOnly(true);
        this.adicionarObservadoresConsolidacao();
    }

    private void adicionarObservadoresConsolidacao() {
        this.impostoDiferidoAnosAnteriores.addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                Consolidacao.this.impostoTotal.setConteudo(Consolidacao.this.impostoDiferidoAnosAnteriores.operacao('+', Consolidacao.this.impostoReferenteAlienacaoAnoAtual));
            }
        });
        this.impostoReferenteAlienacaoAnoAtual.addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                Consolidacao.this.impostoTotal.setConteudo(Consolidacao.this.impostoDiferidoAnosAnteriores.operacao('+', Consolidacao.this.impostoReferenteAlienacaoAnoAtual));
            }
        });
    }

    public String getClasseFicha() {
        return null;
    }

    public String getNomeAba() {
        return null;
    }

    public ValorPositivo getImpostoDiferidoAnosAnteriores() {
        return this.impostoDiferidoAnosAnteriores;
    }

    public ValorPositivo getImpostoReferenteAlienacaoAnoAtual() {
        return this.impostoReferenteAlienacaoAnoAtual;
    }

    public ValorPositivo getImpostoTotal() {
        return this.impostoTotal;
    }

    public ValorPositivo getValorIRF() {
        return this.valorIRF;
    }

    public ValorPositivo getImpostoDevidoAnoAtual() {
        return this.impostoDevidoAnoAtual;
    }

    public ValorPositivo getImpostoDiferidoAnosPosteriores() {
        return this.impostoDiferidoAnosPosteriores;
    }

    public ValorPositivo getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public ValorPositivo getTotalRendIsentosNaoTributaveis() {
        return this.totalRendIsentosNaoTributaveis;
    }

    public ValorPositivo getTotalRendSujeitosTributacao() {
        return this.totalRendSujeitosTributacao;
    }

    public void resetConsolidacao() {
        this.impostoDiferidoAnosAnteriores.clear();
        this.impostoReferenteAlienacaoAnoAtual.clear();
        this.impostoTotal.clear();
        this.valorIRF.clear();
        this.impostoDevidoAnoAtual.clear();
        this.impostoDiferidoAnosPosteriores.clear();
        this.totalImpostoPago.clear();
        this.totalRendIsentosNaoTributaveis.clear();
        this.totalRendSujeitosTributacao.clear();
    }

    public void calcularConsolidacaoImovel(AlienacaoBemImovel alienacao) {
        if (alienacao.isAlienacaoBrasil()) {
            if (alienacao.isAlienacaoAVista()) {
                this.calcularConsolidacaoImovelBrasilAVista(alienacao);
            } else if (alienacao.isAlienacaoAPrazo()) {
                if (alienacao.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
                    if (AplicacaoPropertiesUtil.getExercicio().equals(alienacao.getDataAlienacao().getAno())) {
                        this.calcularConsolidacaoImovelBrasilAPrazo(alienacao);
                    } else {
                        this.calcularConsolidacaoImovelBrasilAPrazoExercicioAnterior(alienacao);
                    }
                } else {
                    alienacao.getConsolidacao().clear();
                }
            }
        } else if (alienacao.isAlienacaoAVista()) {
            this.calcularConsolidacaoImovelExteriorAVista(alienacao);
        } else if (alienacao.isAlienacaoAPrazo()) {
            if (alienacao.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
                if (AplicacaoPropertiesUtil.getExercicio().equals(alienacao.getDataAlienacao().getAno())) {
                    this.calcularConsolidacaoImovelExteriorAPrazo(alienacao);
                } else {
                    this.calcularConsolidacaoImovelExteriorAPrazoExercicioAnterior(alienacao);
                }
            } else {
                alienacao.getConsolidacao().clear();
            }
        }
    }

    private void calcularConsolidacaoImovelBrasilAVista(AlienacaoBemImovel alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(true);
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().clear();
        if (alienacao.isIsento()) {
            alienacao.getConsolidacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(this.valorIsencaoDevidoReducoesBrasil(alienacao));
        } else {
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(this.valorIsencaoDevidoReducoesBrasil(alienacao));
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido2());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
            alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getCalculoImposto().getImpostoPago());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal().operacao('-', alienacao.getConsolidacao().getTotalImpostoPago()));
        }
    }

    private void calcularConsolidacaoImovelBrasilAPrazo(AlienacaoBemImovel alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(true);
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().clear();
        if (alienacao.isIsento()) {
            alienacao.getConsolidacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(this.valorIsencaoDevidoReducoesBrasil(alienacao));
        } else {
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido2());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioImpostoDevidoNoExercicio());
            if (alienacao.getDataRecebimentoUltimaParcela().isVazio()) {
                alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(alienacao.getConsolidacao().getImpostoTotal().operacao('-', alienacao.getConsolidacao().getImpostoDevidoAnoAtual()));
            } else {
                alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
            }
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(this.valorIsencaoDevidoReducoesBrasil(alienacao));
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal().operacao('-', alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal()));
        }
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
    }

    private void calcularConsolidacaoImovelBrasilAPrazoExercicioAnterior(AlienacaoBemImovel alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(false);
        alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().clear();
        alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
        alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioImpostoDevidoNoExercicio());
        if (alienacao.getDataRecebimentoUltimaParcela().isVazio()) {
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(alienacao.getConsolidacao().getImpostoTotal().operacao('-', alienacao.getConsolidacao().getImpostoDevidoAnoAtual()));
        } else {
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
        }
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
        alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
        alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
    }

    private void calcularConsolidacaoImovelExteriorAVista(AlienacaoBemImovel alienacao) {
        ValorPositivo impostoPago = new ValorPositivo(null, "impostoPago", 11, 2);
        ValorPositivo rendIsentos = new ValorPositivo(null, "rendIsentos", 11, 2);
        ValorPositivo rendExclusivos = new ValorPositivo(null, "rendExclusivos", 11, 2);
        impostoPago.setConteudo(alienacao.getCalculoImposto().getImpostoPago());
        impostoPago.append('+', alienacao.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao());
        rendIsentos.setConteudo(this.valorIsencaoDevidoReducoesExterior(alienacao));
        if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL)) {
            rendExclusivos.setConteudo(alienacao.getApuracao().getGanhoCapital5OrigemMNReal());
        } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA)) {
            rendExclusivos.setConteudo(alienacao.getApuracao().getGanhoCapital5OrigemMEReal());
        } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) {
            rendExclusivos.setConteudo(alienacao.getApuracao().getGanhoCapital5OrigemMNReal());
            rendExclusivos.append('+', alienacao.getApuracao().getGanhoCapital5OrigemMEReal());
        }
        rendExclusivos.append('-', alienacao.getCalculoImposto().getImpostoPago());
        rendExclusivos.append('-', alienacao.getValorImpostoExteriorReal());
        alienacao.getConsolidacao().clear();
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(impostoPago);
        alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(rendExclusivos);
        alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(this.valorIsencaoDevidoReducoesExterior(alienacao));
    }

    private void calcularConsolidacaoImovelExteriorAPrazo(AlienacaoBemImovel alienacao) {
        ValorPositivo impostoPago = new ValorPositivo(null, "impostoPago", 11, 2);
        ValorPositivo rendIsentos = new ValorPositivo(null, "rendIsentos", 11, 2);
        ValorPositivo rendExclusivos = new ValorPositivo(null, "rendExclusivos", 11, 2);
        ValorPositivo ganhoCapital1 = new ValorPositivo(null, "ganhoCapital1", 11, 2);
        boolean mudouEnquadramento = alienacao.mudouEnquadramento();
        boolean lucroReduzido = alienacao.isAlienacaoComLucroReduzido();
        impostoPago.setConteudo(alienacao.getColecaoParcelaAlienacao().obterImpostoPagoTotalNoExercicio());
        impostoPago.append('+', alienacao.getValorImpostoExteriorReal());
        if (lucroReduzido) {
            rendIsentos.setConteudo(this.obterRendIsentosApuracaoFinalImovelExterior(alienacao));
        } else if (mudouEnquadramento) {
            rendIsentos.setConteudo(this.obterRendIsentosNoExercicioParaImovelExteriorComMudancaEnquadramento(alienacao));
        } else {
            rendIsentos.setConteudo(this.valorReducoesPrazoExteriorNoExercicio(alienacao));
        }
        ganhoCapital1.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNNoExercicio());
        ganhoCapital1.append('+', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MENoExercicio());
        if (ganhoCapital1.comparacao("=", rendIsentos)) {
            rendExclusivos.clear();
        } else if (lucroReduzido) {
            rendExclusivos.setConteudo(this.obterRendSujeitosTributacaoApuracaoFinalImovelExterior(alienacao));
            rendExclusivos.append('-', impostoPago);
        } else if (mudouEnquadramento) {
            rendExclusivos.setConteudo(this.obterRendExclusivosNoExercicioParaImovelExteriorComMudancaEnquadramento(alienacao));
        } else {
            if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL)) {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MNNoExercicio());
            } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA)) {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MENoExercicio());
            } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MNNoExercicio());
                rendExclusivos.append('+', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MENoExercicio());
            }
            rendExclusivos.append('-', impostoPago);
        }
        alienacao.getConsolidacao().clear();
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(impostoPago);
        if (alienacao.isPrejuizo()) {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
        } else {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(rendExclusivos);
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(rendIsentos);
        }
    }

    private void calcularConsolidacaoImovelExteriorAPrazoExercicioAnterior(AlienacaoBemImovel alienacao) {
        ValorPositivo impostoPago = new ValorPositivo(null, "impostoPago", 11, 2);
        ValorPositivo rendIsentos = new ValorPositivo(null, "rendIsentos", 11, 2);
        ValorPositivo rendExclusivos = new ValorPositivo(null, "rendExclusivos", 11, 2);
        ValorPositivo ganhoCapital1 = new ValorPositivo(null, "ganhoCapital1", 11, 2);
        boolean mudouEnquadramento = alienacao.mudouEnquadramento();
        boolean lucroReduzido = alienacao.isAlienacaoComLucroReduzido();
        impostoPago.setConteudo(alienacao.getColecaoParcelaAlienacao().obterImpostoPagoTotalNoExercicio());
        if (lucroReduzido) {
            rendIsentos.setConteudo(this.obterRendIsentosApuracaoFinalImovelExterior(alienacao));
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMNForaDoExercicio());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMEForaDoExercicio());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMNForaDoExercicio());
                rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMEForaDoExercicio());
            }
        } else if (mudouEnquadramento) {
            rendIsentos.setConteudo(this.obterRendIsentosNoExercicioParaImovelExteriorComMudancaEnquadramento(alienacao));
        } else {
            rendIsentos.setConteudo(this.valorReducoesPrazoExteriorNoExercicio(alienacao));
        }
        ganhoCapital1.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNNoExercicio());
        ganhoCapital1.append('+', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MENoExercicio());
        if (ganhoCapital1.comparacao("=", rendIsentos)) {
            rendExclusivos.clear();
        } else if (lucroReduzido) {
            rendExclusivos.setConteudo(this.obterRendSujeitosTributacaoApuracaoFinalImovelExterior(alienacao));
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MNForaDoExercicio());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MEForaDoExercicio());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MNForaDoExercicio());
                rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MEForaDoExercicio());
            }
            rendExclusivos.append('-', impostoPago);
        } else if (mudouEnquadramento) {
            rendExclusivos.setConteudo(this.obterRendExclusivosNoExercicioParaImovelExteriorComMudancaEnquadramento(alienacao));
        } else {
            if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL)) {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MNNoExercicio());
            } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA)) {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MENoExercicio());
            } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MNNoExercicio());
                rendExclusivos.append('+', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital5MENoExercicio());
            }
            rendExclusivos.append('-', impostoPago);
        }
        alienacao.getConsolidacao().clear();
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(impostoPago);
        if (alienacao.isPrejuizo()) {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
        } else {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(rendExclusivos);
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(rendIsentos);
        }
    }

    private ValorPositivo obterRendIsentosNoExercicioParaImovelExteriorComMudancaEnquadramento(AlienacaoBemImovel alienacao) {
        int enquadramento = alienacao.obterEnquadramentoAtual();
        ValorPositivo rendIsentos = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.append('+', parcela.getValorReducaoLei7713MN());
                rendIsentos.append('+', parcela.getValorReducaoLei11196FR1MN());
                rendIsentos.append('+', parcela.getValorReducaoLei11196FR2MN());
                if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                    rendIsentos.append('+', parcela.getGanhoCapital4ProporcionalMN());
                    continue;
                }
                rendIsentos.append('+', parcela.getValorReducaoAplicacaoOutroImovelMN());
                continue;
            }
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.append('+', parcela.getValorReducaoLei7713ME());
                rendIsentos.append('+', parcela.getValorReducaoLei11196FR1ME());
                rendIsentos.append('+', parcela.getValorReducaoLei11196FR2ME());
                if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                    rendIsentos.append('+', parcela.getGanhoCapital4ProporcionalME());
                    continue;
                }
                rendIsentos.append('+', parcela.getValorReducaoAplicacaoOutroImovelME());
                continue;
            }
            if (!Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) continue;
            rendIsentos.append('+', parcela.getValorReducaoLei7713MN());
            rendIsentos.append('+', parcela.getValorReducaoLei11196FR1MN());
            rendIsentos.append('+', parcela.getValorReducaoLei11196FR2MN());
            if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                rendIsentos.append('+', parcela.getGanhoCapital4ProporcionalMN());
            } else {
                rendIsentos.append('+', parcela.getValorReducaoAplicacaoOutroImovelMN());
            }
            rendIsentos.append('+', parcela.getValorReducaoLei7713ME());
            rendIsentos.append('+', parcela.getValorReducaoLei11196FR1ME());
            rendIsentos.append('+', parcela.getValorReducaoLei11196FR2ME());
            if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                rendIsentos.append('+', parcela.getGanhoCapital4ProporcionalME());
                continue;
            }
            rendIsentos.append('+', parcela.getValorReducaoAplicacaoOutroImovelME());
        }
        return rendIsentos;
    }

    private ValorPositivo obterRendExclusivosNoExercicioParaImovelExteriorComMudancaEnquadramento(AlienacaoBemImovel alienacao) {
        ValorPositivo rendExclusivos = new ValorPositivo();
        ValorPositivo liquidoTotalReal = new ValorPositivo();
        ValorPositivo liquidoNoAnoReal = new ValorPositivo();
        ValorPositivo liquidoParcela = new ValorPositivo();
        ValorPositivo ganho5 = new ValorPositivo();
        for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
            liquidoParcela.setConteudo(parcela.getValorRecebidoDolar());
            liquidoParcela.append('+', parcela.getValorRecebidoDolar());
            liquidoTotalReal.append('+', liquidoParcela.naoFormatado());
            if (parcela.getDataRecebimento().isVazio() || !AplicacaoPropertiesUtil.getExercicio().equals(parcela.getDataRecebimento().getAno())) continue;
            liquidoNoAnoReal.append('+', liquidoParcela.naoFormatado());
        }
        ganho5.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
        ganho5.append('+', alienacao.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
        if (!ganho5.isVazio()) {
            rendExclusivos.setConteudo(liquidoNoAnoReal);
            rendExclusivos.append('*', ganho5.naoFormatado());
            rendExclusivos.append('/', liquidoTotalReal.naoFormatado());
            rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterImpostoPagoTotalNoExercicio());
            rendExclusivos.append('-', alienacao.getValorImpostoExteriorReal());
        }
        return rendExclusivos;
    }

    public ValorPositivo obterRendIsentosApuracaoFinalImovelExterior(AlienacaoBemImovel alienacao) {
        ValorPositivo rendIsentos = new ValorPositivo();
        int enquadramento = alienacao.obterEnquadramentoAtual();
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei7713OrigemMN());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN());
            if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
            } else {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN());
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei7713OrigemME());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME());
            if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
            } else {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME());
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei7713OrigemMN());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR1OrigemMN());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR2OrigemMN());
            if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getGanhoCapital4OrigemMNReal());
            } else {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN());
            }
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei7713OrigemME());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR1OrigemME());
            rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoLei11196FR2OrigemME());
            if (enquadramento == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR || enquadramento == AlienacaoBemImovel.REDUCAO_UNICO_IMOVEL) {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getGanhoCapital4OrigemMEReal());
            } else {
                rendIsentos.append('+', alienacao.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME());
            }
        }
        return rendIsentos;
    }

    public ValorPositivo obterRendSujeitosTributacaoApuracaoFinalImovelExterior(AlienacaoBemImovel alienacao) {
        ValorPositivo rendExclusivos = new ValorPositivo();
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
            rendExclusivos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
            rendExclusivos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
            rendExclusivos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
            rendExclusivos.append('+', alienacao.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
        }
        return rendExclusivos;
    }

    public ValorPositivo obterRendIsentosApuracaoFinalMovelExterior(AlienacaoBemMovel alienacao) {
        ValorPositivo rendIsentos = new ValorPositivo();
        if (alienacao.isIsento()) {
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendIsentos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
                rendIsentos.append('+', alienacao.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            }
        }
        return rendIsentos;
    }

    public ValorPositivo obterRendSujeitosTributacaoApuracaoFinalMovelExterior(AlienacaoBemMovel alienacao) {
        ValorPositivo rendExclusivos = new ValorPositivo();
        if (!alienacao.isIsento()) {
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendExclusivos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendExclusivos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                rendExclusivos.setConteudo(alienacao.getApuracaoFinal().getGanhoCapital1OrigemNacionalReal());
                rendExclusivos.append('+', alienacao.getApuracaoFinal().getGanhoCapital1OrigemMEReal());
            }
        }
        return rendExclusivos;
    }

    private ValorPositivo valorIsencaoDevidoReducoesBrasil(AlienacaoBemImovel alienacao) {
        ValorPositivo valorIsencaoDevidoReducoes = new ValorPositivo();
        valorIsencaoDevidoReducoes.clear();
        valorIsencaoDevidoReducoes.append('+', alienacao.getApuracao().getGanhoCapital1());
        valorIsencaoDevidoReducoes.append('-', alienacao.getApuracao().getGanhoCapital5());
        return valorIsencaoDevidoReducoes;
    }

    private ValorPositivo valorIsencaoDevidoReducoesExterior(AlienacaoBemImovel alienacao) {
        ValorPositivo valorIsencaoDevidoReducoes = new ValorPositivo();
        valorIsencaoDevidoReducoes.clear();
        if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL)) {
            valorIsencaoDevidoReducoes.append('+', alienacao.getApuracao().getGanhoCapital1OrigemNacionalReal());
            valorIsencaoDevidoReducoes.append('-', alienacao.getApuracao().getGanhoCapital5OrigemMNReal());
        } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA)) {
            valorIsencaoDevidoReducoes.append('+', alienacao.getApuracao().getGanhoCapital1OrigemMEReal());
            valorIsencaoDevidoReducoes.append('-', alienacao.getApuracao().getGanhoCapital5OrigemMEReal());
        } else if (alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) {
            valorIsencaoDevidoReducoes.append('+', alienacao.getApuracao().getGanhoCapital1OrigemNacionalReal());
            valorIsencaoDevidoReducoes.append('+', alienacao.getApuracao().getGanhoCapital1OrigemMEReal());
            valorIsencaoDevidoReducoes.append('-', alienacao.getApuracao().getGanhoCapital5OrigemMNReal());
            valorIsencaoDevidoReducoes.append('-', alienacao.getApuracao().getGanhoCapital5OrigemMEReal());
        }
        return valorIsencaoDevidoReducoes;
    }

    private ValorPositivo valorReducoesPrazoExteriorNoExercicio(AlienacaoBem alienacao) {
        AlienacaoBemImovel imovel = (AlienacaoBemImovel)alienacao;
        ValorPositivo valorIsencaoDevidoReducoes = new ValorPositivo();
        valorIsencaoDevidoReducoes.clear();
        if (imovel.isIsento()) {
            valorIsencaoDevidoReducoes.setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNNoExercicio());
            valorIsencaoDevidoReducoes.append('+', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MENoExercicio());
        } else if (imovel.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL)) {
            valorIsencaoDevidoReducoes.setConteudo(imovel.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMNNoExercicio());
        } else if (imovel.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA)) {
            valorIsencaoDevidoReducoes.setConteudo(imovel.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMENoExercicio());
        } else if (imovel.getBemImovel().getAquisicao().getOrigemRendimentos().formatado().equals(Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA)) {
            valorIsencaoDevidoReducoes.setConteudo(imovel.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMNNoExercicio());
            valorIsencaoDevidoReducoes.append('+', imovel.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMENoExercicio());
        }
        return valorIsencaoDevidoReducoes;
    }

    public void calcularConsolidacaoMovel(AlienacaoBemMovel alienacao) {
        if (alienacao.isAlienacaoBrasil()) {
            if (alienacao.isAlienacaoAVista()) {
                this.calcularConsolidacaoMovelBrasilAVista(alienacao);
            } else if (alienacao.isAlienacaoAPrazo()) {
                if (alienacao.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
                    if (AplicacaoPropertiesUtil.getExercicio().equals(alienacao.getDataAlienacao().getAno())) {
                        this.calcularConsolidacaoMovelBrasilAPrazo(alienacao);
                    } else {
                        this.calcularConsolidacaoMovelBrasilAPrazoExercicioAnterior(alienacao);
                    }
                } else {
                    alienacao.getConsolidacao().clear();
                }
            }
        } else if (alienacao.isAlienacaoAVista()) {
            this.calcularConsolidacaoMovelExteriorAVista(alienacao);
        } else if (alienacao.isAlienacaoAPrazo()) {
            if (alienacao.getDataAlienacao().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
                if (AplicacaoPropertiesUtil.getExercicio().equals(alienacao.getDataAlienacao().getAno())) {
                    this.calcularConsolidacaoMovelExteriorAPrazo(alienacao);
                } else {
                    this.calcularConsolidacaoMovelExteriorAPrazoExercicioAnterior(alienacao);
                }
            } else {
                alienacao.getConsolidacao().clear();
            }
        }
    }

    private void calcularConsolidacaoMovelBrasilAVista(AlienacaoBemMovel alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(true);
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().clear();
        if (alienacao.isBemPequenoValor()) {
            alienacao.getConsolidacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
        } else {
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido2());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
            alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getCalculoImposto().getImpostoPago());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal().operacao('-', alienacao.getConsolidacao().getTotalImpostoPago()));
        }
    }

    private void calcularConsolidacaoMovelBrasilAPrazo(AlienacaoBemMovel alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(true);
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().clear();
        if (alienacao.isBemPequenoValor()) {
            alienacao.getConsolidacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
        } else {
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(alienacao.getCalculoImposto().getImpostoDevido2());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioImpostoDevidoNoExercicio());
            if (alienacao.getDataRecebimentoUltimaParcela().isVazio()) {
                alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(alienacao.getConsolidacao().getImpostoTotal().operacao('-', alienacao.getConsolidacao().getImpostoDevidoAnoAtual()));
            } else {
                alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
            }
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal().operacao('-', alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal()));
        }
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
    }

    private void calcularConsolidacaoMovelBrasilAPrazoExercicioAnterior(AlienacaoBemMovel alienacao) {
        alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setReadOnly(false);
        alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().clear();
        alienacao.getConsolidacao().getImpostoTotal().setConteudo(alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
        alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioImpostoDevidoNoExercicio());
        if (alienacao.getDataRecebimentoUltimaParcela().isVazio()) {
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(alienacao.getConsolidacao().getImpostoTotal().operacao('-', alienacao.getConsolidacao().getImpostoDevidoAnoAtual()));
        } else {
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().clear();
        }
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
        alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
        alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
    }

    private void calcularConsolidacaoMovelExteriorAVista(AlienacaoBemMovel alienacao) {
        ValorPositivo impostoPago = new ValorPositivo(null, "impostoPago", 11, 2);
        ValorPositivo rendIsentos = new ValorPositivo(null, "rendIsentos", 11, 2);
        ValorPositivo rendExclusivos = new ValorPositivo(null, "rendExclusivos", 11, 2);
        impostoPago.setConteudo(alienacao.getCalculoImposto().getImpostoPago());
        impostoPago.append('+', alienacao.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao());
        rendIsentos.clear();
        if (alienacao.isBemPequenoValor()) {
            rendIsentos.setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
        } else {
            rendExclusivos.setConteudo(alienacao.getCalculoImposto().getGanhoCapitalTotal());
            rendExclusivos.append('-', alienacao.getCalculoImposto().getImpostoPago());
            rendExclusivos.append('-', alienacao.getValorImpostoExteriorReal());
        }
        alienacao.getConsolidacao().clear();
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(impostoPago);
        alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(rendExclusivos);
        alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(rendIsentos);
    }

    private void calcularConsolidacaoMovelExteriorAPrazo(AlienacaoBemMovel alienacao) {
        ValorPositivo impostoPago = new ValorPositivo(null, "impostoPago", 11, 2);
        ValorPositivo rendIsentos = new ValorPositivo(null, "rendIsentos", 11, 2);
        ValorPositivo rendExclusivos = new ValorPositivo(null, "rendExclusivos", 11, 2);
        boolean lucroReduzido = alienacao.isAlienacaoComLucroReduzido();
        impostoPago.setConteudo(alienacao.getColecaoParcelaAlienacao().obterImpostoPagoTotalNoExercicio());
        impostoPago.append('+', alienacao.getValorImpostoExteriorReal());
        rendIsentos.clear();
        rendExclusivos.clear();
        if (alienacao.isBemPequenoValor()) {
            if (lucroReduzido) {
                rendIsentos.setConteudo(this.obterRendIsentosApuracaoFinalMovelExterior(alienacao));
            } else {
                rendIsentos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalNacionalRealTotalNoExercicio());
                rendIsentos.append('+', alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalMERealTotalNoExercicio());
            }
        } else {
            if (lucroReduzido) {
                rendExclusivos.setConteudo(this.obterRendSujeitosTributacaoApuracaoFinalMovelExterior(alienacao));
            } else {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalNacionalRealTotalNoExercicio());
                rendExclusivos.append('+', alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalMERealTotalNoExercicio());
            }
            rendExclusivos.append('-', impostoPago);
        }
        alienacao.getConsolidacao().clear();
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(impostoPago);
        if (alienacao.isPrejuizo()) {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
        } else {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(rendExclusivos);
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(rendIsentos);
        }
    }

    private void calcularConsolidacaoMovelExteriorAPrazoExercicioAnterior(AlienacaoBemMovel alienacao) {
        ValorPositivo impostoPago = new ValorPositivo(null, "impostoPago", 11, 2);
        ValorPositivo rendIsentos = new ValorPositivo(null, "rendIsentos", 11, 2);
        ValorPositivo rendExclusivos = new ValorPositivo(null, "rendExclusivos", 11, 2);
        boolean lucroReduzido = alienacao.isAlienacaoComLucroReduzido();
        impostoPago.setConteudo(alienacao.getColecaoParcelaAlienacao().obterImpostoPagoTotalNoExercicio());
        rendIsentos.clear();
        rendExclusivos.clear();
        if (alienacao.isBemPequenoValor()) {
            if (lucroReduzido) {
                rendIsentos.setConteudo(this.obterRendIsentosApuracaoFinalMovelExterior(alienacao));
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                    rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNForaDoExercicio());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                    rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MEForaDoExercicio());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                    rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNForaDoExercicio());
                    rendIsentos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MEForaDoExercicio());
                }
            } else {
                rendIsentos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalNacionalRealTotalNoExercicio());
                rendIsentos.append('+', alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalMERealTotalNoExercicio());
            }
        } else {
            if (lucroReduzido) {
                rendIsentos.setConteudo(this.obterRendSujeitosTributacaoApuracaoFinalMovelExterior(alienacao));
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                    rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNForaDoExercicio());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                    rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MEForaDoExercicio());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                    rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MNForaDoExercicio());
                    rendExclusivos.append('-', alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioGanhoCapital1MEForaDoExercicio());
                }
            } else {
                rendExclusivos.setConteudo(alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalNacionalRealTotalNoExercicio());
                rendExclusivos.append('+', alienacao.getColecaoParcelaAlienacao().obterGanhoCapitalProporcionalMERealTotalNoExercicio());
            }
            rendExclusivos.append('-', impostoPago);
        }
        alienacao.getConsolidacao().clear();
        alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(impostoPago);
        if (alienacao.isPrejuizo()) {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().clear();
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().clear();
        } else {
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(rendExclusivos);
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(rendIsentos);
        }
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

