/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.especie;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.MoedasAlienadasMensal;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.negocio.CalculoImpostoDevidoUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class TotalizacaoMoedasAlienadas
extends ObjetoNegocio {
    private MoedasAlienadasMensal janeiro = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal fevereiro = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal marco = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal abril = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal maio = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal junho = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal julho = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal agosto = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal setembro = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal outubro = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal novembro = new MoedasAlienadasMensal();
    private MoedasAlienadasMensal dezembro = new MoedasAlienadasMensal();
    private ValorPositivo totalAlienacoesDolar = new ValorPositivo();
    private ValorPositivo totalAlienacoesDolarConsolidado = new ValorPositivo();
    private ValorPositivo totalGanhosCapital = new ValorPositivo();
    private ValorPositivo totalGanhosCapitalTributavel = new ValorPositivo();
    private ValorPositivo totalImpostoDevido = new ValorPositivo();
    private ValorPositivo totalImpostoPago = new ValorPositivo();
    Data dataInicioExercicio = new Data();

    public TotalizacaoMoedasAlienadas() {
        this.adicionarObservadores();
        this.dataInicioExercicio.setConteudo("01/01/" + AplicacaoPropertiesUtil.getExercicio());
    }

    public void recalcular() {
        this.limparTotalizacao();
        this.recalcularAlienacoesDolar();
        this.recalcularAlienacoesConsolidadasDolar();
        this.recalcularGanhosCapitalTributavel();
        this.recalcularImpostoDevido();
        this.recalcularAliquotas();
        this.totalizar();
    }

    private void limparTotalizacao() {
        this.getJaneiro().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_JANEIRO);
        this.getFevereiro().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_FEVEREIRO);
        this.getMarco().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_MARCO);
        this.getAbril().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_ABRIL);
        this.getMaio().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_MAIO);
        this.getJunho().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_JUNHO);
        this.getJulho().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_JULHO);
        this.getAgosto().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_AGOSTO);
        this.getSetembro().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_SETEMBRO);
        this.getOutubro().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_OUTUBRO);
        this.getNovembro().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_NOVEMBRO);
        this.getDezembro().getMes().setConteudo(MoedasAlienadasMensal.CONST_NOME_MES_DEZEMBRO);
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            mes.getAlienacoesDolar().clear();
            mes.getAlienacoesConsolidadasDolar().clear();
            mes.getGanhosCapital().clear();
            mes.getGanhosCapitalTributavel().clear();
            mes.getAliquotaMedia().clear();
            mes.getImpostoDevido().clear();
            mes.getAlienacoesDolar().setCasasDecimais(9);
            mes.getAlienacoesConsolidadasDolar().setCasasDecimais(2);
            mes.getGanhosCapital().setCasasDecimais(2);
            mes.getGanhosCapitalTributavel().setCasasDecimais(2);
            mes.getAliquotaMedia().setCasasDecimais(6);
            mes.getImpostoDevido().setCasasDecimais(2);
        }
    }

    private void recalcularAlienacoesDolar() {
        this.truncarAlienacoesDolar(9);
        for (MoedaAlienada moedaAlienada : GCAPFacade.getInstancia().getDeclaracao().getMoedasAlienadas().itens()) {
            for (OperacaoEspecie operacao : moedaAlienada.getOperacoesEspecie().itens()) {
                if (!"2".equals(operacao.getTipo().naoFormatado()) || 0 != operacao.getData().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() || 0 != operacao.getCotacaoDolar().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade()) continue;
                ValorPositivo valorDolar = new ValorPositivo(null, "valorDolar", 11, 9);
                valorDolar.append('+', operacao.getValor());
                valorDolar.append('/', operacao.getCotacaoDolar());
                MoedasAlienadasMensal mes = this.getMes(Integer.parseInt(operacao.getData().getMes()) - 1);
                mes.getAlienacoesDolar().append('+', valorDolar);
                mes.getGanhosCapital().append('+', operacao.getGanhoCapital());
            }
        }
        this.truncarAlienacoesDolar(2);
    }

    private void truncarAlienacoesDolar(int casasDecimais) {
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            mes.getAlienacoesDolar().setCasasDecimais(casasDecimais);
        }
    }

    private void truncarAliquota(int casasDecimais) {
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            mes.getAliquotaMedia().setCasasDecimais(casasDecimais);
        }
    }

    private void recalcularAlienacoesConsolidadasDolar() {
        ValorPositivo valorConsolidadoDolar = new ValorPositivo(null, "valorConsolidadoDolar", 11, 2);
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            valorConsolidadoDolar.append('+', mes.getAlienacoesDolar().formatado());
            mes.getAlienacoesConsolidadasDolar().append('+', valorConsolidadoDolar);
        }
    }

    private void recalcularGanhosCapitalTributavel() {
        int flag = 0;
        ValorPositivo ganhoCapitalConsolidado = new ValorPositivo(null, "ganhoCapitalConsolidado", 11, 2);
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            ganhoCapitalConsolidado.append('+', mes.getGanhosCapital().formatado());
            if (mes.getAlienacoesConsolidadasDolar().comparacao(">", "5.000,00") && flag == 0) {
                flag = 1;
            }
            if (flag == 1) {
                mes.getGanhosCapitalTributavel().setConteudo(ganhoCapitalConsolidado.formatado());
                flag = 2;
                continue;
            }
            if (flag != 2) continue;
            mes.getGanhosCapitalTributavel().setConteudo(mes.getGanhosCapital().formatado());
        }
    }

    private void recalcularImpostoDevido() {
        ValorPositivo somatorioGanhoTributavel = new ValorPositivo(null, "somatorioGanhoTributavel", 11, 2);
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            if (mes.getGanhosCapitalTributavel().isVazio()) continue;
            ValorPositivo impostoDevidoTotalAnterior = CalculoImpostoDevidoUtil.calcularImpostoDevido(somatorioGanhoTributavel, this.dataInicioExercicio);
            somatorioGanhoTributavel.append('+', mes.getGanhosCapitalTributavel());
            ValorPositivo impostoDevidoTotalAtual = CalculoImpostoDevidoUtil.calcularImpostoDevido(somatorioGanhoTributavel, this.dataInicioExercicio);
            ValorPositivo impostoDevidoMensal = new ValorPositivo(null, "somatorioGanhoTributavel", 11, 9);
            impostoDevidoMensal.setConteudo(impostoDevidoTotalAtual.formatado());
            impostoDevidoMensal.append('-', impostoDevidoTotalAnterior.formatado());
            impostoDevidoMensal.setCasasDecimais(2);
            mes.getImpostoDevido().setConteudo(impostoDevidoMensal.formatado());
        }
    }

    private void recalcularAliquotas() {
        this.truncarAliquota(8);
        ValorPositivo aliquotaAtual = new ValorPositivo(null, "aliquotaAtual", 11, 8);
        String[][] tabelaProgessiva = CalculoImpostoDevidoUtil.getTabelaImposto(this.dataInicioExercicio);
        aliquotaAtual.setConteudo(tabelaProgessiva[tabelaProgessiva.length - 1][1]);
        aliquotaAtual.append('*', "100,00");
        ValorPositivo aliquotaInicial = new ValorPositivo(null, "aliquotaInicial", 11, 8);
        aliquotaInicial.setConteudo(aliquotaAtual);
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            if (!mes.getGanhosCapitalTributavel().isVazio()) {
                ValorPositivo aliquota = new ValorPositivo(null, "aliquotaAtual", 11, 8);
                aliquota.setConteudo(mes.getImpostoDevido());
                aliquota.append('/', mes.getGanhosCapitalTributavel().formatado());
                aliquota.append('*', "100,00");
                if (aliquota.comparacao("<", aliquotaInicial)) {
                    aliquota.setConteudo(aliquotaInicial);
                }
                aliquotaAtual.setConteudo(aliquota);
            }
            mes.getAliquotaMedia().setConteudo(aliquotaAtual);
        }
        this.truncarAliquota(6);
    }

    public void totalizar() {
        this.getTotalAlienacoesDolar().clear();
        this.getTotalAlienacoesDolarConsolidado().clear();
        this.getTotalGanhosCapital().clear();
        this.getTotalGanhosCapitalTributavel().clear();
        this.getTotalImpostoDevido().clear();
        this.getTotalImpostoPago().clear();
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            this.getTotalAlienacoesDolar().append('+', mes.getAlienacoesDolar());
            this.getTotalAlienacoesDolarConsolidado().append('+', mes.getAlienacoesConsolidadasDolar());
            this.getTotalGanhosCapital().append('+', mes.getGanhosCapital());
            this.getTotalGanhosCapitalTributavel().append('+', mes.getGanhosCapitalTributavel());
            this.getTotalImpostoDevido().append('+', mes.getImpostoDevido());
            this.getTotalImpostoPago().append('+', mes.getImpostoPago());
        }
    }

    private void adicionarObservadores() {
        Observador obsTotalImpostoPago = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                TotalizacaoMoedasAlienadas.this.getTotalImpostoPago().setConteudo(TotalizacaoMoedasAlienadas.this.obterValorAnual(MoedasAlienadasMensal.CONST_CAMPO_IMPOSTO_PAGO));
            }
        };
        for (MoedasAlienadasMensal mes : this.getMeses()) {
            mes.getImpostoPago().addObservador(obsTotalImpostoPago);
        }
    }

    public ValorPositivo getTotalAlienacoesDolar() {
        return this.totalAlienacoesDolar;
    }

    public ValorPositivo getTotalAlienacoesDolarConsolidado() {
        return this.totalAlienacoesDolarConsolidado;
    }

    public ValorPositivo getTotalGanhosCapital() {
        return this.totalGanhosCapital;
    }

    public ValorPositivo getTotalGanhosCapitalTributavel() {
        return this.totalGanhosCapitalTributavel;
    }

    public ValorPositivo getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    public ValorPositivo getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public MoedasAlienadasMensal getJaneiro() {
        return this.janeiro;
    }

    public MoedasAlienadasMensal getFevereiro() {
        return this.fevereiro;
    }

    public MoedasAlienadasMensal getMarco() {
        return this.marco;
    }

    public MoedasAlienadasMensal getAbril() {
        return this.abril;
    }

    public MoedasAlienadasMensal getMaio() {
        return this.maio;
    }

    public MoedasAlienadasMensal getJunho() {
        return this.junho;
    }

    public MoedasAlienadasMensal getJulho() {
        return this.julho;
    }

    public MoedasAlienadasMensal getAgosto() {
        return this.agosto;
    }

    public MoedasAlienadasMensal getSetembro() {
        return this.setembro;
    }

    public MoedasAlienadasMensal getOutubro() {
        return this.outubro;
    }

    public MoedasAlienadasMensal getNovembro() {
        return this.novembro;
    }

    public MoedasAlienadasMensal getDezembro() {
        return this.dezembro;
    }

    public MoedasAlienadasMensal getMes(int mes) {
        switch (mes) {
            case 0: {
                return this.getJaneiro();
            }
            case 1: {
                return this.getFevereiro();
            }
            case 2: {
                return this.getMarco();
            }
            case 3: {
                return this.getAbril();
            }
            case 4: {
                return this.getMaio();
            }
            case 5: {
                return this.getJunho();
            }
            case 6: {
                return this.getJulho();
            }
            case 7: {
                return this.getAgosto();
            }
            case 8: {
                return this.getSetembro();
            }
            case 9: {
                return this.getOutubro();
            }
            case 10: {
                return this.getNovembro();
            }
            case 11: {
                return this.getDezembro();
            }
        }
        return null;
    }

    public List<MoedasAlienadasMensal> getMeses() {
        ArrayList<MoedasAlienadasMensal> meses = new ArrayList<MoedasAlienadasMensal>();
        meses.add(this.janeiro);
        meses.add(this.fevereiro);
        meses.add(this.marco);
        meses.add(this.abril);
        meses.add(this.maio);
        meses.add(this.junho);
        meses.add(this.julho);
        meses.add(this.agosto);
        meses.add(this.setembro);
        meses.add(this.outubro);
        meses.add(this.novembro);
        meses.add(this.dezembro);
        return meses;
    }

    public ValorPositivo obterValorAnual(int campo) {
        ValorPositivo total = new ValorPositivo();
        this.getMeses().forEach(mes -> total.append('+', mes.obterValor(campo)));
        return total;
    }
}

