/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.perguntas;

import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class PerguntasImovel
extends ObjetoNegocio {
    public static String TXT_ACESSIVEL_PERGUNTA_IMOVEL_PEQUENO_VALOR = "O valor do conjunto dos bens ou direitos da mesma natureza, alieanados em (mes/ano), \u00e9 superior a R$ 35.000,00?";
    public static String TXT_ACESSIVEL_PERGUNTA_POSSUI_OUTRO_IMOVEL = "Voc\u00ea possui outro im\u00f3vel, seja como propriet\u00e1rio individual, em condom\u00ednio ou em comunh\u00e3o ou como usufrutu\u00e1rio?";
    public static String TXT_ACESSIVEL_PERGUNTA_ALIENOU_OUTRO_IMOVEL_5_ANOS = "Nos \u00faltimos cinco anos, voc\u00ea efetuou outra aliena\u00e7\u00e3o de im\u00f3vel a qualquer t\u00edtulo, tributada ou n\u00e3o?";
    public static String TXT_ACESSIVEL_PERGUNTA_IMOVEL_RESIDENCIAL = "O im\u00f3vel objeto desta aliena\u00e7\u00e3o \u00e9 residencial?";
    public static String TXT_ACESSIVEL_PERGUNTA_VALOR_REAPLICADO = "A isen\u00e7\u00e3o do imposto sobre a renda sobre o ganho de capital auferido por pessoa f\u00edsica residente no Brasil na aliena\u00e7\u00e3o de im\u00f3veis residenciais precisa atender aos seguintes requisitos: o alienante, no prazo de 180 dias contado da celebra\u00e7\u00e3o do contrato, deve usar o valor recebido para comprar um ou mais im\u00f3veis residenciais ou para quitar um ou mais financiamentos de im\u00f3veis residenciais que j\u00e1 possui. o im\u00f3vel a ser comprado ou a ter seu financiamento quitado precisa ser residencial e localizado no Brasil; a quita\u00e7\u00e3o pode ser total ou parcial e o financiamento pode ser a prazo ou \u00e0 presta\u00e7\u00e3o; esse benef\u00edcio pode ser utilizado uma vez a cada 5 anos. Observe que a isen\u00e7\u00e3o n\u00e3o se aplica: \u00e0 venda ou compra de im\u00f3veis comerciais; \u00e0 venda ou aquisi\u00e7\u00e3o de terreno; \u00e0 aquisi\u00e7\u00e3o somente de vaga de garagem ou de boxe de estacionamento. Para mais informa\u00e7\u00f5es, consulte o Ajuda. Indique em que situa\u00e7\u00e3o voc\u00ea se enquadra:";
    public static String TXT_ACESSIVEL_PERGUNTA_VALOR_REAPLICADO_PARTE2 = "Qual foi o valor aplicado na aquisi\u00e7\u00e3o de im\u00f3veis residenciais localizados no Pa\u00eds?";
    public static String TXT_ACESSIVEL_PERGUNTA_VALOR_REAPLICADO_ALIENACAO_ANTERIOR = "A isen\u00e7\u00e3o est\u00e1 sendo utilizada na venda de mais de um im\u00f3vel? As aliena\u00e7\u00f5es devem ocorrer no per\u00edodo de 180 dias contados da primeira opera\u00e7\u00e3o.";
    public static String TXT_ACESSIVEL_VALOR_REAPLICADO = "Valor da aplica\u00e7\u00e3o em reais";
    public static String TXT_ACESSIVEL_DATA_PRIMEIRA_ALIENACAO = "Data da primeira aliena\u00e7\u00e3o";
    public static String LABEL_CAMPO_MP252 = "Voc\u00ea est\u00e1 alienando (vendendo, permutando...) im\u00f3vel residencial e pretende usar o valor recebido, no prazo de 180 dias, para comprar outro im\u00f3vel ou para quitar um financiamento de im\u00f3vel que j\u00e1 possui?";
    public static String LABEL_CAMPO_MP252_PARTE2 = "Qual foi o valor aplicado na aquisi\u00e7\u00e3o de im\u00f3veis residenciais localizados no Pa\u00eds?";
    public static String LABEL_CAMPO_MP252_PRIMEIRA_ALIENACAO = "A isen\u00e7\u00e3o est\u00e1 sendo utilizada na venda de mais de um im\u00f3vel?";
    public static String LABEL_CAMPO_DATA_PRIMEIRA_ALIENACAO = "Data da primeira aliena\u00e7\u00e3o";
    private Logico propriedadeOutroImovel = new Logico((ObjetoNegocio)this, "Voc\u00ea possui outro im\u00f3vel, seja como propriet\u00e1rio individual, em condom\u00ednio ou em comunh\u00e3o ou como usufrutu\u00e1rio?");
    private Logico outraAlienacao = new Logico((ObjetoNegocio)this, "Nos \u00faltimos cinco anos, voc\u00ea efetuou outra aliena\u00e7\u00e3o de im\u00f3vel a qualquer t\u00edtulo, tributada ou n\u00e3o?");
    private Logico mP252Parte2 = new Logico((ObjetoNegocio)this, LABEL_CAMPO_MP252_PARTE2);
    private Logico mP252 = new Logico((ObjetoNegocio)this, LABEL_CAMPO_MP252);
    private Logico imovelResidencial = new Logico((ObjetoNegocio)this, "O im\u00f3vel objeto desta aliena\u00e7\u00e3o \u00e9 residencial?");
    private Alfa propriedadeOutroImovelAux = new Alfa((ObjetoNegocio)this, "Propriet\u00e1rio de outro im\u00f3vel?");
    private Alfa outraAlienacaoAux = new Alfa((ObjetoNegocio)this, "Nos \u00faltimos cinco anos voc\u00ea efetuou outra aliena\u00e7ao?");
    private Alfa mP252Aux = new Alfa((ObjetoNegocio)this, "Valor da aliena\u00e7\u00e3o foi aplicado no prazo de 180 dias?");
    private Alfa imovelResidencialAux = new Alfa((ObjetoNegocio)this, "Im\u00f3vel Residencial?");
    private Logico mP252PrimeiraAlienacao = new Logico((ObjetoNegocio)this, LABEL_CAMPO_MP252_PRIMEIRA_ALIENACAO);
    private Data dataPrimeiraAlienacao = new Data((ObjetoNegocio)this, LABEL_CAMPO_DATA_PRIMEIRA_ALIENACAO);
    public static final String RESPOSTA_1 = "1";
    public static final String RESPOSTA_2 = "2";
    public static final String RESPOSTA_3 = "3";
    public static final String RESPOSTA_4 = "4";
    public static final String TXT_RESPOSTA_1 = "Adquiri ou pretendo adquirir outro im\u00f3vel residencial em at\u00e9 180 dias contados da celebra\u00e7\u00e3o do contrato.";
    public static final String TXT_RESPOSTA_2 = "N\u00e3o adquiri outro im\u00f3vel residencial em at\u00e9 180 dias contados da celebra\u00e7\u00e3o do contrato com uso desse benef\u00edcio.";
    public static final String TXT_RESPOSTA_3 = "Pretendia adquirir outro im\u00f3vel residencial em at\u00e9 180 dias contados da celebra\u00e7\u00e3o do contrato, mas n\u00e3o o fiz neste prazo.";
    public static final String TXT_RESPOSTA_4 = "J\u00e1 utilizei este benef\u00edcio em per\u00edodo inferior a 5 anos.";

    public PerguntasImovel() {
        this.adicionaOpcaoSimNao(this.propriedadeOutroImovel);
        this.adicionaOpcaoSimNao(this.outraAlienacao);
        this.adicionaOpcaoSimNao(this.imovelResidencial);
        this.adicionaOpcoesReaplicacao(this.mP252);
        this.adicionaOpcoesReaplicacaoParte2(this.mP252Parte2);
        this.adicionaOpcaoSimNao(this.mP252PrimeiraAlienacao);
        this.adicionarObservadoresPerguntas();
    }

    private void adicionarObservadoresPerguntas() {
        this.getPropriedadeOutroImovelAux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PerguntasImovel.this.propriedadeOutroImovelAux.formatado().equals("S")) {
                    PerguntasImovel.this.propriedadeOutroImovel.setConteudo(Logico.SIM);
                } else if (PerguntasImovel.this.propriedadeOutroImovelAux.formatado().equals("N")) {
                    PerguntasImovel.this.propriedadeOutroImovel.setConteudo(Logico.NAO);
                }
            }
        });
        this.getOutraAlienacaoAux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PerguntasImovel.this.outraAlienacaoAux.formatado().equals("S")) {
                    PerguntasImovel.this.outraAlienacao.setConteudo(Logico.SIM);
                } else if (PerguntasImovel.this.outraAlienacaoAux.formatado().equals("N")) {
                    PerguntasImovel.this.outraAlienacao.setConteudo(Logico.NAO);
                }
            }
        });
        this.getMP252Aux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PerguntasImovel.this.mP252Aux.formatado().equals("S")) {
                    PerguntasImovel.this.mP252.setConteudo(Logico.SIM);
                } else if (PerguntasImovel.this.mP252Aux.formatado().equals("N")) {
                    PerguntasImovel.this.mP252.setConteudo(Logico.NAO);
                } else if (PerguntasImovel.this.mP252Aux.formatado().equals("P")) {
                    PerguntasImovel.this.mP252.setConteudo("P");
                }
            }
        });
        this.getImovelResidencialAux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PerguntasImovel.this.imovelResidencialAux.formatado().equals("S")) {
                    PerguntasImovel.this.imovelResidencial.setConteudo(Logico.SIM);
                } else if (PerguntasImovel.this.imovelResidencialAux.formatado().equals("N")) {
                    PerguntasImovel.this.imovelResidencial.setConteudo(Logico.NAO);
                }
            }
        });
        this.getMP252PrimeiraAlienacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.equals(Logico.SIM)) {
                    PerguntasImovel.this.getDataPrimeiraAlienacao().setReadOnly(false);
                } else {
                    PerguntasImovel.this.getDataPrimeiraAlienacao().setReadOnly(true);
                    PerguntasImovel.this.getDataPrimeiraAlienacao().clear();
                }
            }
        });
    }

    protected void adicionaOpcaoSimNao(Logico item) {
        item.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        item.addOpcao(Logico.NAO, Logico.LABEL_NAO);
    }

    protected void adicionaOpcaoSimNaoParcialmente(Logico item) {
        this.adicionaOpcaoSimNao(item);
        item.addOpcao("P", "Parcial");
    }

    protected void adicionaOpcoesReaplicacao(Logico item) {
        item.addOpcao(RESPOSTA_1, TXT_RESPOSTA_1);
        item.addOpcao(RESPOSTA_2, TXT_RESPOSTA_2);
        item.addOpcao(RESPOSTA_3, TXT_RESPOSTA_3);
        item.addOpcao(RESPOSTA_4, TXT_RESPOSTA_4);
    }

    protected void adicionaOpcoesReaplicacaoParte2(Logico item) {
        item.addOpcao(Logico.SIM, "Total");
        item.addOpcao("P", "Parcial");
    }

    public Logico getPropriedadeOutroImovel() {
        return this.propriedadeOutroImovel;
    }

    public Logico getOutraAlienacao() {
        return this.outraAlienacao;
    }

    public Logico getMP252() {
        return this.mP252;
    }

    public Logico getMP252Parte2() {
        return this.mP252Parte2;
    }

    public Logico getMP252PrimeiraAlienacao() {
        return this.mP252PrimeiraAlienacao;
    }

    public Data getDataPrimeiraAlienacao() {
        return this.dataPrimeiraAlienacao;
    }

    public Logico getImovelResidencial() {
        return this.imovelResidencial;
    }

    public Alfa getPropriedadeOutroImovelAux() {
        return this.propriedadeOutroImovelAux;
    }

    public Alfa getOutraAlienacaoAux() {
        return this.outraAlienacaoAux;
    }

    public Alfa getMP252Aux() {
        return this.mP252Aux;
    }

    public Alfa getImovelResidencialAux() {
        return this.imovelResidencialAux;
    }

    public boolean isImovelResidencial() {
        return Logico.SIM.equals(this.getImovelResidencial().naoFormatado());
    }

    public boolean isValorReaplicadoTotalmente() {
        return Logico.SIM.equals(this.getMP252Parte2().naoFormatado());
    }

    public boolean isValorReaplicadoParcialmente() {
        return "P".equals(this.getMP252Parte2().naoFormatado());
    }

    public boolean isValorReaplicavel() {
        return RESPOSTA_1.equals(this.getMP252().naoFormatado());
    }

    public boolean isIN599_2005Aplicavel() {
        return RESPOSTA_3.equals(this.getMP252().naoFormatado());
    }

    public boolean isValorReaplicado() {
        return this.isValorReaplicadoTotalmente() || this.isValorReaplicadoParcialmente();
    }

    public boolean naoTemOutraAlienacao() {
        return Logico.NAO.equals(this.getOutraAlienacao().naoFormatado());
    }

    public boolean unicoImovel() {
        return Logico.NAO.equals(this.getPropriedadeOutroImovel().naoFormatado());
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaPerguntas() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getImovelResidencial());
        lista.add(this.getMP252());
        lista.add(this.getMP252Parte2());
        lista.add(this.getOutraAlienacao());
        lista.add(this.getPropriedadeOutroImovel());
        lista.add(this.getMP252PrimeiraAlienacao());
        lista.add(this.getDataPrimeiraAlienacao());
        return lista;
    }

    public boolean isValorReaplicadoPrimeiraAlienacao() {
        return Logico.SIM.equals(this.getMP252PrimeiraAlienacao().naoFormatado());
    }
}

