/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.psocietarias;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.psocietarias.OperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import java.util.List;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.util.Validador;

public class ColecaoOperacaoParticipacaoSocietaria
extends Colecao<OperacaoParticipacaoSocietaria> {
    private ValorPositivo estoqueInicial = new ValorPositivo((ObjetoNegocio)this, "Estoque inicial", 11, 2);
    private ValorPositivo saldoInicial = new ValorPositivo((ObjetoNegocio)this, "Saldo inicial (R$)", 11, 2);
    private ValorPositivo custoMedioInicial = new ValorPositivo((ObjetoNegocio)this, "Custo m\u00e9dio inicial", 11, 6);
    private ValorPositivo totalQtdAdquirida = new ValorPositivo((ObjetoNegocio)this, "Quantidade total adquirida", 11, 2);
    private ValorPositivo totalQtdAlienada = new ValorPositivo((ObjetoNegocio)this, "Quantidade total alienada", 11, 2);
    private ValorPositivo ultimoCustoMedioTransportado = new ValorPositivo((ObjetoNegocio)this, "\u00daltimo custo m\u00e9dio transportado (R$)", 11, 6);
    private boolean estoqueNegativo = false;
    private Observador obsCalculoGanhoCapital = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            ColecaoOperacaoParticipacaoSocietaria.this.calcularGanhoTotal();
        }
    };

    public ColecaoOperacaoParticipacaoSocietaria() {
        this.ultimoCustoMedioTransportado.setReadOnly(true);
        Observador obsCalcularCustoMedioInicial = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ColecaoOperacaoParticipacaoSocietaria.this.calcularGanhoTotal();
            }
        };
        this.getEstoqueInicial().addObservador(obsCalcularCustoMedioInicial);
        this.getSaldoInicial().addObservador(obsCalcularCustoMedioInicial);
    }

    public ColecaoOperacaoParticipacaoSocietaria(String pNomeCampo, String pNomeFicha, String pNomeAba) {
        super(pNomeCampo, pNomeFicha, pNomeAba);
    }

    public ColecaoOperacaoParticipacaoSocietaria(String pNomeCampo) {
        super(pNomeCampo);
    }

    public ColecaoOperacaoParticipacaoSocietaria(int tamanho) {
        super(tamanho);
    }

    public ValorPositivo getEstoqueInicial() {
        return this.estoqueInicial;
    }

    public ValorPositivo getSaldoInicial() {
        return this.saldoInicial;
    }

    public ValorPositivo getCustoMedioInicial() {
        return this.custoMedioInicial;
    }

    public int obterOrdemOperacaoParticipacaoSocietaria(OperacaoParticipacaoSocietaria operacao) {
        int ordem;
        boolean tipoOperacaoNovaValido;
        List listaOperacoesOrdenada = this.itens();
        boolean dataOperacaoNovaValida = Validador.verificaData((String)operacao.getData().formatado()) == 0;
        boolean bl = tipoOperacaoNovaValido = operacao.getTipo().naoFormatado().equals("1") || operacao.getTipo().naoFormatado().equals("2") || operacao.getTipo().naoFormatado().equals("0");
        for (ordem = 0; ordem < listaOperacoesOrdenada.size(); ++ordem) {
            String chaveOperacao;
            String chaveOperacaoNova;
            OperacaoParticipacaoSocietaria op = (OperacaoParticipacaoSocietaria)((Object)listaOperacoesOrdenada.get(ordem));
            boolean dataOperacaoValida = Validador.verificaData((String)op.getData().formatado()) == 0;
            boolean tipoOperacaoValido = op.getTipo().naoFormatado().equals("1") || op.getTipo().naoFormatado().equals("2") || op.getTipo().naoFormatado().equals("0");
            Object dataOperacaoNova = "99999999";
            String tipoOperacaoNova = "9";
            Object dataOperacao = "99999999";
            String tipoOperacao = "9";
            if (dataOperacaoNovaValida) {
                dataOperacaoNova = operacao.getData().getAno() + operacao.getData().getMes() + operacao.getData().getDia();
            }
            if (tipoOperacaoNovaValido) {
                tipoOperacaoNova = operacao.getTipo().naoFormatado();
            }
            if (dataOperacaoValida) {
                dataOperacao = op.getData().getAno() + op.getData().getMes() + op.getData().getDia();
            }
            if (tipoOperacaoValido) {
                tipoOperacao = op.getTipo().naoFormatado();
            }
            if ((chaveOperacaoNova = (String)dataOperacaoNova + tipoOperacaoNova).compareTo(chaveOperacao = (String)dataOperacao + tipoOperacao) < 0) break;
        }
        return ordem;
    }

    public int alterarOrdemOperacaoParticipacaoSocietaria(int ordem) {
        OperacaoParticipacaoSocietaria op = (OperacaoParticipacaoSocietaria)((Object)this.itens().remove(ordem));
        return this.inserirOperacaoParticipacaoSocietaria(op);
    }

    public int inserirOperacaoParticipacaoSocietaria(OperacaoParticipacaoSocietaria operacao) {
        int ordem = this.obterOrdemOperacaoParticipacaoSocietaria(operacao);
        this.itens().add(ordem, operacao);
        return ordem;
    }

    public int inserirNovaOperacaoSaldoInicial() {
        OperacaoParticipacaoSocietaria op = new OperacaoParticipacaoSocietaria();
        op.getTipo().setConteudo("0");
        op.getData().setConteudo("31/12/" + String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1));
        op.getData().setReadOnly(true);
        return this.inserirOperacaoParticipacaoSocietaria(op);
    }

    public int inserirNovaOperacaoCompra() {
        OperacaoParticipacaoSocietaria op = new OperacaoParticipacaoSocietaria();
        op.getTipo().setConteudo("1");
        return this.inserirOperacaoParticipacaoSocietaria(op);
    }

    public int inserirNovaOperacaoVenda() {
        OperacaoParticipacaoSocietaria op = new OperacaoParticipacaoSocietaria();
        op.getTipo().setConteudo("2");
        return this.inserirOperacaoParticipacaoSocietaria(op);
    }

    public void recalcularGanhoTotal() {
        this.calcularGanhoTotal();
    }

    public void calcularSaldo(OperacaoParticipacaoSocietaria operacao, String estoqueAnterior, String saldoAnterior, String custoMedioAnterior) {
        ValorBigDecimal estoque = new ValorBigDecimal(estoqueAnterior);
        ValorPositivo saldo = new ValorPositivo(saldoAnterior);
        ValorPositivo custoMedio = new ValorPositivo(custoMedioAnterior);
        ValorPositivo custoAlienacao = new ValorPositivo("0,00");
        if (Validador.verificaData((String)operacao.getData().formatado()) == 0) {
            if (operacao.getTipo().naoFormatado().equals("1") || operacao.getTipo().naoFormatado().equals("0")) {
                estoque.append('+', operacao.getQuantidade());
                if (estoque.comparacao(">", "0,00")) {
                    saldo.append('+', operacao.getValor());
                } else {
                    saldo.clear();
                }
                custoMedio.setConteudo(this.calcularCustoMedio(estoque, saldo));
            } else if (operacao.getTipo().naoFormatado().equals("2")) {
                custoAlienacao.setConteudo(operacao.getQuantidade().operacao('*', custoMedio));
                estoque.append('-', operacao.getQuantidade());
                if (estoque.comparacao(">", "0,00") && saldo.comparacao(">", custoAlienacao)) {
                    saldo.append('-', custoAlienacao);
                } else {
                    saldo.clear();
                }
            }
        }
        operacao.getCustoAlienacao().setConteudo(custoAlienacao);
        operacao.getEstoque().setConteudo(estoque);
        operacao.getSaldo().setConteudo(saldo);
        operacao.getCustoMedio().setConteudo(custoMedio);
    }

    public ValorPositivo calcularCustoMedio(ValorBigDecimal estoque, ValorPositivo saldo) {
        ValorPositivo custoMedio = new ValorPositivo("0,000000");
        if (estoque.comparacao(">", "0,00")) {
            custoMedio.setConteudo(saldo.operacao('/', estoque));
        } else {
            custoMedio.clear();
        }
        return custoMedio;
    }

    private void calcularGanhoTotal() {
        ValorBigDecimal estoque = new ValorBigDecimal(this.getEstoqueInicial().naoFormatado());
        ValorPositivo saldo = new ValorPositivo(this.getSaldoInicial().naoFormatado());
        ValorPositivo custoMedio = new ValorPositivo(this.getCustoMedioInicial().naoFormatado());
        ValorPositivo totalQuantidadeAdquirida = new ValorPositivo("0,00");
        ValorPositivo totalQuantidadeAlienada = new ValorPositivo("0,00");
        this.estoqueNegativo = false;
        for (OperacaoParticipacaoSocietaria op : this.itens()) {
            this.calcularSaldo(op, estoque.naoFormatado(), saldo.naoFormatado(), custoMedio.naoFormatado());
            estoque.setConteudo(op.getEstoque());
            saldo.setConteudo(op.getSaldo());
            custoMedio.setConteudo(op.getCustoMedio());
            if (op.getTipo().naoFormatado().equals("1") || op.getTipo().naoFormatado().equals("0")) {
                totalQuantidadeAdquirida.append('+', op.getQuantidade());
            } else if (op.getTipo().naoFormatado().equals("2")) {
                totalQuantidadeAlienada.append('+', op.getQuantidade());
            }
            this.estoqueNegativo = this.estoqueNegativo || estoque.comparacao("<", "0,00");
        }
        this.getTotalQtdAdquirida().setConteudo(totalQuantidadeAdquirida);
        this.getTotalQtdAlienada().setConteudo(totalQuantidadeAlienada);
    }

    public void objetoInserido(OperacaoParticipacaoSocietaria operacao) {
        operacao.getData().addObservador(this.obsCalculoGanhoCapital);
        operacao.getQuantidade().addObservador(this.obsCalculoGanhoCapital);
        operacao.getValor().addObservador(this.obsCalculoGanhoCapital);
    }

    public void objetoRemovido(Object o) {
        OperacaoParticipacaoSocietaria op = (OperacaoParticipacaoSocietaria)((Object)o);
        op.getData().removeObservador(this.obsCalculoGanhoCapital);
        op.getQuantidade().removeObservador(this.obsCalculoGanhoCapital);
        op.getValor().removeObservador(this.obsCalculoGanhoCapital);
    }

    public ValorPositivo getTotalQtdAdquirida() {
        return this.totalQtdAdquirida;
    }

    public ValorPositivo getTotalQtdAlienada() {
        return this.totalQtdAlienada;
    }

    public OperacaoParticipacaoSocietaria instanciaNovoObjeto() {
        return new OperacaoParticipacaoSocietaria();
    }

    public boolean isEstoqueNegativo() {
        return this.estoqueNegativo;
    }

    public ValorPositivo getUltimoCustoMedioTransportado() {
        return this.ultimoCustoMedioTransportado;
    }
}

