/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.psocietarias;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.validador.ValidadorData;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class OperacaoParticipacaoSocietaria
extends ObjetoNegocio {
    public static final String TIPO_SALDO_INICIAL = "0";
    public static final String TIPO_COMPRA = "1";
    public static final String TIPO_VENDA = "2";
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo de opera\u00e7\u00e3o");
    private Data data = new Data((ObjetoNegocio)this, "Data da opera\u00e7\u00e3o");
    private ValorPositivo quantidade = new ValorPositivo(this, "Quantidade", 11, 0);
    private ValorPositivo valor = new ValorPositivo(this, "Valor (R$)", 11, 2);
    private ValorPositivo custoAlienacao = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o (R$)", 11, 2);
    private ValorPositivo saldo = new ValorPositivo(this, "Valor acumulado (R$)", 11, 2);
    private ValorPositivo custoMedio = new ValorPositivo(this, "Custo m\u00e9dio", 11, 6);
    private ValorBigDecimal estoque = new ValorBigDecimal(this, "Quantidade em estoque", 11, 0);
    private Alfa tipoAux = new Alfa((ObjetoNegocio)this, "Tipo de opera\u00e7\u00e3o");

    public OperacaoParticipacaoSocietaria() {
        this.getCustoAlienacao().setReadOnly(true);
        this.getCustoMedio().setReadOnly(true);
        this.adicionarValidadores();
        this.adicionaObservadores();
    }

    private void adicionarValidadores() {
        this.getTipo().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!(OperacaoParticipacaoSocietaria.this.getTipo().naoFormatado().equals(OperacaoParticipacaoSocietaria.TIPO_COMPRA) || OperacaoParticipacaoSocietaria.this.getTipo().naoFormatado().equals(OperacaoParticipacaoSocietaria.TIPO_VENDA) || OperacaoParticipacaoSocietaria.this.getTipo().naoFormatado().equals(OperacaoParticipacaoSocietaria.TIPO_SALDO_INICIAL))) {
                    return new RetornoValidacao(3);
                }
                return null;
            }
        });
        this.getData().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getData().addValidador((ValidadorIf)new ValidadorData(3));
        this.getQuantidade().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getValor().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (OperacaoParticipacaoSocietaria.TIPO_COMPRA.equals(OperacaoParticipacaoSocietaria.this.getTipo().naoFormatado())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getEstoque().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (OperacaoParticipacaoSocietaria.this.getEstoque().comparacao("<", "0,00")) {
                    return new RetornoValidacao("A quantidade correspondente ao saldo da opera\u00e7\u00e3o n\u00e3o pode ser negativa.", this.getSeveridade());
                }
                return null;
            }
        });
    }

    public Data getData() {
        return this.data;
    }

    public ValorPositivo getQuantidade() {
        return this.quantidade;
    }

    public ValorPositivo getValor() {
        return this.valor;
    }

    public ValorBigDecimal getEstoque() {
        return this.estoque;
    }

    public ValorPositivo getSaldo() {
        return this.saldo;
    }

    public ValorPositivo getCustoMedio() {
        return this.custoMedio;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public ValorPositivo getCustoAlienacao() {
        return this.custoAlienacao;
    }

    public Alfa getTipoAux() {
        return this.tipoAux;
    }

    public void adicionaObservadores() {
        this.getTipoAux().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (OperacaoParticipacaoSocietaria.this.tipoAux.formatado().equals("S")) {
                    OperacaoParticipacaoSocietaria.this.tipo.setConteudo(OperacaoParticipacaoSocietaria.TIPO_SALDO_INICIAL);
                } else if (OperacaoParticipacaoSocietaria.this.tipoAux.formatado().equals("E")) {
                    OperacaoParticipacaoSocietaria.this.tipo.setConteudo(OperacaoParticipacaoSocietaria.TIPO_COMPRA);
                } else {
                    OperacaoParticipacaoSocietaria.this.tipo.setConteudo(OperacaoParticipacaoSocietaria.TIPO_VENDA);
                }
            }
        });
    }

    public OperacaoParticipacaoSocietaria obterCopia() {
        OperacaoParticipacaoSocietaria clone = new OperacaoParticipacaoSocietaria();
        clone.getQuantidade().setConteudo(this.getQuantidade());
        clone.getData().setConteudo(this.getData());
        clone.getValor().setConteudo(this.getValor());
        return clone;
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaApucacaoCustoAquisicao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getTipo());
        lista.add((Informacao)this.getData());
        lista.add((Informacao)this.getQuantidade());
        lista.add((Informacao)this.getValor());
        lista.add((Informacao)this.getEstoque());
        return lista;
    }
}

