/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.psocietarias;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.aquisicao.ParcelaAquisicao;
import br.gov.serpro.gcap.entidades.psocietarias.ParticipacaoSocietariaAlienada;
import br.gov.serpro.gcap.observador.ObservadorCalculoValorTotalAquisicaoPSocietaria;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.validador.ValidadorNaoNuloGCAP;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;

public class ParcelaAquisicaoParticipacaoSocietaria
extends ParcelaAquisicao {
    public static String CAMPO_QUANTIDADE_QUOTAS = "Quantidade de Quotas/A\u00e7\u00f5es Alienadas";
    public static String CAMPO_CUSTO_MEDIO = "Custo M\u00e9dio Ponderado Unit\u00e1rio em Reais";
    public static String CAMPO_CUSTO_AQUISICAO = "Custo total de aquisi\u00e7\u00e3o";
    public static int CODIGO_ACAO_PREFERENCIAL = 1;
    public static int CODIGO_ACAO_ORDINARIA = 2;
    public static int CODIGO_QUOTA = 3;
    public static int CODIGO_OUTRAS = 4;
    public static String DESCRICAO_ACAO_PREFERENCIAL = "A\u00e7\u00e3o preferencial nominativa";
    public static String DESCRICAO_ACAO_ORDINARIA = "A\u00e7\u00e3o ordin\u00e1ria nominativa";
    public static String DESCRICAO_QUOTA = "Quota";
    public static String DESCRICAO_OUTRAS = "Outras";
    private Codigo especieAquisicao = new Codigo((ObjetoNegocio)this, "Esp\u00e9cie de Participa\u00e7\u00e3o Societ\u00e1ria", new ArrayList());
    private Inteiro quantidadeQuotas = new Inteiro((ObjetoNegocio)this, CAMPO_QUANTIDADE_QUOTAS);
    private ValorPositivo custoMedio = new ValorPositivo(this, CAMPO_CUSTO_MEDIO, 11, 6);
    private ValorPositivo custoAquisicao = new ValorPositivo(this, CAMPO_CUSTO_AQUISICAO, 11, 2);
    private ParticipacaoSocietariaAlienada participacaoSocietariaAlienada = new ParticipacaoSocietariaAlienada();

    public ParcelaAquisicaoParticipacaoSocietaria() {
        this.adicionarObservadoresParcelaApuracaoCustoAquisicao();
        this.adicionarValidadores();
        this.getCustoAquisicao().setReadOnly(true);
    }

    private void adicionarValidadores() {
        this.getEspecieAquisicao().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getQuantidadeQuotas().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
        this.getCustoMedio().addValidador((ValidadorIf)new ValidadorNaoNuloGCAP(3));
    }

    public void inicializarCmbEspecie(Codigo especieParticipacaoSocietaria) {
        if (!especieParticipacaoSocietaria.isVazio()) {
            String especieSelecionada = especieParticipacaoSocietaria.getConteudoAtual(0);
            if (especieSelecionada.equals(AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_ACOES)) {
                this.getEspecieAquisicao().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarEspecieAquisicaoPSAcoes());
            } else if (especieSelecionada.equals(AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_OUTRAS)) {
                this.getEspecieAquisicao().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarEspecieAquisicaoPSOutras());
            } else {
                this.getEspecieAquisicao().setColecaoElementoTabela(CadastroTabelasGCAP.recuperarEspecieAquisicaoPSQuota());
            }
        }
    }

    public Codigo getEspecieAquisicao() {
        return this.especieAquisicao;
    }

    public Alfa getEspecieParticipacaoSocietariaAlfa() {
        Alfa campo = new Alfa();
        campo.setConteudo(this.especieAquisicao.getConteudoAtual(1));
        return campo;
    }

    public String getEspecieAquisicaoImpressao() {
        return this.especieAquisicao.getConteudoAtual(1);
    }

    public Inteiro getQuantidadeQuotas() {
        return this.quantidadeQuotas;
    }

    public String getQuantidadeQuotasImpressao() {
        return this.quantidadeQuotas.formatado();
    }

    public ValorPositivo getCustoMedio() {
        return this.custoMedio;
    }

    public String getCustoMedioImpressao() {
        return this.custoMedio.formatado();
    }

    @Override
    public ValorPositivo getCustoAquisicao() {
        return this.custoAquisicao;
    }

    public String getCustoAquisicaoImpressao() {
        return this.custoAquisicao.formatado();
    }

    public ParticipacaoSocietariaAlienada getParticipacaoSocietariaAlienada() {
        return this.participacaoSocietariaAlienada;
    }

    public ParcelaAquisicaoParticipacaoSocietaria obterCopia() {
        ParcelaAquisicaoParticipacaoSocietaria clone = new ParcelaAquisicaoParticipacaoSocietaria();
        clone.getEspecieAquisicao().setConteudo(this.getEspecieAquisicao());
        clone.getQuantidadeQuotas().setConteudo(this.getQuantidadeQuotas());
        clone.getCustoMedio().setConteudo(this.getCustoMedio());
        clone.getCustoAquisicao().setConteudo(this.getCustoAquisicao());
        return clone;
    }

    public void restaurar(ParcelaAquisicaoParticipacaoSocietaria parcela) {
        this.getEspecieAquisicao().setConteudo(parcela.getEspecieAquisicao());
        this.getQuantidadeQuotas().setConteudo(parcela.getQuantidadeQuotas());
        this.getCustoMedio().setConteudo(parcela.getCustoMedio());
        this.getCustoAquisicao().setConteudo(parcela.getCustoAquisicao());
    }

    public void addObservador(Observador obs) {
        this.getEspecieAquisicao().addObservador(obs);
        this.getQuantidadeQuotas().addObservador(obs);
        this.getCustoMedio().addObservador(obs);
        this.getCustoAquisicao().addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.getEspecieAquisicao().removeObservador(obs);
        this.getQuantidadeQuotas().removeObservador(obs);
        this.getCustoMedio().removeObservador(obs);
        this.getCustoAquisicao().removeObservador(obs);
    }

    public void adicionarObservadoresParcelaApuracaoCustoAquisicao() {
        this.addObservador(new ObservadorCalculoValorTotalAquisicaoPSocietaria(this));
    }

    public List<Informacao> recuperarListaCamposPendenciaAbaApucacaoCustoAquisicao() {
        ArrayList<Informacao> lista = new ArrayList<Informacao>();
        lista.add((Informacao)this.getEspecieAquisicao());
        lista.add((Informacao)this.getQuantidadeQuotas());
        lista.add((Informacao)this.getCustoMedio());
        return lista;
    }

    @Override
    public boolean isVazio() {
        return this.especieAquisicao.isVazio() && this.quantidadeQuotas.isVazio() && this.custoMedio.isVazio() && this.custoAquisicao.isVazio();
    }
}

