/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.entidades.psocietarias;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.psocietarias.ColecaoOperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.util.MensagemUtil;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ParticipacaoSocietariaAlienada
extends ObjetoNegocio {
    private ValorPositivo estoqueInicial = new ValorPositivo(this, "Quantidade", 11, 2);
    private ValorPositivo saldoInicial = new ValorPositivo(this, "Valor total (R$)", 11, 2);
    private ValorPositivo custoMedioInicial = new ValorPositivo(this, "Custo m\u00e9dio inicial (R$)", 11, 6);
    private ColecaoOperacaoParticipacaoSocietaria operacoesParticipacaoSocietaria = new ColecaoOperacaoParticipacaoSocietaria();

    public ParticipacaoSocietariaAlienada() {
        this.adicionarValidadores();
        this.adicionarObservadores();
    }

    private void adicionarValidadores() {
        this.getEstoqueInicial().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getEstoqueInicial().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (!ParticipacaoSocietariaAlienada.this.getSaldoInicial().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getSaldoInicial().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("erroCampoNulo", new String[]{this.getSaldoInicial().getNomeCampo()})){

            public RetornoValidacao validarImplementado() {
                if (!ParticipacaoSocietariaAlienada.this.getEstoqueInicial().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
    }

    private void adicionarObservadores() {
        this.getEstoqueInicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParticipacaoSocietariaAlienada.this.getOperacoesParticipacaoSocietaria().getEstoqueInicial().setConteudo(ParticipacaoSocietariaAlienada.this.getEstoqueInicial());
            }
        });
        this.getSaldoInicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParticipacaoSocietariaAlienada.this.getOperacoesParticipacaoSocietaria().getSaldoInicial().setConteudo(ParticipacaoSocietariaAlienada.this.getSaldoInicial());
            }
        });
        this.getCustoMedioInicial().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParticipacaoSocietariaAlienada.this.getOperacoesParticipacaoSocietaria().getCustoMedioInicial().setConteudo(ParticipacaoSocietariaAlienada.this.getCustoMedioInicial());
            }
        });
        Observador obsCalcularCustoMedioInicial = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ParticipacaoSocietariaAlienada.this.getCustoMedioInicial().setConteudo(ParticipacaoSocietariaAlienada.this.getOperacoesParticipacaoSocietaria().calcularCustoMedio(ParticipacaoSocietariaAlienada.this.getEstoqueInicial(), ParticipacaoSocietariaAlienada.this.getSaldoInicial()));
            }
        };
        this.getEstoqueInicial().addObservador(obsCalcularCustoMedioInicial);
        this.getSaldoInicial().addObservador(obsCalcularCustoMedioInicial);
    }

    public ValorPositivo getEstoqueInicial() {
        return this.estoqueInicial;
    }

    public ValorPositivo getSaldoInicial() {
        return this.saldoInicial;
    }

    public ColecaoOperacaoParticipacaoSocietaria getOperacoesParticipacaoSocietaria() {
        return this.operacoesParticipacaoSocietaria;
    }

    public ValorPositivo getCustoMedioInicial() {
        return this.custoMedioInicial;
    }
}

