/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.componente.ImgGCAPBemVindo;
import br.gov.serpro.gcap.gui.dialogs.PainelNovoDemonstrativo;
import br.gov.serpro.gcap.gui.listener.DemonstrativoListener;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class GCAPBemVindo
extends PainelDemonstrativoAb
implements DemonstrativoListener {
    private JButton btnCriarNovaDeclaracao;
    private ImgGCAPBemVindo imgGCAPBemVindo;
    private JLabel labelAbrirDecsRecentes;
    private JLabel lblExercicio;
    private JPanel panelDeclaracoes;
    private JScrollPane scrollDeclaracoes;

    public GCAPBemVindo() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(this.getTituloPainel());
        this.getAccessibleContext().setAccessibleDescription(this.getMensagemTela());
        this.carregaDemonstrativos();
    }

    private void carregaDemonstrativos() {
        this.panelDeclaracoes.removeAll();
        try {
            GCAPFacade gcapFacade = GCAPFacade.getInstancia();
            List<IdDemonstrativoGCAP> listaOrdenadaIdDemonstrativos = GCAPFacade.getListaDeclaracoesOrdenadasPorDataAcesso(false);
            if (listaOrdenadaIdDemonstrativos.size() > 5) {
                this.panelDeclaracoes.setLayout(new GridLayout(listaOrdenadaIdDemonstrativos.size(), 0));
            } else {
                this.panelDeclaracoes.setLayout(new GridLayout(5, 0));
            }
            for (ObjetoNegocio objetoNegocio : listaOrdenadaIdDemonstrativos) {
                this.panelDeclaracoes.add(this.getLabelItemDemonstrativo((IdDemonstrativoGCAP)objetoNegocio));
            }
            this.validate();
            this.repaint();
        }
        catch (Exception ex) {
            Logger.getLogger(GCAPBemVindo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private JLabel getLabelItemDemonstrativo(final IdDemonstrativoGCAP demonstrativo) {
        final JLabel lblDemonstrativo = new JLabel();
        lblDemonstrativo.setFont(new Font("Arial", 0, 12));
        lblDemonstrativo.setForeground(new Color(0, 74, 106));
        lblDemonstrativo.setText(demonstrativo.getCpf().formatado() + " - " + demonstrativo.getNome().asString());
        lblDemonstrativo.setIcon(GuiUtil.getImage("/icones/png20px/MN_novo.png"));
        lblDemonstrativo.setHorizontalAlignment(2);
        lblDemonstrativo.setBackground(new Color(227, 239, 251));
        lblDemonstrativo.setOpaque(true);
        lblDemonstrativo.setCursor(new Cursor(12));
        lblDemonstrativo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                try {
                    ControladorGui.abrirDemonstrativo(demonstrativo, true);
                }
                catch (HashInvalidoException e) {
                    ControladorGui.tratarException((Exception)((Object)e));
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
                lblDemonstrativo.setBackground(Color.white);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                lblDemonstrativo.setBackground(new Color(227, 239, 251));
            }
        });
        return lblDemonstrativo;
    }

    private void initComponents() {
        this.imgGCAPBemVindo = new ImgGCAPBemVindo();
        this.scrollDeclaracoes = new JScrollPane();
        this.panelDeclaracoes = new JPanel();
        this.btnCriarNovaDeclaracao = new JButton();
        this.labelAbrirDecsRecentes = new JLabel();
        this.lblExercicio = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setLayout(new GridBagLayout());
        this.imgGCAPBemVindo.setBorder(null);
        this.imgGCAPBemVindo.setPreferredSize(new Dimension(605, 489));
        this.scrollDeclaracoes.setBorder(BorderFactory.createLineBorder(new Color(175, 196, 214)));
        this.panelDeclaracoes.setBackground(new Color(227, 239, 251));
        this.panelDeclaracoes.setLayout(new GridLayout(1, 0));
        this.scrollDeclaracoes.setViewportView(this.panelDeclaracoes);
        this.btnCriarNovaDeclaracao.setBackground(new Color(255, 255, 255));
        this.btnCriarNovaDeclaracao.setFont(new Font("Arial", 1, 12));
        this.btnCriarNovaDeclaracao.setForeground(new Color(0, 74, 106));
        this.btnCriarNovaDeclaracao.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_novo.png")));
        this.btnCriarNovaDeclaracao.setText("Criar Novo Demonstrativo");
        this.btnCriarNovaDeclaracao.setBorder(null);
        this.btnCriarNovaDeclaracao.setBorderPainted(false);
        this.btnCriarNovaDeclaracao.setContentAreaFilled(false);
        this.btnCriarNovaDeclaracao.setCursor(new Cursor(0));
        this.btnCriarNovaDeclaracao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GCAPBemVindo.this.btnCriarNovaDeclaracaoMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GCAPBemVindo.this.btnCriarNovaDeclaracaoMouseExited(evt);
            }
        });
        this.btnCriarNovaDeclaracao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAPBemVindo.this.btnCriarNovaDeclaracaoActionPerformed(evt);
            }
        });
        this.labelAbrirDecsRecentes.setFont(new Font("Arial", 1, 12));
        this.labelAbrirDecsRecentes.setForeground(new Color(0, 76, 106));
        this.labelAbrirDecsRecentes.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir.png")));
        this.labelAbrirDecsRecentes.setText("Abrir demonstrativos recentes");
        this.lblExercicio.setFont(this.lblExercicio.getFont().deriveFont(this.lblExercicio.getFont().getStyle() | 1, this.lblExercicio.getFont().getSize() + 29));
        this.lblExercicio.setForeground(new Color(142, 193, 30));
        this.lblExercicio.setText(AplicacaoPropertiesUtil.getExercicio());
        GroupLayout imgGCAPBemVindoLayout = new GroupLayout(this.imgGCAPBemVindo);
        this.imgGCAPBemVindo.setLayout(imgGCAPBemVindoLayout);
        imgGCAPBemVindoLayout.setHorizontalGroup(imgGCAPBemVindoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imgGCAPBemVindoLayout.createSequentialGroup().addGroup(imgGCAPBemVindoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imgGCAPBemVindoLayout.createSequentialGroup().addGap(229, 229, 229).addComponent(this.lblExercicio, -2, 134, -2)).addGroup(imgGCAPBemVindoLayout.createSequentialGroup().addGap(52, 52, 52).addComponent(this.btnCriarNovaDeclaracao).addGap(26, 26, 26).addGroup(imgGCAPBemVindoLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.scrollDeclaracoes, -1, 287, Short.MAX_VALUE).addComponent(this.labelAbrirDecsRecentes, -1, -1, Short.MAX_VALUE)))).addContainerGap(65, Short.MAX_VALUE)));
        imgGCAPBemVindoLayout.setVerticalGroup(imgGCAPBemVindoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, imgGCAPBemVindoLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.lblExercicio, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 127, Short.MAX_VALUE).addComponent(this.labelAbrirDecsRecentes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(imgGCAPBemVindoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollDeclaracoes, -2, 146, -2).addGroup(GroupLayout.Alignment.TRAILING, imgGCAPBemVindoLayout.createSequentialGroup().addComponent(this.btnCriarNovaDeclaracao).addGap(72, 72, 72))).addGap(93, 93, 93)));
        this.add((Component)this.imgGCAPBemVindo, new GridBagConstraints());
    }

    private void btnCriarNovaDeclaracaoMouseEntered(MouseEvent evt) {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void btnCriarNovaDeclaracaoMouseExited(MouseEvent evt) {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void btnCriarNovaDeclaracaoActionPerformed(ActionEvent evt) {
        GuiUtil.exibeDialog(new PainelNovoDemonstrativo(), true, "Novo Demonstrativo", false);
    }

    @Override
    public String getTituloPainel() {
        return MensagemUtil.getMensagem("TituloAbertura");
    }

    @Override
    public void preExibir() {
        ControladorGui.addDemonstrativoListener(this);
    }

    @Override
    public void posExibir() {
    }

    @Override
    public boolean isTelaComVoltar() {
        return false;
    }

    @Override
    public boolean isTelaComAjuda() {
        return false;
    }

    @Override
    public boolean isTelaComImpressao() {
        return false;
    }

    @Override
    public void executaImpressao() {
    }

    @Override
    public void executaVoltar() {
    }

    @Override
    public boolean isPodeSair() {
        return true;
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.panelDeclaracoes;
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoAbertura.png");
    }

    @Override
    public boolean isPossuiAbas() {
        return false;
    }

    @Override
    public PainelAbaIf[] getAbas() {
        return null;
    }

    @Override
    public void acionarAba(String pNomeAba, boolean pFocusPadraoDaAba) {
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return null;
    }

    @Override
    public int getIndiceAbaPorNome(String nomeAba) {
        return 0;
    }

    @Override
    public void setEnabledAbaPorNome(String pNomeAba, boolean pEnabled) {
    }

    @Override
    public void removeAbaPorNome(String pNomeAba) {
    }

    @Override
    public void initListener() {
    }

    @Override
    public boolean isEnabledAbaPorNome(String pNomeAba) {
        return false;
    }

    @Override
    public String getHelpID() {
        return null;
    }

    @Override
    public void demonstrativoAberto() {
    }

    @Override
    public void demonstrativoFechado() {
    }

    @Override
    public void demonstrativoSalvo() {
    }

    @Override
    public void mudouNumeroDemonstrativos() {
        this.carregaDemonstrativos();
    }

    @Override
    public boolean demonstrativoVaiFechar() {
        return true;
    }

    @Override
    public String getMensagemTela() {
        return "Use a tecla F11 para informa\u00e7\u00f5es de ajuda de acessibilidade";
    }
}

