/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.JanelaPrincipalGCAP;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import serpro.ppgd.infraestrutura.PlataformaPPGD;

public class GCAPLabelInfo
extends JLabel {
    private static final long serialVersionUID = 1L;
    private String mensagem;

    public GCAPLabelInfo() {
        this.setText(null);
        this.setIcon(GuiUtil.getImage("/icones/png10px/info.png"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GCAPLabelInfo.this.exibirMensagem(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (GCAPLabelInfo.this.getTopLevelAncestor() instanceof JanelaPrincipalGCAP) {
                    PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    GCAPLabelInfo.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (GCAPLabelInfo.this.getTopLevelAncestor() instanceof JanelaPrincipalGCAP) {
                    PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getDefaultCursor());
                } else {
                    GCAPLabelInfo.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public GCAPLabelInfo(String mensagem) {
        this();
        this.mensagem = mensagem;
    }

    public GCAPLabelInfo(String mensagem, boolean iconeGrande) {
        this(mensagem);
        if (iconeGrande) {
            this.setIcon(GuiUtil.getImage("/icones/png16px/info.png"));
        }
    }

    private void exibirMensagem(MouseEvent evt) {
        GuiUtil.mostrarInfo(ControladorGui.getJanelaPrincipal(), this.mensagem);
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    public String getMensagem() {
        return this.mensagem;
    }
}

