/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.gui.GCAPTableAb;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.gui.GCAPToolbar;
import br.gov.serpro.gcap.gui.PainelPrincipalAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.TableListaSumario;
import br.gov.serpro.gcap.gui.TableListaSumarioModel;
import br.gov.serpro.gcap.gui.util.GCAPTableDecorator;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class PainelListaAb
extends PainelPrincipalAb {
    private static final long serialVersionUID = 1L;
    private TableListaModel tableListaModel = null;
    private GCAPToolbar irpfToolbar;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelListaAb(boolean construir) {
        if (construir) {
            this.construirUI();
        }
    }

    public PainelListaAb() {
        this(true);
    }

    public PainelListaAb(TableListaModel model) {
        this.tableListaModel = model;
        this.construirUI();
    }

    public void construirUI() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        GCAPTableDecorator.decorate(this.getTabela(), this);
        this.getTabela().getSelectionModel().addListSelectionListener(this.irpfToolbar);
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(1, 0);
        }
    }

    public PainelListaAb(Colecao<? extends ObjetoNegocio> colecao) {
        this.construirUI();
    }

    public GCAPToolbar novoToolBar() {
        return new GCAPToolbar();
    }

    private void initComponents() {
        this.irpfToolbar = this.novoToolBar();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.setBackground(new Color(241, 245, 249));
        this.irpfToolbar.addToolBarListener(this);
        this.jScrollPane1.setViewportView(this.tableLista);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 578, Short.MAX_VALUE).add((Component)this.irpfToolbar, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 285, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.irpfToolbar, -2, -1, -2)));
    }

    @Override
    public GCAPTableAb getTabela() {
        return this.tableLista;
    }

    protected abstract void configurarTamanhoColunas();

    protected abstract TableLista instanciarTabela(TableListaModel var1, int var2, Integer[] var3);

    protected abstract String getClassePainelNavegacao();

    protected abstract String getButtonHelpID();

    protected abstract int getColunaOrdenacao();

    protected abstract Integer[] getColunasOrdenaveis();

    protected TableListaModel getTableModel() {
        return this.tableListaModel;
    }

    @Override
    public void preExibir() {
        if (((GCAPTableModelAb)this.getTabela().getModel()).getObjetoNegocio() instanceof Colecao) {
            ((Colecao)((GCAPTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        }
        ((GCAPTableModelAb)this.getTabela().getModel()).refresh();
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        GCAPTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRowCount() <= 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirmaNaoPadrao(this.getMensagemExclusao(), this.getParametrosMensagemExclusao())) {
                TableListaModel model = (TableListaModel)tabela.getModel();
                ArrayList<Integer> linhasExcluidas = new ArrayList<Integer>();
                for (int linhaTabela : linhasTabela) {
                    ObjetoNegocio objetoNegocio;
                    int indiceVetor;
                    if ((!temSumario || linhaTabela >= tabela.getRowCount() - 1) && temSumario || !this.validarExclusao(indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela), objetoNegocio = model.getObjetoNegocio(indiceVetor))) continue;
                    linhasExcluidas.add(new Integer(indiceVetor));
                }
                model.removeObjetoNegocio(linhasExcluidas.toArray(new Integer[linhasExcluidas.size()]));
            }
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    @Override
    public void onBtnClick(int index, ActionEvent e) {
    }

    public boolean validarExclusao(int row, ObjetoNegocio objetoNegocio) {
        return this.validarExclusao(objetoNegocio);
    }

    public boolean validarExclusao(ObjetoNegocio objetoNegocio) {
        return true;
    }

    public abstract String getMensagemExclusao();

    public abstract String[] getParametrosMensagemExclusao();

    @Override
    public JComponent getDefaultFocus() {
        if (!(this.getTabela().getModel().getRowCount() <= 0 || TableListaSumarioModel.class.isAssignableFrom(this.getTabela().getModel().getClass()) && this.getTabela().getModel().getRowCount() <= 1)) {
            return this.getTabela();
        }
        return this.getIrpfToolbar().getBtnNovo();
    }

    public GCAPToolbar getIrpfToolbar() {
        return this.irpfToolbar;
    }

    @Override
    public String getHelpID() {
        return this.getButtonHelpID();
    }
}

