/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.DefaultRowSorter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SummaryTableSorter<M extends TableModel>
extends TableRowSorter<M> {
    public SummaryTableSorter(M model) {
        super(model);
    }

    @Override
    public void setModel(M model) {
        super.setModel(model);
        this.setModelWrapper(new SummaryModelWrapper(this.getModelWrapper()));
    }

    @Override
    protected boolean useToString(int column) {
        return false;
    }

    @Override
    public Comparator getComparator(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator instanceof Collator) {
            comparator = null;
        }
        return new TableCellValueComparator(comparator);
    }

    class SummaryModelWrapper<N extends TableModel>
    extends DefaultRowSorter.ModelWrapper<N, Integer> {
        private DefaultRowSorter.ModelWrapper<N, Integer> delegate;

        public SummaryModelWrapper(DefaultRowSorter.ModelWrapper<N, Integer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public N getModel() {
            return (N)((TableModel)this.delegate.getModel());
        }

        @Override
        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return this.delegate.getRowCount();
        }

        @Override
        public String getStringValueAt(int row, int column) {
            return this.delegate.getStringValueAt(row, column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return new TableCellValue(row, column, this.delegate.getValueAt(row, column));
        }

        @Override
        public Integer getIdentifier(int row) {
            return this.delegate.getIdentifier(row);
        }
    }

    class TableCellValueComparator
    implements Comparator<TableCellValue> {
        private Comparator delegate;

        public TableCellValueComparator(Comparator delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(TableCellValue cell1, TableCellValue cell2) {
            int modifier;
            SortOrder order = SortOrder.ASCENDING;
            for (RowSorter.SortKey sortKey : SummaryTableSorter.this.getSortKeys()) {
                if (sortKey.getColumn() != cell1.column) continue;
                order = sortKey.getSortOrder();
                break;
            }
            int n = modifier = order == SortOrder.ASCENDING ? 1 : -1;
            if (cell1.row == SummaryTableSorter.this.getModelWrapper().getRowCount() - 1) {
                return modifier;
            }
            if (cell2.row == SummaryTableSorter.this.getModelWrapper().getRowCount() - 1) {
                return -modifier;
            }
            if (this.delegate != null) {
                return this.delegate.compare(cell1.value, cell2.value);
            }
            String v1 = SummaryTableSorter.this.getModelWrapper().getStringValueAt(cell1.row, cell1.column);
            String v2 = SummaryTableSorter.this.getModelWrapper().getStringValueAt(cell2.row, cell2.column);
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            return v2 == null ? 1 : v1.compareToIgnoreCase(v2);
        }
    }

    class TableCellValue {
        public int row;
        public int column;
        public Object value;

        public TableCellValue(int row, int column, Object value) {
            this.row = row;
            this.column = column;
            this.value = value;
        }
    }
}

