/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui;

import br.gov.serpro.gcap.entidades.ColecaoIdDemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public final class TableModelSelecionaDeclaracao
extends GCAPTableModelAb {
    private ColecaoIdDemonstrativoGCAP colecaoIds = GCAPFacade.getListaIdDeclaracoes();
    private String pathTransmitidas;
    private String pathGravadas;

    public TableModelSelecionaDeclaracao() {
        super(null);
        this.setPathTransmitidas(UtilitariosArquivo.getPathGravadas());
        this.setPathGravadas(UtilitariosArquivo.getPathGravadas());
    }

    @Override
    public int getRowCount() {
        return this.colecaoIds.itens().size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getInformacaoAt(rowIndex, columnIndex).formatado();
            }
            case 1: {
                return this.getInformacaoAt(rowIndex, columnIndex).formatado();
            }
            case 2: {
                return this.getInformacaoAt(rowIndex, columnIndex).formatado();
            }
            case 3: {
                return this.getInformacaoAt(rowIndex, columnIndex).formatado();
            }
            case 4: {
                return this.getInformacaoAt(rowIndex, columnIndex).formatado();
            }
        }
        return "";
    }

    public IdDemonstrativoGCAP getIdentificadorDeclaracao(int rowIndex) {
        IdDemonstrativoGCAP id = (IdDemonstrativoGCAP)((Object)this.colecaoIds.itens().get(rowIndex));
        return id;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "CPF";
            }
            case 1: {
                return "Nome";
            }
            case 2: {
                return "Pa\u00eds";
            }
            case 3: {
                return "Data In\u00edcio";
            }
            case 4: {
                return "Data Fim";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return super.isCellEditable(rowIndex, columnIndex);
    }

    public void setColecaoIdDeclaracao(ColecaoIdDemonstrativoGCAP col) {
        this.colecaoIds = col;
        this.fireTableDataChanged();
    }

    public void setPathTransmitidas(String pathTransmitidas) {
        this.pathTransmitidas = pathTransmitidas;
    }

    public String getPathTransmitidas() {
        return this.pathTransmitidas;
    }

    public void setPathGravadas(String pathGravadas) {
        this.pathGravadas = pathGravadas;
    }

    public String getPathGravadas() {
        return this.pathGravadas;
    }

    @Override
    public Informacao getInformacaoAt(int row, int col) {
        IdDemonstrativoGCAP idDeclaracao = this.getIdentificadorDeclaracao(row);
        switch (col) {
            case 0: {
                return idDeclaracao.getCpf();
            }
            case 1: {
                return idDeclaracao.getNome();
            }
            case 2: {
                Alfa pais = new Alfa();
                pais.setConteudo(idDeclaracao.getPaisDeclarante().getConteudoAtual(1));
                return pais;
            }
            case 3: {
                return idDeclaracao.getDataInicioPermanencia();
            }
            case 4: {
                return idDeclaracao.getDataFimPermanencia();
            }
        }
        return null;
    }
}

