/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis.adquirente;

import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.adquirente.ColecaoAdquirente;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.PainelListaAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.bensimoveis.adquirente.PainelAdquirenteDetalhe;
import br.gov.serpro.gcap.gui.bensimoveis.adquirente.TableModelAdquirentes;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaListaAdquirente
extends PainelListaAb
implements PainelAbaIf {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Adquirentes";
    public static final String NOME_ABA = "Adquirentes";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Adquirentes";
    private PainelDemonstrativoIf painelPai;
    private AlienacaoBemImovel alienacaoBemImovel;

    public PainelAbaListaAdquirente(PainelDemonstrativoIf painelPai) {
        super(false);
        this.painelPai = painelPai;
        this.alienacaoBemImovel = (AlienacaoBemImovel)((PainelComAbasAb)this.painelPai).getDataSource();
        super.construirUI();
    }

    public PainelAbaListaAdquirente(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
    }

    @Override
    public String getTituloPainel() {
        return "Adquirentes";
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        AlienacaoBemImovel alienacao = this.alienacaoBemImovel;
        Adquirente adquirente = new Adquirente();
        alienacao.getBemImovel().getAdquirentes().add(adquirente);
        ControladorGui.acionarPainel(new PainelAdquirenteDetalhe(this.painelPai, this.alienacaoBemImovel, adquirente, true));
        lModel.refresh();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelAdquirentes model = (TableModelAdquirentes)this.getTabela().getModel();
            ColecaoAdquirente colAdquientes = (ColecaoAdquirente)model.getObjetoNegocio();
            Adquirente adquirente = (Adquirente)colAdquientes.itens().get(indiceVetor);
            ControladorGui.acionarPainel(new PainelAdquirenteDetalhe(this.painelPai, this.alienacaoBemImovel, adquirente, true));
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(200);
    }

    @Override
    protected TableListaModel getTableModel() {
        this.alienacaoBemImovel = (AlienacaoBemImovel)((PainelComAbasAb)this.painelPai).getDataSource();
        return new TableModelAdquirentes(this.alienacaoBemImovel.getBemImovel().getAdquirentes());
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"CPF/CNPJ", "Nome"};
        return tableLista;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return null;
    }

    @Override
    protected String getButtonHelpID() {
        return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel";
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    @Override
    public String[] getParametrosMensagemExclusao() {
        return new String[]{"adquirente(s)"};
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoBensImoveis.png");
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return "Adquirentes";
    }

    @Override
    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.alienacaoBemImovel.getBemImovel().getEspecificacao().naoFormatado();
    }
}

