/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis.operacao;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPLabelInfo;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.bensimoveis.PainelDadosBensImoveis;
import br.gov.serpro.gcap.gui.bensimoveis.operacao.PainelOperacaoBrasil;
import br.gov.serpro.gcap.gui.bensimoveis.operacao.PainelOperacaoExterior;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.JFlipComponentes;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;

public class PainelAbaOperacaoBemImovel
extends PainelDemonstrativoAb
implements PainelAbaIf {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA = "Opera\u00e7\u00e3o";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Opera\u00e7\u00e3o";
    private AlienacaoBemImovel alienacaoBemImovel = null;
    private PainelDemonstrativoIf painelPai;
    private PainelOperacaoBrasil painelOperacaoBrasil;
    private PainelOperacaoExterior painelOperacaoExterior;
    private JAutoCompleteEditCodigo cmbNaturezaOperacao;
    private JEditData edtDataAlienacao;
    private JEditData edtDataTransitoJulgado;
    private JEditValor edtGanhoCapital;
    private JAutoCompleteEditCodigo edtPaisAcordo;
    private JAutoCompleteEditCodigo edtPaisResidencia;
    private JEditValor edtValorImpostoReais;
    private JFlipComponentes flipOperacao;
    private JButtonGroupPanel grpAlienacaoParcial;
    private JButtonGroupPanel grpAlienacaoPrazo;
    private JButtonGroupPanel grpMotivoTCM;
    private GCAPLabelInfo infoAlienacaoAnterior;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblDadosSobre;
    private JLabel lblDataAlienacao;
    private JLabel lblDataTransitoJulgado;
    private JLabel lblGanhoCapital;
    private JLabel lblTitulo1;
    private JPanel painelImpostoExterior;
    private JPanel panelPaisAlienacao;
    private JPanel pnlAlienacaoParcial;
    private JPanel pnlDataTransitoJulgado;
    private PPGDRadioItem rdbMTCMDecisaoJudicial;
    private PPGDRadioItem rdbMTCMEscrituraPublica;
    private PPGDRadioItem rdbParcialNao;
    private PPGDRadioItem rdbParcialSim;
    private PPGDRadioItem rdbPrazoNao;
    private PPGDRadioItem rdbPrazoSim;

    public PainelAbaOperacaoBemImovel(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
        this.alienacaoBemImovel = (AlienacaoBemImovel)((PainelComAbasAb)this.painelPai).getDataSource();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.criarSubPanels();
        this.initComponents();
        this.associarInformacao();
        this.exibirGanhoCapitalAlienacaoAnterior();
        this.criarListenersDataAlienacao();
        this.criarListenerNaturezaOperacao();
        this.verificaSeTransmissaoCausaMortis();
        this.verificaSeNaturezaSemAlienacaoAPrazo();
        this.verificaSePaisAlienacaoIgualPaisIdDemonstrativo();
    }

    private void criarListenerNaturezaOperacao() {
        ((JComboBox)this.cmbNaturezaOperacao.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox comboNatureza = (JComboBox)PainelAbaOperacaoBemImovel.this.cmbNaturezaOperacao.getComponenteEditor();
                if (comboNatureza.getSelectedIndex() >= 0) {
                    String natureza = ((ElementoTabela)comboNatureza.getSelectedItem()).getConteudo(0);
                    PainelAbaOperacaoBemImovel.this.alienacaoBemImovel.getNatureza().setConteudo(natureza);
                } else {
                    PainelAbaOperacaoBemImovel.this.alienacaoBemImovel.getNatureza().clear();
                }
                PainelAbaOperacaoBemImovel.this.verificaSeHabilitaAbaAdquirentes();
                PainelAbaOperacaoBemImovel.this.verificaSeHabilitaAbaCalculo();
                PainelAbaOperacaoBemImovel.this.verificaSeTransmissaoCausaMortis();
                PainelAbaOperacaoBemImovel.this.verificaSeNaturezaSemAlienacaoAPrazo();
            }
        });
    }

    private void verificaSeExibePerguntaAlienacaoParcial() {
        if (this.alienacaoBemImovel.podeTerAlienacaoParcial()) {
            this.pnlAlienacaoParcial.setVisible(true);
        } else {
            this.alienacaoBemImovel.getAlienacaoParcial().clear();
            this.grpAlienacaoParcial.getGroup().clearSelection();
            this.pnlAlienacaoParcial.setVisible(false);
        }
        this.exibirGanhoCapitalAlienacaoAnterior();
    }

    private void verificaSeHabilitaAbaAdquirentes() {
        ((PainelDadosBensImoveis)this.painelPai).tratarHabilitacaoAbaAdquirentes();
    }

    private void verificaSeHabilitaAbaCalculo() {
        ((PainelDadosBensImoveis)this.painelPai).tratarVisibilidadeAbaCalculo();
    }

    private void verificaSeTransmissaoCausaMortis() {
        ElementoTabela item;
        boolean transmissaoCausaMortis = false;
        if (((JComboBox)this.cmbNaturezaOperacao.getComponenteFoco()).getSelectedIndex() != -1 && AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS == Integer.valueOf((item = (ElementoTabela)((JComboBox)this.cmbNaturezaOperacao.getComponenteFoco()).getSelectedItem()).getConteudo(0))) {
            transmissaoCausaMortis = true;
        }
        if (transmissaoCausaMortis) {
            this.selecionarTipoTransmissaoCausaMortis();
        } else {
            this.lblDataAlienacao.setText("<html>Data de Aliena\u00e7\u00e3o <font color=red>*</font></html>");
            this.edtDataAlienacao.getAccessibleContext().setAccessibleName("Data de Aliena\u00e7\u00e3o");
            this.pnlDataTransitoJulgado.setVisible(false);
        }
        this.lblDadosSobre.setVisible(transmissaoCausaMortis);
        this.grpMotivoTCM.setVisible(transmissaoCausaMortis);
    }

    private void verificaSePaisAlienacaoIgualPaisIdDemonstrativo() {
        if (!this.alienacaoBemImovel.isPaisAlienacaoIgualDemonstrativo(ControladorGui.getDemonstrativoAberto().getIdDemonstrativo())) {
            if (this.alienacaoBemImovel.isAlienacaoEmAnoAnterior()) {
                this.alienacaoBemImovel.getNatureza().setReadOnly(true);
                this.alienacaoBemImovel.getNatureza().setHabilitado(false);
                this.alienacaoBemImovel.getDataAlienacao().setReadOnly(true);
                this.alienacaoBemImovel.getPaisResidencia().setReadOnly(true);
                this.alienacaoBemImovel.getPaisResidencia().setHabilitado(false);
            }
            this.panelPaisAlienacao.setVisible(true);
        } else {
            this.panelPaisAlienacao.setVisible(false);
        }
    }

    private void selecionarTipoTransmissaoCausaMortis() {
        if (this.alienacaoBemImovel.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals(Logico.SIM)) {
            this.lblDataAlienacao.setText("<html>Data da decis\u00e3o judicial <font color=red>*</font></html>");
            this.edtDataAlienacao.getAccessibleContext().setAccessibleName("Data da Decis\u00e3o Judicial");
            this.rdbMTCMDecisaoJudicial.setSelected(true);
            this.pnlDataTransitoJulgado.setVisible(true);
        } else {
            this.lblDataAlienacao.setText("<html>Data da Lavratura <font color=red>*</font></html>");
            this.edtDataAlienacao.getAccessibleContext().setAccessibleName("Data da Lavratura");
            this.rdbMTCMEscrituraPublica.setSelected(true);
            this.pnlDataTransitoJulgado.setVisible(false);
        }
    }

    private void criarListenersDataAlienacao() {
        ((JTextField)this.edtDataAlienacao.getComponenteFoco()).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PainelAbaOperacaoBemImovel.this.verificarDataAlienacao(true);
            }
        });
    }

    private void criarSubPanels() {
        this.painelOperacaoBrasil = new PainelOperacaoBrasil(this.alienacaoBemImovel);
        this.painelOperacaoExterior = new PainelOperacaoExterior(this.alienacaoBemImovel);
    }

    private void associarInformacao() {
        this.cmbNaturezaOperacao.setInformacao((Informacao)this.alienacaoBemImovel.getNatureza());
        this.edtDataAlienacao.setInformacao((Informacao)this.alienacaoBemImovel.getDataAlienacao());
        this.edtDataTransitoJulgado.setInformacao((Informacao)this.alienacaoBemImovel.getDataTransitoJulgado());
        this.grpMotivoTCM.setInformacao((Informacao)this.alienacaoBemImovel.getMotivoTransmissaoCausaMortisDecisaoJudicial());
        this.grpAlienacaoPrazo.setInformacao((Informacao)this.alienacaoBemImovel.getAlienacaoAPrazo());
        this.grpAlienacaoParcial.setInformacao((Informacao)this.alienacaoBemImovel.getAlienacaoParcial());
        this.edtPaisResidencia.setInformacao((Informacao)this.alienacaoBemImovel.getPaisResidencia());
        this.edtGanhoCapital.setInformacao((Informacao)this.alienacaoBemImovel.getGanhoCapitalAlienacaoAnterior());
        this.edtPaisAcordo.setInformacao((Informacao)this.alienacaoBemImovel.getPaisAcordo());
        this.edtValorImpostoReais.setInformacao((Informacao)this.alienacaoBemImovel.getValorImpostoExteriorReal());
    }

    public void verificarDataAlienacao(boolean exibirAlerta) {
        boolean usaAliquotaFixa = false;
        ElementoTabela item = (ElementoTabela)((JComboBox)this.cmbNaturezaOperacao.getComponenteFoco()).getSelectedItem();
        if (item != null && (AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA == Integer.valueOf(item.getConteudo(0)) || AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL == Integer.valueOf(item.getConteudo(0)) || AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS == Integer.valueOf(item.getConteudo(0)))) {
            usaAliquotaFixa = true;
        }
        if (this.alienacaoBemImovel.isAlienacaoEmAnoAnterior()) {
            if (exibirAlerta && !usaAliquotaFixa) {
                GuiUtil.mostrarAviso("MensagemAlienacaoDiferidaAnoAnterior", new String[]{AplicacaoPropertiesUtil.getExercicioAnterior(), AplicacaoPropertiesUtil.getExercicio()});
            }
            this.verificaSeExibePerguntaAlienacaoParcial();
        } else if (usaAliquotaFixa) {
            this.pnlAlienacaoParcial.setVisible(false);
        } else {
            this.pnlAlienacaoParcial.setVisible(true);
        }
    }

    private void verificaSeNaturezaSemAlienacaoAPrazo() {
        int codNaturezaNovo = -1;
        boolean usaAliquotaFixa = false;
        try {
            ElementoTabela elementoSelecionado = (ElementoTabela)((JComboBox)this.cmbNaturezaOperacao.getComponenteFoco()).getSelectedItem();
            codNaturezaNovo = Integer.valueOf(elementoSelecionado.getConteudo(0));
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        if (codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || codNaturezaNovo == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA) {
            usaAliquotaFixa = true;
        }
        if (usaAliquotaFixa) {
            this.grpAlienacaoPrazo.setFocusable(false);
            this.rdbPrazoSim.setEnabled(false);
            this.rdbPrazoNao.setEnabled(false);
            this.alienacaoBemImovel.getAlienacaoParcial().clear();
            this.grpAlienacaoParcial.getGroup().clearSelection();
            this.exibirGanhoCapitalAlienacaoAnterior();
            this.pnlAlienacaoParcial.setVisible(false);
        } else if (this.alienacaoBemImovel.isAlienacaoEmAnoAnterior()) {
            this.grpAlienacaoPrazo.setFocusable(false);
            this.rdbPrazoSim.setEnabled(false);
            this.rdbPrazoNao.setEnabled(false);
            this.verificaSeExibePerguntaAlienacaoParcial();
        } else {
            this.grpAlienacaoPrazo.setFocusable(true);
            this.rdbPrazoSim.setEnabled(true);
            this.rdbPrazoNao.setEnabled(true);
            this.pnlAlienacaoParcial.setVisible(true);
        }
    }

    private void limparPerguntaHouveReformaAquisicao() {
        PainelDadosBensImoveis painelDados = (PainelDadosBensImoveis)this.painelPai;
        this.alienacaoBemImovel.getBemImovel().getAquisicao().getHouveReforma().clear();
        if (this.alienacaoBemImovel.getBemImovel().isAdquiridoNoBrasil()) {
            painelDados.getPainelAbaAquisicao().getPainelAquisicaoBemImovelBrasil().getGrpAquisicaoParcelada().getGroup().clearSelection();
        } else {
            painelDados.getPainelAbaAquisicao().getPainelAquisicaoBemImovelExterior().getGrpAquisicaoParcelada().getGroup().clearSelection();
        }
    }

    public void exibirPaineis() {
        this.verificarDataAlienacao(false);
        this.verificaSeTransmissaoCausaMortis();
        if (this.alienacaoBemImovel.getBemImovel().isAdquiridoNoBrasil()) {
            this.flipOperacao.exibeComponenteA();
            this.painelImpostoExterior.setVisible(false);
        } else {
            this.flipOperacao.exibeComponenteB();
            this.painelImpostoExterior.setVisible(true);
        }
        this.painelOperacaoBrasil.exibirTorna();
        this.painelOperacaoExterior.exibirValoresReal();
        this.painelOperacaoExterior.exibirTorna();
    }

    private void exibirGanhoCapitalAlienacaoAnterior() {
        if (this.alienacaoBemImovel.temAlienacaoParcial()) {
            this.edtGanhoCapital.setVisible(true);
            this.lblGanhoCapital.setVisible(true);
            this.infoAlienacaoAnterior.setVisible(true);
        } else {
            this.edtGanhoCapital.setVisible(false);
            this.lblGanhoCapital.setVisible(false);
            this.infoAlienacaoAnterior.setVisible(false);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.painelImpostoExterior = new JPanel();
        this.edtPaisAcordo = new JAutoCompleteEditCodigo();
        this.jLabel9 = new JLabel();
        this.edtValorImpostoReais = new JEditValor();
        this.jLabel13 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.cmbNaturezaOperacao = new JAutoCompleteEditCodigo();
        this.flipOperacao = new JFlipComponentes();
        this.pnlDataTransitoJulgado = new JPanel();
        this.lblDataTransitoJulgado = new JLabel();
        this.edtDataTransitoJulgado = new JEditData();
        this.pnlAlienacaoParcial = new JPanel();
        this.jLabel7 = new JLabel();
        this.grpAlienacaoParcial = new JButtonGroupPanel();
        this.rdbParcialSim = new PPGDRadioItem();
        this.rdbParcialNao = new PPGDRadioItem();
        this.lblGanhoCapital = new JLabel();
        this.edtGanhoCapital = new JEditValor();
        this.infoAlienacaoAnterior = new GCAPLabelInfo();
        this.jLabel1 = new JLabel();
        this.panelPaisAlienacao = new JPanel();
        this.jLabel10 = new JLabel();
        this.edtPaisResidencia = new JAutoCompleteEditCodigo();
        this.grpMotivoTCM = new JButtonGroupPanel();
        this.rdbMTCMDecisaoJudicial = new PPGDRadioItem();
        this.rdbMTCMEscrituraPublica = new PPGDRadioItem();
        this.lblDadosSobre = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.grpAlienacaoPrazo = new JButtonGroupPanel();
        this.rdbPrazoSim = new PPGDRadioItem();
        this.rdbPrazoNao = new PPGDRadioItem();
        this.lblDataAlienacao = new JLabel();
        this.edtDataAlienacao = new JEditData();
        this.lblTitulo1 = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.painelImpostoExterior.setBackground(new Color(255, 255, 255));
        this.painelImpostoExterior.setBorder(BorderFactory.createTitledBorder(null, "Imposto Pago no Exterior", 0, 0, new Font("Dialog", 0, 12), new Color(0, 102, 153)));
        this.jLabel9.setText("<html>Pa\u00eds com Acordo Internacional/Reciprocidade de Tratamento <font color=red>*</font></html>");
        this.jLabel13.setText("<html>Valor do Imposto em Reais <font color=red>*</font></html>");
        GroupLayout painelImpostoExteriorLayout = new GroupLayout(this.painelImpostoExterior);
        this.painelImpostoExterior.setLayout(painelImpostoExteriorLayout);
        painelImpostoExteriorLayout.setHorizontalGroup(painelImpostoExteriorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelImpostoExteriorLayout.createSequentialGroup().addContainerGap().addGroup(painelImpostoExteriorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtPaisAcordo, -2, 363, -2).addComponent(this.jLabel13, -2, -1, -2).addComponent((Component)this.edtValorImpostoReais, -2, 144, -2).addComponent(this.jLabel9, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        painelImpostoExteriorLayout.setVerticalGroup(painelImpostoExteriorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelImpostoExteriorLayout.createSequentialGroup().addGroup(painelImpostoExteriorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelImpostoExteriorLayout.createSequentialGroup().addGap(33, 33, 33).addComponent((Component)this.edtPaisAcordo, -2, 19, -2)).addGroup(painelImpostoExteriorLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel13, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorImpostoReais, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.edtPaisAcordo.getAccessibleContext().setAccessibleName("Pa\u00eds com Acordo Internacional/Reciprocidade de Tratament");
        this.edtValorImpostoReais.getAccessibleContext().setAccessibleName("Valor do Imposto em Reais");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel8.setText("<html>Natureza <font color=red>*</font></html>");
        this.flipOperacao.setComponenteA((JComponent)this.painelOperacaoBrasil);
        this.flipOperacao.setComponenteB((JComponent)this.painelOperacaoExterior);
        this.pnlDataTransitoJulgado.setBackground(Color.white);
        this.lblDataTransitoJulgado.setText("<html>Data do tr\u00e2nsito em julgado<font color=red>*</font></html>");
        GroupLayout pnlDataTransitoJulgadoLayout = new GroupLayout(this.pnlDataTransitoJulgado);
        this.pnlDataTransitoJulgado.setLayout(pnlDataTransitoJulgadoLayout);
        pnlDataTransitoJulgadoLayout.setHorizontalGroup(pnlDataTransitoJulgadoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDataTransitoJulgado, -2, -1, -2).addComponent((Component)this.edtDataTransitoJulgado, -2, 141, -2));
        pnlDataTransitoJulgadoLayout.setVerticalGroup(pnlDataTransitoJulgadoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDataTransitoJulgadoLayout.createSequentialGroup().addComponent(this.lblDataTransitoJulgado, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDataTransitoJulgado, -2, -1, -2)));
        this.edtDataTransitoJulgado.getAccessibleContext().setAccessibleName("Data do tr\u00e2nsito em julgado");
        this.pnlAlienacaoParcial.setBackground(Color.white);
        this.pnlAlienacaoParcial.setBorder(null);
        this.jLabel7.setText("<html>J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem? <font color=red>*</font></html>");
        this.grpAlienacaoParcial.setBorder(null);
        this.grpAlienacaoParcial.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelAbaOperacaoBemImovel.this.grpAlienacaoParcialAtualizaPainel(evt);
            }
        });
        this.rdbParcialSim.setBackground(new Color(255, 255, 255));
        this.rdbParcialSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbParcialSim.setText("Sim");
        this.rdbParcialSim.setValorSelecionadoTrue(Logico.SIM);
        this.rdbParcialNao.setBackground(new Color(255, 255, 255));
        this.rdbParcialNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbParcialNao.setText("N\u00e3o");
        this.rdbParcialNao.setValorSelecionadoTrue(Logico.NAO);
        GroupLayout grpAlienacaoParcialLayout = new GroupLayout((Container)this.grpAlienacaoParcial);
        this.grpAlienacaoParcial.setLayout((LayoutManager)grpAlienacaoParcialLayout);
        grpAlienacaoParcialLayout.setHorizontalGroup(grpAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAlienacaoParcialLayout.createSequentialGroup().addComponent((Component)this.rdbParcialSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbParcialNao, -2, -1, -2).addContainerGap(44, Short.MAX_VALUE)));
        grpAlienacaoParcialLayout.setVerticalGroup(grpAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAlienacaoParcialLayout.createSequentialGroup().addGroup(grpAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbParcialSim, -2, -1, -2).addComponent((Component)this.rdbParcialNao, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.rdbParcialSim.getAccessibleContext().setAccessibleName("J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem? Sim");
        this.rdbParcialNao.getAccessibleContext().setAccessibleName("J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem? N\u00e3o");
        this.lblGanhoCapital.setText("<html>Ganho de capital da aliena\u00e7\u00e3o anterior - (R$) <font color=red>*</font></html>");
        this.infoAlienacaoAnterior.setMensagem(MensagemUtil.getMensagemComQuebraDeLinha("infoGCAPApos0101exercicioAnterior", new String[]{AplicacaoPropertiesUtil.getExercicioAnterior()}));
        GroupLayout pnlAlienacaoParcialLayout = new GroupLayout(this.pnlAlienacaoParcial);
        this.pnlAlienacaoParcial.setLayout(pnlAlienacaoParcialLayout);
        pnlAlienacaoParcialLayout.setHorizontalGroup(pnlAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAlienacaoParcialLayout.createSequentialGroup().addGroup(pnlAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -2, -1, -2).addComponent((Component)this.grpAlienacaoParcial, -2, -1, -2)).addGap(34, 34, 34).addGroup(pnlAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAlienacaoParcialLayout.createSequentialGroup().addGap(3, 3, 3).addComponent((Component)this.edtGanhoCapital, -2, 144, -2).addGap(3, 3, 3).addComponent(this.infoAlienacaoAnterior, -2, -1, -2)).addComponent(this.lblGanhoCapital, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        pnlAlienacaoParcialLayout.setVerticalGroup(pnlAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAlienacaoParcialLayout.createSequentialGroup().addComponent(this.jLabel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpAlienacaoParcial, -1, -1, Short.MAX_VALUE)).addGroup(pnlAlienacaoParcialLayout.createSequentialGroup().addComponent(this.lblGanhoCapital, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAlienacaoParcialLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtGanhoCapital, -2, -1, -2).addComponent(this.infoAlienacaoAnterior, -2, -1, -2))));
        this.edtGanhoCapital.getAccessibleContext().setAccessibleName("Ganho de capital da aliena\u00e7\u00e3o anterior em reais");
        this.jLabel1.setText("          ");
        this.panelPaisAlienacao.setBackground(Color.white);
        this.panelPaisAlienacao.setBorder(null);
        this.jLabel10.setText("<html>Pa\u00eds de resid\u00eancia no ato da aliena\u00e7\u00e3o</html>");
        GroupLayout panelPaisAlienacaoLayout = new GroupLayout(this.panelPaisAlienacao);
        this.panelPaisAlienacao.setLayout(panelPaisAlienacaoLayout);
        panelPaisAlienacaoLayout.setHorizontalGroup(panelPaisAlienacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPaisAlienacaoLayout.createSequentialGroup().addGroup(panelPaisAlienacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -2, -1, -2).addComponent((Component)this.edtPaisResidencia, -2, 280, -2)).addContainerGap(120, Short.MAX_VALUE)));
        panelPaisAlienacaoLayout.setVerticalGroup(panelPaisAlienacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPaisAlienacaoLayout.createSequentialGroup().addComponent(this.jLabel10, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtPaisResidencia, -2, 19, -2)));
        this.edtPaisResidencia.getAccessibleContext().setAccessibleName("Pa\u00eds de resid\u00eancia no ato da aliena\u00e7\u00e3o");
        this.grpMotivoTCM.setBorder(null);
        this.grpMotivoTCM.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelAbaOperacaoBemImovel.this.grpMotivoTCMAtualizaPainel(evt);
            }
        });
        this.rdbMTCMDecisaoJudicial.setBackground(new Color(255, 255, 255));
        this.rdbMTCMDecisaoJudicial.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbMTCMDecisaoJudicial.setText("Decis\u00e3o Judicial");
        this.rdbMTCMDecisaoJudicial.setValorSelecionadoTrue(Logico.SIM);
        this.rdbMTCMDecisaoJudicial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbaOperacaoBemImovel.this.rdbMTCMDecisaoJudicialActionPerformed(evt);
            }
        });
        this.rdbMTCMEscrituraPublica.setBackground(new Color(255, 255, 255));
        this.rdbMTCMEscrituraPublica.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbMTCMEscrituraPublica.setText("Escritura P\u00fablica");
        this.rdbMTCMEscrituraPublica.setValorSelecionadoTrue(Logico.NAO);
        GroupLayout grpMotivoTCMLayout = new GroupLayout((Container)this.grpMotivoTCM);
        this.grpMotivoTCM.setLayout((LayoutManager)grpMotivoTCMLayout);
        grpMotivoTCMLayout.setHorizontalGroup(grpMotivoTCMLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpMotivoTCMLayout.createSequentialGroup().addComponent((Component)this.rdbMTCMDecisaoJudicial, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbMTCMEscrituraPublica, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpMotivoTCMLayout.setVerticalGroup(grpMotivoTCMLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpMotivoTCMLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbMTCMDecisaoJudicial, -2, -1, -2).addComponent((Component)this.rdbMTCMEscrituraPublica, -2, -1, -2)));
        this.rdbMTCMDecisaoJudicial.getAccessibleContext().setAccessibleName("Dados sobre: Decis\u00e3o Judicial");
        this.rdbMTCMEscrituraPublica.getAccessibleContext().setAccessibleName("Dados sobre: Escritura P\u00fablica");
        this.lblDadosSobre.setText("<html>Dados sobre: <font color=red>*</font></html>");
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(null);
        this.jLabel5.setText("<html>A aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o? <font color=red>*</font></html>");
        this.grpAlienacaoPrazo.setBorder(null);
        this.grpAlienacaoPrazo.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelAbaOperacaoBemImovel.this.grpAlienacaoPrazoAtualizaPainel(evt);
            }
        });
        this.rdbPrazoSim.setBackground(new Color(255, 255, 255));
        this.rdbPrazoSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbPrazoSim.setText("Sim");
        this.rdbPrazoSim.setValorSelecionadoTrue(Logico.SIM);
        this.rdbPrazoNao.setBackground(new Color(255, 255, 255));
        this.rdbPrazoNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbPrazoNao.setText("N\u00e3o");
        this.rdbPrazoNao.setValorSelecionadoTrue(Logico.NAO);
        GroupLayout grpAlienacaoPrazoLayout = new GroupLayout((Container)this.grpAlienacaoPrazo);
        this.grpAlienacaoPrazo.setLayout((LayoutManager)grpAlienacaoPrazoLayout);
        grpAlienacaoPrazoLayout.setHorizontalGroup(grpAlienacaoPrazoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAlienacaoPrazoLayout.createSequentialGroup().addComponent((Component)this.rdbPrazoSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbPrazoNao, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpAlienacaoPrazoLayout.setVerticalGroup(grpAlienacaoPrazoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpAlienacaoPrazoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.rdbPrazoSim, -2, -1, -2).addComponent((Component)this.rdbPrazoNao, -2, -1, -2)));
        this.rdbPrazoSim.getAccessibleContext().setAccessibleName("A aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o? Sim");
        this.rdbPrazoNao.getAccessibleContext().setAccessibleName("A aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o? N\u00e3o");
        this.lblDataAlienacao.setText("<html>Data de aliena\u00e7\u00e3o <font color=red>*</font></html>");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, -1, -2).addComponent((Component)this.grpAlienacaoPrazo, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtDataAlienacao, -2, 141, -2).addComponent(this.lblDataAlienacao, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpAlienacaoPrazo, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblDataAlienacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDataAlienacao, -2, -1, -2)));
        this.edtDataAlienacao.getAccessibleContext().setAccessibleName("Data de Aliena\u00e7\u00e3o");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.flipOperacao, -1, -1, Short.MAX_VALUE).addComponent(this.pnlAlienacaoParcial, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, -2, -1, -2).addComponent((Component)this.cmbNaturezaOperacao, -2, 363, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.grpMotivoTCM, -2, -1, -2).addComponent(this.lblDadosSobre, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlDataTransitoJulgado, -2, -1, -2)).addComponent(this.jLabel1).addComponent(this.panelPaisAlienacao, -2, -1, -2)).addGap(0, 231, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.lblDadosSobre, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.cmbNaturezaOperacao, -2, 19, -2).addComponent((Component)this.grpMotivoTCM, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pnlDataTransitoJulgado, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelPaisAlienacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.flipOperacao, -1, 20, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlAlienacaoParcial, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)));
        this.cmbNaturezaOperacao.getAccessibleContext().setAccessibleName("Natureza");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.painelImpostoExterior, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.painelImpostoExterior, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblTitulo1.setFont(new Font("DejaVu Sans", 1, 13));
        this.lblTitulo1.setForeground(new Color(107, 151, 9));
        this.lblTitulo1.setText("Dados da Opera\u00e7\u00e3o");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblTitulo1, -2, 148, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblTitulo1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void grpAlienacaoParcialAtualizaPainel(GroupPanelEvent evt) {
        this.exibirGanhoCapitalAlienacaoAnterior();
    }

    private void grpAlienacaoPrazoAtualizaPainel(GroupPanelEvent evt) {
        this.verificaSeHabilitaAbaCalculo();
    }

    private void rdbMTCMDecisaoJudicialActionPerformed(ActionEvent evt) {
    }

    private void grpMotivoTCMAtualizaPainel(GroupPanelEvent evt) {
        this.selecionarTipoTransmissaoCausaMortis();
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return null;
    }

    @Override
    public PainelDemonstrativoIf getPainelPai() {
        return null;
    }
}

