/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensimoveis.perguntas;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.perguntas.PerguntasImovel;
import br.gov.serpro.gcap.entidades.perguntas.PerguntasUtil;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.bensimoveis.perguntas.PainelPerguntaConjuntoBensSuperior35Mil;
import br.gov.serpro.gcap.gui.bensimoveis.perguntas.PainelPerguntaImovelResidencial;
import br.gov.serpro.gcap.gui.bensimoveis.perguntas.PainelPerguntaIndicadorPropriedadeOutroImovel;
import br.gov.serpro.gcap.gui.bensimoveis.perguntas.PainelPerguntaMP252;
import br.gov.serpro.gcap.gui.bensimoveis.perguntas.PainelPerguntaOutraAlienacao5anos;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorTela;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelAbaPerguntas
extends PainelDemonstrativoAb
implements PainelAbaIf {
    public static final String NOME_ABA = "Perguntas";
    private static final long serialVersionUID = 1L;
    private AlienacaoBemImovel alienacaoBemImovel = null;
    private PerguntasImovel perguntas = null;
    private boolean inicializando = false;
    private PainelDemonstrativoIf painelPai;
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem Im\u00f3vel/Perguntas";
    private JLabel lblTitulo1;
    private PainelPerguntaConjuntoBensSuperior35Mil painelPerguntaConjuntoBensSuperior35Mil;
    private PainelPerguntaImovelResidencial painelPerguntaImovelResidencial;
    private PainelPerguntaIndicadorPropriedadeOutroImovel painelPerguntaIndicadorPropriedadeOutroImovel;
    private PainelPerguntaMP252 painelPerguntaMP252;
    private PainelPerguntaOutraAlienacao5anos painelPerguntaOutraAlienacao5anos;
    private JPanel painelPerguntas;

    private void initComponents() {
        this.painelPerguntas = new JPanel();
        this.painelPerguntaConjuntoBensSuperior35Mil = new PainelPerguntaConjuntoBensSuperior35Mil();
        this.painelPerguntaIndicadorPropriedadeOutroImovel = new PainelPerguntaIndicadorPropriedadeOutroImovel();
        this.painelPerguntaOutraAlienacao5anos = new PainelPerguntaOutraAlienacao5anos();
        this.painelPerguntaImovelResidencial = new PainelPerguntaImovelResidencial();
        this.painelPerguntaMP252 = new PainelPerguntaMP252();
        this.lblTitulo1 = new JLabel();
        this.painelPerguntas.setBackground(new Color(255, 255, 255));
        this.painelPerguntas.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        GroupLayout painelPerguntasLayout = new GroupLayout(this.painelPerguntas);
        this.painelPerguntas.setLayout(painelPerguntasLayout);
        painelPerguntasLayout.setHorizontalGroup(painelPerguntasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelPerguntasLayout.createSequentialGroup().addContainerGap().addGroup(painelPerguntasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.painelPerguntaConjuntoBensSuperior35Mil, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.painelPerguntaIndicadorPropriedadeOutroImovel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.painelPerguntaOutraAlienacao5anos, -2, 0, Short.MAX_VALUE).addComponent(this.painelPerguntaImovelResidencial, -1, -1, Short.MAX_VALUE).addComponent(this.painelPerguntaMP252, -1, -1, Short.MAX_VALUE)).addContainerGap(79, Short.MAX_VALUE)));
        painelPerguntasLayout.setVerticalGroup(painelPerguntasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelPerguntasLayout.createSequentialGroup().addContainerGap().addComponent(this.painelPerguntaConjuntoBensSuperior35Mil, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.painelPerguntaIndicadorPropriedadeOutroImovel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.painelPerguntaOutraAlienacao5anos, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.painelPerguntaImovelResidencial, -2, -1, -2).addGap(0, 0, 0).addComponent(this.painelPerguntaMP252, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblTitulo1.setFont(new Font("DejaVu Sans", 1, 13));
        this.lblTitulo1.setForeground(new Color(107, 151, 9));
        this.lblTitulo1.setText(NOME_ABA);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitulo1).addComponent(this.painelPerguntas, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitulo1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.painelPerguntas, -1, -1, Short.MAX_VALUE).addGap(25, 25, 25)));
    }

    public PainelAbaPerguntas(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
        this.alienacaoBemImovel = (AlienacaoBemImovel)((PainelComAbasAb)this.painelPai).getDataSource();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.initComponents();
        this.initComponents();
        this.iniciarComponentes();
        this.configObservadores();
        this.setUpAcessibilidade();
        this.inicializando = true;
        this.tratarExibicaoPerguntas();
        this.inicializando = false;
    }

    private void configObservadores() {
        this.alienacaoBemImovel.getDataAlienacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                PainelAbaPerguntas.this.atualizarLabelPerguntasBemSuperior35Mil();
            }
        });
        this.painelPerguntaConjuntoBensSuperior35Mil.getFlagConjuntoBensSuperior35Mil().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object pSource, String string, Object o1, Object o2) {
                PainelAbaPerguntas.this.processarRespostaPerguntaConjuntoBensSuperior35Mil();
            }
        });
        this.painelPerguntaImovelResidencial.getEdtFlagImovelResidencial().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaPerguntas.this.tratarExibicaoPerguntaMP252();
            }
        });
        this.painelPerguntaIndicadorPropriedadeOutroImovel.getFlagPossuiOutroImovel().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaPerguntas.this.tratarExibirPerguntaOutraAlienacao5anos(observado.toString());
            }
        });
        this.painelPerguntaOutraAlienacao5anos.getFlagOutraAlienacao().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object pSource, String string, Object o1, Object o2) {
                PainelAbaPerguntas.this.tratarExibicaoPerguntaMP252();
            }
        });
        this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object pSource, String pValor, Object o1, Object o2) {
                PainelAbaPerguntas.this.tratarIndMP252();
            }
        });
        this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252Parte2().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object pSource, String pValor, Object o1, Object o2) {
                PainelAbaPerguntas.this.tratarIndMP252();
            }
        });
        this.painelPerguntaMP252.getEdtValorReaplicacaoMP252().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object pSource, String pValor, Object o1, Object o2) {
            }
        });
        this.painelPerguntaImovelResidencial.getEdtFlagImovelResidencial().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaPerguntas.this.tratarExibicaoPerguntas();
            }
        });
        this.painelPerguntaOutraAlienacao5anos.getFlagOutraAlienacao().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaPerguntas.this.tratarExibicaoPerguntas();
            }
        });
        this.painelPerguntaIndicadorPropriedadeOutroImovel.getFlagPossuiOutroImovel().getInformacao().addObservador((Observador)new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelAbaPerguntas.this.tratarExibicaoPerguntaImovelResidencial();
            }
        });
    }

    private void atualizarLabelPerguntasBemSuperior35Mil() {
        this.painelPerguntaConjuntoBensSuperior35Mil.ajustarMensagem(this.alienacaoBemImovel.getDataAlienacao());
    }

    private void processarRespostaPerguntaConjuntoBensSuperior35Mil() {
        this.tratarExibicaoPerguntaImovelResidencial();
        this.tratarExibicaoPerguntaMP252();
        if (!this.inicializando) {
            // empty if block
        }
    }

    private void tratarExibirPerguntaOutraAlienacao5anos(String pResposta) {
        if ("0".equals(pResposta)) {
            this.painelPerguntaOutraAlienacao5anos.setVisible(true);
        } else {
            this.painelPerguntaOutraAlienacao5anos.setVisible(false);
            this.perguntas.getOutraAlienacao().clear();
        }
        this.tratarExibicaoPerguntaMP252();
        if (!this.inicializando) {
            // empty if block
        }
    }

    public void tratarExibicaoPerguntas() {
        this.tratarExibicaoPerguntaConjuntoBensSuperior35Mil();
        this.tratarExibicaoPerguntaPropriedadeOutroImovel();
        this.tratarExibicaoPerguntaImovelResidencial();
        this.tratarExibicaoPerguntaMP252();
        this.tratarIndMP252();
        this.tratarExibirPerguntaOutraAlienacao5anos(this.perguntas.getPropriedadeOutroImovel().formatado());
        this.tratarIndMP252();
    }

    private void tratarExibicaoPerguntaImovelResidencial() {
        if (GCAPFacade.getInstancia().deveExibirPerguntaImovelResidencial(this.alienacaoBemImovel)) {
            this.painelPerguntaImovelResidencial.setVisible(true);
        } else {
            this.painelPerguntaImovelResidencial.setVisible(false);
            this.perguntas.getImovelResidencial().clear();
        }
    }

    private void tratarExibicaoPerguntaConjuntoBensSuperior35Mil() {
        if (this.alienacaoBemImovel.podeResponderPerguntaBemIsentoPorPequenoValor()) {
            this.painelPerguntaConjuntoBensSuperior35Mil.setVisible(true);
        } else {
            this.painelPerguntaConjuntoBensSuperior35Mil.setVisible(false);
            this.alienacaoBemImovel.getBemGrandeValor().clear();
        }
        this.atualizarLabelPerguntasBemSuperior35Mil();
    }

    private void tratarExibicaoPerguntaPropriedadeOutroImovel() {
        if (GCAPFacade.getInstancia().deveExibirPerguntaPossuiOutroImovel(this.alienacaoBemImovel)) {
            this.painelPerguntaIndicadorPropriedadeOutroImovel.setVisible(true);
        } else {
            this.painelPerguntaIndicadorPropriedadeOutroImovel.setVisible(false);
            this.perguntas.getPropriedadeOutroImovel().clear();
        }
    }

    public void tratarExibicaoPerguntaMP252() {
        boolean exibir = GCAPFacade.getInstancia().deveExibirPerguntaMP252(this.alienacaoBemImovel);
        if (exibir) {
            this.painelPerguntaMP252.setVisible(true);
        } else {
            this.painelPerguntaMP252.setVisible(false);
            this.perguntas.getMP252().clear();
            this.alienacaoBemImovel.getValorAplicado().clear();
        }
    }

    public void tratarIndMP252() {
        if (!this.perguntas.isValorReaplicavel()) {
            this.perguntas.getMP252Parte2().clear();
            this.painelPerguntaMP252.getEdtValorReaplicacaoMP252().getInformacao().clear();
        }
        if (this.perguntas.isValorReaplicadoParcialmente()) {
            this.alienacaoBemImovel.getValorAplicado().setReadOnly(false);
        } else if (this.perguntas.isValorReaplicadoTotalmente()) {
            this.painelPerguntaMP252.getEdtValorReaplicacaoMP252().getInformacao().setConteudo(PerguntasUtil.getInstancia().obterValorLiquidoAlienacao(this.alienacaoBemImovel).formatado());
            this.alienacaoBemImovel.getValorAplicado().setReadOnly(true);
        } else {
            this.painelPerguntaMP252.getEdtValorReaplicacaoMP252().getInformacao().setConteudo("0");
            this.alienacaoBemImovel.getValorAplicado().setReadOnly(true);
        }
        this.tratarIndMP252Anterior();
    }

    public void tratarIndMP252Anterior() {
        if (this.perguntas.isValorReaplicado()) {
            this.painelPerguntaMP252.getPanelPerguntaAlienacaoAnterior().setVisible(true);
            this.painelPerguntaMP252.getPanelPerguntaMP252Parte2().setVisible(true);
            if (this.alienacaoBemImovel.getPerguntas().getMP252PrimeiraAlienacao().isVazio()) {
                this.alienacaoBemImovel.getPerguntas().getDataPrimeiraAlienacao().clear();
                this.alienacaoBemImovel.getPerguntas().getDataPrimeiraAlienacao().setReadOnly(true);
            }
        } else if (this.perguntas.isValorReaplicavel()) {
            this.painelPerguntaMP252.getPanelPerguntaMP252Parte2().setVisible(true);
            this.painelPerguntaMP252.getPanelPerguntaAlienacaoAnterior().setVisible(false);
            this.alienacaoBemImovel.getPerguntas().getMP252PrimeiraAlienacao().clear();
            this.alienacaoBemImovel.getPerguntas().getDataPrimeiraAlienacao().clear();
        } else {
            this.painelPerguntaMP252.getPanelPerguntaAlienacaoAnterior().setVisible(false);
            this.painelPerguntaMP252.getPanelPerguntaMP252Parte2().setVisible(false);
            this.alienacaoBemImovel.getPerguntas().getMP252Parte2().clear();
            this.alienacaoBemImovel.getPerguntas().getMP252PrimeiraAlienacao().clear();
            this.alienacaoBemImovel.getPerguntas().getDataPrimeiraAlienacao().clear();
        }
    }

    protected void iniciarComponentes() {
        this.perguntas = this.alienacaoBemImovel.getPerguntas();
        this.painelPerguntaConjuntoBensSuperior35Mil.getFlagConjuntoBensSuperior35Mil().setInformacao((Informacao)this.alienacaoBemImovel.getBemGrandeValor());
        this.painelPerguntaIndicadorPropriedadeOutroImovel.getFlagPossuiOutroImovel().setInformacao((Informacao)this.perguntas.getPropriedadeOutroImovel());
        this.painelPerguntaOutraAlienacao5anos.getFlagOutraAlienacao().setInformacao((Informacao)this.perguntas.getOutraAlienacao());
        this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252().setInformacao((Informacao)this.perguntas.getMP252());
        this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252Parte2().setInformacao((Informacao)this.perguntas.getMP252Parte2());
        this.painelPerguntaMP252.getEdtValorReaplicacaoMP252().setInformacao((Informacao)this.alienacaoBemImovel.getValorAplicado());
        this.painelPerguntaMP252.getEdtFlagPerguntaMP252Anterior().setInformacao((Informacao)this.perguntas.getMP252PrimeiraAlienacao());
        this.painelPerguntaMP252.getEdtDataAlienacaoAnterior().setInformacao((Informacao)this.perguntas.getDataPrimeiraAlienacao());
        this.painelPerguntaImovelResidencial.getEdtFlagImovelResidencial().setInformacao((Informacao)this.perguntas.getImovelResidencial());
    }

    @Override
    public void aposCriarAbas() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNomeAba() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PainelDemonstrativoIf getPainelPai() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDefaultFocus() {
        if (this.painelPerguntaConjuntoBensSuperior35Mil.isVisible()) {
            GuiUtil.focusJEditLogico(this.painelPerguntaConjuntoBensSuperior35Mil.getFlagConjuntoBensSuperior35Mil());
        } else if (this.painelPerguntaIndicadorPropriedadeOutroImovel.isVisible()) {
            GuiUtil.focusJEditLogico(this.painelPerguntaIndicadorPropriedadeOutroImovel.getFlagPossuiOutroImovel());
        } else if (this.painelPerguntaOutraAlienacao5anos.isVisible()) {
            GuiUtil.focusJEditLogico(this.painelPerguntaOutraAlienacao5anos.getFlagOutraAlienacao());
        } else if (this.painelPerguntaImovelResidencial.isVisible()) {
            GuiUtil.focusJEditLogico(this.painelPerguntaImovelResidencial.getEdtFlagImovelResidencial());
        } else if (this.painelPerguntaMP252.isVisible()) {
            GuiUtil.focusJEditLogico(this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252());
        }
    }

    private void setUpAcessibilidade() {
        String msgBemPequenoValor = PainelPerguntaConjuntoBensSuperior35Mil.getPerguntaConfirmacaoValorAlienacaoVersusLimiteIsencao(this.alienacaoBemImovel.getDataAlienacao(), "35.000,00");
        this.painelPerguntaConjuntoBensSuperior35Mil.getFlagConjuntoBensSuperior35Mil().getAccessibleContext().setAccessibleName(msgBemPequenoValor);
        this.painelPerguntaIndicadorPropriedadeOutroImovel.getFlagPossuiOutroImovel().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_PERGUNTA_POSSUI_OUTRO_IMOVEL);
        this.painelPerguntaOutraAlienacao5anos.getFlagOutraAlienacao().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_PERGUNTA_ALIENOU_OUTRO_IMOVEL_5_ANOS);
        this.painelPerguntaImovelResidencial.getEdtFlagImovelResidencial().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_PERGUNTA_IMOVEL_RESIDENCIAL);
        this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_PERGUNTA_VALOR_REAPLICADO);
        this.painelPerguntaMP252.getEdtFlagValorReaplicadoMP252Parte2().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_PERGUNTA_VALOR_REAPLICADO_PARTE2);
        this.painelPerguntaMP252.getEdtFlagPerguntaMP252Anterior().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_PERGUNTA_VALOR_REAPLICADO_ALIENACAO_ANTERIOR);
        this.painelPerguntaMP252.getEdtDataAlienacaoAnterior().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_DATA_PRIMEIRA_ALIENACAO);
        this.painelPerguntaMP252.getEdtValorReaplicacaoMP252().getAccessibleContext().setAccessibleName(PerguntasImovel.TXT_ACESSIVEL_VALOR_REAPLICADO);
    }
}

