/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensmoveis;

import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.NavegacaoIf;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.bensmoveis.adquirente.PainelAbaListaAdquirente;
import br.gov.serpro.gcap.gui.bensmoveis.apuracao.PainelAbaApuracaoBemMovel;
import br.gov.serpro.gcap.gui.bensmoveis.calculoimposto.PainelAbaCalculoImpostoBemMovel;
import br.gov.serpro.gcap.gui.bensmoveis.consolidacao.PainelAbaConsolidacao;
import br.gov.serpro.gcap.gui.bensmoveis.identificacao.PainelAbaIdentificacaoBemMovel;
import br.gov.serpro.gcap.gui.bensmoveis.operacao.PainelAbaOperacaoBemMovel;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import javax.swing.JComponent;
import serpro.ppgd.infraestrutura.PlataformaPPGD;

public class PainelDadosBensMoveis
extends PainelComAbasAb {
    public static String TITULO = "Direitos/Bens M\u00f3veis";
    private static final long serialVersionUID = 1L;
    private PainelAbaIdentificacaoBemMovel painelAbaIdentificacao;
    private PainelAbaListaAdquirente painelAbaAdquirente;
    private PainelAbaOperacaoBemMovel painelAbaOperacaoBemMovel;
    private PainelAbaApuracaoBemMovel painelAbaApuracaoBemMovel;
    private PainelAbaCalculoImpostoBemMovel painelAbaCalculoImpostoBemMovel;
    private PainelAbaConsolidacao painelAbaConsolidacao;
    private AlienacaoBemMovel alienacaoBemMovel;

    public PainelDadosBensMoveis(AlienacaoBemMovel alienacaoBemMovel) {
        super(alienacaoBemMovel);
        this.alienacaoBemMovel = alienacaoBemMovel;
        this.montarAbas();
        this.configurarHelpID();
        this.acionarAba("Identifica\u00e7\u00e3o/Aquisi\u00e7\u00e3o", true);
        this.exibirMensagemValorecebidoAnoAnterior();
    }

    @Override
    protected void montarAbas() {
        this.painelAbaIdentificacao = new PainelAbaIdentificacaoBemMovel(this);
        this.painelAbaAdquirente = new PainelAbaListaAdquirente(this);
        this.painelAbaApuracaoBemMovel = new PainelAbaApuracaoBemMovel(this);
        this.painelAbaCalculoImpostoBemMovel = new PainelAbaCalculoImpostoBemMovel(this);
        this.painelAbaOperacaoBemMovel = new PainelAbaOperacaoBemMovel(this);
        this.painelAbaConsolidacao = new PainelAbaConsolidacao(this);
        this.getTabbedPane().addTab("Identifica\u00e7\u00e3o/Aquisi\u00e7\u00e3o", this.painelAbaIdentificacao);
        this.getTabbedPane().addTab("Adquirentes", this.painelAbaAdquirente);
        this.getTabbedPane().addTab("Opera\u00e7\u00e3o", this.painelAbaOperacaoBemMovel);
        this.getTabbedPane().addTab("Apura\u00e7\u00e3o", this.painelAbaApuracaoBemMovel);
        this.getTabbedPane().addTab("C\u00e1lculo do Imposto", this.painelAbaCalculoImpostoBemMovel);
        this.getTabbedPane().addTab("Consolida\u00e7\u00e3o", this.painelAbaConsolidacao);
        this.tratarHabilitacaoAbaAdquirentes();
        this.tratarVisibilidadeAbaCalculo();
    }

    public void tratarHabilitacaoAbaAdquirentes() {
        this.setEnabledAbaPorNome("Adquirentes", this.alienacaoBemMovel.isAdquirenteRequerido());
    }

    public void tratarVisibilidadeAbaCalculo() {
        if (this.getTabbedPane().getTabCount() >= 4) {
            this.getTabbedPane().setEnabledAt(4, this.alienacaoBemMovel.podePreencherCalculo());
        }
    }

    @Override
    protected void tratarMudancaTabbedPane() {
        ControladorGui.alterarCabecalhoFicha(this.getTituloPainel());
        ControladorGui.alterarHelpId(this.getHelpIdAba(this.getTabbedPane().getSelectedIndex()));
        if (this.getTabbedPane().getSelectedIndex() == 2) {
            this.painelAbaOperacaoBemMovel.exibirPaineis();
        }
        if (this.getTabbedPane().getSelectedIndex() == 3) {
            this.painelAbaApuracaoBemMovel.atualizaSubPainelApuracao();
        }
        if (this.getTabbedPane().getSelectedIndex() == 4) {
            this.painelAbaCalculoImpostoBemMovel.atualizaSubPainelCalculoImposto();
        }
        if (this.getTabbedPane().getSelectedIndex() == 5) {
            this.painelAbaConsolidacao.atualizaSubPainelConsolidacao();
        }
        this.configurarHelpID();
    }

    public void tratarMudancaNatureza() {
        this.painelAbaIdentificacao.tratarMudancaNatureza();
    }

    private void exibirMensagemValorecebidoAnoAnterior() {
        if (this.alienacaoBemMovel.deveExibirMensagemValorecebidoAnoAnterior()) {
            GuiUtil.mostrarAviso("infoValorRecebidoAnosAnteriores");
        }
    }

    @Override
    protected String[] definirNomeAbas() {
        return new String[]{"Identifica\u00e7\u00e3o/Aquisi\u00e7\u00e3o", "Adquirentes", "Opera\u00e7\u00e3o", "Apura\u00e7\u00e3o", "C\u00e1lculo do Imposto", "Consolida\u00e7\u00e3o"};
    }

    @Override
    protected void configObservadores() {
    }

    @Override
    public String getTituloPainel() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            return "Direitos/Bens M\u00f3veis - Identifica\u00e7\u00e3o/Aquisi\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 1) {
            return "Direitos/Bens M\u00f3veis - Adquirentes";
        }
        if (this.getTabbedPane().getSelectedIndex() == 2) {
            return "Direitos/Bens M\u00f3veis - Opera\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 3) {
            return "Direitos/Bens M\u00f3veis - Apura\u00e7\u00e3o";
        }
        if (this.getTabbedPane().getSelectedIndex() == 4) {
            return "Direitos/Bens M\u00f3veis - C\u00e1lculo do Imposto";
        }
        if (this.getTabbedPane().getSelectedIndex() == 5) {
            return "Direitos/Bens M\u00f3veis - Consolida\u00e7\u00e3o";
        }
        return TITULO;
    }

    @Override
    public String getHelpID() {
        return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
    }

    private void configurarHelpID() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o");
        } else if (this.getTabbedPane().getSelectedIndex() == 1) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Adquirentes");
        } else if (this.getTabbedPane().getSelectedIndex() == 2) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Opera\u00e7\u00e3o");
        } else if (this.getTabbedPane().getSelectedIndex() == 3) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o");
        } else if (this.getTabbedPane().getSelectedIndex() == 4) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o");
        } else {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o");
        }
    }

    private String getHelpIdAba(int indiceAba) {
        if (indiceAba == 0) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
        }
        if (indiceAba == 1) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Adquirentes";
        }
        if (indiceAba == 2) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Opera\u00e7\u00e3o";
        }
        if (indiceAba == 3) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
        }
        if (indiceAba == 4) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
        }
        if (indiceAba == 5) {
            return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
        }
        return "";
    }

    @Override
    public boolean isTelaComVoltar() {
        return true;
    }

    @Override
    public void executaVoltar() {
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_BEM_MOVEL);
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.alienacaoBemMovel.getBemMovel().getEspecificacao().naoFormatado();
    }
}

