/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensmoveis.calculoimposto;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPLabelInfo;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.bensmoveis.calculoimposto.PainelCalculoImpostoAPrazoExterior;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PainelParcelaExteriorAmbasDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Direitos/Bens M\u00f3veis - C\u00e1lculo do Imposto - Parcela da Aliena\u00e7\u00e3o a Prazo";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Adquirentes";
    private ParcelaAlienacaoBem parcela = null;
    private ParcelaAlienacaoBem parcelaAnterior = null;
    private AlienacaoBemMovel alienacaoBemMovel;
    private PainelDemonstrativoIf painelPai;
    private PainelCalculoImpostoAPrazoExterior painelLista;
    private boolean mostrouMensagemPequenoValor;
    private JButtonMensagem btnMsgUltimaParcela;
    private JEditValor edtAliquotaMedia;
    private JEditValor edtCotacaoDolar;
    private JEditValor edtCotacaoDolarCopia1;
    private JEditValor edtCotacaoDolarCopia2;
    private JEditValor edtCustoAquisicaoProporcionalMEDolar;
    private JEditValor edtCustoAquisicaoProporcionalMNReal;
    private JEditValor edtCustoCorretagem;
    private JEditData edtDataRecebimentoUltimaParcela;
    private JEditValor edtGanhoCapitalTotal;
    private JEditValor edtGanhoProporcionalDolarME;
    private JEditValor edtGanhoProporcionalRealME;
    private JEditValor edtGanhoProporcionalRealMN;
    private JEditValor edtImpostoDevido;
    private JEditValor edtImpostoDevido2;
    private JEditValor edtImpostoPago;
    private JEditValor edtImpostoPagoExterior;
    private JEditValor edtValorLiquidoAlienacaoDolar;
    private JEditValor edtValorLiquidoAlienacaoMEDolar;
    private JEditValor edtValorLiquidoAlienacaoMNDolar;
    private JEditValor edtValorLiquidoAlienacaoMNReal;
    private JEditValor edtValorRecebido;
    private JButtonGroupPanel grpUltimaParcela;
    private GCAPLabelInfo infoCustoCorretagem;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel39;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblOrigemME;
    private JLabel lblOrigemMN;
    private JLabel lblTitulo;
    private PPGDRadioItem rdbNao;
    private PPGDRadioItem rdbSim;

    public PainelParcelaExteriorAmbasDetalhe(PainelDemonstrativoIf painelPai, PainelCalculoImpostoAPrazoExterior painelLista, AlienacaoBemMovel alienacaoBemMovel, ParcelaAlienacaoBem parcela, boolean itemNovo) {
        this.painelPai = painelPai;
        this.alienacaoBemMovel = alienacaoBemMovel;
        this.parcela = parcela;
        this.parcelaAnterior = parcela.obterCopia();
        this.painelLista = painelLista;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.initComponents();
        this.associarInformacao();
        this.adicionarEventoCamposTransportados();
        this.mostrouMensagemPequenoValor = false;
    }

    protected void associarInformacao() {
        this.grpUltimaParcela.setInformacao((Informacao)this.parcela.getUltimaParcela());
        this.edtDataRecebimentoUltimaParcela.setInformacao((Informacao)this.parcela.getDataRecebimento());
        this.edtValorRecebido.setInformacao((Informacao)this.parcela.getValorRecebidoDolar());
        this.edtCustoCorretagem.setInformacao((Informacao)this.parcela.getCustoCorretagemDolar());
        this.edtValorLiquidoAlienacaoDolar.setInformacao((Informacao)this.parcela.getValorLiquidoAlienacaoDolar());
        this.edtCotacaoDolar.setInformacao((Informacao)this.parcela.getCotacaoDolar());
        this.edtValorLiquidoAlienacaoMNDolar.setInformacao((Informacao)this.parcela.getValorAlienacaoOrigemNacionalDolar());
        this.edtValorLiquidoAlienacaoMEDolar.setInformacao((Informacao)this.parcela.getValorAlienacaoOrigemMEDolar());
        this.edtValorLiquidoAlienacaoMNReal.setInformacao((Informacao)this.parcela.getValorAlienacaoOrigemNacionalReal());
        this.edtCustoAquisicaoProporcionalMNReal.setInformacao((Informacao)this.parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
        this.edtCustoAquisicaoProporcionalMEDolar.setInformacao((Informacao)this.parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
        this.edtGanhoProporcionalRealMN.setInformacao((Informacao)this.parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        this.edtGanhoProporcionalDolarME.setInformacao((Informacao)this.parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
        this.edtGanhoProporcionalRealME.setInformacao((Informacao)this.parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        this.edtGanhoCapitalTotal.setInformacao((Informacao)this.parcela.getGanhoCapital1ProporcionalTotalReal());
        this.edtAliquotaMedia.setInformacao((Informacao)this.parcela.getAliquotaMedia());
        this.edtImpostoDevido.setInformacao((Informacao)this.parcela.getImpostoDevido());
        this.edtImpostoPagoExterior.setInformacao((Informacao)this.parcela.getImpostoPagoExterior());
        this.edtImpostoDevido2.setInformacao((Informacao)this.parcela.getImpostoDevido2());
        this.edtImpostoPago.setInformacao((Informacao)this.parcela.getImpostoPago());
        this.atualizarCamposTransportados();
    }

    private void adicionarEventoCamposTransportados() {
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PainelParcelaExteriorAmbasDetalhe.this.atualizarCamposTransportados();
            }
        };
        ((JTextField)this.edtValorRecebido.getComponenteFoco()).addFocusListener(focusAdapter);
        ((JTextField)this.edtCustoCorretagem.getComponenteFoco()).addFocusListener(focusAdapter);
        ((JTextField)this.edtCotacaoDolar.getComponenteFoco()).addFocusListener(focusAdapter);
    }

    private void atualizarCamposTransportados() {
        ValorPositivo cotacaoDolarCopia1 = new ValorPositivo(null, "", 11, 4);
        cotacaoDolarCopia1.setReadOnly(true);
        cotacaoDolarCopia1.setConteudo(this.parcela.getCotacaoDolar());
        this.edtCotacaoDolarCopia1.setInformacao((Informacao)cotacaoDolarCopia1);
        ValorPositivo cotacaoDolarCopia2 = new ValorPositivo(null, "", 11, 4);
        cotacaoDolarCopia2.setReadOnly(true);
        cotacaoDolarCopia2.setConteudo(this.parcela.getCotacaoDolar());
        this.edtCotacaoDolarCopia2.setInformacao((Informacao)cotacaoDolarCopia2);
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.alienacaoBemMovel.getBemMovel().getEspecificacao().naoFormatado();
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.grpUltimaParcela;
    }

    @Override
    public boolean isTelaComVoltar() {
        return true;
    }

    @Override
    public boolean isTelaComCancelar() {
        return true;
    }

    @Override
    public void executaVoltar() {
        List pendencias = FabricaUtilitarios.verificarPendencias((Object)((Object)this.parcela));
        Pendencia erro = null;
        for (Pendencia pendencia : pendencias) {
            if (pendencia.getSeveridade() != 3) continue;
            erro = pendencia;
            break;
        }
        if (erro != null) {
            GuiUtil.mostrarErro(null, erro.getMsg());
        } else {
            if (!this.mostrouMensagemPequenoValor && this.alienacaoBemMovel.getBemGrandeValor().isVazio() && this.alienacaoBemMovel.podeResponderPerguntaPequenoValorNoExteriorPorParcelas() && !this.parcela.getValorRecebidoDolar().isVazio() && !this.parcela.getCotacaoDolar().isVazio()) {
                String mesAno = this.alienacaoBemMovel.getDataAlienacao().getMes() + "/" + this.alienacaoBemMovel.getDataAlienacao().getAno();
                if (GuiUtil.mostrarConfirma("perguntaBemPequenoValorSemhtml", new String[]{mesAno, this.alienacaoBemMovel.getValorIsencaoAsString(), "opera\u00e7\u00e3o"})) {
                    this.alienacaoBemMovel.getBemGrandeValor().setConteudo(Logico.SIM);
                } else {
                    this.alienacaoBemMovel.getBemGrandeValor().setConteudo(Logico.NAO);
                    GuiUtil.mostrarAviso("impostoDevidoZeroPorBemPequenoValor");
                }
                this.mostrouMensagemPequenoValor = true;
            }
            this.alienacaoBemMovel.getColecaoParcelaAlienacao().excluirRegistrosEmBranco();
            this.painelLista.exibirTextoIsencao();
            ControladorGui.acionarPainel(this.painelPai);
            this.painelLista.atualizarTableModel();
        }
    }

    @Override
    public void executaCancelar() {
        this.parcela.restaurar(this.parcelaAnterior);
        this.alienacaoBemMovel.getColecaoParcelaAlienacao().excluirRegistrosEmBranco();
        ControladorGui.acionarPainel(this.painelPai);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.edtDataRecebimentoUltimaParcela = new JEditData();
        this.jLabel5 = new JLabel();
        this.grpUltimaParcela = new JButtonGroupPanel();
        this.rdbSim = new PPGDRadioItem();
        this.rdbNao = new PPGDRadioItem();
        this.btnMsgUltimaParcela = new JButtonMensagem();
        this.lblOrigemMN = new JLabel();
        this.lblOrigemME = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.edtValorLiquidoAlienacaoMNDolar = new JEditValor();
        this.jLabel23 = new JLabel();
        this.edtValorLiquidoAlienacaoMEDolar = new JEditValor();
        this.jLabel32 = new JLabel();
        this.jLabel33 = new JLabel();
        this.edtValorLiquidoAlienacaoMNReal = new JEditValor();
        this.jLabel34 = new JLabel();
        this.jLabel35 = new JLabel();
        this.edtCustoAquisicaoProporcionalMNReal = new JEditValor();
        this.jLabel36 = new JLabel();
        this.edtCustoAquisicaoProporcionalMEDolar = new JEditValor();
        this.jLabel37 = new JLabel();
        this.jLabel39 = new JLabel();
        this.edtGanhoProporcionalDolarME = new JEditValor();
        this.jLabel40 = new JLabel();
        this.jLabel41 = new JLabel();
        this.edtGanhoProporcionalRealME = new JEditValor();
        this.jLabel42 = new JLabel();
        this.edtGanhoProporcionalRealMN = new JEditValor();
        this.jLabel44 = new JLabel();
        this.jLabel45 = new JLabel();
        this.edtAliquotaMedia = new JEditValor();
        this.jLabel46 = new JLabel();
        this.jLabel47 = new JLabel();
        this.edtImpostoDevido = new JEditValor();
        this.jLabel48 = new JLabel();
        this.jLabel49 = new JLabel();
        this.edtImpostoPago = new JEditValor();
        this.jSeparator1 = new JSeparator();
        this.jLabel26 = new JLabel();
        this.jLabel43 = new JLabel();
        this.edtCotacaoDolarCopia1 = new JEditValor();
        this.jLabel51 = new JLabel();
        this.jLabel52 = new JLabel();
        this.edtCotacaoDolarCopia2 = new JEditValor();
        this.edtGanhoCapitalTotal = new JEditValor();
        this.jLabel50 = new JLabel();
        this.jLabel53 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel27 = new JLabel();
        this.edtImpostoDevido2 = new JEditValor();
        this.jLabel28 = new JLabel();
        this.edtImpostoPagoExterior = new JEditValor();
        this.jLabel29 = new JLabel();
        this.edtValorRecebido = new JEditValor();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.infoCustoCorretagem = new GCAPLabelInfo();
        this.edtCustoCorretagem = new JEditValor();
        this.jLabel2 = new JLabel();
        this.jLabel10 = new JLabel();
        this.edtValorLiquidoAlienacaoDolar = new JEditValor();
        this.jLabel3 = new JLabel();
        this.jLabel11 = new JLabel();
        this.edtCotacaoDolar = new JEditValor();
        this.jLabel24 = new JLabel();
        this.jLabel30 = new JLabel();
        this.lblTitulo = new JLabel();
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel8.setText("<html>Data de Recebimento da Parcela:<font color=red>*</font></html>");
        this.jLabel5.setText("<html>Esta \u00e9 a \u00faltima parcela? <font color=red>*</font></html>");
        this.grpUltimaParcela.setButtonMensagem(this.btnMsgUltimaParcela);
        this.grpUltimaParcela.setBorder(null);
        this.grpUltimaParcela.setButtonMensagem(this.btnMsgUltimaParcela);
        this.grpUltimaParcela.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelParcelaExteriorAmbasDetalhe.this.grpUltimaParcelaAtualizaPainel(evt);
            }
        });
        this.rdbSim.setBackground(new Color(255, 255, 255));
        this.rdbSim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbSim.setText("Sim");
        this.rdbSim.setValorSelecionadoTrue(Logico.SIM);
        this.rdbSim.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelParcelaExteriorAmbasDetalhe.this.rdbSimFocusLost(evt);
            }
        });
        this.rdbNao.setBackground(new Color(255, 255, 255));
        this.rdbNao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbNao.setText("N\u00e3o");
        this.rdbNao.setValorSelecionadoTrue(Logico.NAO);
        this.rdbNao.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelParcelaExteriorAmbasDetalhe.this.rdbNaoFocusLost(evt);
            }
        });
        GroupLayout grpUltimaParcelaLayout = new GroupLayout((Container)this.grpUltimaParcela);
        this.grpUltimaParcela.setLayout((LayoutManager)grpUltimaParcelaLayout);
        grpUltimaParcelaLayout.setHorizontalGroup(grpUltimaParcelaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpUltimaParcelaLayout.createSequentialGroup().addComponent((Component)this.rdbSim, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbNao, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpUltimaParcelaLayout.setVerticalGroup(grpUltimaParcelaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.rdbNao, -1, -1, Short.MAX_VALUE).addComponent((Component)this.rdbSim, -1, -1, Short.MAX_VALUE));
        this.rdbSim.getAccessibleContext().setAccessibleName("Esta \u00e9 a \u00faltima parcela? Sim");
        this.rdbNao.getAccessibleContext().setAccessibleName("Esta \u00e9 a \u00faltima parcela? N\u00e3o");
        this.btnMsgUltimaParcela.setText("jButtonMensagem1");
        this.lblOrigemMN.setFont(new Font("FreeSans", 1, 12));
        this.lblOrigemMN.setText("Moeda Nacional");
        this.lblOrigemMN.setName("lblMN");
        this.lblOrigemME.setFont(new Font("FreeSans", 1, 12));
        this.lblOrigemME.setText("Moeda Estrangeira");
        this.lblOrigemME.setName("lblME");
        this.jLabel21.setText("Valor L\u00edquido Recebido em D\u00f3lar");
        this.jLabel21.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel22.setText("(US$)");
        this.jLabel22.setName("lblMN");
        this.jLabel23.setText("(US$)");
        this.jLabel23.setName("lblME");
        this.jLabel32.setText("Valor L\u00edquido Recebido");
        this.jLabel32.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel33.setHorizontalAlignment(4);
        this.jLabel33.setText("(R$)");
        this.jLabel33.setName("lblMN");
        this.jLabel34.setText("Custo de Aquisi\u00e7\u00e3o Proporcional");
        this.jLabel34.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel35.setHorizontalAlignment(4);
        this.jLabel35.setText("(R$)");
        this.jLabel35.setName("lblMN");
        this.jLabel36.setHorizontalAlignment(4);
        this.jLabel36.setText("(US$)");
        this.jLabel36.setName("lblME");
        this.jLabel37.setText("Ganho de Capital em D\u00f3lar");
        this.jLabel37.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel39.setHorizontalAlignment(4);
        this.jLabel39.setText("(US$)");
        this.jLabel39.setName("lblME");
        this.jLabel40.setHorizontalAlignment(4);
        this.jLabel40.setText("(R$)");
        this.jLabel40.setName("lblMN");
        this.jLabel41.setText("Ganho de Capital em Reais");
        this.jLabel41.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel42.setHorizontalAlignment(4);
        this.jLabel42.setText("(R$)");
        this.jLabel42.setName("lblME");
        this.jLabel44.setText("Al\u00edquota M\u00e9dia");
        this.jLabel44.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel45.setHorizontalAlignment(4);
        this.jLabel45.setText("(%)");
        this.jLabel45.setName("lblME");
        this.jLabel46.setText("Imposto Devido");
        this.jLabel46.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel47.setHorizontalAlignment(4);
        this.jLabel47.setText("(R$)");
        this.jLabel47.setName("lblME");
        this.jLabel48.setText("Imposto Pago no Brasil");
        this.jLabel48.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel49.setHorizontalAlignment(4);
        this.jLabel49.setText("(R$)");
        this.jLabel49.setName("lblME");
        this.jLabel26.setText("Cota\u00e7\u00e3o do D\u00f3lar na Data do Recebimento da Parcela ");
        this.jLabel26.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel43.setHorizontalAlignment(4);
        this.jLabel43.setText("(R$)");
        this.jLabel43.setName("lblMN");
        this.jLabel51.setText("Cota\u00e7\u00e3o do D\u00f3lar na Data do Recebimento da Parcela ");
        this.jLabel51.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel52.setHorizontalAlignment(4);
        this.jLabel52.setText("(R$)");
        this.jLabel52.setName("lblME");
        this.jLabel50.setText("Ganho de Capital Total");
        this.jLabel50.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel53.setHorizontalAlignment(4);
        this.jLabel53.setText("(R$)");
        this.jLabel53.setName("lblME");
        this.jLabel25.setHorizontalAlignment(4);
        this.jLabel25.setText("(R$)");
        this.jLabel27.setText("Imposto Devido no Brasil");
        this.jLabel27.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel28.setText("Imposto Pago no Exterior Pass\u00edvel de Compensa\u00e7\u00e3o");
        this.jLabel28.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel29.setHorizontalAlignment(4);
        this.jLabel29.setText("(R$)");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("(US$)");
        this.jLabel9.setText("<html>Valor Recebido <font color=red>*</font></html>");
        this.jLabel9.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.infoCustoCorretagem.setMensagem(MensagemUtil.getMensagemComQuebraDeLinha("info.custo.corretagem"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("(US$)");
        this.jLabel10.setText("Custo de Corretagem");
        this.jLabel10.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("(US$)");
        this.jLabel11.setText("Valor L\u00edquido Recebido");
        this.jLabel11.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.jLabel24.setHorizontalAlignment(4);
        this.jLabel24.setText("(R$)");
        this.jLabel30.setText("<html>Cota\u00e7\u00e3o do D\u00f3lar na Data do Recebimento da Parcela <font color=red>*</font></html>");
        this.jLabel30.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel50, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel53, -2, 36, -2).addGap(6, 6, 6).addComponent((Component)this.edtGanhoCapitalTotal, -2, 149, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel44, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel45, -2, 36, -2).addGap(6, 6, 6).addComponent((Component)this.edtAliquotaMedia, -2, 149, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel46, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel47, -2, 36, -2).addGap(6, 6, 6).addComponent((Component)this.edtImpostoDevido, -2, 149, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel48, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel49, -2, 36, -2).addGap(6, 6, 6).addComponent((Component)this.edtImpostoPago, -2, 149, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel26, GroupLayout.Alignment.LEADING, -1, 477, Short.MAX_VALUE).addComponent(this.jLabel32, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel34, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel37, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel51, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel41, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel33, -2, 36, -2).addComponent(this.jLabel35, -2, 36, -2).addComponent(this.jLabel40, -2, 36, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtCustoAquisicaoProporcionalMNReal, GroupLayout.Alignment.TRAILING, -2, 149, -2).addComponent((Component)this.edtValorLiquidoAlienacaoMNReal, -2, 149, -2).addComponent((Component)this.edtGanhoProporcionalRealMN, -2, 149, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel43, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel22, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtCotacaoDolarCopia1, -1, 149, Short.MAX_VALUE).addComponent((Component)this.edtValorLiquidoAlienacaoMNDolar, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel36, -2, 36, -2).addComponent(this.jLabel39)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtCustoAquisicaoProporcionalMEDolar, -2, 149, -2).addComponent((Component)this.edtGanhoProporcionalDolarME, -2, 149, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel42, -2, 36, -2).addComponent(this.jLabel52, -2, 36, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtCotacaoDolarCopia2, -2, 149, -2).addComponent((Component)this.edtGanhoProporcionalRealME, -2, 149, -2))))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel23, -2, 36, -2).addGap(6, 6, 6).addComponent((Component)this.edtValorLiquidoAlienacaoMEDolar, -2, 149, -2)))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.grpUltimaParcela, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnMsgUltimaParcela, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDataRecebimentoUltimaParcela, -2, 115, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel28, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel27, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel29, GroupLayout.Alignment.TRAILING, -2, 36, -2).addComponent(this.jLabel25, GroupLayout.Alignment.TRAILING, -2, 36, -2)).addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtImpostoPagoExterior, -2, 149, -2).addComponent((Component)this.edtImpostoDevido2, -2, 149, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValorRecebido, -2, 149, -2).addGap(34, 34, 34)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblOrigemMN, -2, 152, -2).addGap(51, 51, 51).addComponent(this.lblOrigemME, -2, 149, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel30).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel24, -2, 36, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtCotacaoDolar, -1, 150, Short.MAX_VALUE).addComponent((Component)this.edtValorLiquidoAlienacaoDolar, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtCustoCorretagem, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoCustoCorretagem, -2, -1, -2)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.edtDataRecebimentoUltimaParcela, -2, -1, -2).addComponent((Component)this.grpUltimaParcela, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.LEADING)).addComponent((Component)this.btnMsgUltimaParcela, -2, -1, -2)).addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtValorRecebido, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel9, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.infoCustoCorretagem, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtCustoCorretagem, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addComponent(this.jLabel10))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtValorLiquidoAlienacaoDolar, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtCotacaoDolar, -2, 24, -2).addComponent(this.jLabel24).addComponent(this.jLabel30, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblOrigemME, -1, -1, Short.MAX_VALUE).addComponent(this.lblOrigemMN, -2, 46, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent((Component)this.edtValorLiquidoAlienacaoMEDolar, -2, -1, -2).addComponent(this.jLabel23).addComponent(this.jLabel22).addComponent((Component)this.edtValorLiquidoAlienacaoMNDolar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel26).addComponent(this.jLabel43).addComponent((Component)this.edtCotacaoDolarCopia1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel32).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtCustoAquisicaoProporcionalMEDolar, -2, -1, -2).addComponent(this.jLabel36).addComponent(this.jLabel34)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtGanhoProporcionalDolarME, -2, -1, -2).addComponent(this.jLabel37))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel33).addComponent((Component)this.edtValorLiquidoAlienacaoMNReal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel35).addComponent((Component)this.edtCustoAquisicaoProporcionalMNReal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel39, -2, 22, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtCotacaoDolarCopia2, -2, -1, -2).addComponent(this.jLabel52).addComponent(this.jLabel51)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtGanhoProporcionalRealME, -2, -1, -2).addComponent(this.jLabel42).addComponent(this.jLabel41))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtGanhoProporcionalRealMN, -2, -1, -2).addComponent(this.jLabel40))).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel50).addComponent((Component)this.edtGanhoCapitalTotal, -2, -1, -2).addComponent(this.jLabel53)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel44).addComponent((Component)this.edtAliquotaMedia, -2, -1, -2).addComponent(this.jLabel45)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel46).addComponent((Component)this.edtImpostoDevido, -2, -1, -2).addComponent(this.jLabel47)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtImpostoPagoExterior, -2, -1, -2).addComponent(this.jLabel29).addComponent(this.jLabel28)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtImpostoDevido2, -2, -1, -2).addComponent(this.jLabel25).addComponent(this.jLabel27)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel48).addComponent((Component)this.edtImpostoPago, -2, -1, -2).addComponent(this.jLabel49)).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtDataRecebimentoUltimaParcela.getAccessibleContext().setAccessibleName("Data de Recebimento da Parcela");
        this.edtValorLiquidoAlienacaoMNDolar.getAccessibleContext().setAccessibleName("Valor L\u00edquido Recebido em D\u00f3lar moeda nacional");
        this.edtValorLiquidoAlienacaoMEDolar.getAccessibleContext().setAccessibleName("Valor L\u00edquido Recebido em D\u00f3lar moeda estrangeira");
        this.edtValorLiquidoAlienacaoMNReal.getAccessibleContext().setAccessibleName("Valor L\u00edquido Recebido");
        this.edtCustoAquisicaoProporcionalMNReal.getAccessibleContext().setAccessibleName("Custo de Aquisi\u00e7\u00e3o Proporcional em reais moeda nacional");
        this.edtCustoAquisicaoProporcionalMEDolar.getAccessibleContext().setAccessibleName("Custo de Aquisi\u00e7\u00e3o Proporcional em d\u00f3lar moeda estrangeira");
        this.edtGanhoProporcionalDolarME.getAccessibleContext().setAccessibleName("Ganho de Capital em D\u00f3lar");
        this.edtGanhoProporcionalRealME.getAccessibleContext().setAccessibleName("Ganho de Capital em Reais moeda estrangeira");
        this.edtGanhoProporcionalRealMN.getAccessibleContext().setAccessibleName("Ganho de Capital em Reais moeda nacional");
        this.edtAliquotaMedia.getAccessibleContext().setAccessibleName("Al\u00edquota M\u00e9dia");
        this.edtImpostoDevido.getAccessibleContext().setAccessibleName("Imposto Devido");
        this.edtImpostoPago.getAccessibleContext().setAccessibleName("Imposto Pago no Brasil");
        this.edtCotacaoDolarCopia1.getAccessibleContext().setAccessibleName("Cota\u00e7\u00e3o do D\u00f3lar na Data do Recebimento da Parcela ");
        this.edtCotacaoDolarCopia2.getAccessibleContext().setAccessibleName("Cota\u00e7\u00e3o do D\u00f3lar na Data do Recebimento da Parcela ");
        this.edtGanhoCapitalTotal.getAccessibleContext().setAccessibleName("Ganho de Capital Total");
        this.edtImpostoDevido2.getAccessibleContext().setAccessibleName("Imposto Devido no Brasil");
        this.edtImpostoPagoExterior.getAccessibleContext().setAccessibleName("Imposto Pago no Exterior Pass\u00edvel de Compensa\u00e7\u00e3o");
        this.edtValorRecebido.getAccessibleContext().setAccessibleName("Valor Recebido em d\u00f3lar");
        this.edtCustoCorretagem.getAccessibleContext().setAccessibleName("Custo de Corretagem em d\u00f3lar");
        this.edtValorLiquidoAlienacaoDolar.getAccessibleContext().setAccessibleName("Valor L\u00edquido Recebido em d\u00f3lar");
        this.edtCotacaoDolar.getAccessibleContext().setAccessibleName("Cota\u00e7\u00e3o do D\u00f3lar na Data do Recebimento da Parcela");
        this.lblTitulo.setFont(new Font("DejaVu Sans", 1, 15));
        this.lblTitulo.setForeground(new Color(107, 151, 9));
        this.lblTitulo.setHorizontalAlignment(0);
        this.lblTitulo.setText("Dados da Parcela");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.lblTitulo, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitulo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void rdbSimFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbNao) {
            this.grpUltimaParcela.chamaValidacao();
        }
    }

    private void rdbNaoFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbSim) {
            this.grpUltimaParcela.chamaValidacao();
        }
    }

    private void grpUltimaParcelaAtualizaPainel(GroupPanelEvent evt) {
    }
}

