/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.bensmoveis.calculoimposto;

import br.gov.serpro.gcap.entidades.alienacao.ColecaoParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import br.gov.serpro.gcap.gui.TableListaSumarioModel;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;

public class TableModelParcelasExterior
extends TableListaSumarioModel {
    private Codigo origemRendimentos = null;
    private static final long serialVersionUID = 1L;
    private Alfa vazio = new Alfa();

    public TableModelParcelasExterior(Codigo origemRendimentos, ColecaoParcelaAlienacaoBem parcelas) {
        super(parcelas);
        this.origemRendimentos = origemRendimentos;
    }

    @Override
    public int getColumnCount() {
        int colcount = 11;
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.origemRendimentos.naoFormatado())) {
            colcount = 8;
        }
        return colcount;
    }

    @Override
    public Informacao getInformacaoAt(int row, int col) {
        boolean ultimaLinha;
        ColecaoParcelaAlienacaoBem parcelas = (ColecaoParcelaAlienacaoBem)this.getObjetoNegocio();
        ParcelaAlienacaoBem item = null;
        boolean bl = ultimaLinha = row == this.getRowCount() - 1;
        item = !ultimaLinha ? (ParcelaAlienacaoBem)((Object)parcelas.itens().get(row)) : (parcelas.itens().size() > 0 ? (ParcelaAlienacaoBem)((Object)parcelas.itens().get(0)) : new ParcelaAlienacaoBem());
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.origemRendimentos.naoFormatado())) {
            switch (col) {
                case 0: {
                    return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
                }
                case 1: {
                    return ultimaLinha ? parcelas.getValorRecebidoDolarTotal() : item.getValorRecebidoDolar();
                }
                case 2: {
                    return ultimaLinha ? parcelas.getCustoCorretagemDolarTotal() : item.getCustoCorretagemDolar();
                }
                case 3: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoDolarTotal() : item.getValorLiquidoAlienacaoDolar();
                }
                case 4: {
                    return ultimaLinha ? this.vazio : item.getCotacaoDolar();
                }
                case 5: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoRealTotal() : item.getValorLiquidoAlienacaoReal();
                }
                case 6: {
                    return ultimaLinha ? parcelas.getCustoAquisicaoProporcionalOrigemNacionalRealTotal() : item.getCustoAquisicaoProporcionalOrigemNacionalReal();
                }
                case 7: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalNacionalRealTotal() : item.getGanhoCapital1ProporcionalOrigemNacionalReal();
                }
                case 8: {
                    return ultimaLinha ? this.vazio : item.getAliquotaMedia();
                }
                case 9: {
                    return ultimaLinha ? parcelas.getImpostoDevido2Total() : item.getImpostoDevido2();
                }
                case 10: {
                    return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.origemRendimentos.naoFormatado())) {
            switch (col) {
                case 0: {
                    return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
                }
                case 1: {
                    return ultimaLinha ? parcelas.getValorRecebidoDolarTotal() : item.getValorRecebidoDolar();
                }
                case 2: {
                    return ultimaLinha ? parcelas.getCustoCorretagemDolarTotal() : item.getCustoCorretagemDolar();
                }
                case 3: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoDolarTotal() : item.getValorLiquidoAlienacaoDolar();
                }
                case 4: {
                    return ultimaLinha ? parcelas.getCustoAquisicaoProporcionalOrigemMEDolarTotal() : item.getCustoAquisicaoProporcionalOrigemMEDolar();
                }
                case 5: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalMEDolarTotal() : item.getGanhoCapital1ProporcionalOrigemMEDolar();
                }
                case 6: {
                    return ultimaLinha ? this.vazio : item.getCotacaoDolar();
                }
                case 7: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalMERealTotal() : item.getGanhoCapital1ProporcionalOrigemMEReal();
                }
                case 8: {
                    return ultimaLinha ? this.vazio : item.getAliquotaMedia();
                }
                case 9: {
                    return ultimaLinha ? parcelas.getImpostoDevido2Total() : item.getImpostoDevido2();
                }
                case 10: {
                    return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.origemRendimentos.naoFormatado())) {
            switch (col) {
                case 0: {
                    return ultimaLinha ? this.labelTotal : item.getDataRecebimento();
                }
                case 1: {
                    return ultimaLinha ? parcelas.getValorRecebidoDolarTotal() : item.getValorRecebidoDolar();
                }
                case 2: {
                    return ultimaLinha ? parcelas.getCustoCorretagemDolarTotal() : item.getCustoCorretagemDolar();
                }
                case 3: {
                    return ultimaLinha ? parcelas.getValorLiquidoAlienacaoDolarTotal() : item.getValorLiquidoAlienacaoDolar();
                }
                case 4: {
                    return ultimaLinha ? parcelas.getGanhoCapital1ProporcionalRealTotal() : item.getGanhoCapital1ProporcionalTotalReal();
                }
                case 5: {
                    return ultimaLinha ? this.vazio : item.getAliquotaMedia();
                }
                case 6: {
                    return ultimaLinha ? parcelas.getImpostoDevido2Total() : item.getImpostoDevido2();
                }
                case 7: {
                    return ultimaLinha ? parcelas.getImpostoPagoTotal() : item.getImpostoPago();
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.origemRendimentos.naoFormatado())) {
            switch (column) {
                case 0: {
                    return "<html><center>Data<br>Parcela</center></html>";
                }
                case 1: {
                    return "<html><center>Valor<br>Recebido-(XX$)</center></html>";
                }
                case 2: {
                    return "<html><center>Custo de<br>Corretagem-(XX$)</center></html>";
                }
                case 3: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(XX$)</center></html>";
                }
                case 4: {
                    return "<html><center>Cota\u00e7\u00e3o<br>da Moeda Estrangeira</center></html>";
                }
                case 5: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(R$)</center></html>";
                }
                case 6: {
                    return "<html><center>Custo de<br>Aquisi\u00e7\u00e3o-(R$)</center></html>";
                }
                case 7: {
                    return "<html><center>Ganho de<br>Capital-(R$)</center></html>";
                }
                case 8: {
                    return "<html><center>% Al\u00edquota<br>M\u00e9dia</center></html>";
                }
                case 9: {
                    return "<html><center>Imposto Devido<br>no Brasil-(R$)</center></html>";
                }
                case 10: {
                    return "<html><center>Imposto Pago<br>no Brasil-(R$)</center></html>";
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.origemRendimentos.naoFormatado())) {
            switch (column) {
                case 0: {
                    return "<html><center>Data<br>Parcela</center></html>";
                }
                case 1: {
                    return "<html><center>Valor<br>Recebido-(US$)</center></html>";
                }
                case 2: {
                    return "<html><center>Custo de<br>Corretagem-(US$)</center></html>";
                }
                case 3: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(US$)</center></html>";
                }
                case 4: {
                    return "<html><center>Custo de<br>Aquisi\u00e7\u00e3o-(US$)</center></html>";
                }
                case 5: {
                    return "<html><center>Ganho de<br>Capital-(US$)</center></html>";
                }
                case 6: {
                    return "<html><center>Cota\u00e7\u00e3o<br>do D\u00f3lar</center></html>";
                }
                case 7: {
                    return "<html><center>Ganho de<br>Capital-(R$)</center></html>";
                }
                case 8: {
                    return "<html><center>% Al\u00edquota<br>M\u00e9dia</center></html>";
                }
                case 9: {
                    return "<html><center>Imposto Devido<br>no Brasil-(R$)</center></html>";
                }
                case 10: {
                    return "<html><center>Imposto Pago<br>no Brasil-(R$)</center></html>";
                }
            }
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.origemRendimentos.naoFormatado())) {
            switch (column) {
                case 0: {
                    return "<html><center>Data<br>Parcela</center></html>";
                }
                case 1: {
                    return "<html><center>Valor<br>Recebido-(US$)</center></html>";
                }
                case 2: {
                    return "<html><center>Custo de<br>Corretagem-(US$)</center></html>";
                }
                case 3: {
                    return "<html><center>Valor L\u00edquido<br>Recebido-(US$)</center></html>";
                }
                case 4: {
                    return "<html><center>Ganho de Capital<br>Total-(R$)</center></html>";
                }
                case 5: {
                    return "<html><center>% Al\u00edquota<br>M\u00e9dia</center></html>";
                }
                case 6: {
                    return "<html><center>Imposto Devido<br>no Brasil-(R$)</center></html>";
                }
                case 7: {
                    return "<html><center>Imposto Pago<br>no Brasil-(R$)</center></html>";
                }
            }
        }
        return "";
    }
}

