/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.consolidacaogeral;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.consolidacaogeral.PainelAbaConsolidacaoBrasil;
import br.gov.serpro.gcap.gui.consolidacaogeral.PainelAbaConsolidacaoExterior;
import br.gov.serpro.gcap.gui.especie.PainelAbaConsolidacaoMoeda;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import serpro.ppgd.infraestrutura.PlataformaPPGD;

public class PainelDadosConsolidacaoGeral
extends PainelComAbasAb {
    private static final long serialVersionUID = 1L;
    public static String TITULO = " Consolida\u00e7\u00e3o Geral";
    private PainelAbaConsolidacaoBrasil painelAbaConsolidacaoBrasil = null;
    private PainelAbaConsolidacaoExterior painelAbaConsolidacaoExterior = null;
    private PainelAbaConsolidacaoMoeda painelConsolidacaoMoeda = null;
    private Consolidacao consolidacaoBrasil;
    private Consolidacao consolidacaoExterior;
    private ColecaoMoedaAlienada moedasAlienadas;
    private DemonstrativoGCAP demonstrativo;

    public PainelDadosConsolidacaoGeral() {
        this(GCAPFacade.getInstancia().getDeclaracao());
    }

    public PainelDadosConsolidacaoGeral(DemonstrativoGCAP demonstrativo) {
        super(demonstrativo);
        this.demonstrativo = demonstrativo;
        this.consolidacaoBrasil = this.demonstrativo.getConsolidacaoBrasil();
        this.consolidacaoExterior = this.demonstrativo.getConsolidacaoExterior();
        this.moedasAlienadas = this.demonstrativo.getMoedasAlienadas();
        this.montarAbas();
        this.configurarHelpID();
    }

    @Override
    protected void montarAbas() {
        this.painelAbaConsolidacaoBrasil = new PainelAbaConsolidacaoBrasil(this.consolidacaoBrasil);
        this.getTabbedPane().addTab("Bens, Direitos e Participa\u00e7\u00f5es Societ\u00e1rias no Brasil", this.painelAbaConsolidacaoBrasil);
        this.painelAbaConsolidacaoExterior = new PainelAbaConsolidacaoExterior(this.consolidacaoExterior);
        this.getTabbedPane().addTab("Bens e Direitos no Exterior", this.painelAbaConsolidacaoExterior);
        this.painelConsolidacaoMoeda = new PainelAbaConsolidacaoMoeda(this, "Consolida\u00e7\u00e3o de Moedas em Esp\u00e9cie");
        this.getTabbedPane().addTab("Moedas em Esp\u00e9cie", this.painelConsolidacaoMoeda);
    }

    @Override
    protected void tratarMudancaTabbedPane() {
        ControladorGui.alterarCabecalhoFicha(this.getTituloPainel());
        ControladorGui.alterarHelpId(this.getHelpIdAba(this.getTabbedPane().getSelectedIndex()));
        this.configurarHelpID();
    }

    @Override
    protected String[] definirNomeAbas() {
        return new String[]{"Bens, Direitos e Participa\u00e7\u00f5es Societ\u00e1rias no Brasil", "Bens e Direitos no Exterior", "Moedas em Esp\u00e9cie"};
    }

    @Override
    protected void configObservadores() {
    }

    @Override
    public String getTituloPainel() {
        if (this.getTabbedPane().getSelectedIndex() == 0) {
            return "Consolida\u00e7\u00e3o Geral - Bens, Direitos e Participa\u00e7\u00f5es Societ\u00e1rias no Brasil";
        }
        if (this.getTabbedPane().getSelectedIndex() == 1) {
            return "Consolida\u00e7\u00e3o Geral - Bens e Direitos no Exterior";
        }
        if (this.getTabbedPane().getSelectedIndex() == 2) {
            return "Consolida\u00e7\u00e3o Geral - Moedas em Esp\u00e9cie";
        }
        return TITULO;
    }

    @Override
    public String getHelpID() {
        return "";
    }

    private void configurarHelpID() {
        switch (this.getTabbedPane().getSelectedIndex()) {
            case 0: {
                PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "");
                break;
            }
            case 1: {
                PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "");
                break;
            }
            case 2: {
                PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "\u00cdndice");
                break;
            }
        }
    }

    private String getHelpIdAba(int indiceAba) {
        switch (indiceAba) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "\u00cdndice";
            }
        }
        return "";
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoConsolidacao.png");
    }
}

