/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.dialogs;

import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.dialogs.PainelNovidadesBackground;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;

public class PainelNovidades
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static PainelNovidades painelNovidades = null;
    private static String HELP_ID_NOVIDADE_1 = "\u00cdndice";
    private static String HELP_ID_NOVIDADE_2 = "\u00cdndice";
    private static String HELP_ID_NOVIDADE_3 = "\u00cdndice";
    private static String HELP_ID_NOVIDADE_4 = "\u00cdndice";
    private final HyperlinkListener escutaLinks = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
    };
    private JButton btnFechar;
    private JCheckBox chkNaoMostrar;
    private JEditorPane epNovidades1;
    private JEditorPane epNovidades2;
    private JEditorPane epNovidades3;
    private JEditorPane epNovidades4;
    private JEditorPane epNovidades5;
    private JLabel lblExercicio;
    private JLabel lblNovidadesPrograma;
    private JLabel lblTitulo1;
    private JLabel lblTitulo2;
    private JLabel lblTitulo3;
    private JLabel lblTitulo4;
    private JLabel lblTitulo5;
    private PainelNovidadesBackground painelNovidadesBackground1;

    public static PainelNovidades getInstance() {
        if (painelNovidades == null) {
            painelNovidades = new PainelNovidades();
        }
        return painelNovidades;
    }

    private PainelNovidades() {
        this.initComponents();
        this.configCursor(this.lblTitulo1);
        this.configCursor(this.lblTitulo2);
        this.configCursor(this.lblTitulo3);
        this.configCursor(this.lblTitulo4);
        this.configCursor(this.lblTitulo5);
        this.configAcaoAjuda(this.lblTitulo1, this.epNovidades1);
        this.configAcaoAjuda(this.lblTitulo2, this.epNovidades2);
        this.configAcaoAjuda(this.lblTitulo3, this.epNovidades3);
        this.configAcaoAjuda(this.lblTitulo4, this.epNovidades4);
        this.configAcaoAjuda(this.lblTitulo5, this.epNovidades5);
        this.setCheckboxNaoExibirNovamente();
        this.escondeTextos();
        this.lerNovidade(this.lblTitulo1, this.epNovidades1, "msg_novidades_titulo_01", "msg_novidades_01");
        this.lerNovidade(this.lblTitulo2, this.epNovidades2, "msg_novidades_titulo_02", "msg_novidades_02");
        this.lerNovidade(this.lblTitulo3, this.epNovidades3, "msg_novidades_titulo_03", "msg_novidades_03");
        this.lerNovidade(this.lblTitulo4, this.epNovidades4, "msg_novidades_titulo_04", "msg_novidades_04");
        this.lerNovidade(this.lblTitulo5, this.epNovidades5, "msg_novidades_titulo_05", "msg_novidades_05");
    }

    public String getTitulo() {
        return "Novidades do " + AplicacaoPropertiesUtil.getNomeAplicacao() + " " + AplicacaoPropertiesUtil.getExercicio();
    }

    public void escondeTextos() {
        this.epNovidades1.setVisible(false);
        this.epNovidades2.setVisible(false);
        this.epNovidades3.setVisible(false);
        this.epNovidades4.setVisible(false);
        this.epNovidades5.setVisible(false);
    }

    private void configAcaoAjuda(JComponent component, final JEditorPane componentTexto) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (componentTexto.isVisible()) {
                    componentTexto.setVisible(false);
                } else {
                    PainelNovidades.this.escondeTextos();
                    Dimension tamanho = new Dimension(593, PainelNovidades.getAlturaDoConteudo(componentTexto.getText()));
                    componentTexto.setPreferredSize(tamanho);
                    componentTexto.validate();
                    componentTexto.setVisible(true);
                }
            }
        });
    }

    public void configCursor(final JComponent component) {
        component.setBorder(BorderFactory.createLineBorder(new Color(76, 76, 76)));
        component.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
                component.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getDefaultCursor());
                component.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
                component.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void focusLost(FocusEvent e) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getDefaultCursor());
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
    }

    private void setCheckboxNaoExibirNovamente() {
        if (ControladorGui.getGCAPPreferences().getBoolean(ControladorGui.NAO_EXIBIR_NOVIDADES_GCAP, false)) {
            this.chkNaoMostrar.setSelected(true);
        } else {
            this.chkNaoMostrar.setSelected(false);
        }
    }

    private void initComponents() {
        this.painelNovidadesBackground1 = new PainelNovidadesBackground();
        this.lblExercicio = new JLabel();
        this.lblNovidadesPrograma = new JLabel();
        this.chkNaoMostrar = new JCheckBox();
        this.btnFechar = new JButton();
        this.lblTitulo1 = new JLabel();
        this.epNovidades1 = new JEditorPane();
        this.lblTitulo2 = new JLabel();
        this.epNovidades2 = new JEditorPane();
        this.lblTitulo3 = new JLabel();
        this.epNovidades3 = new JEditorPane();
        this.lblTitulo4 = new JLabel();
        this.epNovidades4 = new JEditorPane();
        this.lblTitulo5 = new JLabel();
        this.epNovidades5 = new JEditorPane();
        this.setBackground(Color.white);
        this.painelNovidadesBackground1.setPreferredSize(new Dimension(630, 1016));
        this.lblExercicio.setFont(new Font("Arial", 1, 30));
        this.lblExercicio.setForeground(new Color(142, 193, 30));
        this.lblExercicio.setText(AplicacaoPropertiesUtil.getExercicio());
        this.lblNovidadesPrograma.setFont(new Font("Ubuntu", 1, 24));
        this.lblNovidadesPrograma.setForeground(new Color(0, 74, 106));
        this.lblNovidadesPrograma.setHorizontalAlignment(0);
        this.lblNovidadesPrograma.setText("Novidades do Programa");
        this.lblNovidadesPrograma.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.chkNaoMostrar.setText("N\u00e3o mostrar esta tela novamente");
        this.chkNaoMostrar.setContentAreaFilled(false);
        this.chkNaoMostrar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelNovidades.this.chkNaoMostrarActionPerformed(evt);
            }
        });
        this.btnFechar.setText("Fechar");
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelNovidades.this.btnFecharActionPerformed(evt);
            }
        });
        this.lblTitulo1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo1.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/seta_novidade.png")));
        this.lblTitulo1.setText("Titulo 1");
        this.epNovidades1.setEditable(false);
        this.epNovidades1.setBorder(null);
        this.epNovidades1.setContentType("text/html");
        this.epNovidades1.setFont(FontesUtil.FONTE_MENOR);
        this.epNovidades1.setText("<html>\r   <head>\r \r   </head>\r   <body>\r     <p style=\"margin-top: 0\"></p>\r   </body>\r </html>\r ");
        this.epNovidades1.setToolTipText("");
        this.epNovidades1.setOpaque(false);
        this.lblTitulo2.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo2.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/seta_novidade.png")));
        this.lblTitulo2.setText("Titulo 2");
        this.epNovidades2.setEditable(false);
        this.epNovidades2.setBorder(null);
        this.epNovidades2.setContentType("text/html");
        this.epNovidades2.setFont(FontesUtil.FONTE_MENOR);
        this.epNovidades2.setOpaque(false);
        this.lblTitulo3.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo3.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/seta_novidade.png")));
        this.lblTitulo3.setText("Titulo 3");
        this.epNovidades3.setEditable(false);
        this.epNovidades3.setBorder(null);
        this.epNovidades3.setContentType("text/html");
        this.epNovidades3.setFont(FontesUtil.FONTE_MENOR);
        this.epNovidades3.setOpaque(false);
        this.lblTitulo4.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo4.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/seta_novidade.png")));
        this.lblTitulo4.setText("Titulo 4");
        this.epNovidades4.setEditable(false);
        this.epNovidades4.setBorder(null);
        this.epNovidades4.setContentType("text/html");
        this.epNovidades4.setFont(FontesUtil.FONTE_MENOR);
        this.epNovidades4.setOpaque(false);
        this.lblTitulo5.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/seta_novidade.png")));
        this.lblTitulo5.setText("Titulo 5");
        this.epNovidades5.setEditable(false);
        this.epNovidades5.setBorder(null);
        this.epNovidades5.setContentType("text/html");
        this.epNovidades5.setFont(FontesUtil.FONTE_MENOR);
        this.epNovidades5.setOpaque(false);
        GroupLayout painelNovidadesBackground1Layout = new GroupLayout(this.painelNovidadesBackground1);
        this.painelNovidadesBackground1.setLayout(painelNovidadesBackground1Layout);
        painelNovidadesBackground1Layout.setHorizontalGroup(painelNovidadesBackground1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelNovidadesBackground1Layout.createSequentialGroup().addContainerGap().addComponent(this.chkNaoMostrar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 172, Short.MAX_VALUE).addComponent(this.btnFechar, -2, 92, -2).addGap(29, 29, 29)).addGroup(GroupLayout.Alignment.TRAILING, painelNovidadesBackground1Layout.createSequentialGroup().addGroup(painelNovidadesBackground1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, painelNovidadesBackground1Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(painelNovidadesBackground1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.epNovidades4, GroupLayout.Alignment.TRAILING).addComponent(this.lblTitulo4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.epNovidades3, GroupLayout.Alignment.TRAILING).addComponent(this.lblTitulo3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.epNovidades2, GroupLayout.Alignment.TRAILING).addComponent(this.lblTitulo2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.epNovidades1, GroupLayout.Alignment.TRAILING).addComponent(this.lblTitulo1, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, painelNovidadesBackground1Layout.createSequentialGroup().addContainerGap().addGroup(painelNovidadesBackground1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.epNovidades5, GroupLayout.Alignment.TRAILING).addComponent(this.lblTitulo5, -1, -1, Short.MAX_VALUE)))).addGap(126, 126, 126)).addComponent(this.lblNovidadesPrograma, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, painelNovidadesBackground1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.lblExercicio, -2, 136, -2).addGap(201, 201, 201)));
        painelNovidadesBackground1Layout.setVerticalGroup(painelNovidadesBackground1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, painelNovidadesBackground1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblExercicio, -2, 59, -2).addGap(26, 26, 26).addComponent(this.lblNovidadesPrograma).addGap(20, 20, 20).addComponent(this.lblTitulo1, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epNovidades1, -1, 25, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.lblTitulo2, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epNovidades2, -1, 25, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.lblTitulo3, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epNovidades3, -1, 21, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.lblTitulo4, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epNovidades4, -1, 22, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.lblTitulo5, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.epNovidades5, -1, 16, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 133, Short.MAX_VALUE).addGroup(painelNovidadesBackground1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkNaoMostrar).addComponent(this.btnFechar)).addContainerGap()));
        painelNovidadesBackground1Layout.linkSize(1, this.lblTitulo1, this.lblTitulo2, this.lblTitulo3, this.lblTitulo4, this.lblTitulo5);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.painelNovidadesBackground1, -2, 524, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.painelNovidadesBackground1, -1, 600, Short.MAX_VALUE));
    }

    private void btnFecharActionPerformed(ActionEvent evt) {
        if (this.chkNaoMostrar.isSelected()) {
            ControladorGui.getGCAPPreferences().putBoolean(ControladorGui.NAO_EXIBIR_NOVIDADES_GCAP, true);
        } else {
            ControladorGui.getGCAPPreferences().putBoolean(ControladorGui.NAO_EXIBIR_NOVIDADES_GCAP, false);
        }
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void chkNaoMostrarActionPerformed(ActionEvent evt) {
        ControladorGui.getGCAPPreferences().putBoolean(ControladorGui.NAO_EXIBIR_NOVIDADES_GCAP, this.chkNaoMostrar.isSelected());
    }

    private void lerNovidade(JLabel lblTitulo, JEditorPane epNovidades, String msg_novidades_titulo, String msg_novidades) {
        String txt_msg_novidade_titulo = MensagemUtil.getMensagem(msg_novidades_titulo);
        String html_msg_novidade = MensagemUtil.getMensagem(msg_novidades);
        if (html_msg_novidade.isEmpty() || html_msg_novidade.equals(msg_novidades)) {
            lblTitulo.setVisible(false);
        } else {
            lblTitulo.setText(txt_msg_novidade_titulo);
            epNovidades.setText(this.incluirIcones(html_msg_novidade));
            epNovidades.addHyperlinkListener(this.escutaLinks);
        }
    }

    private String incluirIcones(String HTML2) {
        URL recursoinfo = this.getClass().getResource("/icones/png10px/info.png");
        HTML2 = HTML2.replaceAll("%info%", recursoinfo.toString());
        return HTML2.trim();
    }

    public static int getAlturaDoConteudo(String conteudo) {
        JEditorPane dummyEditorPane = new JEditorPane();
        dummyEditorPane.setSize(593, Short.MAX_VALUE);
        dummyEditorPane.setContentType("text/html");
        dummyEditorPane.setText(conteudo);
        return dummyEditorPane.getPreferredSize().height;
    }
}

